/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.afml;

import com.adobe.agl.util.StringTokenizer;
import com.adobe.internal.afml.AFMLAnomalies;
import com.adobe.internal.afml.AFMLAttribute__Abstract;
import com.adobe.internal.afml.AFMLAttribute__ClassId;
import com.adobe.internal.afml.AFMLAttribute__Name;
import com.adobe.internal.afml.AFMLAttribute__TypeId;
import com.adobe.internal.afml.AFMLException;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLSVGNamedColorMap;

public final class AFMLAttribute_Color
extends AFMLAttribute__Abstract {
    private boolean pvt_isCMYKColor;
    private double pvt_red;
    private double pvt_green;
    private double pvt_blue;
    private double pvt_cyan;
    private double pvt_magenta;
    private double pvt_yellow;
    private double pvt_black;
    private double pvt_alpha;
    private String pvt_string;

    public AFMLAttribute_Color() {
        super(AFMLAttribute__TypeId.unset, AFMLAttribute__ClassId.AttributeClassId_Color, false);
        this.pvt_isCMYKColor = false;
        this.pvt_red = 0.0;
        this.pvt_green = 0.0;
        this.pvt_blue = 0.0;
        this.pvt_cyan = 0.0;
        this.pvt_magenta = 0.0;
        this.pvt_yellow = 0.0;
        this.pvt_black = 0.0;
        this.pvt_alpha = 0.0;
        this.pvt_string = "transparent";
    }

    public AFMLAttribute_Color(AFMLAttribute__TypeId in_attributeId, String in_attributeValue, boolean in_isInheritable) throws AFMLExceptionInvalidParameter {
        super(in_attributeId, AFMLAttribute__ClassId.AttributeClassId_Color, in_isInheritable);
        double var_black;
        this.pvt_string = in_attributeValue;
        int var_currentIndex = 0;
        int var_count = in_attributeValue.length();
        this.pvt_isCMYKColor = false;
        if (in_attributeValue.charAt(var_currentIndex) == '#') {
            if (in_attributeValue.charAt(++var_currentIndex) == '$') {
                switch (var_count - ++var_currentIndex) {
                    case 4: {
                        this.pvt_cyan = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) / 15.0;
                        this.pvt_magenta = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1)) / 15.0;
                        this.pvt_yellow = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) / 15.0;
                        this.pvt_black = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3)) / 15.0;
                        this.pvt_alpha = 1.0;
                        break;
                    }
                    case 5: {
                        this.pvt_cyan = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) / 15.0;
                        this.pvt_magenta = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1)) / 15.0;
                        this.pvt_yellow = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) / 15.0;
                        this.pvt_black = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3)) / 15.0;
                        this.pvt_alpha = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 4)) / 15.0;
                        break;
                    }
                    case 8: {
                        this.pvt_cyan = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1))) / 255.0;
                        this.pvt_magenta = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3))) / 255.0;
                        this.pvt_yellow = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 4)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 5))) / 255.0;
                        this.pvt_black = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 6)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 7))) / 255.0;
                        this.pvt_alpha = 1.0;
                        break;
                    }
                    case 10: {
                        this.pvt_cyan = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1))) / 255.0;
                        this.pvt_magenta = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3))) / 255.0;
                        this.pvt_yellow = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 4)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 5))) / 255.0;
                        this.pvt_black = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 6)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 7))) / 255.0;
                        this.pvt_alpha = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 8)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 9))) / 255.0;
                        break;
                    }
                    default: {
                        AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for " + AFMLAttribute__Name.getAttributeName(in_attributeId) + ": \"" + in_attributeValue + "\" is not a valid cmyk/cmyka color.");
                    }
                }
                if (this.pvt_cyan < 0.0) {
                    this.pvt_cyan = 0.0;
                }
                if (this.pvt_cyan > 1.0) {
                    this.pvt_cyan = 1.0;
                }
                if (this.pvt_magenta < 0.0) {
                    this.pvt_magenta = 0.0;
                }
                if (this.pvt_magenta > 1.0) {
                    this.pvt_magenta = 1.0;
                }
                if (this.pvt_yellow < 0.0) {
                    this.pvt_yellow = 0.0;
                }
                if (this.pvt_yellow > 1.0) {
                    this.pvt_yellow = 1.0;
                }
                if (this.pvt_black < 0.0) {
                    this.pvt_black = 0.0;
                }
                if (this.pvt_black > 1.0) {
                    this.pvt_black = 1.0;
                }
                double var_cyan = this.pvt_cyan;
                double var_magenta = this.pvt_magenta;
                double var_yellow = this.pvt_yellow;
                var_black = this.pvt_cyan;
                if (this.pvt_magenta < var_black) {
                    var_black = this.pvt_magenta;
                }
                if (this.pvt_yellow < var_black) {
                    var_black = this.pvt_yellow;
                }
                if (var_black > 0.0) {
                    var_cyan = this.pvt_cyan - var_black;
                    var_magenta = this.pvt_magenta - var_black;
                    var_yellow = this.pvt_yellow - var_black;
                }
                if ((var_black = this.pvt_black + var_black) < 0.0) {
                    var_black = 0.0;
                }
                if (var_black > 1.0) {
                    var_black = 1.0;
                }
                this.pvt_red = 1.0 - (var_black + var_cyan);
                this.pvt_green = 1.0 - (var_black + var_magenta);
                this.pvt_blue = 1.0 - (var_black + var_yellow);
                if (this.pvt_red < 0.0) {
                    this.pvt_red = 0.0;
                }
                if (this.pvt_red > 1.0) {
                    this.pvt_red = 1.0;
                }
                if (this.pvt_green < 0.0) {
                    this.pvt_green = 0.0;
                }
                if (this.pvt_green > 1.0) {
                    this.pvt_green = 1.0;
                }
                if (this.pvt_blue < 0.0) {
                    this.pvt_blue = 0.0;
                }
                if (this.pvt_blue > 1.0) {
                    this.pvt_blue = 1.0;
                }
                this.pvt_isCMYKColor = true;
            } else {
                switch (var_count - var_currentIndex) {
                    case 3: {
                        this.pvt_red = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) / 15.0;
                        this.pvt_green = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1)) / 15.0;
                        this.pvt_blue = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) / 15.0;
                        this.pvt_alpha = 1.0;
                        break;
                    }
                    case 4: {
                        this.pvt_red = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) / 15.0;
                        this.pvt_green = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1)) / 15.0;
                        this.pvt_blue = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) / 15.0;
                        this.pvt_alpha = (double)AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3)) / 15.0;
                        break;
                    }
                    case 6: {
                        this.pvt_red = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1))) / 255.0;
                        this.pvt_green = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3))) / 255.0;
                        this.pvt_blue = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 4)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 5))) / 255.0;
                        this.pvt_alpha = 1.0;
                        break;
                    }
                    case 8: {
                        this.pvt_red = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 1))) / 255.0;
                        this.pvt_green = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 2)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 3))) / 255.0;
                        this.pvt_blue = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 4)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 5))) / 255.0;
                        this.pvt_alpha = (double)(AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 6)) * 16 + AFMLAttribute_Color.getAFMLHexValue(in_attributeValue.charAt(var_currentIndex + 7))) / 255.0;
                        break;
                    }
                    default: {
                        AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for " + AFMLAttribute__Name.getAttributeName(in_attributeId) + ": \"" + in_attributeValue + "\" is not a valid rgb/rgba color.");
                        break;
                    }
                }
            }
        } else if (in_attributeValue.charAt(in_attributeValue.length() - 1) == ')' && (in_attributeValue.regionMatches(true, 0, "rgb(", 0, 4) || in_attributeValue.regionMatches(true, 0, "rgba(", 0, 5) || in_attributeValue.regionMatches(true, 0, "cmyk(", 0, 5) || in_attributeValue.regionMatches(true, 0, "cmyka(", 0, 6))) {
            int var_startOffset = 0;
            int var_numArgsToProcess = 0;
            int var_currentArgIndex = 0;
            if (in_attributeValue.regionMatches(true, 0, "rgb(", 0, 4)) {
                var_startOffset = 4;
                var_numArgsToProcess = 3;
                this.pvt_isCMYKColor = false;
            } else if (in_attributeValue.regionMatches(true, 0, "rgba(", 0, 5)) {
                var_startOffset = 5;
                var_numArgsToProcess = 4;
                this.pvt_isCMYKColor = false;
            } else if (in_attributeValue.regionMatches(true, 0, "cmyk(", 0, 5)) {
                var_startOffset = 5;
                var_numArgsToProcess = 4;
                this.pvt_isCMYKColor = true;
            } else if (in_attributeValue.regionMatches(true, 0, "cmyka(", 0, 6)) {
                var_startOffset = 6;
                var_numArgsToProcess = 5;
                this.pvt_isCMYKColor = true;
            }
            this.pvt_alpha = 1.0;
            StringTokenizer var_commaDelimited = new StringTokenizer(in_attributeValue.substring(var_startOffset, in_attributeValue.length() - 1), ",");
            if (!this.pvt_isCMYKColor) {
                block25: for (var_currentArgIndex = 0; var_currentArgIndex < var_numArgsToProcess && var_commaDelimited.hasMoreTokens(); ++var_currentArgIndex) {
                    String var_Token = var_commaDelimited.nextToken().trim();
                    switch (var_currentArgIndex) {
                        case 0: {
                            this.pvt_red = this.internalConvertColorFunctionValue(var_Token);
                            continue block25;
                        }
                        case 1: {
                            this.pvt_green = this.internalConvertColorFunctionValue(var_Token);
                            continue block25;
                        }
                        case 2: {
                            this.pvt_blue = this.internalConvertColorFunctionValue(var_Token);
                            continue block25;
                        }
                        case 3: {
                            this.pvt_alpha = this.internalConvertColorFunctionValue(var_Token);
                        }
                    }
                }
            } else {
                block26: for (var_currentArgIndex = 0; var_currentArgIndex < var_numArgsToProcess && var_commaDelimited.hasMoreTokens(); ++var_currentArgIndex) {
                    String var_Token = var_commaDelimited.nextToken().trim();
                    switch (var_currentArgIndex) {
                        case 0: {
                            this.pvt_cyan = this.internalConvertColorFunctionValue(var_Token);
                            continue block26;
                        }
                        case 1: {
                            this.pvt_magenta = this.internalConvertColorFunctionValue(var_Token);
                            continue block26;
                        }
                        case 2: {
                            this.pvt_yellow = this.internalConvertColorFunctionValue(var_Token);
                            continue block26;
                        }
                        case 3: {
                            this.pvt_black = this.internalConvertColorFunctionValue(var_Token);
                            continue block26;
                        }
                        case 4: {
                            this.pvt_alpha = this.internalConvertColorFunctionValue(var_Token);
                        }
                    }
                }
                if (this.pvt_cyan < 0.0) {
                    this.pvt_cyan = 0.0;
                }
                if (this.pvt_cyan > 1.0) {
                    this.pvt_cyan = 1.0;
                }
                if (this.pvt_magenta < 0.0) {
                    this.pvt_magenta = 0.0;
                }
                if (this.pvt_magenta > 1.0) {
                    this.pvt_magenta = 1.0;
                }
                if (this.pvt_yellow < 0.0) {
                    this.pvt_yellow = 0.0;
                }
                if (this.pvt_yellow > 1.0) {
                    this.pvt_yellow = 1.0;
                }
                if (this.pvt_black < 0.0) {
                    this.pvt_black = 0.0;
                }
                if (this.pvt_black > 1.0) {
                    this.pvt_black = 1.0;
                }
                double var_cyan = this.pvt_cyan;
                double var_magenta = this.pvt_magenta;
                double var_yellow = this.pvt_yellow;
                double var_black2 = this.pvt_cyan;
                if (this.pvt_magenta < var_black2) {
                    var_black2 = this.pvt_magenta;
                }
                if (this.pvt_yellow < var_black2) {
                    var_black2 = this.pvt_yellow;
                }
                if (var_black2 > 0.0) {
                    var_cyan = this.pvt_cyan - var_black2;
                    var_magenta = this.pvt_magenta - var_black2;
                    var_yellow = this.pvt_yellow - var_black2;
                }
                if ((var_black2 = this.pvt_black + var_black2) < 0.0) {
                    var_black2 = 0.0;
                }
                if (var_black2 > 1.0) {
                    var_black2 = 1.0;
                }
                this.pvt_red = 1.0 - (var_black2 + var_cyan);
                this.pvt_green = 1.0 - (var_black2 + var_magenta);
                this.pvt_blue = 1.0 - (var_black2 + var_yellow);
                if (this.pvt_red < 0.0) {
                    this.pvt_red = 0.0;
                }
                if (this.pvt_red > 1.0) {
                    this.pvt_red = 1.0;
                }
                if (this.pvt_green < 0.0) {
                    this.pvt_green = 0.0;
                }
                if (this.pvt_green > 1.0) {
                    this.pvt_green = 1.0;
                }
                if (this.pvt_blue < 0.0) {
                    this.pvt_blue = 0.0;
                }
                if (this.pvt_blue > 1.0) {
                    this.pvt_blue = 1.0;
                }
                this.pvt_isCMYKColor = true;
            }
        } else {
            long var_SVGColorKey = AFMLSVGNamedColorMap.convertSVGNamedColorToRGB(in_attributeValue);
            if (var_SVGColorKey != 0xFFFFFFL) {
                this.pvt_red = (double)((var_SVGColorKey & 0xFF0000L) >> 16) / 255.0;
                this.pvt_green = (double)((var_SVGColorKey & 0xFF00L) >> 8) / 255.0;
                this.pvt_blue = (double)(var_SVGColorKey & 0xFFL) / 255.0;
                this.pvt_alpha = (double)((var_SVGColorKey & 0xFF000000L) >> 24) / 255.0;
            } else {
                AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for " + AFMLAttribute__Name.getAttributeName(in_attributeId) + ": \"" + in_attributeValue + "\" is not a valid color name.");
            }
        }
        if (this.pvt_red < 0.0) {
            this.pvt_red = 0.0;
        }
        if (this.pvt_red > 1.0) {
            this.pvt_red = 1.0;
        }
        if (this.pvt_green < 0.0) {
            this.pvt_green = 0.0;
        }
        if (this.pvt_green > 1.0) {
            this.pvt_green = 1.0;
        }
        if (this.pvt_blue < 0.0) {
            this.pvt_blue = 0.0;
        }
        if (this.pvt_blue > 1.0) {
            this.pvt_blue = 1.0;
        }
        if (!this.pvt_isCMYKColor) {
            double var_red = this.pvt_red;
            double var_green = this.pvt_green;
            double var_blue = this.pvt_blue;
            this.pvt_cyan = 1.0 - var_red;
            this.pvt_magenta = 1.0 - var_green;
            this.pvt_yellow = 1.0 - var_blue;
            var_black = this.pvt_cyan;
            if (this.pvt_magenta < var_black) {
                var_black = this.pvt_magenta;
            }
            if (this.pvt_yellow < var_black) {
                var_black = this.pvt_yellow;
            }
            if (var_black < 0.0) {
                var_black = 0.0;
            }
            if (var_black > 1.0) {
                var_black = 1.0;
            }
            if (var_black > 0.0) {
                this.pvt_cyan -= var_black;
                this.pvt_magenta -= var_black;
                this.pvt_yellow -= var_black;
            }
            this.pvt_black = var_black;
            if (this.pvt_cyan < 0.0) {
                this.pvt_cyan = 0.0;
            }
            if (this.pvt_red > 1.0) {
                this.pvt_red = 1.0;
            }
            if (this.pvt_magenta < 0.0) {
                this.pvt_magenta = 0.0;
            }
            if (this.pvt_magenta > 1.0) {
                this.pvt_magenta = 1.0;
            }
            if (this.pvt_yellow < 0.0) {
                this.pvt_yellow = 0.0;
            }
            if (this.pvt_yellow > 1.0) {
                this.pvt_yellow = 1.0;
            }
        }
    }

    private double internalConvertColorFunctionValue(String in_value) {
        in_value.trim();
        double var_return = Double.NEGATIVE_INFINITY;
        var_return = in_value.charAt(in_value.length() - 1) == '%' ? Double.valueOf(in_value.substring(0, in_value.length() - 1)) / 100.0 : Double.valueOf(in_value) / 255.0;
        if (var_return < 0.0) {
            var_return = 0.0;
        }
        if (var_return > 1.0) {
            var_return = 1.0;
        }
        return var_return;
    }

    @Override
    public Object clone() {
        try {
            return new AFMLAttribute_Color(this.getAttributeTypeId(), this.toString(), this.isInheritable());
        }
        catch (AFMLException e) {
            return null;
        }
    }

    @Override
    public boolean equals(AFMLAttribute__Abstract in_comparisonObject) {
        if (this == in_comparisonObject) {
            return true;
        }
        return in_comparisonObject.getAttributeClassId() == this.getAttributeClassId() && in_comparisonObject.getAttributeTypeId() == this.getAttributeTypeId() && ((AFMLAttribute_Color)in_comparisonObject).getColorAsRGBLong() == this.getColorAsRGBLong();
    }

    public long getColorAsRGBLong() {
        return ((int)(this.pvt_alpha * 255.0) << 24) + ((int)(this.pvt_red * 255.0) << 16) + ((int)(this.pvt_green * 255.0) << 8) + (int)(this.pvt_blue * 255.0);
    }

    public boolean isCMYKColor() {
        return this.pvt_isCMYKColor;
    }

    public double getColorOpacityFactor() {
        return this.pvt_alpha;
    }

    public double getColorTransparencyFactor() {
        return 1.0 - this.pvt_alpha;
    }

    public double getColorRedFactor() {
        return this.pvt_red;
    }

    public double getColorGreenFactor() {
        return this.pvt_green;
    }

    public double getColorBlueFactor() {
        return this.pvt_blue;
    }

    public double getColorCyanFactor() {
        if (!this.isCMYKColor()) {
            AFMLAnomalies.AFMLErrorStop("requesting CMYK value from an rgb color");
        }
        return this.pvt_cyan;
    }

    public double getColorMagentaFactor() {
        if (!this.isCMYKColor()) {
            AFMLAnomalies.AFMLErrorStop("requesting CMYK value from an rgb color");
        }
        return this.pvt_magenta;
    }

    public double getColorYellowFactor() {
        if (!this.isCMYKColor()) {
            AFMLAnomalies.AFMLErrorStop("requesting CMYK value from an rgb color");
        }
        return this.pvt_yellow;
    }

    public double getColorBlackFactor() {
        if (!this.isCMYKColor()) {
            AFMLAnomalies.AFMLErrorStop("requesting CMYK value from an rgb color");
        }
        return this.pvt_black;
    }

    public String toString() {
        return this.pvt_string;
    }
}

