/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class URLFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    protected final URL outlineFileURL;
    protected URL metricFileURL;
    protected final int index;
    protected String canonicalPath;
    protected long length;
    protected long lastModified;
    protected ConcurrentHashMap<String, Object> descCache = new ConcurrentHashMap(16, 0.75f, 1);
    protected transient SoftReference fontRef;

    URLFont(URL outlineFileURL, int index) {
        this.outlineFileURL = outlineFileURL;
        this.index = index;
        this.fontRef = new SoftReference<Object>(null);
        this.initCacheTags();
    }

    URLFont(URL outlineFileURL, int index, FontData font) throws UnsupportedFontException {
        this.outlineFileURL = outlineFileURL;
        this.index = index;
        this.fontRef = new SoftReference<FontData>(font);
        this.initCacheTags();
    }

    void setMetricURL(URL metricFileURL, MetricFile f) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData data = this.retrieveFontData();
        if (!(data instanceof Type1Font)) {
            return;
        }
        if (((Type1Font)data).setMetricFile(f)) {
            this.metricFileURL = metricFileURL;
        }
    }

    @Override
    protected synchronized FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData font = null;
        font = (FontData)this.fontRef.get();
        if (font == null) {
            FontData[] arr;
            try {
                arr = FontLoader.fromURL(this.outlineFileURL, this.metricFileURL);
            }
            catch (IOException e) {
                throw new FontLoadingException(e);
            }
            font = arr[this.index];
            this.fontRef = new SoftReference<FontData>(font);
        }
        return font;
    }

    @Override
    public int hashCode() {
        int hash = this.index;
        hash ^= this.outlineFileURL.hashCode();
        if (this.metricFileURL != null) {
            hash ^= this.metricFileURL.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof URLFont) {
                URLFont otherURLFont = (URLFont)obj;
                if (this.index == otherURLFont.index) {
                    try {
                        if (!this.outlineFileURL.toURI().equals(otherURLFont.outlineFileURL.toURI())) {
                            return false;
                        }
                    }
                    catch (URISyntaxException e) {
                        return false;
                    }
                    if (this.metricFileURL == null && otherURLFont.metricFileURL == null) {
                        return true;
                    }
                    try {
                        if (this.metricFileURL == null || otherURLFont.metricFileURL == null || !this.metricFileURL.toURI().equals(otherURLFont.metricFileURL.toURI())) {
                            return false;
                        }
                    }
                    catch (URISyntaxException e) {
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.outlineFileURL.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.fontRef = new SoftReference<Object>(null);
    }

    private void initCacheTags() {
        try {
            try {
                this.canonicalPath = this.outlineFileURL.toURI().getPath();
                if (this.canonicalPath == null) {
                    throw new IOException("Cannot resolve path to file");
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e.toString());
            }
            File file = new File(this.canonicalPath);
            this.canonicalPath = file.getCanonicalPath();
            this.length = file.length();
            this.lastModified = file.lastModified();
        }
        catch (IOException e) {
            this.canonicalPath = null;
            this.length = 0L;
            this.lastModified = 0L;
        }
    }

    @Override
    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Object getCachedFontDescription(String key) {
        return this.descCache.get(key);
    }

    @Override
    public Map<String, Object> getCachedFontDescriptionMap() {
        return this.descCache;
    }

    @Override
    public void setCachedFontDescription(String key, Object value) {
        this.descCache.put(key, value);
    }
}

