/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.type1.Type1CStringConsumerDefault;
import com.adobe.fontengine.font.type1.Type1CStringParser;
import com.adobe.fontengine.font.type1.Type1Font;

public final class Type1OutlineParser {
    private final Type1CStringParser parser = new Type1CStringParser();
    private OutlineConsumer c;
    private T1OutlineConsumer outlineconsumer = new T1OutlineConsumer();
    double cpx;
    double cpy;
    double pathStartX;
    double pathStartY;
    boolean pathStarted;

    public void parse(Type1Font font, int glyphID, OutlineConsumer consumer) throws InvalidGlyphException, UnsupportedFontException {
        this.cpy = 0.0;
        this.cpx = 0.0;
        this.pathStarted = false;
        this.c = consumer;
        consumer.setMatrix(font.getFontMatrix());
        this.parser.parse(this.outlineconsumer, font, glyphID);
    }

    private class T1OutlineConsumer
    extends Type1CStringConsumerDefault {
        private T1OutlineConsumer() {
        }

        private void startPath(double x, double y) {
            if (!Type1OutlineParser.this.pathStarted) {
                Type1OutlineParser.this.pathStarted = true;
                Type1OutlineParser.this.pathStartX = x;
                Type1OutlineParser.this.pathStartY = y;
            }
        }

        @Override
        public void closepath() {
            if (Type1OutlineParser.this.pathStarted) {
                Type1OutlineParser.this.c.lineto(Type1OutlineParser.this.pathStartX, Type1OutlineParser.this.pathStartY);
                Type1OutlineParser.this.pathStarted = false;
            }
        }

        @Override
        public void endchar() {
            if (Type1OutlineParser.this.pathStarted) {
                Type1OutlineParser.this.c.lineto(Type1OutlineParser.this.pathStartX, Type1OutlineParser.this.pathStartY);
            }
            Type1OutlineParser.this.c.endchar();
        }

        @Override
        public void lineto(double x, double y) {
            this.startPath(Type1OutlineParser.this.cpx, Type1OutlineParser.this.cpy);
            Type1OutlineParser.this.cpx = x;
            Type1OutlineParser.this.cpy = y;
            Type1OutlineParser.this.c.lineto(x, y);
        }

        @Override
        public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.startPath(Type1OutlineParser.this.cpx, Type1OutlineParser.this.cpy);
            Type1OutlineParser.this.cpx = x3;
            Type1OutlineParser.this.cpy = y3;
            Type1OutlineParser.this.c.curveto(x1, y1, x2, y2, x3, y3);
        }

        @Override
        public void moveto(double x, double y) {
            Type1OutlineParser.this.pathStarted = false;
            Type1OutlineParser.this.cpx = x;
            Type1OutlineParser.this.cpy = y;
            Type1OutlineParser.this.c.moveto(x, y);
        }

        @Override
        public void flex(double depth, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double x5, double y5, double x6, double y6) {
            this.curveto(x1, y1, x2, y2, x3, y3);
            this.curveto(x4, y4, x5, y5, x6, y6);
        }
    }
}

