/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.VmtxRaw;
import java.util.Map;

public final class Vmtx
extends Table {
    protected final int numberOfVMetrics;
    protected final VmtxRaw vmtx;

    protected Vmtx(VmtxRaw vmtx, int numberOfVHMetrics) {
        this.vmtx = vmtx;
        this.numberOfVMetrics = numberOfVHMetrics;
    }

    public int getTopSideBearing(int glyphID) throws InvalidFontException {
        return this.vmtx.getTopSideBearing(glyphID, this.numberOfVMetrics);
    }

    public int getHorizontalAdvance(int glyphID) throws InvalidFontException {
        return this.vmtx.getVerticalAdvance(glyphID, this.numberOfVMetrics);
    }

    public void subsetAndStream(Subset subset, Map tables) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(subset.getNumGlyphs() * 4);
        int o = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int fullId = subset.getFullGid(i);
            newData.setuint16(o, this.getHorizontalAdvance(fullId));
            newData.setint16(o + 2, this.getTopSideBearing(fullId));
            o += 4;
        }
        tables.put(new Integer(1986884728), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.vmtx.getDataAsByteArray();
        tables.put(new Integer(1986884728), newData);
    }
}

