/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.math.F16Dot16;
import com.adobe.fontengine.math.F16Dot16Vector;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import com.adobe.fontengine.math.F2Dot14;
import com.adobe.fontengine.math.F2Dot14Vector;

public class TTInterpreter {
    private GraphicState gs;
    private GraphicParameters gp;
    private StorageArea storageArea;
    private Stack stack;
    private FunctionDefinitions functionDefs;
    private FunctionDefinitions instructionDefs = new FunctionDefinitions(256);
    private int unitsPerEm;
    private Matrix em2px;
    private TTPoint[] twilightZone;
    static Instr[] instructions = new Instr[]{new Instr(0, "SetVectorsToCoordAxis {x}", 0, 0), new Instr(1, "SetVectorsToCoordAxis {y}", 0, 0), new Instr(2, "SetPVToCoordAxis {x}", 0, 0), new Instr(3, "SetPVToCoordAxis {y}", 0, 0), new Instr(4, "SetFVToCoordAxis {x}", 0, 0), new Instr(5, "SetFVToCoordAxis {y}", 0, 0), new Instr(6, "SetPVToLine {para}", 2, 0), new Instr(7, "SetPVToLine {perp}", 2, 0), new Instr(8, "SetFVToLine {para}", 2, 0), new Instr(9, "SetFVToLine {para}", 2, 0), new Instr(10, "SetPVFromStack", 2, 0), new Instr(11, "SetFVFromStack", 2, 0), new Instr(12, "GetPV", 0, 2), new Instr(13, "GetFV", 0, 2), new Instr(14, "SetFVtoPV", 0, 0), new Instr(15, "movepointtoInterSECTion", 5, 0), new Instr(16, "SetRP0", 1, 0), new Instr(17, "SetRP1", 1, 0), new Instr(18, "SetRP2", 1, 0), new Instr(19, "SetZP0", 1, 0), new Instr(20, "SetZP1", 1, 0), new Instr(21, "SetZP2", 1, 0), new Instr(22, "SetZPS", 1, 0), new Instr(23, "SetLOOPvariable", 1, 0), new Instr(24, "RoundToGrid", 0, 0), new Instr(25, "RoundToHalfGrid", 0, 0), new Instr(26, "SetMinimumDistance", 1, 0), new Instr(27, "ELSE", 0, 0), new Instr(28, "JuMPRelative", 1, 0), new Instr(29, "SetCVTCutIn", 1, 0), new Instr(30, "SetSingleWidthCutIn", 1, 0), new Instr(31, "SetSingleWdith", 1, 0), new Instr(32, "DUP", 0, 1), new Instr(33, "POP", 0, 0), new Instr(34, "CLEAR", 0, 0), new Instr(35, "SWAP", 2, 2), new Instr(36, "DEPTH", 0, 1), new Instr(37, "CINDEX", 1, 1), new Instr(38, "MINDEX", 1, 1), new Instr(39, "ALIGNPoinTS", 2, 0), new Instr(40, "<idef>", 0, 0), new Instr(41, "UnTouchPoint", 1, 0), new Instr(42, "LOOPCALL", 2, 0), new Instr(43, "CALL", 1, 0), new Instr(44, "FDEF", 1, 0), new Instr(45, "ENDF", 0, 0), new Instr(46, "MoveDirectAbsolutePoint {noround}", 1, 0), new Instr(47, "MoveDirectAbsolutePoint {round}", 1, 0), new Instr(48, "InterpolateUntouchedPoints {y}", 0, 0), new Instr(49, "InterpolateUntouchedPoints {x}", 0, 0), new Instr(50, "ShiftPoint {zp1-rp2}", 0, 0), new Instr(51, "ShiftPoint {zp0-rp1}", 0, 0), new Instr(52, "SHiftContour {zp1-rp2}", 0, 0), new Instr(53, "SHiftContour {zp0-rp1}", 0, 0), new Instr(54, "SHiftZone {zp1-rp2}", 0, 0), new Instr(55, "SHiftZone {zp0-rp1}", 0, 0), new Instr(56, "SHiftpointbyPIXelamount", 0, 0), new Instr(57, "InterPolate", 0, 0), new Instr(58, "MoveStackIndirectRelativePoint", 2, 0), new Instr(59, "MoveStackIndirectRelativePoint {setRp0}", 2, 0), new Instr(60, "ALIGNRelativePoint", 0, 0), new Instr(61, "RoundToDoubleGrid", 0, 0), new Instr(62, "MoveIndirectAbsolutePoint {noround}", 2, 0), new Instr(63, "MoveIndirectAbsolutePoint {round}", 2, 0), new Instr(64, "NPUSHB", 0, 0), new Instr(65, "NPUSHW", 0, 0), new Instr(66, "WriteStore", 2, 0), new Instr(67, "ReadStore", 1, 1), new Instr(68, "WriteCVTPixel", 2, 0), new Instr(69, "ReadCVT", 1, 1), new Instr(70, "GetCoordinate (proj)", 1, 1), new Instr(71, "GetCoordinate (unhinted)", 1, 1), new Instr(72, "SetCoordinateFromStack", 2, 0), new Instr(73, "MeasureDistance (hinted)", 2, 1), new Instr(74, "MeasureDistance (original)", 2, 1), new Instr(75, "MeasurePPEM", 0, 1), new Instr(76, "MeasurePointSize", 0, 1), new Instr(77, "FLIPON", 0, 0), new Instr(78, "FLIPOFF", 0, 0), new Instr(79, "DEBUG", 1, 0), new Instr(80, "LessThan", 2, 1), new Instr(81, "LessThanEQ", 2, 1), new Instr(82, "GreaterThan", 2, 1), new Instr(83, "GreateThanEQ", 2, 1), new Instr(84, "EQual", 2, 1), new Instr(85, "NotEQual", 2, 1), new Instr(86, "ODD", 1, 1), new Instr(87, "EVEN", 1, 1), new Instr(88, "IF", 1, 0), new Instr(89, "EIF", 0, 0), new Instr(90, "AND", 2, 1), new Instr(91, "OR", 2, 1), new Instr(92, "NOT", 1, 1), new Instr(93, "DELTAP1", 1, 0), new Instr(94, "SetDeltaBase", 1, 0), new Instr(95, "SetDeltaShift", 1, 0), new Instr(96, "ADD", 2, 1), new Instr(97, "SUB", 2, 1), new Instr(98, "DIV", 2, 1), new Instr(99, "MUL", 2, 1), new Instr(100, "ABS", 1, 1), new Instr(101, "NEG", 1, 1), new Instr(102, "FLOOR", 1, 1), new Instr(103, "CEILING", 1, 1), new Instr(104, "ROUND {comp0}", 1, 1), new Instr(105, "ROUND {comp1}", 1, 1), new Instr(106, "ROUND {comp2}", 1, 1), new Instr(107, "ROUND {comp3}", 1, 1), new Instr(108, "NROUND {comp0}", 1, 1), new Instr(109, "NROUND {comp1}", 1, 1), new Instr(110, "NROUND {comp2}", 1, 1), new Instr(111, "NROUND {comp3}", 1, 1), new Instr(112, "WriteCVTFunits", 2, 0), new Instr(113, "DELTAP2", 1, 0), new Instr(114, "DELTAP3", 1, 0), new Instr(115, "DELTAC1", 1, 0), new Instr(116, "DELTAC2", 1, 0), new Instr(117, "DELTAC3", 1, 0), new Instr(118, "SuperROUND", 1, 0), new Instr(119, "S45ROUND", 1, 0), new Instr(120, "JumpRelativeOnTrue", 2, 0), new Instr(121, "JumpRelativeOnFalse", 2, 0), new Instr(122, "RoundOFF", 0, 0), new Instr(123, "<idef>", 0, 0), new Instr(124, "RoundUpToGrid", 0, 0), new Instr(125, "RoundDownToGrid", 0, 0), new Instr(126, "SetANGleWeight", 1, 0), new Instr(127, "AdjustAngle", 0, 0), new Instr(128, "FliPPoinT", 0, 0), new Instr(129, "FLIPRanGeON", 2, 0), new Instr(130, "FLIPRanGeOFF", 2, 0), new Instr(131, "<idef>", 0, 0), new Instr(132, "<idef>", 0, 0), new Instr(133, "SCANCTRL", 1, 0), new Instr(134, "SetDPVToLine {para}", 2, 0), new Instr(135, "SetDPVToLine {perp}", 2, 0), new Instr(136, "GETINFO", 1, 1), new Instr(137, "IDEF", 1, 0), new Instr(138, "ROLL", 3, 3), new Instr(139, "MAX", 2, 1), new Instr(140, "MIN", 2, 1), new Instr(141, "SCANTYPE", 1, 0), new Instr(142, "INSTCRL", 2, 0), new Instr(143, "<idef>", 0, 0), new Instr(144, "<idef>", 0, 0), new Instr(145, "<idef>", 0, 0), new Instr(146, "<idef>", 0, 0), new Instr(147, "<idef>", 0, 0), new Instr(148, "<idef>", 0, 0), new Instr(149, "<idef>", 0, 0), new Instr(150, "<idef>", 0, 0), new Instr(151, "<idef>", 0, 0), new Instr(152, "<idef>", 0, 0), new Instr(153, "<idef>", 0, 0), new Instr(154, "<idef>", 0, 0), new Instr(155, "<idef>", 0, 0), new Instr(156, "<idef>", 0, 0), new Instr(157, "<idef>", 0, 0), new Instr(158, "<idef>", 0, 0), new Instr(159, "<idef>", 0, 0), new Instr(160, "<idef>", 0, 0), new Instr(161, "<idef>", 0, 0), new Instr(162, "<idef>", 0, 0), new Instr(163, "<idef>", 0, 0), new Instr(164, "<idef>", 0, 0), new Instr(165, "<idef>", 0, 0), new Instr(166, "<idef>", 0, 0), new Instr(167, "<idef>", 0, 0), new Instr(168, "<idef>", 0, 0), new Instr(169, "<idef>", 0, 0), new Instr(170, "<idef>", 0, 0), new Instr(171, "<idef>", 0, 0), new Instr(172, "<idef>", 0, 0), new Instr(173, "<idef>", 0, 0), new Instr(174, "<idef>", 0, 0), new Instr(175, "<idef>", 0, 0), new Instr(176, "PUSHB1", 0, 1), new Instr(177, "PUSHB2", 0, 2), new Instr(178, "PUSHB3", 0, 3), new Instr(179, "PUSHB4", 0, 4), new Instr(180, "PUSHB5", 0, 5), new Instr(181, "PUSHB6", 0, 6), new Instr(182, "PUSHB7", 0, 7), new Instr(183, "PUSHB8", 0, 8), new Instr(184, "PUSHW1", 0, 1), new Instr(185, "PUSHW2", 0, 2), new Instr(186, "PUSHW3", 0, 3), new Instr(187, "PUSHW4", 0, 4), new Instr(188, "PUSHW5", 0, 5), new Instr(189, "PUSHW6", 0, 6), new Instr(190, "PUSHW7", 0, 7), new Instr(191, "PUSHW8", 0, 8), new Instr(192, "MoveDirectRelativePoint {comp0}", 1, 0), new Instr(193, "MoveDirectRelativePoint {comp1}", 1, 0), new Instr(194, "MoveDirectRelativePoint {comp2}", 1, 0), new Instr(195, "MoveDirectRelativePoint {comp3}", 1, 0), new Instr(196, "MoveDirectRelativePoint {round, comp0}", 1, 0), new Instr(197, "MoveDirectRelativePoint {round, comp1}", 1, 0), new Instr(198, "MoveDirectRelativePoint {round, comp2}", 1, 0), new Instr(199, "MoveDirectRelativePoint {round, comp3}", 1, 0), new Instr(200, "MoveDirectRelativePoint {keepMin, comp0}", 1, 0), new Instr(201, "MoveDirectRelativePoint {keepMin, comp1}", 1, 0), new Instr(202, "MoveDirectRelativePoint {keepMin, comp2}", 1, 0), new Instr(203, "MoveDirectRelativePoint {keepMin, comp3}", 1, 0), new Instr(204, "MoveDirectRelativePoint {keepMin, round, comp0}", 1, 0), new Instr(205, "MoveDirectRelativePoint {keepMin, round, comp1}", 1, 0), new Instr(206, "MoveDirectRelativePoint {keepMin, round, comp2}", 1, 0), new Instr(207, "MoveDirectRelativePoint {keepMin, round, comp3}", 1, 0), new Instr(208, "MoveDirectRelativePoint {setRp0, comp0}", 1, 0), new Instr(209, "MoveDirectRelativePoint {setRp0, comp1}", 1, 0), new Instr(210, "MoveDirectRelativePoint {setRp0, comp2}", 1, 0), new Instr(211, "MoveDirectRelativePoint {setRp0, comp3}", 1, 0), new Instr(212, "MoveDirectRelativePoint {setRp0, round, comp0}", 1, 0), new Instr(213, "MoveDirectRelativePoint {setRp0, round, comp1}", 1, 0), new Instr(214, "MoveDirectRelativePoint {setRp0, round, comp2}", 1, 0), new Instr(215, "MoveDirectRelativePoint {setRp0, round, comp3}", 1, 0), new Instr(216, "MoveDirectRelativePoint {setRp0, keepMin, comp0}", 1, 0), new Instr(217, "MoveDirectRelativePoint {setRp0, keepMin, comp1}", 1, 0), new Instr(218, "MoveDirectRelativePoint {setRp0, keepMin, comp2}", 1, 0), new Instr(219, "MoveDirectRelativePoint {setRp0, keepMin, comp3}", 1, 0), new Instr(220, "MoveDirectRelativePoint {setRp0, keepMin, round, comp0}", 1, 0), new Instr(221, "MoveDirectRelativePoint {setRp0, keepMin, round, comp1}", 1, 0), new Instr(222, "MoveDirectRelativePoint {setRp0, keepMin, round, comp2}", 1, 0), new Instr(223, "MoveDirectRelativePoint {setRp0, keepMin, round, comp3}", 1, 0), new Instr(224, "MoveIndirectRelativePoint {comp0}", 2, 0), new Instr(225, "MoveIndirectRelativePoint {comp1}", 2, 0), new Instr(226, "MoveIndirectRelativePoint {comp2}", 2, 0), new Instr(227, "MoveIndirectRelativePoint {comp3}", 2, 0), new Instr(228, "MoveIndirectRelativePoint {round, comp0}", 2, 0), new Instr(229, "MoveIndirectRelativePoint {round, comp1}", 2, 0), new Instr(230, "MoveIndirectRelativePoint {round, comp2}", 2, 0), new Instr(231, "MoveIndirectRelativePoint {round, comp3}", 2, 0), new Instr(232, "MoveIndirectRelativePoint {keepMin, comp0}", 2, 0), new Instr(233, "MoveIndirectRelativePoint {keepMin, comp1}", 2, 0), new Instr(234, "MoveIndirectRelativePoint {keepMin, comp2}", 2, 0), new Instr(235, "MoveIndirectRelativePoint {keepMin, comp3}", 2, 0), new Instr(236, "MoveIndirectRelativePoint {keepMin, round, comp0}", 2, 0), new Instr(237, "MoveIndirectRelativePoint {keepMin, round, comp1}", 2, 0), new Instr(238, "MoveIndirectRelativePoint {keepMin, round, comp2}", 2, 0), new Instr(239, "MoveIndirectRelativePoint {keepMin, round, comp3}", 2, 0), new Instr(240, "MoveIndirectRelativePoint {setRp0, comp0}", 2, 0), new Instr(241, "MoveIndirectRelativePoint {setRp0, comp1}", 2, 0), new Instr(242, "MoveIndirectRelativePoint {setRp0, comp2}", 2, 0), new Instr(243, "MoveIndirectRelativePoint {setRp0, comp3}", 2, 0), new Instr(244, "MoveIndirectRelativePoint {setRp0, round, comp0}", 2, 0), new Instr(245, "MoveIndirectRelativePoint {setRp0, round, comp1}", 2, 0), new Instr(246, "MoveIndirectRelativePoint {setRp0, round, comp2}", 2, 0), new Instr(247, "MoveIndirectRelativePoint {setRp0, round, comp3}", 2, 0), new Instr(248, "MoveIndirectRelativePoint {setRp0, keepMin, comp0}", 2, 0), new Instr(249, "MoveIndirectRelativePoint {setRp0, keepMin, comp1}", 2, 0), new Instr(250, "MoveIndirectRelativePoint {setRp0, keepMin, comp2}", 2, 0), new Instr(251, "MoveIndirectRelativePoint {setRp0, keepMin, comp3}", 2, 0), new Instr(252, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp0}", 2, 0), new Instr(253, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp1}", 2, 0), new Instr(254, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp2}", 2, 0), new Instr(255, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp3}", 2, 0)};
    private ScalerDebugger debugger;
    private Instr currentInstr;
    private StringBuffer sb = new StringBuffer();
    private StringBuffer sbDetails = new StringBuffer();

    public TTInterpreter(int storageAreaSize, int maxStackDepth, int cvtSize, OTByteArray cvt, int nbFunctionDefs, int nbTwilightPoints) throws InvalidFontException, UnsupportedFontException {
        this.gs = new GraphicState(cvtSize, cvt);
        this.gp = new GraphicParameters();
        this.storageArea = new StorageArea(storageAreaSize);
        this.stack = new Stack(maxStackDepth);
        this.functionDefs = new FunctionDefinitions(nbFunctionDefs);
        this.instructionDefs = new FunctionDefinitions(256);
        this.twilightZone = new TTPoint[nbTwilightPoints];
        for (int p = 0; p < this.twilightZone.length; ++p) {
            this.twilightZone[p] = new TTPoint(0, 0, false);
        }
    }

    public void setUnitsPerEm(int unitsPerEm) {
        this.unitsPerEm = unitsPerEm;
    }

    public void setScaling(double pointSize, double ppemX, double ppemY, double dX, double dY) throws InvalidFontException, UnsupportedFontException {
        int ay;
        int ax;
        this.gs.setPointSize(pointSize);
        boolean hintAtEmSquare = false;
        boolean integerScaling = false;
        this.em2px = new Matrix(ppemX, 0.0, 0.0, ppemY, dX, dY);
        if (hintAtEmSquare) {
            ax = F16Dot16.fromInt(this.unitsPerEm);
            ay = F16Dot16.fromInt(this.unitsPerEm);
        } else {
            ax = F16Dot16.fromDouble(Math.max(this.em2px.a, this.em2px.c));
            ay = F16Dot16.fromDouble(Math.max(this.em2px.b, this.em2px.d));
            if (integerScaling) {
                ax = F16Dot16.round(ax);
                ay = F16Dot16.round(ay);
            }
        }
        this.gs.cvtxN = ax;
        this.gs.cvtD = F16Dot16.fromInt(this.unitsPerEm);
        this.gs.cvtyN = ay;
        if (ax >= ay) {
            ((GraphicState)this.gs).cvtStretch.x = 65536;
            ((GraphicState)this.gs).cvtStretch.y = F16Dot16.divide(ay, ax);
            this.gs.setPixelsPerEm(ppemX);
        } else {
            ((GraphicState)this.gs).cvtStretch.x = F16Dot16.divide(ax, ay);
            ((GraphicState)this.gs).cvtStretch.y = 65536;
            this.gs.setPixelsPerEm(ppemY);
        }
        this.gs.resetAndScaleCVT();
    }

    private TTPoint getPoint(TTOutline outline, int zone, int index) throws InvalidGlyphException {
        if (zone == 0) {
            return this.twilightZone[index];
        }
        return outline.getPoint(index);
    }

    private int getNumOutlinePoints(TTOutline outline, int zone) throws InvalidGlyphException {
        if (zone == 0) {
            return this.twilightZone.length;
        }
        return outline.getNumOutlinePoints();
    }

    public int getScanType() {
        int scanControl = this.gs.getScanControl();
        int ppemThreshold = scanControl & 0xFF;
        boolean imageIsRotated = false;
        boolean imageIsStretched = false;
        boolean doScanControl = (scanControl & 0x100) != 0 && this.gs.getPixelsPerEm() <= ppemThreshold ? true : ((scanControl & 0x100) != 0 && ppemThreshold == 255 ? true : ((scanControl & 0x200) != 0 && imageIsRotated ? true : ((scanControl & 0x400) != 0 && imageIsStretched ? true : ((scanControl & 0x800) != 0 && this.gs.getPixelsPerEm() > ppemThreshold ? false : ((scanControl & 0x1000) != 0 && !imageIsRotated ? false : ((scanControl & 0x2000) != 0 && !imageIsStretched ? false : false))))));
        if (doScanControl) {
            return scanControl >> 16;
        }
        return 2;
    }

    public void runFpgm(OTByteArray instructionStream, int offset, int limit) throws InvalidFontException, UnsupportedFontException {
        this.run(null, instructionStream, offset, limit);
    }

    public void runPrep(OTByteArray instructionStream, int offset, int limit) throws InvalidFontException, UnsupportedFontException {
        if (this.gs.getPixelsPerEm() <= 1) {
            return;
        }
        this.gs.setAutoFlip(true);
        this.gs.setDeltaBase(9);
        this.gs.setDeltaShift(3);
        this.gs.setRoundMode(this.gs.ROUND_TO_GRID);
        this.gs.setMinimumDistance(64);
        this.gs.setControlValueCutIn(F26Dot6.fromDouble(1.0625));
        this.gs.setSingleWidth(0);
        this.gs.setSingleWidthCutIn(0);
        this.gs.setAngleWeight(128);
        this.gs.setScanControl(0);
        this.gs.setInstrControl(0);
        try {
            this.gs.defaultGraphicState = (LocalGraphicState)this.gs.localGraphicState.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("LocalGraphicState cannot be cloned!");
        }
        this.run(null, instructionStream, offset, limit);
        if ((this.gs.getInstrControl() & 2) == 0) {
            try {
                this.gs.defaultGraphicState = (LocalGraphicState)this.gs.localGraphicState.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("LocalGraphicState cannot be cloned!");
            }
        }
    }

    public void runGlyf(TTSimpleOutline outline, OTByteArray instructionStream, int offset, int limit) throws InvalidGlyphException, UnsupportedFontException {
        if (this.gs.getPixelsPerEm() <= 1) {
            return;
        }
        if ((this.gs.getInstrControl() & 1) != 0) {
            return;
        }
        try {
            this.gs.localGraphicState = (LocalGraphicState)this.gs.defaultGraphicState.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("LocalGraphicState cannot be cloned!");
        }
        this.run(outline, instructionStream, offset, limit);
    }

    private void run(TTSimpleOutline outline, OTByteArray instructionStream, int offset, int limit) throws InvalidGlyphException, UnsupportedFontException {
        this.gs.setRp0(0);
        this.gs.setRp1(0);
        this.gs.setRp2(0);
        this.gs.setZp0(1);
        this.gs.setZp1(1);
        this.gs.setZp2(1);
        this.gs.setVector(this.gs.projectionVector, 16384, 0, false);
        this.gs.setVector(this.gs.freedomVector, 16384, 0, false);
        this.gs.setVector(this.gs.originalProjectionVector, 16384, 0, false);
        this.gs.setLoopVariable(1);
        this.runWithoutInit(outline, instructionStream, offset, limit);
    }

    private int scaleAndRound(int value, int numerator, int denominator) {
        int d2 = denominator >> 1;
        value = value < 0 ? -(-value * numerator + d2) / denominator : (value * numerator + d2) / denominator;
        return value;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runWithoutInit(TTSimpleOutline outline, OTByteArray instructionStream, int offset, int limit) throws InvalidGlyphException, UnsupportedFontException {
        block242: {
            start = offset;
            try {
                block153: while (offset < limit) {
                    instruction = instructionStream.getuint8(offset);
                    ++offset;
                    switch (instruction) {
                        case 64: {
                            n = instructionStream.getuint8(offset);
                            ++offset;
                            for (i = 0; i < n; ++offset, ++i) {
                                this.stack.push(instructionStream.getuint8(offset));
                            }
                            continue block153;
                        }
                        case 65: {
                            n = instructionStream.getuint8(offset);
                            ++offset;
                            for (i = 0; i < n; offset += 2, ++i) {
                                this.stack.push(instructionStream.getint16(offset));
                            }
                            continue block153;
                        }
                        case 176: 
                        case 177: 
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: {
                            n = (instruction & 7) + 1;
                            for (i = 0; i < n; ++offset, ++i) {
                                this.stack.push(instructionStream.getuint8(offset));
                            }
                            continue block153;
                        }
                        case 184: 
                        case 185: 
                        case 186: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: {
                            n = (instruction & 7) + 1;
                            for (i = 0; i < n; offset += 2, ++i) {
                                this.stack.push(instructionStream.getint16(offset));
                            }
                            continue block153;
                        }
                        case 67: {
                            this.stack.push(this.storageArea.getuint32(this.stack.pop()));
                            break;
                        }
                        case 66: {
                            value = this.stack.pop();
                            location = this.stack.pop();
                            this.storageArea.setuint32(location, value);
                            break;
                        }
                        case 68: {
                            value = this.stack.pop();
                            location = this.stack.pop();
                            this.gs.putCVT(location, value);
                            break;
                        }
                        case 112: {
                            value = this.stack.pop();
                            location = this.stack.pop();
                            this.gs.putCVTPixels(location, value);
                            break;
                        }
                        case 69: {
                            this.stack.push(this.gs.getCVT(this.stack.pop()));
                            break;
                        }
                        case 0: 
                        case 1: {
                            rotate = (instruction & 1) == 0;
                            this.gs.setVector(GraphicState.access$2000(this.gs), 16384, 0, rotate);
                            this.gs.setVector(GraphicState.access$2200(this.gs), 16384, 0, rotate);
                            this.gs.setVector(GraphicState.access$2100(this.gs), 16384, 0, rotate);
                            break;
                        }
                        case 2: 
                        case 3: {
                            rotate = (instruction & 1) == 0;
                            this.gs.setVector(GraphicState.access$2000(this.gs), 16384, 0, rotate);
                            this.gs.setVector(GraphicState.access$2200(this.gs), 16384, 0, rotate);
                            break;
                        }
                        case 4: 
                        case 5: {
                            rotate = (instruction & 1) == 0;
                            this.gs.setVector(GraphicState.access$2100(this.gs), 16384, 0, rotate);
                            break;
                        }
                        case 6: 
                        case 7: {
                            rotate = (instruction & 1) == 1;
                            p1 = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                            p2 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            this.gs.setVector(GraphicState.access$2000(this.gs), p1.hinted, p2.hinted, rotate);
                            break;
                        }
                        case 8: 
                        case 9: {
                            rotate = (instruction & 1) == 1;
                            p1 = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                            p2 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            this.gs.setVector(GraphicState.access$2100(this.gs), p1.hinted, p2.hinted, rotate);
                            break;
                        }
                        case 134: 
                        case 135: {
                            rotate = (instruction & 1) == 1;
                            p1 = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                            p2 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            this.gs.setVector(GraphicState.access$2200(this.gs), p1.unhinted, p2.unhinted, rotate);
                            this.gs.setVector(GraphicState.access$2000(this.gs), p1.hinted, p2.hinted, rotate);
                            break;
                        }
                        case 14: {
                            this.gs.setVector(GraphicState.access$2100(this.gs), GraphicState.access$2000((GraphicState)this.gs).x, GraphicState.access$2000((GraphicState)this.gs).y, false);
                            break;
                        }
                        case 10: {
                            y = this.stack.pop();
                            x = this.stack.pop();
                            this.gs.setVector(GraphicState.access$2000(this.gs), x, y, false);
                            this.gs.setVector(GraphicState.access$2200(this.gs), x, y, false);
                            break;
                        }
                        case 11: {
                            y = this.stack.pop();
                            x = this.stack.pop();
                            this.gs.setVector(GraphicState.access$2100(this.gs), x, y, false);
                            break;
                        }
                        case 12: {
                            this.stack.push(GraphicState.access$2000((GraphicState)this.gs).x);
                            this.stack.push(GraphicState.access$2000((GraphicState)this.gs).y);
                            break;
                        }
                        case 13: {
                            this.stack.push(GraphicState.access$2100((GraphicState)this.gs).x);
                            this.stack.push(GraphicState.access$2100((GraphicState)this.gs).y);
                            break;
                        }
                        case 16: {
                            this.gs.setRp0(this.stack.pop());
                            break;
                        }
                        case 17: {
                            this.gs.setRp1(this.stack.pop());
                            break;
                        }
                        case 18: {
                            this.gs.setRp2(this.stack.pop());
                            break;
                        }
                        case 19: {
                            this.gs.setZp0(this.stack.pop());
                            break;
                        }
                        case 20: {
                            this.gs.setZp1(this.stack.pop());
                            break;
                        }
                        case 21: {
                            this.gs.setZp2(this.stack.pop());
                            break;
                        }
                        case 22: {
                            zone = this.stack.pop();
                            this.gs.setZp0(zone);
                            this.gs.setZp1(zone);
                            this.gs.setZp2(zone);
                            break;
                        }
                        case 25: {
                            this.gs.setRoundMode(this.gs.ROUND_TO_HALF_GRID);
                            break;
                        }
                        case 24: {
                            this.gs.setRoundMode(this.gs.ROUND_TO_GRID);
                            break;
                        }
                        case 61: {
                            this.gs.setRoundMode(this.gs.ROUND_TO_DOUBLE_GRID);
                            break;
                        }
                        case 125: {
                            this.gs.setRoundMode(this.gs.ROUND_DOWN_TO_GRID);
                            break;
                        }
                        case 124: {
                            this.gs.setRoundMode(this.gs.ROUND_UP_TO_GRID);
                            break;
                        }
                        case 122: {
                            this.gs.setRoundMode(this.gs.ROUND_OFF);
                            break;
                        }
                        case 118: 
                        case 119: {
                            n = this.stack.pop();
                            phase = 0;
                            if ((instruction & 1) == 0) {
                                switch (n & 192) {
                                    case 0: {
                                        period = 32;
                                        break;
                                    }
                                    case 64: {
                                        period = 64;
                                        break;
                                    }
                                    case 128: {
                                        period = 128;
                                        break;
                                    }
                                    default: {
                                        period = 999;
                                        break;
                                    }
                                }
                            } else {
                                period45 = 11591;
                                switch (n & 192) {
                                    case 0: {
                                        period45 >>= 1;
                                        break;
                                    }
                                    case 64: {
                                        break;
                                    }
                                    case 128: {
                                        period45 <<= 1;
                                        break;
                                    }
                                    default: {
                                        period45 = 999;
                                    }
                                }
                                tmp = 8;
                                period = period45 + (1 << tmp - 1) >> tmp;
                            }
                            switch (n & 48) {
                                case 0: {
                                    phase = 0;
                                    break;
                                }
                                case 16: {
                                    phase = period + 2 >> 2;
                                    break;
                                }
                                case 32: {
                                    phase = period + 1 >> 1;
                                    break;
                                }
                                case 48: {
                                    phase = period + period + period + 2 >> 2;
                                    break;
                                }
                            }
                            threshold = (n & 15) == 0 ? period - 1 : ((n & 15) - 4) * period + 4 >> 3;
                            this.gs.setRounding(period, phase, threshold, (instruction & 1) == 0 ? this.gs.SUPER_ROUND : this.gs.SUPER_45_ROUND);
                            break;
                        }
                        case 23: {
                            this.gs.setLoopVariable(this.stack.pop());
                            break;
                        }
                        case 26: {
                            this.gs.setMinimumDistance(this.stack.pop());
                            break;
                        }
                        case 142: {
                            selectorFlag = this.stack.pop();
                            value = this.stack.pop();
                            instrControl = this.gs.getInstrControl();
                            if (selectorFlag == 1) {
                                instrControl &= -2;
                            } else if (selectorFlag == 2) {
                                instrControl &= -3;
                            }
                            this.gs.setInstrControl(instrControl |= value);
                            break;
                        }
                        case 133: {
                            this.gs.setScanControl(this.gs.getScanControl() & -65536 | this.stack.pop() & 65535);
                            break;
                        }
                        case 141: {
                            this.gs.setScanControl(this.stack.pop() << 16 | this.gs.getScanControl() & 65535);
                            break;
                        }
                        case 29: {
                            this.gs.setControlValueCutIn(this.stack.pop());
                            break;
                        }
                        case 30: {
                            this.gs.setSingleWidthCutIn(this.stack.pop());
                            break;
                        }
                        case 31: {
                            this.gs.setSingleWidth(this.stack.pop());
                            break;
                        }
                        case 77: {
                            this.gs.setAutoFlip(true);
                            break;
                        }
                        case 78: {
                            this.gs.setAutoFlip(false);
                            break;
                        }
                        case 126: {
                            this.gs.setAngleWeight(this.stack.pop());
                            break;
                        }
                        case 94: {
                            this.gs.setDeltaBase(this.stack.pop());
                            break;
                        }
                        case 95: {
                            this.gs.setDeltaShift(this.stack.pop());
                            break;
                        }
                        case 70: 
                        case 71: {
                            pt = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                            if ((instruction & 1) == 0) {
                                this.stack.push(this.gs.project(GraphicState.access$2000(this.gs), pt.hinted));
                                break;
                            }
                            this.stack.push(this.gs.project(GraphicState.access$2200(this.gs), pt.unhinted));
                            break;
                        }
                        case 72: {
                            targetCoordinate = this.stack.pop();
                            p = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                            actualCoordinate = this.gs.project(GraphicState.access$2000(this.gs), p.hinted);
                            this.gs.move(p, targetCoordinate - actualCoordinate);
                            if (this.gs.getZp2() != 0) continue block153;
                            p.unhinted.x = p.hinted.x;
                            p.unhinted.y = p.hinted.y;
                            break;
                        }
                        case 73: 
                        case 74: {
                            p1 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            p2 = this.getPoint(outline, this.gs.getZp0(), this.stack.pop());
                            v = (instruction & 1) == 0 ? this.gs.project(GraphicState.access$2200(this.gs), p1.unhinted, p2.unhinted) : this.gs.project(GraphicState.access$2000(this.gs), p1.hinted, p2.hinted);
                            this.stack.push(v);
                            break;
                        }
                        case 75: {
                            this.stack.push(this.gs.getPixelsPerEm());
                            break;
                        }
                        case 76: {
                            this.stack.push(this.gs.getPointSize());
                            break;
                        }
                        case 128: {
                            zone = this.gs.getZp0();
                            for (count = this.gs.getAndResetLoopVariable(); count > 0; --count) {
                                p = this.getPoint(outline, zone, this.stack.pop());
                                p.onCurve = p.onCurve == false;
                            }
                            continue block153;
                        }
                        case 129: 
                        case 130: {
                            zone = this.gs.getZp0();
                            hp = this.stack.pop();
                            lp = this.stack.pop();
                            onCurve = (instruction & 1) == 1;
                            for (i = lp; i <= hp; ++i) {
                                this.getPoint((TTOutline)outline, (int)zone, (int)i).onCurve = onCurve;
                            }
                            continue block153;
                        }
                        case 50: 
                        case 51: {
                            lastPoint = (instruction & 1) == 0 ? this.getPoint(outline, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(outline, this.gs.getZp0(), this.gs.getRp1());
                            delta = this.gs.project(GraphicState.access$2000(this.gs), lastPoint.unhinted, lastPoint.hinted);
                            dx = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, GraphicState.access$2100((GraphicState)this.gs).x, GraphicState.access$2300(this.gs));
                            dy = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, GraphicState.access$2100((GraphicState)this.gs).y, GraphicState.access$2300(this.gs));
                            for (count = this.gs.getAndResetLoopVariable(); count > 0; --count) {
                                p = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                                if (p == lastPoint) continue;
                                this.gs.move(p, dx, dy);
                            }
                            continue block153;
                        }
                        case 52: 
                        case 53: {
                            contour = this.stack.pop();
                            lastPoint = (instruction & 1) == 0 ? this.getPoint(outline, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(outline, this.gs.getZp0(), this.gs.getRp1());
                            delta = this.gs.project(GraphicState.access$2000(this.gs), lastPoint.unhinted, lastPoint.hinted);
                            dx = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, GraphicState.access$2100((GraphicState)this.gs).x, GraphicState.access$2300(this.gs));
                            dy = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, GraphicState.access$2100((GraphicState)this.gs).y, GraphicState.access$2300(this.gs));
                            first = outline.getContourFirstPoint(contour);
                            last = outline.getContourLastPoint(contour);
                            for (i = first; i <= last; ++i) {
                                p = this.getPoint(outline, this.gs.getZp2(), i);
                                if (p == lastPoint) continue;
                                this.gs.move(p, dx, dy);
                            }
                            continue block153;
                        }
                        case 54: 
                        case 55: {
                            zone = this.stack.pop();
                            lastPoint = (instruction & 1) == 0 ? this.getPoint(outline, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(outline, this.gs.getZp0(), this.gs.getRp1());
                            delta = this.gs.project(GraphicState.access$2000(this.gs), lastPoint.unhinted, lastPoint.hinted);
                            dx = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, GraphicState.access$2100((GraphicState)this.gs).x, GraphicState.access$2300(this.gs));
                            dy = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, GraphicState.access$2100((GraphicState)this.gs).y, GraphicState.access$2300(this.gs));
                            first = 0;
                            last = this.getNumOutlinePoints(outline, zone) - 1;
                            for (i = first; i <= last; ++i) {
                                p = this.getPoint(outline, zone, i);
                                if (p == lastPoint) continue;
                                this.gs.move(p, dx, dy);
                            }
                            continue block153;
                        }
                        case 56: {
                            shiftAmount = this.stack.pop();
                            dx = F26Dot6.multiplyByF2Dot14(shiftAmount, GraphicState.access$2100((GraphicState)this.gs).x);
                            dy = F26Dot6.multiplyByF2Dot14(shiftAmount, GraphicState.access$2100((GraphicState)this.gs).y);
                            for (count = this.gs.getAndResetLoopVariable(); count > 0; --count) {
                                p = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                                this.gs.move(p, dx, dy);
                            }
                            continue block153;
                        }
                        case 58: 
                        case 59: {
                            desiredDistance = this.stack.pop();
                            pIndex = this.stack.pop();
                            p = this.getPoint(outline, this.gs.getZp1(), pIndex);
                            rp0 = this.getPoint(outline, this.gs.getZp0(), this.gs.getRp0());
                            if (this.gs.getZp1() == 0) {
                                p.unhinted.x = F26Dot6.multiplyByF2Dot14(desiredDistance, GraphicState.access$2000((GraphicState)this.gs).x);
                                p.unhinted.y = F26Dot6.multiplyByF2Dot14(desiredDistance, GraphicState.access$2000((GraphicState)this.gs).y);
                                p.hinted.x = p.unhinted.x;
                                p.hinted.y = p.unhinted.y;
                            }
                            actualDistance = this.gs.project(GraphicState.access$2000(this.gs), rp0.hinted, p.hinted);
                            this.gs.move(p, desiredDistance - actualDistance);
                            this.gs.setRp1(this.gs.getRp0());
                            this.gs.setRp2(pIndex);
                            if ((instruction & 1) == 0) continue block153;
                            this.gs.setRp0(pIndex);
                            break;
                        }
                        case 46: 
                        case 47: {
                            pIndex = this.stack.pop();
                            p = this.getPoint(outline, this.gs.getZp0(), pIndex);
                            this.gs.setRp0(pIndex);
                            this.gs.setRp1(pIndex);
                            delta = 0;
                            if ((instruction & 1) != 0) {
                                projection = this.gs.project(GraphicState.access$2000(this.gs), p.hinted);
                                delta = this.gs.round(projection, this.gp.getEngineCompensation(0)) - projection;
                            }
                            this.gs.move(p, delta);
                            break;
                        }
                        case 62: 
                        case 63: {
                            desiredDistance = this.gs.getCVT(this.stack.pop());
                            pIndex = this.stack.pop();
                            p = this.getPoint(outline, this.gs.getZp0(), pIndex);
                            this.gs.setRp0(pIndex);
                            this.gs.setRp1(pIndex);
                            if (this.gs.getZp0() == 0) {
                                p.unhinted.x = F26Dot6.multiplyByF2Dot14(desiredDistance, GraphicState.access$2000((GraphicState)this.gs).x);
                                p.unhinted.y = F26Dot6.multiplyByF2Dot14(desiredDistance, GraphicState.access$2000((GraphicState)this.gs).y);
                                p.hinted.x = p.unhinted.x;
                                p.hinted.y = p.unhinted.y;
                            }
                            currentDistance = this.gs.project(GraphicState.access$2000(this.gs), p.hinted);
                            if ((instruction & 1) != 0) {
                                if (Math.abs(desiredDistance - currentDistance) > this.gs.getControlValueCutIn()) {
                                    desiredDistance = currentDistance;
                                }
                                desiredDistance = this.gs.round(desiredDistance, this.gp.getEngineCompensation(0));
                            }
                            this.gs.move(p, desiredDistance - currentDistance);
                            break;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: {
                            pIndex = this.stack.pop();
                            p = this.getPoint(outline, this.gs.getZp1(), pIndex);
                            rp0 = this.getPoint(outline, this.gs.getZp0(), this.gs.getRp0());
                            if (this.gs.getZp0() == 0 || this.gs.getZp1() == 0 || outline.unscaledCoordinatesAreInvalid) {
                                desiredDistance = this.gs.project(GraphicState.access$2200(this.gs), rp0.unhinted, p.unhinted);
                            } else {
                                xDiff = this.scaleAndRound(p.unscaled.x - rp0.unscaled.x, GraphicState.access$1600(this.gs) >> 10, GraphicState.access$1700(this.gs) >> 16);
                                yDiff = this.scaleAndRound(p.unscaled.y - rp0.unscaled.y, GraphicState.access$1800(this.gs) >> 10, GraphicState.access$1700(this.gs) >> 16);
                                desiredDistance = this.gs.project(GraphicState.access$2200(this.gs), xDiff, yDiff);
                            }
                            unroundedDesiredDistance = desiredDistance = this.gs.snapToSingleWidth(desiredDistance);
                            engineCompensation = this.gp.getEngineCompensation(instruction & 3);
                            desiredDistance = (instruction & 4) != 0 ? this.gs.round(desiredDistance, engineCompensation) : this.gs.roundOff(desiredDistance, engineCompensation);
                            if ((instruction & 8) != 0) {
                                min = this.gs.getMinimumDistance();
                                if (unroundedDesiredDistance >= 0) {
                                    if (desiredDistance < min) {
                                        desiredDistance = min;
                                    }
                                } else if (desiredDistance > -min) {
                                    desiredDistance = -min;
                                }
                            }
                            currentDistance = this.gs.project(GraphicState.access$2000(this.gs), rp0.hinted, p.hinted);
                            this.gs.move(p, desiredDistance - currentDistance);
                            this.gs.setRp1(this.gs.getRp0());
                            this.gs.setRp2(pIndex);
                            if ((instruction & 16) == 0) continue block153;
                            this.gs.setRp0(pIndex);
                            break;
                        }
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: {
                            desiredDistance = this.gs.getCVT(this.stack.pop());
                            pIndex = this.stack.pop();
                            p = this.getPoint(outline, this.gs.getZp1(), pIndex);
                            rp0 = this.getPoint(outline, this.gs.getZp0(), this.gs.getRp0());
                            desiredDistance = this.gs.snapToSingleWidth(desiredDistance);
                            if (this.gs.getZp1() == 0) {
                                p.unhinted.x = rp0.unhinted.x + F26Dot6.multiplyByF2Dot14(desiredDistance, GraphicState.access$2000((GraphicState)this.gs).x);
                                p.unhinted.y = rp0.unhinted.y + F26Dot6.multiplyByF2Dot14(desiredDistance, GraphicState.access$2000((GraphicState)this.gs).y);
                                p.hinted.x = p.unhinted.x;
                                p.hinted.y = p.unhinted.y;
                            }
                            originalDistance = this.gs.project(GraphicState.access$2200(this.gs), rp0.unhinted, p.unhinted);
                            currentDistance = this.gs.project(GraphicState.access$2000(this.gs), rp0.hinted, p.hinted);
                            if (this.gs.getAutoFlip() && !F26Dot6.sameSign(originalDistance, desiredDistance)) {
                                desiredDistance = -desiredDistance;
                            }
                            engineCompensation = this.gp.getEngineCompensation(instruction & 3);
                            if ((instruction & 4) != 0) {
                                if (Math.abs(desiredDistance - originalDistance) > this.gs.getControlValueCutIn()) {
                                    desiredDistance = originalDistance;
                                }
                                desiredDistance = this.gs.round(desiredDistance, engineCompensation);
                            } else {
                                desiredDistance = this.gs.roundOff(desiredDistance, engineCompensation);
                            }
                            if ((instruction & 8) != 0) {
                                min = this.gs.getMinimumDistance();
                                if (originalDistance >= 0) {
                                    if (desiredDistance < min) {
                                        desiredDistance = min;
                                    }
                                } else if (desiredDistance > -min) {
                                    desiredDistance = -min;
                                }
                            }
                            this.gs.move(p, desiredDistance - currentDistance);
                            this.gs.setRp1(this.gs.getRp0());
                            this.gs.setRp2(pIndex);
                            if ((instruction & 16) == 0) continue block153;
                            this.gs.setRp0(pIndex);
                            break;
                        }
                        case 60: {
                            p0 = this.getPoint(outline, this.gs.getZp0(), this.gs.getRp0());
                            for (count = this.gs.getAndResetLoopVariable(); count > 0; --count) {
                                p = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                                this.gs.move(p, -this.gs.project(GraphicState.access$2000(this.gs), p0.hinted, p.hinted));
                            }
                            continue block153;
                        }
                        case 127: {
                            throw new InvalidGlyphException("TT instruction AA is no longer supported");
                        }
                        case 15: {
                            b1 = this.getPoint(outline, this.gs.getZp0(), this.stack.pop());
                            b0 = this.getPoint(outline, this.gs.getZp0(), this.stack.pop());
                            a1 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            a0 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            p = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                            bx = b1.hinted.x - b0.hinted.x;
                            by = b1.hinted.y - b0.hinted.y;
                            ax = a1.hinted.x - a0.hinted.x;
                            ay = a1.hinted.y - a0.hinted.y;
                            if (by == 0) {
                                if (ax == 0) {
                                    this.gs.set(p, a0.hinted.x, b0.hinted.y);
                                    break;
                                }
                                N = a0.hinted.y - b0.hinted.y;
                                D = -ay;
                            } else if (bx == 0) {
                                if (ay == 0) {
                                    this.gs.set(p, b0.hinted.x, a0.hinted.y);
                                    break;
                                }
                                N = a0.hinted.x - b0.hinted.x;
                                D = -ax;
                            } else if (F26Dot6.abs(bx) >= F26Dot6.abs(by)) {
                                N = a0.hinted.y - b0.hinted.y - F26Dot6.multiplyDivide(a0.hinted.x - b0.hinted.x, by, bx);
                                D = F26Dot6.multiplyDivide(ax, by, bx) - ay;
                            } else {
                                N = F26Dot6.multiplyDivide(a0.hinted.y - b0.hinted.y, bx, by) - (a0.hinted.x - b0.hinted.x);
                                D = ax - F26Dot6.multiplyDivide(ay, bx, by);
                            }
                            if (D != 0) {
                                this.gs.set(p, a0.hinted.x + F26Dot6.multiplyDivide(ax, N, D), a0.hinted.y + F26Dot6.multiplyDivide(ay, N, D));
                                break;
                            }
                            this.gs.set(p, a0.hinted.x + (ax >> 1) + b0.hinted.x + (bx >> 1) >> 1, a0.hinted.y + (ay >> 1) + b0.hinted.y + (by >> 1) >> 1);
                            break;
                        }
                        case 39: {
                            p1 = this.getPoint(outline, this.gs.getZp1(), this.stack.pop());
                            p2 = this.getPoint(outline, this.gs.getZp0(), this.stack.pop());
                            p1_p2 = this.gs.project(GraphicState.access$2000(this.gs), p1.hinted, p2.hinted);
                            this.gs.move(p1, p1_p2 / 2);
                            this.gs.move(p2, p1_p2 - p1_p2 / 2);
                            break;
                        }
                        case 57: {
                            rp1 = this.getPoint(outline, this.gs.getZp0(), this.gs.getRp1());
                            rp2 = this.getPoint(outline, this.gs.getZp1(), this.gs.getRp2());
                            useScaledValues = this.gs.getZp0() == 0 || this.gs.getZp1() == 0 || this.gs.getZp2() == 0 || outline.unscaledCoordinatesAreInvalid != false;
                            rp1_rp2_original = useScaledValues != false ? this.gs.project(GraphicState.access$2200(this.gs), rp1.unhinted, rp2.unhinted) : this.gs.project(GraphicState.access$2200(this.gs), rp2.unscaled.x - rp1.unscaled.x, rp2.unscaled.y - rp1.unscaled.y);
                            rp1_rp2_current = this.gs.project(GraphicState.access$2000(this.gs), rp1.hinted, rp2.hinted);
                            for (count = this.gs.getAndResetLoopVariable(); count > 0; --count) {
                                p = this.getPoint(outline, this.gs.getZp2(), this.stack.pop());
                                rp1_p_original = useScaledValues != false ? this.gs.project(GraphicState.access$2000(this.gs), rp1.unhinted, p.unhinted) : this.gs.project(GraphicState.access$2000(this.gs), p.unscaled.x - rp1.unscaled.x, p.unscaled.y - rp1.unscaled.y);
                                rp1_p_current = this.gs.project(GraphicState.access$2000(this.gs), rp1.hinted, p.hinted);
                                desired = rp1_rp2_original == 0 ? rp1_p_original : F26Dot6.multiplyDivide(rp1_rp2_current, rp1_p_original, rp1_rp2_original);
                                this.gs.move(p, desired - rp1_p_current);
                            }
                            continue block153;
                        }
                        case 41: {
                            p = this.getPoint(outline, this.gs.getZp0(), this.stack.pop());
                            this.gs.untouch(p);
                            break;
                        }
                        case 48: 
                        case 49: {
                            v0 = xDirection = (instruction & 1) == 1;
                            if (this.gs.getZp2() != 1) {
                                throw new InvalidGlyphException("ZP2 should be 1 instead of " + this.gs.getZp2() + " in an IUP instruction");
                            }
                            contour = 0;
lbl523:
                            // 2 sources

                            while (contour < outline.getNumContours()) {
                                first = outline.getContourFirstPoint(contour);
                                last = outline.getContourLastPoint(contour);
                                for (anchor = first; anchor <= last && !this.getPoint(outline, 1, anchor).touched(xDirection); ++anchor) {
                                }
                                if (anchor > last) break block242;
                                touchedBefore = anchor;
                                untouched = outline.getContourNextPoint(contour, anchor);
                                while (untouched != anchor) {
                                    if (this.getPoint(outline, 1, untouched).touched(xDirection)) {
                                        touchedBefore = untouched;
                                        untouched = outline.getContourNextPoint(contour, untouched);
                                        continue;
                                    }
                                    touchedAfter = outline.getContourNextPoint(contour, untouched);
                                    while (!this.getPoint(outline, 1, touchedAfter).touched(xDirection)) {
                                        touchedAfter = outline.getContourNextPoint(contour, touchedAfter);
                                    }
                                    p1 = this.getPoint(outline, 1, touchedBefore);
                                    p2 = this.getPoint(outline, 1, touchedAfter);
                                    v1 = xDirection ? (outline.unscaledCoordinatesAreInvalid ? p1.unhinted.x : p1.unscaled.x) : (orig1 = outline.unscaledCoordinatesAreInvalid != false ? p1.unhinted.y : p1.unscaled.y);
                                    v2 = xDirection ? (outline.unscaledCoordinatesAreInvalid ? p2.unhinted.x : p2.unscaled.x) : (orig2 = outline.unscaledCoordinatesAreInvalid != false ? p2.unhinted.y : p2.unscaled.y);
                                    if (orig1 > orig2) {
                                        temp = p1;
                                        p1 = p2;
                                        p2 = temp;
                                        temp = orig1;
                                        orig1 = orig2;
                                        orig2 = temp;
                                    }
                                    while (untouched != touchedAfter) {
                                        p = this.getPoint(outline, 1, untouched);
                                        orig = xDirection ? (outline.unscaledCoordinatesAreInvalid ? p.unhinted.x : p.unscaled.x) : (outline.unscaledCoordinatesAreInvalid != false ? p.unhinted.y : p.unscaled.y);
                                        oldx = p.hinted.x;
                                        oldy = p.hinted.y;
                                        if (orig1 != orig2) ** GOTO lbl562
                                        if (xDirection) {
                                            p.hinted.x += p2.hinted.x - p2.unhinted.x;
                                        } else {
                                            p.hinted.y += p2.hinted.y - p2.unhinted.y;
                                        }
                                        ** GOTO lbl578
lbl562:
                                        // 1 sources

                                        if (orig1 >= orig || orig >= orig2) ** GOTO lbl568
                                        if (xDirection) {
                                            p.hinted.x = p1.hinted.x + F26Dot6.multiplyDivide(orig - orig1, p2.hinted.x - p1.hinted.x, orig2 - orig1);
                                        } else {
                                            p.hinted.y = p1.hinted.y + F26Dot6.multiplyDivide(orig - orig1, p2.hinted.y - p1.hinted.y, orig2 - orig1);
                                        }
                                        ** GOTO lbl578
lbl568:
                                        // 1 sources

                                        if (orig > orig1) ** GOTO lbl574
                                        if (xDirection) {
                                            p.hinted.x += p1.hinted.x - p1.unhinted.x;
                                        } else {
                                            p.hinted.y += p1.hinted.y - p1.unhinted.y;
                                        }
                                        ** GOTO lbl578
lbl574:
                                        // 1 sources

                                        if (xDirection) {
                                            p.hinted.x += p2.hinted.x - p2.unhinted.x;
                                        } else {
                                            p.hinted.y += p2.hinted.y - p2.unhinted.y;
                                        }
lbl578:
                                        // 8 sources

                                        untouched = outline.getContourNextPoint(contour, untouched);
                                    }
                                }
                                break block242;
                            }
                            continue block153;
                        }
                        case 93: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: {
                            base = instruction == 114 || instruction == 117 ? this.gs.getDeltaBase() + 32 : (instruction == 113 || instruction == 116 ? this.gs.getDeltaBase() + 16 : this.gs.getDeltaBase());
                            pixelsPerEm = this.gs.getPixelsPerEm();
                            n = this.stack.pop();
                            for (i = 0; i < n; ++i) {
                                pointOrCvtEntry = this.stack.pop();
                                exception = this.stack.pop();
                                applyAtPpem = base + (exception >> 4 & 15);
                                if (applyAtPpem != pixelsPerEm) continue;
                                steps = magnitude - ((magnitude = exception & 15) < 8 ? 8 : 7);
                                value = steps << 6 - this.gs.getDeltaShift();
                                if (instruction < 115) {
                                    this.gs.move(this.getPoint(outline, this.gs.getZp0(), pointOrCvtEntry), value);
                                    continue;
                                }
                                this.gs.incrementCVT(pointOrCvtEntry, value);
                            }
                            continue block153;
                        }
                        case 32: {
                            this.stack.copy(1);
                            break;
                        }
                        case 33: {
                            this.stack.pop();
                            break;
                        }
                        case 34: {
                            this.stack.clear();
                            break;
                        }
                        case 35: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e2);
                            this.stack.push(e1);
                            break;
                        }
                        case 36: {
                            this.stack.pushDepth();
                            break;
                        }
                        case 37: {
                            this.stack.copy(this.stack.pop());
                            break;
                        }
                        case 38: {
                            this.stack.bubbleUp(this.stack.pop());
                            break;
                        }
                        case 138: {
                            a = this.stack.pop();
                            b = this.stack.pop();
                            c = this.stack.pop();
                            this.stack.push(b);
                            this.stack.push(a);
                            this.stack.push(c);
                            break;
                        }
                        case 88: {
                            n = this.stack.pop();
                            if (n != 0) continue block153;
                            nestedIfs = 0;
                            targetOffset = offset;
                            isTarget = false;
                            while (targetOffset < limit && !isTarget) {
                                switch (instructionStream.getuint8(targetOffset)) {
                                    case 88: {
                                        ++nestedIfs;
                                        break;
                                    }
                                    case 27: {
                                        if (nestedIfs != 0) break;
                                        isTarget = true;
                                        break;
                                    }
                                    case 89: {
                                        if (nestedIfs == 0) {
                                            isTarget = true;
                                            break;
                                        }
                                        --nestedIfs;
                                        break;
                                    }
                                }
                                targetOffset = this.skipInstruction(instructionStream, targetOffset);
                            }
                            if (!isTarget) {
                                throw new InvalidFontException("incorrect IF - no ELSE or EIF in TT outline");
                            }
                            offset = targetOffset;
                            break;
                        }
                        case 27: {
                            nestedIfs = 0;
                            targetOffset = offset;
                            isTarget = false;
                            while (targetOffset < limit && !isTarget) {
                                switch (instructionStream.getuint8(targetOffset)) {
                                    case 88: {
                                        ++nestedIfs;
                                        break;
                                    }
                                    case 89: {
                                        if (nestedIfs == 0) {
                                            isTarget = true;
                                            break;
                                        }
                                        --nestedIfs;
                                        break;
                                    }
                                }
                                targetOffset = this.skipInstruction(instructionStream, targetOffset);
                            }
                            if (!isTarget) {
                                throw new InvalidGlyphException("incorrect IF - ELSE - no EIF in TT outline");
                            }
                            offset = targetOffset;
                            break;
                        }
                        case 89: {
                            break;
                        }
                        case 120: {
                            b = this.stack.pop();
                            off = this.stack.pop();
                            if (b == 0 || (offset += off - 1) >= start && limit >= offset) continue block153;
                            throw new InvalidGlyphException("JROF outside of hinted instruction block");
                        }
                        case 28: {
                            off = this.stack.pop();
                            if ((offset += off - 1) >= start && limit >= offset) continue block153;
                            throw new InvalidGlyphException("JROF outside of hinted instruction block");
                        }
                        case 121: {
                            b = this.stack.pop();
                            off = this.stack.pop();
                            if (b != 0 || (offset += off - 1) >= start && limit >= offset) continue block153;
                            throw new InvalidGlyphException("JROF outside of hinted instruction block");
                        }
                        case 80: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 < e2 ? 1 : 0);
                            break;
                        }
                        case 81: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 <= e2 ? 1 : 0);
                            break;
                        }
                        case 82: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 > e2 ? 1 : 0);
                            break;
                        }
                        case 83: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 >= e2 ? 1 : 0);
                            break;
                        }
                        case 84: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 == e2 ? 1 : 0);
                            break;
                        }
                        case 85: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 != e2 ? 1 : 0);
                            break;
                        }
                        case 86: {
                            e1 = this.stack.pop();
                            this.stack.push(F26Dot6.isEven(this.gs.roundToGrid(e1, 0)) != false ? 0 : 1);
                            break;
                        }
                        case 87: {
                            e1 = this.stack.pop();
                            this.stack.push(F26Dot6.isEven(this.gs.roundToGrid(e1, 0)) != false ? 1 : 0);
                            break;
                        }
                        case 90: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 != 0 && e2 != 0 ? 1 : 0);
                            break;
                        }
                        case 91: {
                            e2 = this.stack.pop();
                            e1 = this.stack.pop();
                            this.stack.push(e1 != 0 || e2 != 0 ? 1 : 0);
                            break;
                        }
                        case 92: {
                            e1 = this.stack.pop();
                            this.stack.push(e1 == 0 ? 1 : 0);
                            break;
                        }
                        case 96: {
                            this.stack.push(F26Dot6.add(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 97: {
                            e1 = this.stack.pop();
                            e2 = this.stack.pop();
                            this.stack.push(F26Dot6.subtract(e2, e1));
                            break;
                        }
                        case 98: {
                            e1 = this.stack.pop();
                            e2 = this.stack.pop();
                            this.stack.push(F26Dot6.divide(e2, e1));
                            break;
                        }
                        case 99: {
                            this.stack.push(F26Dot6.multiply(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 100: {
                            this.stack.push(F26Dot6.abs(this.stack.pop()));
                            break;
                        }
                        case 101: {
                            this.stack.push(F26Dot6.negate(this.stack.pop()));
                            break;
                        }
                        case 102: {
                            this.stack.push(F26Dot6.floor(this.stack.pop()));
                            break;
                        }
                        case 103: {
                            this.stack.push(F26Dot6.ceiling(this.stack.pop()));
                            break;
                        }
                        case 139: {
                            this.stack.push(Math.max(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 140: {
                            this.stack.push(Math.min(this.stack.pop(), this.stack.pop()));
                            break;
                        }
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: {
                            v = this.stack.pop();
                            this.stack.push(this.gs.round(v, this.gp.getEngineCompensation(instruction & 3)));
                            break;
                        }
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: {
                            v = this.stack.pop();
                            this.stack.push(this.gs.roundOff(v, this.gp.getEngineCompensation(instruction & 3)));
                            break;
                        }
                        case 44: {
                            f = this.stack.pop();
                            if (f < 0 || f > FunctionDefinitions.access$2400(this.functionDefs).length) {
                                throw new InvalidGlyphException("Invalid function identifier in FDEF (" + f + ")");
                            }
                            targetOffset = offset;
                            isTarget = false;
                            while (targetOffset < limit && !isTarget) {
                                switch (instructionStream.getuint8(targetOffset)) {
                                    case 44: 
                                    case 137: {
                                        throw new InvalidGlyphException("Nested FDEF/IDEF definitions");
                                    }
                                    case 45: {
                                        isTarget = true;
                                        break;
                                    }
                                }
                                targetOffset = this.skipInstruction(instructionStream, targetOffset);
                            }
                            if (!isTarget) {
                                throw new InvalidGlyphException("FDEF without IDEF in TT outline");
                            }
                            this.functionDefs.setFunction(f, instructionStream, offset, targetOffset - 1);
                            offset = targetOffset;
                            break;
                        }
                        case 45: {
                            throw new InvalidGlyphException("dangling ENDF");
                        }
                        case 43: {
                            f = this.stack.pop();
                            if (f < 0 || f > FunctionDefinitions.access$2400(this.functionDefs).length) {
                                throw new InvalidGlyphException("Invalid function identifier in CALL (" + f + ")");
                            }
                            if (FunctionDefinitions.access$2500(this.functionDefs)[f] == -1) {
                                throw new InvalidGlyphException("Undefined function identifier in CALL (" + f + ")");
                            }
                            this.runWithoutInit(outline, FunctionDefinitions.access$2400(this.functionDefs)[f], FunctionDefinitions.access$2600(this.functionDefs)[f], FunctionDefinitions.access$2500(this.functionDefs)[f]);
                            break;
                        }
                        case 42: {
                            f = this.stack.pop();
                            count = this.stack.pop();
                            if (f < 0 || f > FunctionDefinitions.access$2400(this.functionDefs).length) {
                                throw new InvalidGlyphException("Invalid function identifier in LOOPCALL (" + f + ")");
                            }
                            if (FunctionDefinitions.access$2500(this.functionDefs)[f] == -1) {
                                throw new InvalidGlyphException("Undefined function identifier in LOOPCALL (" + f + ")");
                            }
                            for (i = 0; i < count; ++i) {
                                this.runWithoutInit(outline, FunctionDefinitions.access$2400(this.functionDefs)[f], FunctionDefinitions.access$2600(this.functionDefs)[f], FunctionDefinitions.access$2500(this.functionDefs)[f]);
                            }
                            continue block153;
                        }
                        case 137: {
                            opcode = this.stack.pop();
                            if (opcode < 0 || opcode > 255) {
                                throw new InvalidGlyphException("Illegal IDEF opcode (" + opcode + ")");
                            }
                            targetOffset = offset;
                            isTarget = false;
                            while (targetOffset < limit && !isTarget) {
                                switch (instructionStream.getuint8(targetOffset)) {
                                    case 44: 
                                    case 137: {
                                        throw new InvalidGlyphException("Nested FDEF/IDEF definitions");
                                    }
                                    case 45: {
                                        isTarget = true;
                                        break;
                                    }
                                }
                                targetOffset = this.skipInstruction(instructionStream, targetOffset);
                            }
                            if (!isTarget) {
                                throw new InvalidGlyphException("IDEF without ENDF TT outline");
                            }
                            offset = targetOffset;
                            this.instructionDefs.setFunction(opcode, instructionStream, offset, targetOffset - 1);
                            offset = targetOffset;
                            break;
                        }
                        case 79: {
                            this.stack.pop();
                            break;
                        }
                        case 136: {
                            selector = this.stack.pop();
                            answer = 0;
                            rotated = false;
                            stretched = false;
                            greyscale = false;
                            if ((selector & 1) != 0) {
                                answer |= 37;
                            }
                            if ((selector & 2) != 0) {
                                answer |= rotated != false ? 256 : 0;
                            }
                            if ((selector & 4) != 0) {
                                answer |= stretched != false ? 512 : 0;
                            }
                            if ((selector & 16) != 0) {
                                answer |= greyscale != false ? 4096 : 0;
                            }
                            this.stack.push(answer);
                            break;
                        }
                        default: {
                            if (FunctionDefinitions.access$2400(this.instructionDefs)[instruction] == null) continue block153;
                            this.runWithoutInit(outline, FunctionDefinitions.access$2400(this.instructionDefs)[instruction], FunctionDefinitions.access$2600(this.instructionDefs)[instruction], FunctionDefinitions.access$2500(this.instructionDefs)[instruction]);
                            break;
                        }
                    }
                }
                return;
            }
            catch (InvalidGlyphException f) {
                throw f;
            }
            catch (InvalidFontException e) {
                throw new InvalidGlyphException(e);
            }
        }
        ++contour;
        ** GOTO lbl523
    }

    private int skipInstruction(OTByteArray instructionStream, int offset) throws InvalidFontException {
        int instruction = instructionStream.getuint8(offset);
        ++offset;
        switch (instruction) {
            case 64: {
                int nBytes = instructionStream.getuint8(offset);
                ++offset;
                offset += nBytes;
                break;
            }
            case 65: {
                int nWords = instructionStream.getuint8(offset);
                ++offset;
                offset += 2 * nWords;
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                offset += (instruction & 7) + 1;
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                offset += 2 * ((instruction & 7) + 1);
            }
        }
        return offset;
    }

    public void setDebugger(ScalerDebugger debugger) {
        this.debugger = debugger;
    }

    private void logInstruction(int offset, int opcode) {
        this.sb.setLength(0);
        this.sbDetails.setLength(0);
        this.currentInstr = instructions[opcode];
        this.sb.append(offset);
        this.sb.append(" ");
        this.sb.append(this.currentInstr.name);
        this.sb.append(" (");
        this.logStack(this.sb, this.currentInstr.stackPop);
        this.sb.append(")");
    }

    private void logResult() {
        if (this.currentInstr.stackPush != 0) {
            this.sb.append(" -> ");
            this.logStack(this.sb, this.currentInstr.stackPush);
        }
        this.sb.append("\n");
        this.sb.append(this.sbDetails);
        this.debugger.ttInterpLog(this.sb.toString());
    }

    private void logDetail(String s) {
        this.sbDetails.append("  ");
        this.sbDetails.append(s);
        this.sbDetails.append("\n");
    }

    private void logDetailNoLn(String s) {
        this.sbDetails.append(s);
    }

    private void logStack(StringBuffer sb, int nbElems) {
        String prefix = "";
        for (int i = 0; i < nbElems; ++i) {
            sb.append(prefix + Integer.toHexString(this.stack.peek(i)));
            prefix = ", ";
        }
    }

    static class Instr {
        int opcode;
        String name;
        int stackPop;
        int stackPush;

        public Instr(int opcode, String name, int stackPop, int stackPush) {
            this.opcode = opcode;
            this.name = name;
            this.stackPop = stackPop;
            this.stackPush = stackPush;
        }
    }

    private final class FunctionDefinitions {
        private OTByteArray[] instructionStreams;
        private int[] start;
        private int[] limit;

        public FunctionDefinitions(int max) {
            this.instructionStreams = new OTByteArray[max];
            this.start = new int[max];
            this.limit = new int[max];
        }

        public void setFunction(int index, OTByteArray instructionStream, int start, int limit) {
            this.instructionStreams[index] = instructionStream;
            this.start[index] = start;
            this.limit[index] = limit;
        }

        static /* synthetic */ OTByteArray[] access$2400(FunctionDefinitions x0) {
            return x0.instructionStreams;
        }

        static /* synthetic */ int[] access$2500(FunctionDefinitions x0) {
            return x0.limit;
        }

        static /* synthetic */ int[] access$2600(FunctionDefinitions x0) {
            return x0.start;
        }
    }

    private final class ControlValueTable {
        private int[] originalData;
        private int[] data;

        ControlValueTable(int nbEntries, OTByteArray cvt) throws InvalidFontException {
            if (nbEntries < 0 || 200000 <= nbEntries) {
                throw new InvalidFontException("attempt to CVT table with " + nbEntries + " entries");
            }
            this.originalData = new int[nbEntries];
            for (int i = 0; i < nbEntries; ++i) {
                this.originalData[i] = cvt.getint16(2 * i);
            }
            this.data = new int[nbEntries];
        }

        void resetAndScale(int N, int D) {
            for (int i = 0; i < this.originalData.length; ++i) {
                this.data[i] = this.scale(this.originalData[i], N, D);
            }
        }

        int countLowZeros(int n) {
            for (int i = 0; i < 32; ++i) {
                if ((n & 1) != 0) {
                    return i;
                }
                n >>= 1;
            }
            return 32;
        }

        int getShift(int v) {
            if ((v & v - 1) != 0 || v == 0) {
                return -1;
            }
            return this.countLowZeros(v);
        }

        int scale(int v, int n, int d) {
            int shift = this.countLowZeros(n | d) - 1;
            if (shift > 0) {
                n >>= shift;
                d >>= shift;
            }
            if (n < 0x2000000) {
                n <<= 6;
            } else {
                d >>= 6;
            }
            if (n <= Short.MAX_VALUE) {
                shift = this.getShift(d);
                if (shift >= 0) {
                    return v * n + (d >> 1) >> shift;
                }
                if (v < 0) {
                    return -(-v * n + (d >> 1)) / d;
                }
                return (v * n + (d >> 1)) / d;
            }
            return F16Dot16.multiply(v, F16Dot16.divide(n, d));
        }

        void put(int entry, int value) throws InvalidGlyphException {
            if (entry < 0 || this.data.length <= entry) {
                throw new InvalidGlyphException("attempt to write CVT entry " + entry + " (" + this.data.length + " actual entries)");
            }
            this.data[entry] = value;
        }

        int get(int entry) throws InvalidGlyphException {
            if (entry < 0 || this.data.length <= entry) {
                return 0;
            }
            return this.data[entry];
        }
    }

    private final class Stack {
        private final int[] data;
        private int currentDepth;

        public Stack(int maxSize) {
            this.data = new int[maxSize];
            this.currentDepth = 0;
        }

        public int pop() throws InvalidGlyphException {
            if (this.currentDepth == 0) {
                throw new InvalidGlyphException("pop on empty TT stack");
            }
            --this.currentDepth;
            return this.data[this.currentDepth];
        }

        public void push(int value) throws InvalidGlyphException {
            if (this.currentDepth > this.data.length) {
                throw new InvalidGlyphException("push on full TT stack");
            }
            this.data[this.currentDepth] = value;
            ++this.currentDepth;
        }

        public int peek(int depth) {
            if (this.currentDepth - depth < 0) {
                System.err.println("*** peek below stack bottom");
            }
            return this.data[this.currentDepth - depth - 1];
        }

        public void clear() {
            this.currentDepth = 0;
        }

        public void copy(int n) throws InvalidGlyphException {
            if (n > this.currentDepth) {
                throw new InvalidGlyphException("index of non-existing TT stack element (" + n + ", currentDepth=" + this.currentDepth + ")");
            }
            this.push(this.data[this.currentDepth - n]);
        }

        public void pushDepth() throws InvalidGlyphException {
            this.push(this.currentDepth);
        }

        public void bubbleUp(int n) throws InvalidGlyphException {
            if (n > this.currentDepth) {
                throw new InvalidGlyphException("index of non-existing TT stack element (" + n + ", currentDepth=" + this.currentDepth + ")");
            }
            int v = this.data[this.currentDepth - n];
            for (int i = this.currentDepth - n; i < this.currentDepth - 1; ++i) {
                this.data[i] = this.data[i + 1];
            }
            this.data[this.currentDepth - 1] = v;
        }
    }

    private final class StorageArea {
        private final int[] data;

        public StorageArea(int size) {
            this.data = new int[size];
        }

        public int getuint32(int location) throws InvalidGlyphException {
            if (location < 0 || this.data.length <= location) {
                throw new InvalidGlyphException("attempting to access TT storage area location " + location + " (must be in [" + 0 + ", " + this.data.length + "[)");
            }
            return this.data[location];
        }

        public void setuint32(int location, int value) throws InvalidGlyphException {
            if (location < 0 || this.data.length <= location) {
                throw new InvalidGlyphException("attempting to access TT storage area location " + location + " (must be in [" + 0 + ", " + this.data.length + "[)");
            }
            this.data[location] = value;
        }
    }

    private final class GraphicParameters {
        private GraphicParameters() {
        }

        int getEngineCompensation(int distanceType) {
            return 0;
        }
    }

    private final class GraphicState {
        LocalGraphicState defaultGraphicState;
        LocalGraphicState localGraphicState;
        final int ROUND_TO_DOUBLE_GRID = 0;
        final int ROUND_TO_GRID = 1;
        final int ROUND_TO_HALF_GRID = 2;
        final int ROUND_OFF = 3;
        final int ROUND_DOWN_TO_GRID = 4;
        final int ROUND_UP_TO_GRID = 5;
        final int SUPER_ROUND = 6;
        final int SUPER_45_ROUND = 7;
        private F2Dot14Vector projectionVector = new F2Dot14Vector(0, 0);
        private F2Dot14Vector freedomVector = new F2Dot14Vector(0, 0);
        private F2Dot14Vector originalProjectionVector = new F2Dot14Vector(0, 0);
        private int fDotP;
        private F16Dot16Vector cvtStretch = new F16Dot16Vector();
        private ControlValueTable controlValueTable;
        private int cvtxN;
        private int cvtyN;
        private int cvtD;
        private double pixelsPerEm;
        private double pointSize;
        private int rp0;
        private int rp1;
        private int rp2;
        private int zp0;
        private int zp1;
        private int zp2;
        private int loopVariable;

        public GraphicState(int cvtSize, OTByteArray cvt) throws InvalidFontException {
            this.cvtStretch.x = 65536;
            this.cvtStretch.y = 65536;
            this.controlValueTable = new ControlValueTable(cvtSize, cvt);
            this.localGraphicState = new LocalGraphicState();
        }

        boolean getAutoFlip() {
            return this.localGraphicState.autoFlip;
        }

        void setAutoFlip(boolean v) {
            this.localGraphicState.autoFlip = v;
        }

        int getAngleWeight() {
            return this.localGraphicState.angleWeight;
        }

        void setAngleWeight(int v) {
            this.localGraphicState.angleWeight = v;
        }

        int getMinimumDistance() {
            return this.localGraphicState.minimumDistance;
        }

        void setMinimumDistance(int v) {
            this.localGraphicState.minimumDistance = v;
        }

        int getControlValueCutIn() {
            return this.localGraphicState.controlValueCutIn;
        }

        void setControlValueCutIn(int v) {
            this.localGraphicState.controlValueCutIn = v;
        }

        int snapToSingleWidth(int distance) {
            if (this.localGraphicState.singleWidth - this.localGraphicState.singleWidthCutIn < distance && distance < this.localGraphicState.singleWidth + this.localGraphicState.singleWidthCutIn) {
                return this.localGraphicState.singleWidth;
            }
            if (-(this.localGraphicState.singleWidth + this.localGraphicState.singleWidthCutIn) < distance && distance < -(this.localGraphicState.singleWidth - this.localGraphicState.singleWidthCutIn)) {
                return -this.localGraphicState.singleWidth;
            }
            return distance;
        }

        void setSingleWidthCutIn(int v) {
            this.localGraphicState.singleWidthCutIn = v;
        }

        void setSingleWidth(int v) {
            this.localGraphicState.singleWidth = v;
        }

        int getDeltaBase() {
            return this.localGraphicState.deltaBase;
        }

        void setDeltaBase(int v) {
            this.localGraphicState.deltaBase = v;
        }

        int getDeltaShift() {
            return this.localGraphicState.deltaShift;
        }

        void setDeltaShift(int v) {
            this.localGraphicState.deltaShift = v;
        }

        void setScanControl(int v) {
            this.localGraphicState.scanControl = v;
        }

        int getScanControl() {
            return this.localGraphicState.scanControl;
        }

        void setInstrControl(int v) {
            this.localGraphicState.instrControl = v;
        }

        int getInstrControl() {
            return this.localGraphicState.instrControl;
        }

        void setRoundMode(int v) {
            this.localGraphicState.roundMode = v;
        }

        void setRounding(int period, int phase, int threshold, int mode) {
            this.localGraphicState.roundPeriod = period;
            this.localGraphicState.roundPhase = phase;
            this.localGraphicState.roundThreshold = threshold;
            this.localGraphicState.roundMode = mode;
        }

        int round(int vIn, int engineCompensation) {
            return this.round(vIn, engineCompensation, this.localGraphicState.roundMode);
        }

        int roundOff(int vIn, int engineCompenstation) {
            return this.round(vIn, engineCompenstation, 3);
        }

        int roundToGrid(int vIn, int engineCompensation) {
            return this.round(vIn, engineCompensation, 1);
        }

        int round(int vIn, int engineCompensation, int roundMode) {
            boolean negate;
            int v;
            if (vIn < 0) {
                v = -vIn;
                negate = true;
            } else {
                v = vIn;
                negate = false;
            }
            v += engineCompensation;
            switch (roundMode) {
                case 0: {
                    v += 16;
                    v &= 0xFFFFFFE0;
                    break;
                }
                case 1: {
                    v += 32;
                    v &= 0xFFFFFFC0;
                    break;
                }
                case 2: {
                    v &= 0xFFFFFFC0;
                    v += 32;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    v &= 0xFFFFFFC0;
                    break;
                }
                case 5: {
                    v += 63;
                    v &= 0xFFFFFFC0;
                    break;
                }
                case 6: {
                    v += this.localGraphicState.roundThreshold - this.localGraphicState.roundPhase;
                    v &= ~(this.localGraphicState.roundPeriod - 1);
                    v += this.localGraphicState.roundPhase;
                    break;
                }
                case 7: {
                    v = F26Dot6.divideByF2Dot14(v, this.localGraphicState.roundPeriod);
                    v = F26Dot6.truncate(v);
                    v = F26Dot6.multiplyByF2Dot14(v, this.localGraphicState.roundPeriod);
                    v += this.localGraphicState.roundPhase;
                }
            }
            if (negate) {
                v = -v;
            }
            if (!F26Dot6.sameSign(v, vIn) && vIn != 0) {
                v = 0;
            }
            return v;
        }

        void setVector(F2Dot14Vector v, F26Dot6Vector p1, F26Dot6Vector p2, boolean rotate) {
            int x = p2.x - p1.x;
            int y = p2.y - p1.y;
            if (x == 0 && y == 0) {
                this.setVector(v, 16384, 0, rotate);
            } else {
                double xx = F26Dot6.toDouble(x);
                double yy = F26Dot6.toDouble(y);
                double length = Math.sqrt(xx * xx + yy * yy);
                this.setVector(v, F2Dot14.fromDouble(xx / length), F2Dot14.fromDouble(yy / length), rotate);
            }
        }

        void setVector(F2Dot14Vector v, int x, int y, boolean rotate) {
            if (rotate) {
                v.x = -y;
                v.y = x;
            } else {
                v.x = x;
                v.y = y;
            }
            if (v == this.projectionVector || v == this.freedomVector) {
                this.fDotP = F2Dot14.multiply(this.projectionVector.x, this.freedomVector.x) + F2Dot14.multiply(this.projectionVector.y, this.freedomVector.y);
                if (-1024 < this.fDotP && this.fDotP < 1024) {
                    this.fDotP = this.fDotP < 0 ? -16384 : 16384;
                }
            }
        }

        int project(F2Dot14Vector v, int x, int y) {
            return F26Dot6.multiplyByF2Dot14(x, v.x) + F26Dot6.multiplyByF2Dot14(y, v.y);
        }

        int project(F2Dot14Vector v, F26Dot6Vector p) {
            return this.project(v, p.x, p.y);
        }

        int project(F2Dot14Vector v, F26Dot6Vector p1, F26Dot6Vector p2) {
            return this.project(v, p2.x - p1.x, p2.y - p1.y);
        }

        void resetAndScaleCVT() {
            this.controlValueTable.resetAndScale(this.cvtxN, this.cvtD);
        }

        int getCVTscale() {
            int z = F16Dot16.multiplyByF2Dot14(F16Dot16.square(this.cvtStretch.x), F2Dot14.square(this.projectionVector.x)) + F16Dot16.multiplyByF2Dot14(F16Dot16.square(this.cvtStretch.y), F2Dot14.square(this.projectionVector.y));
            if (z >= 65536) {
                return 65536;
            }
            return F16Dot16.fromDouble(Math.sqrt(F16Dot16.toDouble(z)));
        }

        int getCVT(int cvtIndex) throws InvalidGlyphException {
            return F26Dot6.multiplyByF16Dot16(this.controlValueTable.get(cvtIndex), this.getCVTscale());
        }

        void putCVT(int cvtIndex, int value) throws InvalidGlyphException {
            this.controlValueTable.put(cvtIndex, F26Dot6.divideByF16Dot16(value, this.getCVTscale()));
        }

        void putCVTPixels(int cvtIndex, int value) throws InvalidGlyphException {
            this.controlValueTable.put(cvtIndex, F16Dot16.multiplyDivide(F26Dot6.fromDouble(value), this.cvtxN, this.cvtD));
        }

        void incrementCVT(int cvtIndex, int value) throws InvalidGlyphException {
            this.controlValueTable.put(cvtIndex, this.controlValueTable.get(cvtIndex) + F26Dot6.divideByF16Dot16(value, this.getCVTscale()));
        }

        int getPixelsPerEm() {
            return F26Dot6.toInt(F26Dot6.multiplyByF16Dot16(F26Dot6.fromDouble(this.pixelsPerEm), this.getCVTscale()));
        }

        void setPixelsPerEm(double pixelsPerEm) {
            this.pixelsPerEm = pixelsPerEm;
        }

        int getPointSize() {
            return F26Dot6.fromDouble(this.pointSize);
        }

        void setPointSize(double pointSize) {
            this.pointSize = pointSize;
        }

        void move(TTPoint p, int delta) {
            if (this.fDotP != 16384) {
                if (this.freedomVector.x != 0) {
                    p.hinted.x = this.fDotP == this.freedomVector.x ? (p.hinted.x += delta) : (p.hinted.x += F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, this.freedomVector.x, this.fDotP));
                    p.touchedX = true;
                }
                if (this.freedomVector.y != 0) {
                    p.hinted.y = this.fDotP == this.freedomVector.y ? (p.hinted.y += delta) : (p.hinted.y += F26Dot6.multiplyByF2Dot14DivideByF2Dot14(delta, this.freedomVector.y, this.fDotP));
                    p.touchedY = true;
                }
            } else if (this.freedomVector.x == 16384) {
                p.hinted.x += delta;
                p.touchedX = true;
            } else if (this.freedomVector.y == 16384) {
                p.hinted.y += delta;
                p.touchedY = true;
            } else {
                if (this.freedomVector.x != 0) {
                    p.hinted.x += F26Dot6.multiplyByF2Dot14(delta, this.freedomVector.x);
                    p.touchedX = true;
                }
                if (this.freedomVector.y != 0) {
                    p.hinted.y += F26Dot6.multiplyByF2Dot14(delta, this.freedomVector.y);
                    p.touchedY = true;
                }
            }
        }

        void move(TTPoint p, int deltaX, int deltaY) {
            if (this.freedomVector.x != 0) {
                p.hinted.x += deltaX;
                p.touchedX = true;
            }
            if (this.freedomVector.y != 0) {
                p.hinted.y += deltaY;
                p.touchedY = true;
            }
        }

        void set(TTPoint p, int x, int y) {
            p.hinted.x = x;
            p.touchedX = true;
            p.hinted.y = y;
            p.touchedY = true;
        }

        void untouch(TTPoint p) {
            if (this.freedomVector.x != 0) {
                p.touchedX = false;
            }
            if (this.freedomVector.x != 0) {
                p.touchedY = false;
            }
        }

        void setRp0(int p) {
            this.rp0 = p;
        }

        int getRp0() {
            return this.rp0;
        }

        void setRp1(int p) {
            this.rp1 = p;
        }

        int getRp1() {
            return this.rp1;
        }

        void setRp2(int p) {
            this.rp2 = p;
        }

        int getRp2() {
            return this.rp2;
        }

        void setZp0(int zone) {
            this.zp0 = zone;
        }

        int getZp0() {
            return this.zp0;
        }

        void setZp1(int zone) {
            this.zp1 = zone;
        }

        int getZp1() {
            return this.zp1;
        }

        void setZp2(int zone) {
            this.zp2 = zone;
        }

        int getZp2() {
            return this.zp2;
        }

        void setLoopVariable(int v) {
            this.loopVariable = v;
        }

        int getAndResetLoopVariable() {
            int result = this.loopVariable;
            this.loopVariable = 1;
            return result;
        }

        static /* synthetic */ int access$2300(GraphicState x0) {
            return x0.fDotP;
        }

        static /* synthetic */ int access$1600(GraphicState x0) {
            return x0.cvtxN;
        }

        static /* synthetic */ int access$1700(GraphicState x0) {
            return x0.cvtD;
        }

        static /* synthetic */ int access$1800(GraphicState x0) {
            return x0.cvtyN;
        }
    }

    private final class LocalGraphicState
    implements Cloneable {
        private boolean autoFlip;
        private int angleWeight;
        private int minimumDistance;
        private int controlValueCutIn;
        private int singleWidthCutIn;
        private int singleWidth;
        private int deltaBase;
        private int deltaShift;
        private int scanControl;
        private int instrControl;
        private int roundMode;
        private int roundPeriod;
        private int roundPhase;
        private int roundThreshold;

        private LocalGraphicState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

