/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingGenerator;
import com.adobe.fontengine.font.opentype.ContextualGenerator;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class GsubSubsetter
extends LookupTableSubsetter {
    public GsubSubsetter(LookupTable origGsub, int numGlyphs) {
        super(origGsub, OTByteArray.getOTByteArrayBuilderInstance(10), numGlyphs);
    }

    @Override
    void patchSubtableCoverage(int origSTOffset, int newSTOffset, Map coverageInfo, int lookupType) throws InvalidFontException {
        switch (lookupType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                GsubSubsetter.patchCoverageAtOffset(this.origTable, this.builder, origSTOffset, newSTOffset, 2, coverageInfo);
                break;
            }
            case 5: {
                ContextualGenerator.patchSubtableCoverage(this.origTable, this.builder, origSTOffset, newSTOffset, coverageInfo, lookupType);
                break;
            }
            case 6: {
                ChainingGenerator.patchSubtableCoverage(this.origTable, this.builder, origSTOffset, newSTOffset, coverageInfo, lookupType);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type: " + lookupType);
            }
        }
    }

    private int writeType1Format1(int origSTOffset, int newSTOffset, int newDelta) throws InvalidFontException {
        this.builder.ensureCapacity(newSTOffset + 6);
        this.builder.setuint16(newSTOffset, 1);
        this.builder.setint16(newSTOffset + 4, newDelta);
        return 6;
    }

    @Override
    int writeSubtable(int origSTOffset, int newSTOffset, Map newCoverages, int lookupType, Subset subset, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        LookupTableSubsetter.LookupSubtableGenerator generator;
        switch (lookupType) {
            case 1: {
                Type1TargetGIDFetcher fetcher;
                int format = this.origTable.data.getuint16(origSTOffset);
                switch (format) {
                    case 1: {
                        fetcher = new Type1Format1TargetGIDFetcher();
                        ((Type1Format1TargetGIDFetcher)fetcher).setDelta(this.origTable.data.getint16(origSTOffset + 4));
                        break;
                    }
                    case 2: {
                        fetcher = new Type1Format2TargetGIDFetcher();
                        ((Type1Format2TargetGIDFetcher)fetcher).setOrigSTOffset(origSTOffset);
                        break;
                    }
                    default: {
                        throw new InvalidFontException("Invalid lookup type 1 format:" + format);
                    }
                }
                DeltaDeterminer consumer = new DeltaDeterminer(subset, fetcher);
                this.origTable.iterateCoverage(this.origTable.data.getOffset(origSTOffset, 2), subset, consumer);
                if (consumer.canUseFormat1()) {
                    return this.writeType1Format1(origSTOffset, newSTOffset, consumer.delta());
                }
                generator = new Type1Format2Generator(origSTOffset, subset, this.builder, newSTOffset, fetcher, newCoverages);
                break;
            }
            case 2: 
            case 3: {
                generator = new Type2Or3Generator(subset, this.builder, newSTOffset, origSTOffset, newCoverages);
                break;
            }
            case 4: {
                generator = Type4Generator.newInstance(this.origTable, subset, this.builder, newSTOffset, origSTOffset, newCoverages);
                break;
            }
            case 5: {
                generator = ContextualGenerator.newContextualGenerator(this.origTable, this.builder, origSTOffset, newSTOffset, subset, newCoverages, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 6: {
                generator = ChainingGenerator.newChainingInstance(this.origTable, this.builder, origSTOffset, newSTOffset, subset, newCoverages, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 7: {
                this.builder.ensureCapacity(newSTOffset + 4);
                this.builder.setuint16(newSTOffset, 1);
                this.builder.setuint16(newSTOffset + 2, this.origTable.data.getuint16(origSTOffset + 2));
                return 8;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + lookupType + ")");
            }
        }
        return generator.writeSubtable();
    }

    @Override
    int getExtensionSubtableSize() {
        return 8;
    }

    @Override
    void gatherCoveragesForSubtable(int stOffset, int lookupType, int lookupIndex, Integer subtableIndex, Map coverages, Map extensionCoverages, Subset subset) throws InvalidFontException, UnsupportedFontException {
        Map coverageMapToUse = coverages;
        if (lookupType == 7) {
            lookupType = this.origTable.data.getuint16(stOffset + 2);
            stOffset += this.origTable.data.getuint32asint(stOffset + 4, "Unhandled extension offset");
            coverageMapToUse = extensionCoverages;
        }
        switch (lookupType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int coverageOffset = this.origTable.data.getOffset(stOffset, 2);
                GsubSubsetter.addToCoveragesMap(this.origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                break;
            }
            case 5: {
                ContextualGenerator.gatherCoveragesForSubtable(this.origTable, stOffset, lookupType, lookupIndex, subtableIndex, coverageMapToUse, subset);
                break;
            }
            case 6: {
                ChainingGenerator.gatherCoveragesForSubtable(this.origTable, stOffset, lookupType, lookupIndex, subtableIndex, coverageMapToUse, subset);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + lookupType + ")");
            }
        }
    }

    @Override
    int getReferencedLookupType(int origExtSubOffset) throws InvalidFontException {
        return this.origTable.data.getuint16(origExtSubOffset + 2);
    }

    @Override
    void patchExtensionOffset(int extensionSubtableOffset, int nonExtensionSubtableOffset) {
        this.builder.setuint32(extensionSubtableOffset + 4, nonExtensionSubtableOffset - extensionSubtableOffset);
    }

    @Override
    int getReferencedSubtableOffset(int origSTOffset) throws InvalidFontException, UnsupportedFontException {
        return origSTOffset + this.origTable.data.getuint32asint(origSTOffset + 4, "Only handle extensions that fit in 31 bits");
    }

    @Override
    int getExtensionLookupType() {
        return 7;
    }

    @Override
    int writeExtensionSubtable(int newSTOffset, int subTableLookupType) {
        this.builder.setuint16(newSTOffset, 1);
        this.builder.setuint16(newSTOffset + 2, subTableLookupType);
        return 8;
    }

    @Override
    boolean mustKeepFeature(int featureTagOffset) {
        return false;
    }

    private static class Type4Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private Type4Generator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, int glyphCount) throws InvalidFontException {
            super(origTable, subset, newData, newSTOffset, origSTOffset, glyphCount, 4, false, true);
            this.writeHeader(newSTOffset, glyphCount);
        }

        private void writeHeader(int newSTOffset, int glyphCount) {
            this.builder.ensureCapacity(newSTOffset + 6 + 2 * glyphCount);
            this.builder.setuint16(newSTOffset, 1);
            this.builder.setuint16(newSTOffset + 4, glyphCount);
        }

        static Type4Generator newInstance(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, Map newCoverages) throws InvalidFontException, UnsupportedFontException {
            int coverageOffset = origTable.data.getOffset(origSTOffset, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)newCoverages.get(new Integer(coverageOffset));
            Type4Generator generator = new Type4Generator(origTable, subset, newData, newSTOffset, origSTOffset, newCoverage.glyphCount);
            origTable.iterateCoverage(coverageOffset, subset, generator);
            return generator;
        }

        @Override
        boolean[] computeMembersToKeep(int newLSOffset, int origLSOffset) throws InvalidFontException, UnsupportedFontException {
            int origLigaCount = this.origTable.data.getuint16(origLSOffset);
            boolean[] keep = new boolean[origLigaCount];
            Arrays.fill(keep, true);
            block0: for (int i = 0; i < origLigaCount; ++i) {
                int ligatureOffset = this.origTable.data.getOffset(origLSOffset, 2 + 2 * i);
                int ligGlyph = this.origTable.data.getuint16(ligatureOffset);
                if (this.subset.getExistingSubsetGid(ligGlyph) == -1) {
                    keep[i] = false;
                    continue;
                }
                int compCount = this.origTable.data.getuint16(ligatureOffset + 2);
                for (int j = 0; j < compCount - 1; ++j) {
                    ligGlyph = this.origTable.data.getuint16(ligatureOffset + 4 + 2 * j);
                    if (this.subset.getExistingSubsetGid(ligGlyph) != -1) continue;
                    keep[i] = false;
                    continue block0;
                }
            }
            return keep;
        }

        @Override
        int writeMember(int newLigaOffset, int origLigaOffset) throws InvalidFontException, UnsupportedFontException {
            int componentCount = this.origTable.data.getuint16(origLigaOffset + 2);
            int lSize = 4 + 2 * (componentCount - 1);
            this.builder.ensureCapacity(newLigaOffset + lSize);
            this.builder.setuint16(newLigaOffset, this.subset.getExistingSubsetGid(this.origTable.data.getuint16(origLigaOffset)));
            this.builder.setuint16(newLigaOffset + 2, componentCount);
            for (int i = 0; i < componentCount - 1; ++i) {
                this.builder.setuint16(newLigaOffset + 4 + 2 * i, this.subset.getExistingSubsetGid(this.origTable.data.getuint16(origLigaOffset + 4 + 2 * i)));
            }
            return lSize;
        }

        @Override
        int whichRuleSetIndexApplies(int gid, int coverageIndex) {
            return coverageIndex;
        }

        @Override
        int getOrigRecordSize() {
            return 0;
        }
    }

    private class Type2Or3Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private final Subset subset;
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int newSTOffset;
        private final int origSTOffset;
        private int[] subsetToCoverageIndex;
        private final int glyphCount;

        Type2Or3Generator(Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, Map newCoverages) throws InvalidFontException {
            int coverageOffset = GsubSubsetter.this.origTable.data.getOffset(origSTOffset, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)newCoverages.get(new Integer(coverageOffset));
            this.subset = subset;
            this.builder = newData;
            this.newSTOffset = newSTOffset;
            this.origSTOffset = origSTOffset;
            this.glyphCount = newCoverage.glyphCount;
            this.subsetToCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToCoverageIndex, -1);
        }

        private void writeHeader(int glyphCount) {
            this.builder.ensureCapacity(this.newSTOffset + 6 + 2 * glyphCount);
            this.builder.setuint16(this.newSTOffset, 1);
            this.builder.setuint16(this.newSTOffset + 4, glyphCount);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            this.subsetToCoverageIndex[this.subset.getExistingSubsetGid((int)gid)] = coverageIndex;
            return true;
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int subtableSize = 6 + 2 * this.glyphCount;
            this.writeHeader(this.glyphCount);
            GsubSubsetter.this.origTable.iterateCoverage(GsubSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2), this.subset, this);
            int j = 0;
            for (int i = 0; i < this.subsetToCoverageIndex.length; ++i) {
                if (this.subsetToCoverageIndex[i] == -1) continue;
                this.builder.setuint16(this.newSTOffset + 6 + 2 * j, subtableSize);
                int origSequenceOrSetOffset = GsubSubsetter.this.origTable.data.getOffset(this.origSTOffset, 6 + 2 * this.subsetToCoverageIndex[i]);
                int glyphCount = GsubSubsetter.this.origTable.data.getuint16(origSequenceOrSetOffset);
                this.builder.ensureCapacity(this.newSTOffset + subtableSize + 2 + 2 * glyphCount);
                this.builder.setuint16(this.newSTOffset + subtableSize, glyphCount);
                for (int k = 0; k < glyphCount; ++k) {
                    int subsetGid = this.subset.getExistingSubsetGid(GsubSubsetter.this.origTable.data.getuint16(origSequenceOrSetOffset + 2 + 2 * k));
                    if (subsetGid == -1) {
                        throw new RuntimeException("Matched a gid not in our subset?? Can't happen..");
                    }
                    this.builder.setuint16(this.newSTOffset + subtableSize + 2 + 2 * k, subsetGid);
                }
                subtableSize += 2 + 2 * glyphCount;
                ++j;
            }
            return subtableSize;
        }
    }

    private class Type1Format2Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private final Subset subset;
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int newSTOffset;
        int glyphCount = 0;
        private final Type1TargetGIDFetcher fetcher;
        private int[] subsetToTarget;
        private final int origSTOffset;
        private final Map newCoverages;

        Type1Format2Generator(int origSTOffset, Subset subset, OTByteArray.OTByteArrayBuilder builder, int newSTOffset, Type1TargetGIDFetcher fetcher, Map newCoverages) {
            this.builder = builder;
            this.subset = subset;
            this.newSTOffset = newSTOffset;
            this.origSTOffset = origSTOffset;
            this.fetcher = fetcher;
            this.newCoverages = newCoverages;
            this.subsetToTarget = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToTarget, -1);
        }

        void writeHeader(int glyphCount) {
            this.builder.ensureCapacity(this.newSTOffset + 6 + 2 * glyphCount);
            this.builder.setuint16(this.newSTOffset, 2);
            this.builder.setuint16(this.newSTOffset + 4, glyphCount);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            int subsetGid;
            int matchedGid = this.fetcher.getTarget(gid, coverageIndex);
            this.subsetToTarget[this.subset.getExistingSubsetGid((int)gid)] = subsetGid = this.subset.getExistingSubsetGid(matchedGid);
            if (subsetGid == -1) {
                throw new RuntimeException("Matched a gid not in our subset?? Can't happen..");
            }
            ++this.glyphCount;
            return true;
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int coverageOffset = GsubSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)this.newCoverages.get(new Integer(coverageOffset));
            this.writeHeader(newCoverage.glyphCount);
            GsubSubsetter.this.origTable.iterateCoverage(coverageOffset, this.subset, this);
            int j = 0;
            for (int i = 0; i < this.subsetToTarget.length; ++i) {
                if (this.subsetToTarget[i] == -1) continue;
                this.builder.setuint16(this.newSTOffset + 6 + 2 * j, this.subsetToTarget[i]);
                ++j;
            }
            return 6 + 2 * newCoverage.glyphCount;
        }
    }

    class DeltaDeterminer
    implements LayoutTable.CoverageConsumer {
        private final Subset subset;
        private boolean format1Ok = true;
        private int delta;
        private boolean deltaInitialized = false;
        private Type1TargetGIDFetcher fetcher;

        public DeltaDeterminer(Subset subset, Type1TargetGIDFetcher fetcher) {
            this.subset = subset;
            this.fetcher = fetcher;
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            int subsetGid = this.subset.getExistingSubsetGid(gid);
            int origTarget = this.fetcher.getTarget(gid, coverageIndex);
            int newTarget = this.subset.getExistingSubsetGid(origTarget);
            if (this.deltaInitialized) {
                if (newTarget - subsetGid == this.delta) {
                    return true;
                }
                this.format1Ok = false;
                return false;
            }
            this.delta = newTarget - subsetGid;
            this.deltaInitialized = true;
            if (this.delta > Short.MAX_VALUE || this.delta < Short.MIN_VALUE) {
                this.format1Ok = false;
                return false;
            }
            return true;
        }

        boolean canUseFormat1() {
            return this.format1Ok;
        }

        int delta() {
            return this.delta;
        }
    }

    class Type1Format2TargetGIDFetcher
    implements Type1TargetGIDFetcher {
        private int origSTOffset;

        Type1Format2TargetGIDFetcher() {
        }

        void setOrigSTOffset(int theOffset) {
            this.origSTOffset = theOffset;
        }

        @Override
        public int getTarget(int originalGID, int coverageIndex) throws InvalidFontException {
            return GsubSubsetter.this.origTable.data.getuint16(this.origSTOffset + 6 + 2 * coverageIndex);
        }
    }

    class Type1Format1TargetGIDFetcher
    implements Type1TargetGIDFetcher {
        private int delta;

        Type1Format1TargetGIDFetcher() {
        }

        void setDelta(int delta) {
            this.delta = delta;
        }

        @Override
        public int getTarget(int originalGID, int coverageIndex) {
            return originalGID + this.delta;
        }
    }

    static interface Type1TargetGIDFetcher {
        public int getTarget(int var1, int var2) throws InvalidFontException;
    }
}

