/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingGenerator;
import com.adobe.fontengine.font.opentype.ContextualGenerator;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class GposSubsetter
extends LookupTableSubsetter {
    private final boolean preserveNonEmptyKernFeature;

    GposSubsetter(Gpos origTable, int numGlyphs, boolean preserveNonEmptyKernFeature) {
        super(origTable, OTByteArray.getOTByteArrayBuilderInstance(), numGlyphs);
        this.preserveNonEmptyKernFeature = preserveNonEmptyKernFeature;
    }

    @Override
    void gatherCoveragesForSubtable(int stOffset, int lookupType, int lookupIndex, Integer subtableIndex, Map coverages, Map extensionCoverages, Subset subset) throws InvalidFontException, UnsupportedFontException {
        Map coverageMapToUse = coverages;
        if (lookupType == 9) {
            lookupType = this.origTable.data.getuint16(stOffset + 2);
            stOffset += this.origTable.data.getuint32asint(stOffset + 4, "Unhandled extension offset");
            coverageMapToUse = extensionCoverages;
        }
        switch (lookupType) {
            case 1: 
            case 2: 
            case 3: {
                int coverageOffset = this.origTable.data.getOffset(stOffset, 2);
                GposSubsetter.addToCoveragesMap(this.origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                int coverageOffset = this.origTable.data.getOffset(stOffset, 2);
                GposSubsetter.addToCoveragesMap(this.origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                coverageOffset = this.origTable.data.getOffset(stOffset, 4);
                GposSubsetter.addToCoveragesMap(this.origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                break;
            }
            case 7: {
                ContextualGenerator.gatherCoveragesForSubtable(this.origTable, stOffset, lookupType, lookupIndex, subtableIndex, coverageMapToUse, subset);
                break;
            }
            case 8: {
                ChainingGenerator.gatherCoveragesForSubtable(this.origTable, stOffset, lookupType, lookupIndex, subtableIndex, coverageMapToUse, subset);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + lookupType + ")");
            }
        }
    }

    @Override
    int getExtensionSubtableSize() {
        return 8;
    }

    @Override
    void patchSubtableCoverage(int origSTOffset, int newSTOffset, Map coverageInfo, int lookupType) throws InvalidFontException {
        switch (lookupType) {
            case 1: 
            case 2: 
            case 3: {
                GposSubsetter.patchCoverageAtOffset(this.origTable, this.builder, origSTOffset, newSTOffset, 2, coverageInfo);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                GposSubsetter.patchCoverageAtOffset(this.origTable, this.builder, origSTOffset, newSTOffset, 2, coverageInfo);
                GposSubsetter.patchCoverageAtOffset(this.origTable, this.builder, origSTOffset, newSTOffset, 4, coverageInfo);
                break;
            }
            case 7: {
                ContextualGenerator.patchSubtableCoverage(this.origTable, this.builder, origSTOffset, newSTOffset, coverageInfo, lookupType);
                break;
            }
            case 8: {
                ChainingGenerator.patchSubtableCoverage(this.origTable, this.builder, origSTOffset, newSTOffset, coverageInfo, lookupType);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type: " + lookupType);
            }
        }
    }

    private int targetValueFormat(int originalValueFormat) {
        return originalValueFormat & 0xF;
    }

    private void writeValueFormat(int startingOffset, int origFormat, int targetFormat, int[] value) {
        int i = 0;
        int j = 0;
        for (int mask = 1; mask <= 8 && i < value.length; mask <<= 1) {
            if ((origFormat & mask) == 0) continue;
            if ((targetFormat & mask) != 0) {
                this.builder.setint16(startingOffset + 2 * j, value[i]);
                ++j;
            }
            ++i;
        }
    }

    private void writeValueFormatFromOriginal(int origOffset, int startingOffset, int origFormat, int targetFormat) throws InvalidFontException {
        int i = 0;
        int j = 0;
        for (int mask = 1; mask <= 8; mask <<= 1) {
            if ((origFormat & mask) == 0) continue;
            if ((targetFormat & mask) != 0) {
                int orig = this.origTable.data.getint16(origOffset + 2 * i);
                this.builder.setint16(startingOffset + 2 * j, orig);
                ++j;
            }
            ++i;
        }
    }

    private int writeAnchorFromOriginal(int origOffset, int newOffset) throws InvalidFontException {
        this.builder.ensureCapacity(newOffset + 6);
        this.builder.setuint16(newOffset, 1);
        this.builder.setint16(newOffset + 2, this.origTable.data.getint16(origOffset + 2));
        this.builder.setint16(newOffset + 4, this.origTable.data.getint16(origOffset + 4));
        return 6;
    }

    private int writeLookup1Format1(int origSTOffset, int newSTOffset, int[] value) throws InvalidFontException {
        int origFormat = this.origTable.data.getuint16(origSTOffset + 4);
        int targetFormat = this.targetValueFormat(origFormat);
        int targetFormatLength = ((Gpos)this.origTable).getValueRecordSize(targetFormat);
        int size = 6 + targetFormatLength;
        this.builder.ensureCapacity(newSTOffset + size);
        this.builder.setuint16(newSTOffset, 1);
        this.builder.setuint16(newSTOffset + 4, targetFormat);
        this.writeValueFormat(newSTOffset + 6, origFormat, targetFormat, value);
        return size;
    }

    @Override
    int writeSubtable(int origSTOffset, int newSTOffset, Map newCoverages, int lookupType, Subset subset, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        LookupTableSubsetter.LookupSubtableGenerator generator;
        block0 : switch (lookupType) {
            case 1: {
                int[] value;
                int targetFormat;
                int origFormat = this.origTable.data.getuint16(origSTOffset);
                if (origFormat == 2) {
                    L1F2TargetFormatDeterminer consumer = new L1F2TargetFormatDeterminer(origSTOffset);
                    targetFormat = consumer.canUseFormat1(subset) ? 1 : 2;
                    value = consumer.bytes;
                } else {
                    targetFormat = 1;
                    value = new int[((Gpos)this.origTable).getValueRecordSize(this.origTable.data.getuint16(origSTOffset + 4)) / 2];
                    for (int i = 0; i < value.length; ++i) {
                        value[i] = this.origTable.data.getint16(origSTOffset + 6 + 2 * i);
                    }
                }
                if (targetFormat == 1) {
                    return this.writeLookup1Format1(origSTOffset, newSTOffset, value);
                }
                generator = new Type1Format2Generator(origSTOffset, newSTOffset, subset);
                break;
            }
            case 2: {
                int origFormat = this.origTable.data.getuint16(origSTOffset);
                switch (origFormat) {
                    case 1: {
                        generator = new Type2Format1Generator(this.origTable, subset, this.builder, newSTOffset, origSTOffset, newCoverages);
                        break block0;
                    }
                    case 2: {
                        generator = new Type2Format2Generator(origSTOffset, newSTOffset, subset);
                        break block0;
                    }
                }
                throw new InvalidFontException("Invalid type 2 gpos lookup: " + origFormat);
            }
            case 3: {
                generator = new Type3Generator(origSTOffset, newSTOffset, subset);
                break;
            }
            case 4: 
            case 6: {
                generator = new Type4Or6Generator(origSTOffset, newSTOffset, subset);
                break;
            }
            case 5: {
                generator = new Type5Generator(origSTOffset, newSTOffset, subset);
                break;
            }
            case 7: {
                generator = ContextualGenerator.newContextualGenerator(this.origTable, this.builder, origSTOffset, newSTOffset, subset, newCoverages, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 8: {
                generator = ChainingGenerator.newChainingInstance(this.origTable, this.builder, origSTOffset, newSTOffset, subset, newCoverages, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 9: {
                this.builder.setuint16(newSTOffset, 1);
                this.builder.setuint16(newSTOffset + 2, this.origTable.data.getuint16(origSTOffset + 2));
                return 8;
            }
            default: {
                throw new InvalidFontException("Invalid GPOS lookup type (" + lookupType + ")");
            }
        }
        return generator.writeSubtable();
    }

    @Override
    int getReferencedLookupType(int origExtSubOffset) throws InvalidFontException {
        return this.origTable.data.getuint16(origExtSubOffset + 2);
    }

    @Override
    void patchExtensionOffset(int extensionSubtableOffset, int nonExtensionSubtableOffset) {
        this.builder.setuint32(extensionSubtableOffset + 4, nonExtensionSubtableOffset - extensionSubtableOffset);
    }

    @Override
    int getReferencedSubtableOffset(int origSTOffset) throws InvalidFontException, UnsupportedFontException {
        return origSTOffset + this.origTable.data.getuint32asint(origSTOffset + 4, "Only handle extensions that fit in 31 bits");
    }

    @Override
    int getExtensionLookupType() {
        return 9;
    }

    @Override
    int writeExtensionSubtable(int newSTOffset, int subTableLookupType) {
        this.builder.setuint16(newSTOffset, 1);
        this.builder.setuint16(newSTOffset + 2, subTableLookupType);
        return 8;
    }

    @Override
    boolean mustKeepFeature(int origFeatureTagOffset) throws InvalidFontException {
        if (this.preserveNonEmptyKernFeature) {
            int[] kernTag = new int[]{107, 101, 114, 110};
            for (int i = 0; i < 4; ++i) {
                if (this.origTable.data.getuint8(origFeatureTagOffset + i) == kernTag[i]) continue;
                return false;
            }
            int featureOffset = this.origTable.data.getOffset(origFeatureTagOffset, 4);
            int numFeatures = this.origTable.data.getuint16(featureOffset + 2);
            return numFeatures > 0;
        }
        return false;
    }

    private class Type5Generator
    extends MarkGenerator {
        Type5Generator(int origSTOffset, int newSTOffset, Subset subset) {
            super(origSTOffset, newSTOffset, subset);
        }

        @Override
        int writeTargetArray(int origLAOffset, int newLAOffset, ClassSubset classSubset, int origClassCount) throws InvalidFontException {
            int lASize = 2 + 2 * this.entryCount;
            GposSubsetter.this.builder.ensureCapacity(newLAOffset + lASize);
            GposSubsetter.this.builder.setuint16(newLAOffset, this.entryCount);
            int i = 0;
            for (int j = 0; i < this.entryCount && j < this.subset.getNumGlyphs(); ++j) {
                if (this.subsetToCoverage[j] == -1) continue;
                GposSubsetter.this.builder.setuint16(newLAOffset + 2 + 2 * i, lASize);
                lASize += this.writeArrayEntry(origLAOffset, 2 + 2 * this.subsetToCoverage[j], newLAOffset + lASize, classSubset, origClassCount, this.subsetToCoverage[j]);
                ++i;
            }
            return lASize;
        }

        int writeArrayEntry(int origLAOffset, int origLAEntryDelta, int newLAEntryOffset, ClassSubset classSubset, int origClassCount, int origCoverageIndex) throws InvalidFontException {
            int ligAttachOffset = GposSubsetter.this.origTable.data.getOffset(origLAOffset, origLAEntryDelta);
            int componentCount = GposSubsetter.this.origTable.data.getuint16(ligAttachOffset);
            int entrySize = 2 + 2 * componentCount * classSubset.getNumGlyphs();
            GposSubsetter.this.builder.ensureCapacity(newLAEntryOffset + entrySize);
            GposSubsetter.this.builder.setuint16(newLAEntryOffset, componentCount);
            for (int i = 0; i < componentCount; ++i) {
                for (int k = 0; k < classSubset.getNumGlyphs(); ++k) {
                    int origDelta = 2 + 2 * (origClassCount * i + classSubset.getFullGid(k));
                    int origOffset = GposSubsetter.this.origTable.data.getOffset(ligAttachOffset, origDelta);
                    if (origOffset == 0) {
                        GposSubsetter.this.builder.setuint16(newLAEntryOffset + 2 + 2 * (i * classSubset.getNumGlyphs() + k), 0);
                        continue;
                    }
                    GposSubsetter.this.builder.setuint16(newLAEntryOffset + 2 + 2 * (i * classSubset.getNumGlyphs() + k), entrySize);
                    entrySize += GposSubsetter.this.writeAnchorFromOriginal(origOffset, newLAEntryOffset + entrySize);
                }
            }
            return entrySize;
        }
    }

    private class Type4Or6Generator
    extends MarkGenerator {
        Type4Or6Generator(int origSTOffset, int newSTOffset, Subset subset) {
            super(origSTOffset, newSTOffset, subset);
        }

        @Override
        int writeTargetArray(int origBAOffset, int newBAOffset, ClassSubset classSubset, int origClassCount) throws InvalidFontException {
            int bASize = 2 + 2 * classSubset.getNumGlyphs() * this.entryCount;
            GposSubsetter.this.builder.ensureCapacity(newBAOffset + bASize);
            GposSubsetter.this.builder.setuint16(newBAOffset, this.entryCount);
            int i = 0;
            for (int j = 0; i < this.entryCount && j < this.subset.getNumGlyphs(); ++j) {
                if (this.subsetToCoverage[j] == -1) continue;
                for (int k = 0; k < classSubset.getNumGlyphs(); ++k) {
                    GposSubsetter.this.builder.setuint16(newBAOffset + 2 + 2 * (i * classSubset.getNumGlyphs() + k), bASize);
                    bASize += GposSubsetter.this.writeAnchorFromOriginal(GposSubsetter.this.origTable.data.getOffset(origBAOffset, 2 + 2 * (this.subsetToCoverage[j] * origClassCount + classSubset.getFullGid(k))), newBAOffset + bASize);
                }
                ++i;
            }
            return bASize;
        }
    }

    private abstract class MarkGenerator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        protected final Subset subset;
        private final int origSTOffset;
        private final int newSTOffset;
        protected int entryCount = 0;
        protected int[] subsetToCoverage;

        MarkGenerator(int origSTOffset, int newSTOffset, Subset subset) {
            this.origSTOffset = origSTOffset;
            this.newSTOffset = newSTOffset;
            this.subset = subset;
            this.subsetToCoverage = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToCoverage, -1);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            this.subsetToCoverage[this.subset.getExistingSubsetGid((int)gid)] = coverageIndex;
            ++this.entryCount;
            return true;
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int subtableSize = 12;
            MarkArrayGenerator markGenerator = new MarkArrayGenerator(this.subset);
            int coverageOffset = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2);
            int origMAOffset = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 8);
            int origClassCount = GposSubsetter.this.origTable.data.getuint16(this.origSTOffset + 6);
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + subtableSize);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 1);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 8, subtableSize);
            subtableSize += markGenerator.writeMarkArray(coverageOffset, origMAOffset, this.newSTOffset + subtableSize, origClassCount);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 6, markGenerator.classSubset.getNumGlyphs());
            GposSubsetter.this.origTable.iterateCoverage(GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 4), this.subset, this);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 10, subtableSize);
            subtableSize += this.writeTargetArray(GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 10), this.newSTOffset + subtableSize, markGenerator.classSubset, origClassCount);
            return subtableSize;
        }

        abstract int writeTargetArray(int var1, int var2, ClassSubset var3, int var4) throws InvalidFontException;
    }

    private class MarkArrayGenerator
    implements LayoutTable.CoverageConsumer {
        private final Subset subset;
        private int[] subsetToCoverageIndex;
        private int entryCount = 0;
        int subtableSize;
        ClassSubset classSubset;

        MarkArrayGenerator(Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.subset = subset;
            this.subsetToCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToCoverageIndex, -1);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            this.subsetToCoverageIndex[this.subset.getExistingSubsetGid((int)gid)] = coverageIndex;
            ++this.entryCount;
            return true;
        }

        int writeMarkArray(int coverageOffset, int origMAOffset, int newMAOffset, int origClassCount) throws InvalidFontException, UnsupportedFontException {
            GposSubsetter.this.origTable.iterateCoverage(coverageOffset, this.subset, this);
            this.classSubset = new ClassSubset(origClassCount);
            this.subtableSize = 2 + 4 * this.entryCount;
            GposSubsetter.this.builder.ensureCapacity(newMAOffset + this.subtableSize);
            GposSubsetter.this.builder.setuint16(newMAOffset, this.entryCount);
            int i = 0;
            for (int j = 0; i < this.entryCount && j < this.subset.getNumGlyphs(); ++j) {
                if (this.subsetToCoverageIndex[j] == -1) continue;
                int origClass = GposSubsetter.this.origTable.data.getuint16(origMAOffset + 2 + 4 * this.subsetToCoverageIndex[j]);
                GposSubsetter.this.builder.setuint16(newMAOffset + 2 + 4 * i, this.classSubset.getSubsetGid(origClass));
                GposSubsetter.this.builder.setuint16(newMAOffset + 4 + 4 * i, this.subtableSize);
                this.subtableSize += GposSubsetter.this.writeAnchorFromOriginal(GposSubsetter.this.origTable.data.getOffset(origMAOffset, 4 + 4 * this.subsetToCoverageIndex[j]), newMAOffset + this.subtableSize);
                ++i;
            }
            return this.subtableSize;
        }
    }

    private class ClassSubset
    extends SubsetDefaultImpl {
        ClassSubset(int numGlyphs) throws InvalidFontException, UnsupportedFontException {
            super(numGlyphs, true);
        }
    }

    private class Type3Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private int subtableSize = 0;
        private final int origSTOffset;
        private final int newSTOffset;
        private final Subset subset;
        private int entryExitCount = 0;
        private int[] subsetGidToCoverageIndex;

        Type3Generator(int origSTOffset, int newSTOffset, Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.origSTOffset = origSTOffset;
            this.newSTOffset = newSTOffset;
            this.subset = subset;
            this.subsetGidToCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetGidToCoverageIndex, -1);
            int coverageOffset = GposSubsetter.this.origTable.data.getOffset(origSTOffset, 2);
            GposSubsetter.this.origTable.iterateCoverage(coverageOffset, subset, this);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            this.subsetGidToCoverageIndex[this.subset.getExistingSubsetGid((int)gid)] = coverageIndex;
            ++this.entryExitCount;
            return true;
        }

        @Override
        public int writeSubtable() throws InvalidFontException {
            this.subtableSize = 6 + 4 * this.entryExitCount;
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + this.subtableSize);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 1);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 4, this.entryExitCount);
            int i = 0;
            for (int j = 0; i < this.entryExitCount * 2 && j < this.subset.getNumGlyphs(); ++j) {
                if (this.subsetGidToCoverageIndex[j] == -1) continue;
                for (int k = 0; k < 2; ++k) {
                    int origOffset = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 6 + 4 * this.subsetGidToCoverageIndex[j] + 2 * k);
                    if (origOffset == 0) {
                        GposSubsetter.this.builder.setuint16(this.newSTOffset + 6 + 2 * i, 0);
                    } else {
                        GposSubsetter.this.builder.setuint16(this.newSTOffset + 6 + 2 * i, this.subtableSize);
                        this.subtableSize += GposSubsetter.this.writeAnchorFromOriginal(origOffset, this.newSTOffset + this.subtableSize);
                    }
                    ++i;
                }
            }
            return this.subtableSize;
        }
    }

    private class Type2Format2Generator
    implements LayoutTable.ClassConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private int subtableSize = 0;
        private int class1CountInSubset;
        private int class2CountInSubset;
        private final int origClass2Count;
        private int currentMax = 0;
        private final Subset subset;
        private final int value1Format;
        private final int value2Format;
        private final int value1Size;
        private final int value2Size;
        private final int target1Format;
        private final int target2Format;
        private final int target1Size;
        private final int target2Size;
        private final int newSTOffset;
        private final int origSTOffset;

        public Type2Format2Generator(int origSTOffset, int newSTOffset, Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.subset = subset;
            this.newSTOffset = newSTOffset;
            this.origSTOffset = origSTOffset;
            int class1Offset = GposSubsetter.this.origTable.data.getOffset(origSTOffset, 8);
            int class2Offset = GposSubsetter.this.origTable.data.getOffset(origSTOffset, 10);
            this.origClass2Count = GposSubsetter.this.origTable.data.getuint16(origSTOffset + 14);
            GposSubsetter.this.origTable.iterateClass(class1Offset, GposSubsetter.this.origNumGlyphs, this, -1);
            this.class1CountInSubset = this.currentMax + 1;
            if (class1Offset == class2Offset) {
                this.class2CountInSubset = this.currentMax;
            } else {
                this.currentMax = 0;
                GposSubsetter.this.origTable.iterateClass(class2Offset, GposSubsetter.this.origNumGlyphs, this, -1);
                this.class2CountInSubset = this.currentMax + 1;
            }
            this.value1Format = GposSubsetter.this.origTable.data.getuint16(origSTOffset + 4);
            this.value2Format = GposSubsetter.this.origTable.data.getuint16(origSTOffset + 6);
            this.value1Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.value1Format);
            this.value2Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.value2Format);
            this.target1Format = GposSubsetter.this.targetValueFormat(this.value1Format);
            this.target2Format = GposSubsetter.this.targetValueFormat(this.value2Format);
            this.target1Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.target1Format);
            this.target2Size = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(this.target2Format);
        }

        private void writeHeader() throws InvalidFontException, UnsupportedFontException {
            this.subtableSize = 16 + (this.target1Size + this.target2Size) * this.class2CountInSubset * this.class1CountInSubset;
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + this.subtableSize);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 2);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 4, this.target1Format);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 6, this.target2Format);
            this.subtableSize += GposSubsetter.this.writeClassDef(this.origSTOffset, 8, this.newSTOffset, this.subtableSize, this.subset, GposSubsetter.this.origNumGlyphs);
            int class1Offset = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 8);
            int class2Offset = GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 10);
            if (class1Offset == class2Offset) {
                GposSubsetter.this.builder.setuint16(this.newSTOffset + 10, GposSubsetter.this.builder.getuint16(this.newSTOffset + 8));
            } else {
                this.subtableSize += GposSubsetter.this.writeClassDef(this.origSTOffset, 10, this.newSTOffset, this.subtableSize, this.subset, GposSubsetter.this.origNumGlyphs);
            }
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 12, this.class1CountInSubset);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 14, this.class2CountInSubset);
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            this.writeHeader();
            for (int i = 0; i < this.class1CountInSubset; ++i) {
                for (int j = 0; j < this.class2CountInSubset; ++j) {
                    GposSubsetter.this.writeValueFormatFromOriginal(this.origSTOffset + 16 + (this.value1Size + this.value2Size) * (this.origClass2Count * i + j), this.newSTOffset + 16 + (this.target1Size + this.target2Size) * (this.class2CountInSubset * i + j), this.value1Format, this.target1Format);
                    GposSubsetter.this.writeValueFormatFromOriginal(this.origSTOffset + 16 + (this.value1Size + this.value2Size) * (this.origClass2Count * i + j) + this.value1Size, this.newSTOffset + 16 + (this.target1Size + this.target2Size) * (this.class2CountInSubset * i + j) + this.target1Size, this.value2Format, this.target2Format);
                }
            }
            return this.subtableSize;
        }

        @Override
        public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException {
            if (this.subset.getExistingSubsetGid(glyphID) != -1 && classID > this.currentMax) {
                this.currentMax = classID;
            }
            return true;
        }
    }

    private class Type2Format1Generator
    extends SetGenerator
    implements LookupTableSubsetter.LookupSubtableGenerator {
        private final int value1Size;
        private final int value2Size;
        private final int value1Format;
        private final int value2Format;
        private final int targetValue1Format;
        private final int targetValue2Format;
        private final int targetValue1Size;
        private final int targetValue2Size;

        Type2Format1Generator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, Map newCoverages) throws InvalidFontException, UnsupportedFontException {
            super(origTable, subset, newData, newSTOffset, origSTOffset, ((LookupTableSubsetter.NewCoverage)newCoverages.get((Object)new Integer((int)origTable.data.getOffset((int)origSTOffset, (int)2)))).glyphCount, 8, false, false);
            this.value1Format = origTable.data.getuint16(origSTOffset + 4);
            this.value1Size = ((Gpos)origTable).getValueRecordSize(this.value1Format);
            this.value2Format = origTable.data.getuint16(origSTOffset + 6);
            this.value2Size = ((Gpos)origTable).getValueRecordSize(this.value2Format);
            this.targetValue1Format = GposSubsetter.this.targetValueFormat(this.value1Format);
            this.targetValue2Format = GposSubsetter.this.targetValueFormat(this.value2Format);
            this.targetValue1Size = ((Gpos)origTable).getValueRecordSize(this.targetValue1Format);
            this.targetValue2Size = ((Gpos)origTable).getValueRecordSize(this.targetValue2Format);
            this.writeHeader(((LookupTableSubsetter.NewCoverage)newCoverages.get((Object)new Integer((int)origTable.data.getOffset((int)origSTOffset, (int)2)))).glyphCount);
            origTable.iterateCoverage(origTable.data.getOffset(origSTOffset, 2), subset, this);
        }

        void writeHeader(int setCount) {
            this.builder.ensureCapacity(this.newSTOffset + 8);
            this.builder.setuint16(this.newSTOffset, 1);
            this.builder.setuint16(this.newSTOffset + 4, this.targetValue1Format);
            this.builder.setuint16(this.newSTOffset + 6, this.targetValue2Format);
            this.builder.setuint16(this.newSTOffset + 8, setCount);
        }

        @Override
        boolean[] computeMembersToKeep(int newSetOffset, int origSetOffset) throws InvalidFontException, UnsupportedFontException {
            int pairValueCount = this.origTable.data.getuint16(origSetOffset);
            boolean[] keep = new boolean[pairValueCount];
            Arrays.fill(keep, true);
            for (int i = 0; i < pairValueCount; ++i) {
                int secondGlyph = this.origTable.data.getuint16(origSetOffset + 2 + (2 + this.value1Size + this.value2Size) * i);
                if (this.subset.getExistingSubsetGid(secondGlyph) != -1) continue;
                keep[i] = false;
            }
            return keep;
        }

        @Override
        int whichRuleSetIndexApplies(int gid, int coverageIndex) throws InvalidFontException {
            return coverageIndex;
        }

        @Override
        int writeMember(int newMemberOffset, int origMemberOffset) throws InvalidFontException, UnsupportedFontException {
            this.builder.ensureCapacity(newMemberOffset + 2 + this.targetValue1Size + this.targetValue2Size);
            int secondGlyph = this.origTable.data.getuint16(origMemberOffset);
            this.builder.setuint16(newMemberOffset, this.subset.getExistingSubsetGid(secondGlyph));
            GposSubsetter.this.writeValueFormatFromOriginal(origMemberOffset + 2, newMemberOffset + 2, this.value1Format, this.targetValue1Format);
            GposSubsetter.this.writeValueFormatFromOriginal(origMemberOffset + 2 + this.value1Size, newMemberOffset + 2 + this.targetValue1Size, this.value2Format, this.targetValue2Format);
            return 2 + this.targetValue1Size + this.targetValue2Size;
        }

        @Override
        int getOrigRecordSize() {
            return 2 + this.value1Size + this.value2Size;
        }
    }

    private class Type1Format2Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private final Subset subset;
        private final int newSTOffset;
        private final int origSTOffset;
        int glyphCount = 0;
        private int[] subsetToOrigCoverageIndex;

        Type1Format2Generator(int origSTOffset, int newSTOffset, Subset subset) throws InvalidFontException, UnsupportedFontException {
            this.subset = subset;
            this.newSTOffset = newSTOffset;
            this.origSTOffset = origSTOffset;
            this.subsetToOrigCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToOrigCoverageIndex, -1);
            GposSubsetter.this.origTable.iterateCoverage(GposSubsetter.this.origTable.data.getOffset(origSTOffset, 2), subset, this);
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            int subsetGID = this.subset.getExistingSubsetGid(gid);
            this.subsetToOrigCoverageIndex[subsetGID] = coverageIndex;
            ++this.glyphCount;
            return true;
        }

        @Override
        public int writeSubtable() throws InvalidFontException {
            int origFormat = GposSubsetter.this.origTable.data.getuint16(this.origSTOffset + 4);
            int targetFormat = GposSubsetter.this.targetValueFormat(origFormat);
            int targetFormatLength = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(targetFormat);
            int origFormatLength = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(origFormat);
            GposSubsetter.this.builder.ensureCapacity(this.newSTOffset + 8 + targetFormatLength * this.glyphCount);
            GposSubsetter.this.builder.setuint16(this.newSTOffset, 2);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 4, targetFormat);
            GposSubsetter.this.builder.setuint16(this.newSTOffset + 6, this.glyphCount);
            int j = 0;
            for (int i = 0; i < this.subset.getNumGlyphs() && j < this.glyphCount; ++i) {
                if (this.subsetToOrigCoverageIndex[i] == -1) continue;
                GposSubsetter.this.writeValueFormatFromOriginal(this.origSTOffset + 8 + origFormatLength * this.subsetToOrigCoverageIndex[i], this.newSTOffset + 8 + targetFormatLength * j, origFormat, targetFormat);
                ++j;
            }
            return 8 + targetFormatLength * this.glyphCount;
        }
    }

    private class L1F2TargetFormatDeterminer
    implements LayoutTable.CoverageConsumer {
        private boolean canUseFormat1 = true;
        private final int origSTOffset;
        private final int valueFormatSize;
        int[] bytes = null;

        public L1F2TargetFormatDeterminer(int origSTOffset) throws InvalidFontException {
            this.origSTOffset = origSTOffset;
            this.valueFormatSize = ((Gpos)GposSubsetter.this.origTable).getValueRecordSize(GposSubsetter.this.origTable.data.getuint16(origSTOffset + 4)) / 2;
        }

        @Override
        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            if (this.bytes == null) {
                this.bytes = new int[this.valueFormatSize];
                for (int i = 0; i < this.valueFormatSize; ++i) {
                    this.bytes[i] = GposSubsetter.this.origTable.data.getint16(this.origSTOffset + 8 + coverageIndex * this.valueFormatSize * 2 + i);
                }
            } else {
                for (int i = 0; i < this.valueFormatSize; ++i) {
                    int value = GposSubsetter.this.origTable.data.getint16(this.origSTOffset + 8 + coverageIndex * this.valueFormatSize * 2 + i);
                    if (value == this.bytes[i]) continue;
                    this.canUseFormat1 = false;
                    return false;
                }
            }
            return true;
        }

        boolean canUseFormat1(Subset subset) throws InvalidFontException, UnsupportedFontException {
            GposSubsetter.this.origTable.iterateCoverage(GposSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2), subset, this);
            return this.canUseFormat1;
        }
    }
}

