/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.log;

import coldfusion.filter.FusionContext;
import coldfusion.orm.hibernate.ConfigurationManager;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import java.io.IOException;
import java.io.Writer;

public class ORMLogWriter
extends Writer {
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        String data = new String(cbuf, off, len);
        this.writeLogToDebugger(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String data = str.substring(off, off + len);
            this.writeLogToDebugger(data);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    private void writeLogToDebugger(String str) {
        DebuggingService debuggingService;
        boolean sqlLogEnabled = false;
        String appName = FusionContext.getCurrent().getApplicationName();
        ConfigurationManager configMgr = ConfigurationManager.getInstance();
        HibernateConfiguration config = configMgr.getConfiguration(appName);
        if (config != null) {
            sqlLogEnabled = config.getORMSettings().isSqlLogEnabled();
        }
        if (sqlLogEnabled && (debuggingService = ServiceFactory.getDebuggingService()).getDebugger() != null && debuggingService.check(3)) {
            debuggingService.getDebugger().ormSql(str, (Throwable)new Exception());
        }
    }
}

