/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.IntegerOutOfRangeException;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLV;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;

public class TLVUByte
extends TLV {
    private short value = 0;

    public TLVUByte() {
        super(1, 1);
    }

    public TLVUByte(short p_tag) {
        super(p_tag, 1, 1);
    }

    protected void setValueData(ByteBuffer buffer) throws TLVException {
        this.checkLength(buffer);
        try {
            this.value = TLVUByte.decodeUnsigned(buffer.removeByte());
        }
        catch (NotEnoughDataInByteBufferException notEnoughDataInByteBufferException) {
            // empty catch block
        }
        this.markValueSet();
    }

    protected ByteBuffer getValueData() throws ValueNotSetException {
        ByteBuffer valueBuf = new ByteBuffer();
        valueBuf.appendByte(TLVUByte.encodeUnsigned(this.getValue()));
        return valueBuf;
    }

    public void setValue(short value) throws IntegerOutOfRangeException {
        TLVUByte.checkRange(0, value, 255);
        this.value = value;
        this.markValueSet();
    }

    public short getValue() throws ValueNotSetException {
        if (this.hasValue()) {
            return this.value;
        }
        throw new ValueNotSetException();
    }

    public String debugString() {
        String dbgs = "(byte: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.value;
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

