/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.Address;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.DistributionList;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongDestFlagException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class DestinationAddress
extends ByteData {
    private byte destFlag = 0;
    private ByteData theAddress = null;

    public DestinationAddress() {
    }

    public DestinationAddress(Address address) {
        this.setAddress(address);
    }

    public DestinationAddress(String address) throws WrongLengthOfStringException {
        this.setAddress(new Address(address));
    }

    public DestinationAddress(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this.setAddress(new Address(ton, npi, address));
    }

    public DestinationAddress(DistributionList dl) {
        this.setDistributionList(dl);
    }

    public void setData(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, WrongLengthOfStringException, WrongDestFlagException {
        this.destFlag = buffer.removeByte();
        switch (this.destFlag) {
            case 1: {
                Address address = new Address();
                address.setData(buffer);
                this.setAddress(address);
                break;
            }
            case 2: {
                DistributionList dl = new DistributionList();
                dl.setData(buffer);
                this.setDistributionList(dl);
                break;
            }
            default: {
                throw new WrongDestFlagException("" + this.destFlag);
            }
        }
    }

    public ByteBuffer getData() throws ValueNotSetException {
        if (this.hasValue()) {
            ByteBuffer buffer = new ByteBuffer();
            buffer.appendByte(this.getDestFlag());
            if (this.isAddress()) {
                Address address = this.getAddress();
                buffer.appendBuffer(address.getData());
            } else if (this.isDistributionList()) {
                DistributionList dl = this.getDistributionList();
                buffer.appendBuffer(dl.getData());
            }
            return buffer;
        }
        throw new ValueNotSetException();
    }

    public void setAddress(Address address) {
        this.destFlag = 1;
        this.theAddress = address;
    }

    public void setDistributionList(DistributionList dl) {
        this.destFlag = (byte)2;
        this.theAddress = dl;
    }

    public byte getDestFlag() {
        return this.destFlag;
    }

    public ByteData getTheAddress() {
        return this.theAddress;
    }

    public Address getAddress() {
        if (this.isAddress()) {
            return (Address)this.theAddress;
        }
        return null;
    }

    public DistributionList getDistributionList() {
        if (this.isDistributionList()) {
            return (DistributionList)this.theAddress;
        }
        return null;
    }

    public boolean hasValue() {
        return this.destFlag != 0;
    }

    public boolean isAddress() {
        return this.destFlag == 1;
    }

    public boolean isDistributionList() {
        return this.destFlag == 2;
    }

    public String debugString() {
        String dbgs = "(destaddr: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + Integer.toString(this.getDestFlag());
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getTheAddress().debugString();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

