/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.presentation;

import coldfusion.document.BreezeConfigXmlBuilder;
import coldfusion.document.BreezeSearchXmlBuilder;
import coldfusion.document.BreezeXmlBuilder;
import coldfusion.document.HTMLSlideShowHelper;
import coldfusion.document.SlideData;
import coldfusion.document.presentation.core.PresentationExceptions;
import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.server.DocumentService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.document.DocumentTag;
import coldfusion.tagext.presentation.PresenterTag;
import coldfusion.util.CFFileServlet;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.IOUtils;
import coldfusion.util.UUIDUtils;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.xml.sax.SAXException;

public class PresentationTag
extends GenericTag
implements BodyTag {
    private String title = "";
    private String directory;
    private String destination;
    private List presenters;
    private Map indexMap;
    private List slides;
    private int slideCount;
    private boolean overWrite;
    private boolean showOutline = true;
    private boolean showNotes = true;
    private boolean showSearch = true;
    private String control;
    private String controlLocation;
    private String initialTab;
    private String primaryColor;
    private String backgroundColor;
    private String textColor;
    private String lightColor;
    private String shadowColor;
    private String glowColor;
    private int marginTop = 20;
    private int marginBottom = 20;
    private int marginLeft = 20;
    private int marginRight = 20;
    private String proxyHost;
    private int proxyPort = 80;
    private String proxyUser;
    private String proxyPassword;
    private String authUser;
    private String authPassword;
    private String userAgent;
    private boolean autoPlay = true;
    private boolean loop = false;
    private ArrayList<String[]> htmlslides;
    private boolean shouldSendToBrowser = true;
    private File presentationDir;
    private File dataDirectory;
    private static final String htmFile = "index.htm";
    private static String[] rootTemplates = new String[]{"viewer.swf", "loadflash.js", "components.swf"};
    private static String[] dataTemplates = new String[]{"vconfig.xml", "Master80000000.swf", "blank.swf"};
    private static final String VIEWER_XML = "viewer.xml";
    private static final String SEARCH_XML = "srchdata.xml";
    private static final String backgroundUrl = "Master80000000.swf";
    private static final String TEMP_FOLDER = "CFFileServlet/_cf_preso";
    private static final String NOTES = "notes";
    private static final String SEARCH = "search";
    private static boolean initialized = false;
    private static DocumentService documentService = null;
    private static final Map colorMap = new CaseInsensitiveMap();
    private HSLFSlideShow ppt = null;
    private static final String html1 = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html>\n\t<head>\n\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n\t\t<title>";
    private static final String html2 = "</title>\n\t\t<script type=\"text/javascript\" language=\"JavaScript\" src=\"";
    private static final String html3 = "loadflash.js\" >\n\t\t</script>\n\t</head>\n\t<body>\n\t\t<script type=\"text/javascript\" language=\"JavaScript\">\n\t\t\tshowFlash(\"";
    private static final String html4 = "viewer.swf\", '100%', '100%', false);\n\t\t</script>\n\t</body>\n</html>";
    private String presoFolderURI = "";
    private boolean configChangeRequired = false;
    public static final int WIDTH = 720;
    public static final int HEIGHT = 540;
    private URLConnectionSettings urlConnSettings;
    private static String templateDir;
    private String format = "";

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        if ((directory = directory.trim()).length() == 0) {
            throw new PresentationExceptions.InvalidDestinationException(directory);
        }
        this.directory = directory;
    }

    public void setDestination(String destination) {
        if ((destination = destination.trim()).length() == 0) {
            throw new PresentationExceptions.InvalidDestinationException(destination);
        }
        this.destination = destination;
        this.directory = destination;
    }

    public boolean isOverWrite() {
        return this.overWrite;
    }

    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }

    public boolean isShowOutline() {
        return this.showOutline;
    }

    public void setShowOutline(boolean showOutline) {
        this.showOutline = showOutline;
        if (!showOutline) {
            this.configChangeRequired = true;
        }
    }

    public boolean isShowNotes() {
        return this.showNotes;
    }

    public void setShowNotes(boolean showNotes) {
        this.showNotes = showNotes;
        if (!showNotes) {
            this.configChangeRequired = true;
        }
    }

    public boolean isShowSearch() {
        return this.showSearch;
    }

    public void setShowSearch(boolean showSearch) {
        this.showSearch = showSearch;
        if (!showSearch) {
            this.configChangeRequired = true;
        }
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
        if (!"brief".equalsIgnoreCase(control) && !"normal".equalsIgnoreCase(control)) {
            throw new PresentationExceptions.InvalidControlException(control);
        }
        if ("brief".equalsIgnoreCase(control)) {
            this.configChangeRequired = true;
        }
    }

    public String getControlLocation() {
        return this.controlLocation;
    }

    public void setControlLocation(String controlLocation) {
        this.controlLocation = controlLocation;
        if (!controlLocation.equalsIgnoreCase("left") && !controlLocation.equalsIgnoreCase("right")) {
            throw new PresentationExceptions.InvalidControlLocationException(controlLocation);
        }
        if ("left".equalsIgnoreCase(controlLocation)) {
            this.configChangeRequired = true;
        }
    }

    public String getInitialTab() {
        return this.initialTab;
    }

    public void setInitialTab(String initialTab) {
        this.initialTab = initialTab.trim();
        if (!(initialTab.equalsIgnoreCase(NOTES) || initialTab.equalsIgnoreCase(SEARCH) || initialTab.equalsIgnoreCase("outline"))) {
            throw new PresentationExceptions.InvalidInitialTabException(initialTab);
        }
        if (NOTES.equalsIgnoreCase(initialTab) || SEARCH.equalsIgnoreCase(initialTab)) {
            this.configChangeRequired = true;
        }
    }

    public String getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(String primaryColor) {
        this.primaryColor = this.getHexColor(primaryColor);
        this.configChangeRequired = true;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = this.getHexColor(backgroundColor);
        this.configChangeRequired = true;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = this.getHexColor(textColor);
        this.configChangeRequired = true;
    }

    public String getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(String lightColor) {
        this.lightColor = this.getHexColor(lightColor);
        this.configChangeRequired = true;
    }

    public String getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(String shadowColor) {
        this.shadowColor = this.getHexColor(shadowColor);
        this.configChangeRequired = true;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public String getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(String glowColor) {
        this.glowColor = this.getHexColor(glowColor);
        this.configChangeRequired = true;
    }

    private String getHexColor(String color) {
        if ((color = color.trim()).startsWith("#")) {
            color = color.substring(1);
            this.validateHexColor(color);
            return "0x" + color;
        }
        if (color.startsWith("0x")) {
            this.validateHexColor(color.substring(2));
            return color;
        }
        String retColor = (String)colorMap.get(color);
        if (retColor == null) {
            throw new PresentationExceptions.InvalidColorException(color);
        }
        return retColor;
    }

    private void validateHexColor(String color) {
        if (color.length() != 6) {
            throw new PresentationExceptions.InvalidColorException(color);
        }
        try {
            Integer.parseInt(color, 16);
        }
        catch (NumberFormatException e) {
            throw new PresentationExceptions.InvalidColorException(color);
        }
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isAutoPlay() {
        return this.autoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public List getPresenters() {
        return this.presenters;
    }

    public void addPresenter(PresenterTag.Presenter presenter) {
        if (this.presenters == null) {
            this.presenters = new ArrayList();
            this.indexMap = new HashMap();
        }
        this.indexMap.put(presenter.getName().toLowerCase(), new Integer(this.presenters.size()));
        this.presenters.add(presenter);
    }

    public int getIndexOfPresenter(String presenterName) {
        if (this.indexMap == null) {
            return -1;
        }
        Integer intObj = (Integer)this.indexMap.get(presenterName.toLowerCase());
        return intObj == null ? -1 : intObj;
    }

    public void addSlides(SlideData slide) {
        if (this.slides == null) {
            this.slides = new ArrayList();
        }
        this.slides.add(slide);
    }

    public void addHTMLSlides(String[] html) {
        if (this.htmlslides == null) {
            this.htmlslides = new ArrayList();
        }
        this.htmlslides.add(html);
    }

    public int getHTMLSlideCount() {
        if (this.htmlslides == null) {
            return 0;
        }
        return this.htmlslides.size();
    }

    public void incrementSlideCount() {
        ++this.slideCount;
    }

    public void setSlideCount(int count) {
        this.slideCount += count;
    }

    public int getSlideCount() {
        return this.slideCount;
    }

    public HSLFSlideShow getPPTObject() {
        return this.ppt;
    }

    public int doStartTag() throws JspException {
        File destFile;
        if (!this.isShowNotes() && NOTES.equalsIgnoreCase(this.initialTab)) {
            throw new PresentationExceptions.InvalidInitialNotesException();
        }
        if (this.title.equalsIgnoreCase("") && !this.format.equalsIgnoreCase("ppt") && !this.format.equalsIgnoreCase("html")) {
            throw new PresentationExceptions.TitleNotSpecifiedException();
        }
        if (this.format.equalsIgnoreCase("PPT") && this.destination == null) {
            throw new PresentationExceptions.DestinationNotDefinedException();
        }
        if (this.destination != null && VFSFileFactory.getFileObject((String)this.destination).isDirectory() && this.format.equalsIgnoreCase("PPT")) {
            throw new PresentationExceptions.FilenameNotFileException(this.destination);
        }
        if (this.destination != null && (destFile = VFSFileFactory.getFileObject((String)this.destination)).exists() && !this.isOverWrite()) {
            throw new PresentationExceptions.FileAlreadyExistsException(destFile.getAbsolutePath());
        }
        this.onTagStart();
        this.setupDestination();
        this.initURLConnectionSettings();
        if (this.format.equalsIgnoreCase("PPT")) {
            this.ppt = new HSLFSlideShow();
        }
        FeatureRouter.getInstance().allowFeature(EFRConstants.presentation_generation.intValue(), this.tagNameFromClass(), null);
        return 2;
    }

    private void initURLConnectionSettings() {
        if (this.proxyHost != null) {
            try {
                Socket sock = new Socket(this.proxyHost, this.proxyPort);
                sock.close();
            }
            catch (IOException e) {
                throw new DocumentTag.ProxyConnectionException(this.proxyHost, this.proxyPort, (Throwable)e);
            }
        }
        this.urlConnSettings = new URLConnectionSettings();
        this.urlConnSettings.setProxyHost(this.proxyHost);
        this.urlConnSettings.setProxyPort(this.proxyPort);
        this.urlConnSettings.setProxyUser(this.proxyUser);
        this.urlConnSettings.setProxyPassword(this.proxyPassword);
        this.urlConnSettings.setAuthUserName(this.authUser);
        this.urlConnSettings.setAuthPassword(this.authPassword);
        this.urlConnSettings.setUserAgent(this.userAgent);
    }

    public URLConnectionSettings getURLConnectionSettings() {
        return this.urlConnSettings;
    }

    public static boolean isPPT(String filename) {
        if (filename != null) {
            return filename.toLowerCase().endsWith(".ppt") || filename.toLowerCase().endsWith(".pps");
        }
        return false;
    }

    private void setupDestination() {
        if (this.destination != null) {
            File destinationDirectory;
            File destinationFile = VFSFileFactory.getFileObject((String)this.destination);
            if (!destinationFile.isAbsolute()) {
                destinationFile = new File(Utils.getTemplatePathBaseDir(), this.destination);
            }
            if (!(destinationDirectory = destinationFile.getParentFile()).exists()) {
                throw new PresentationExceptions.InvalidDestinationException(this.destination);
            }
            this.directory = destinationFile.isDirectory() ? this.destination : destinationDirectory.getAbsolutePath();
        }
        if (this.directory != null && this.destination == null) {
            this.destination = this.directory;
        }
        if (this.directory != null) {
            File file = VFSFileFactory.getFileObject((String)this.directory);
            if (!file.isAbsolute()) {
                file = new File(Utils.getTemplatePathBaseDir(), this.directory);
            }
            if (!(file.exists() && !file.isFile() || this.format.equalsIgnoreCase("PPT"))) {
                throw new PresentationExceptions.InvalidDestinationException(this.directory);
            }
            this.shouldSendToBrowser = false;
            this.presentationDir = file;
        } else if (System.getSecurityManager() == null) {
            this.createTempPresentationDir();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationTag.this.createTempPresentationDir();
                    return null;
                }
            });
        }
    }

    private void createTempPresentationDir() {
        String presoFolder;
        File tempDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), TEMP_FOLDER);
        if (!initialized) {
            this.initDocService();
            CFFileServlet.cleanupTempCache((File)tempDir, (int)documentService.getPresentationExpiryTime());
            initialized = true;
        }
        do {
            presoFolder = "_preso" + UUIDUtils.createUUID((boolean)false);
            this.presentationDir = new File(tempDir, presoFolder);
        } while (this.presentationDir.exists());
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        if (req.getContextPath() != null) {
            this.presoFolderURI = req.getContextPath();
        }
        this.presoFolderURI = this.presoFolderURI + "/CFFileServlet/_cf_preso/" + presoFolder;
    }

    public File getPresentationDirectory() {
        if (this.presentationDir != null && !this.presentationDir.exists()) {
            this.presentationDir.mkdirs();
        }
        return this.presentationDir;
    }

    public File getDataDirectory() {
        if (Objects.isNull(this.dataDirectory)) {
            this.dataDirectory = VFSFileFactory.getFileObject((File)this.getPresentationDirectory(), (String)"data");
            this.dataDirectory.mkdir();
        }
        return this.dataDirectory;
    }

    public void checkSlideFile(final File slideFile) {
        if (System.getSecurityManager() == null) {
            this._checkHTMLSlide(slideFile);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationTag.this._checkHTMLSlide(slideFile);
                    return null;
                }
            });
        }
    }

    private void _checkHTMLSlide(File f) {
        if (!this.isOverWrite() && f.exists()) {
            throw new PresentationExceptions.FileAlreadyExistsException(f.getAbsolutePath());
        }
    }

    private ArrayList<String> generateHTMLSlideShow() throws Exception {
        int slidenumber = 1;
        ArrayList<String> slidefiles = new ArrayList<String>();
        for (int i = 0; i < this.htmlslides.size(); ++i) {
            String[] allhtmls = this.htmlslides.get(i);
            for (int j = 0; j < allhtmls.length; ++j) {
                String name = "htmlslide_" + slidenumber + ".htm";
                File htmlfile = VFSFileFactory.getFileObject((File)this.getPresentationDirectory(), (String)name);
                this.checkSlideFile(htmlfile);
                slidefiles.add(name);
                ++slidenumber;
                this._writeHtml(allhtmls[j], name);
            }
        }
        return slidefiles;
    }

    private void _copyJSFile(final File jsfile) {
        if (System.getSecurityManager() == null) {
            this.copyJSFile(jsfile);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PresentationTag.this.copyJSFile(jsfile);
                    return null;
                }
            });
        }
    }

    private void copyJSFile(File jsfile) {
        try {
            IOUtils.copyFile((File)jsfile, (File)this.getPresentationDirectory());
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
    }

    private String buildIndexhtml(ArrayList<String> slidefiles, String jsfileloc, String uriPrefix) {
        return new HTMLSlideShowHelper().build(slidefiles, jsfileloc, uriPrefix);
    }

    private String _buildIndexhtml(final ArrayList<String> slidefiles, final String jsfileloc, final String uriPrefix) {
        String indexhtml = "";
        indexhtml = System.getSecurityManager() == null ? this.buildIndexhtml(slidefiles, jsfileloc, uriPrefix) : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PresentationTag.this.buildIndexhtml(slidefiles, jsfileloc, uriPrefix);
            }
        });
        return indexhtml;
    }

    private void initDocService() {
        if (documentService == null) {
            documentService = ServiceFactory.getDocumentService();
        }
    }

    public int doEndTag() throws JspException {
        if (this.slideCount == 0) {
            throw new PresentationExceptions.EmptyPresentationException();
        }
        if ((this.directory != null || this.destination != null) && System.getSecurityManager() != null) {
            AccessController.checkPermission(new FilePermission(this.getPresentationDirectory().getAbsolutePath(), "write"));
        }
        try {
            if (this.format.equalsIgnoreCase("html")) {
                ArrayList<String> slidefiles = this.generateHTMLSlideShow();
                File jsfile = VFSFileFactory.getFileObject((String)this.getTemplateDir(), (String)"cfslideshow.js");
                this._copyJSFile(jsfile);
                String jsfileloc = this.getPresentationDirectory().getAbsolutePath() + "/cfslideshow.js";
                String uriPrefix = this.directory == null ? this.presoFolderURI + "/" : "";
                String index_html = this._buildIndexhtml(slidefiles, jsfileloc, uriPrefix);
                String index_html_name = htmFile;
                if (this.shouldSendToBrowser) {
                    this.initDocService();
                    CFFileServlet.submitTaskForCleanup((File)this.getPresentationDirectory(), (int)documentService.getPresentationExpiryTime());
                    if (this.out instanceof CFOutput) {
                        ((CFOutput)this.out).clearAll();
                    }
                    this.out.clear();
                    this.out.write(index_html);
                } else {
                    this._writeHtml(index_html, index_html_name);
                }
            } else {
                if (this.format.equalsIgnoreCase("")) {
                    throw new PresentationExceptions.FormatInvalidException();
                }
                this._writePPT();
            }
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
        this.onTagEnd();
        return 6;
    }

    public void _writePPT() throws Exception {
        if (System.getSecurityManager() == null) {
            this.writePPT();
        } else {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PresentationTag.this.writePPT();
                    return null;
                }
            });
        }
    }

    public void writePPT() {
        OutputStream pptout = null;
        try {
            pptout = VFSFileFactory.getOutputStream((String)this.destination);
            if (this.ppt != null) {
                this.ppt.write(pptout);
            }
        }
        catch (Exception e) {
            throw new PresentationExceptions.PresentationException((Throwable)e);
        }
        finally {
            if (pptout != null) {
                try {
                    pptout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void _writeHtml(final String content, final String filename) throws Exception {
        if (System.getSecurityManager() == null) {
            this.writeHtml(content, filename);
        } else {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PresentationTag.this.writeHtml(content, filename);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHtml(String content, String htmFile) throws IOException {
        File htmlFile = VFSFileFactory.getFileObject((File)this.getPresentationDirectory(), (String)htmFile);
        if (this.directory != null && !this.overWrite && htmlFile.exists()) {
            throw new PresentationExceptions.FileAlreadyExistsException(htmlFile.getAbsolutePath());
        }
        try (OutputStream fos = null;){
            fos = VFSFileFactory.getOutputStream((File)htmlFile);
            fos.write(content.getBytes());
        }
    }

    public void _writeHtml(String content) throws Exception {
        this._writeHtml(content, htmFile);
    }

    private String getHtmlContent() {
        String uriPrefix = this.directory == null ? this.presoFolderURI + "/" : "";
        StringBuffer buff = new StringBuffer(html1);
        buff.append(this.title).append(html2).append(uriPrefix).append(html3).append(uriPrefix).append(html4);
        return buff.toString();
    }

    private void _copyTemplateFiles() throws IOException, PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            this.copyTemplateFiles();
        } else {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PresentationTag.this.copyTemplateFiles();
                    return null;
                }
            });
        }
    }

    private void copyTemplateFiles() throws IOException {
        File dest;
        File template;
        int i;
        String templateFolder = this.getTemplateDir();
        for (i = 0; i < rootTemplates.length; ++i) {
            template = new File(templateFolder, rootTemplates[i]);
            if (this.directory != null && !this.overWrite && (dest = VFSFileFactory.getFileObject((File)this.getPresentationDirectory(), (String)rootTemplates[i])).exists()) {
                throw new PresentationExceptions.FileAlreadyExistsException(dest.getAbsolutePath());
            }
            IOUtils.copyFile((File)template, (File)this.getPresentationDirectory());
        }
        for (i = 0; i < dataTemplates.length; ++i) {
            template = new File(templateFolder, dataTemplates[i]);
            if (this.directory != null && !this.overWrite && (dest = VFSFileFactory.getFileObject((File)this.getDataDirectory(), (String)dataTemplates[i])).exists()) {
                throw new PresentationExceptions.FileAlreadyExistsException(dest.getAbsolutePath());
            }
            IOUtils.copyFile((File)template, (File)this.getDataDirectory());
        }
    }

    public String getTemplateDir() {
        if (templateDir == null) {
            String rootDir = ServiceFactory.getRuntimeService().getRootDir();
            templateDir = rootDir + File.separator + "lib" + File.separator + "preso";
        }
        return templateDir;
    }

    private void _buildBreezeXml() throws Exception {
        if (System.getSecurityManager() == null) {
            this.buildBreezeXml();
        } else {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PresentationTag.this.buildBreezeXml();
                    return null;
                }
            });
        }
    }

    private void buildBreezeXml() throws ParserConfigurationException, IOException {
        int i;
        File viewerXmlFile = VFSFileFactory.getFileObject((File)this.getDataDirectory(), (String)VIEWER_XML);
        File searchXmlFile = VFSFileFactory.getFileObject((File)this.getDataDirectory(), (String)SEARCH_XML);
        if (this.directory != null && !this.overWrite) {
            if (viewerXmlFile.exists()) {
                throw new PresentationExceptions.FileAlreadyExistsException(viewerXmlFile.getAbsolutePath());
            }
            if (searchXmlFile.exists()) {
                throw new PresentationExceptions.FileAlreadyExistsException(searchXmlFile.getAbsolutePath());
            }
        }
        BreezeXmlBuilder breezeXml = new BreezeXmlBuilder(viewerXmlFile);
        BreezeSearchXmlBuilder searchXml = new BreezeSearchXmlBuilder(searchXmlFile);
        breezeXml.setHeight(540);
        breezeXml.setWidth(720);
        breezeXml.setStartMode(this.autoPlay ? "play" : "paused");
        breezeXml.setLoop(this.loop);
        breezeXml.setPresentationTitle(this.title);
        searchXml.setDocumentInfo(this.title, "", "");
        if (this.presenters != null) {
            for (i = 0; i < this.presenters.size(); ++i) {
                PresenterTag.Presenter presenter = (PresenterTag.Presenter)this.presenters.get(i);
                String image = presenter.getImage();
                image = image == null ? image : new File(image).getName();
                String logo = presenter.getLogo();
                logo = logo == null ? logo : new File(logo).getName();
                breezeXml.addSpeaker(presenter.getName(), presenter.getTitle(), presenter.getEmail(), image, presenter.getBiography(), logo);
            }
        }
        breezeXml.addBackGround(backgroundUrl);
        breezeXml.setSearchXml(SEARCH_XML);
        for (i = 0; i < this.slides.size(); ++i) {
            SlideData slideData = (SlideData)this.slides.get(i);
            breezeXml.addSlide(slideData);
            searchXml.addSlide(slideData);
        }
        searchXml.save();
        breezeXml.save();
    }

    private void _buildVConfigXml() throws Exception {
        if (System.getSecurityManager() == null) {
            this.buildVConfigXml();
        } else {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PresentationTag.this.buildVConfigXml();
                    return null;
                }
            });
        }
    }

    private void buildVConfigXml() throws IOException, ParserConfigurationException, SAXException {
        File breezeConfigFile = VFSFileFactory.getFileObject((File)this.getDataDirectory(), (String)"vconfig.xml");
        BreezeConfigXmlBuilder breezeConfig = new BreezeConfigXmlBuilder(breezeConfigFile);
        breezeConfig.setOutlineVisible(this.showOutline);
        breezeConfig.setSearchVisible(this.showSearch);
        breezeConfig.setNotesVisible(this.showNotes);
        if (this.control != null) {
            breezeConfig.setControl(this.control);
        }
        if (this.controlLocation != null) {
            breezeConfig.setControlLocation(this.controlLocation);
        }
        if (this.initialTab != null) {
            breezeConfig.setInitialTab(this.initialTab);
        }
        if (this.primaryColor != null) {
            breezeConfig.setPrimaryColor(this.primaryColor);
        }
        if (this.backgroundColor != null) {
            breezeConfig.setBackgroundColor(this.backgroundColor);
        }
        if (this.textColor != null) {
            breezeConfig.setTextColor(this.textColor);
        }
        if (this.glowColor != null) {
            breezeConfig.setGlowColor(this.glowColor);
        }
        if (this.lightColor != null) {
            breezeConfig.setLightColor(this.lightColor);
        }
        if (this.shadowColor != null) {
            breezeConfig.setShadowColor(this.shadowColor);
        }
        breezeConfig.save();
    }

    public void release() {
        this.title = "";
        this.directory = null;
        this.destination = null;
        this.presenters = null;
        this.indexMap = null;
        this.slides = null;
        this.htmlslides = null;
        this.slideCount = 0;
        this.overWrite = false;
        this.showOutline = true;
        this.showNotes = true;
        this.showSearch = true;
        this.control = null;
        this.controlLocation = null;
        this.initialTab = null;
        this.primaryColor = null;
        this.backgroundColor = null;
        this.textColor = null;
        this.lightColor = null;
        this.shadowColor = null;
        this.glowColor = null;
        this.marginTop = 20;
        this.marginBottom = 20;
        this.marginLeft = 20;
        this.marginRight = 20;
        this.proxyHost = null;
        this.proxyPort = 80;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.authUser = null;
        this.authPassword = null;
        this.userAgent = null;
        this.autoPlay = true;
        this.loop = false;
        this.format = "";
        this.ppt = null;
        super.release();
    }

    static {
        colorMap.put("red", "0xFF0000");
        colorMap.put("green", "0x008000");
        colorMap.put("blue", "0x0000FF");
        colorMap.put("black", "0x000000");
        colorMap.put("white", "0xFFFFFF");
        colorMap.put("yellow", "0xFFFF00");
        colorMap.put("gray", "0x808080");
        colorMap.put("darkgray", "0xA9A9A9");
        colorMap.put("lightgray", "0xD3D3D3");
        colorMap.put("cyan", "0x00FFFF");
        colorMap.put("magenta", "0xFF00FF");
        colorMap.put("orange", "0xFFA500");
        colorMap.put("pink", "0xFFC0CB");
    }
}

