/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.Task;

import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.orm.search.ORMSearchManager;
import coldfusion.orm.search.Task.AddLuceneTask;
import coldfusion.orm.search.Task.DeleteLuceneTask;
import coldfusion.orm.search.Task.LuceneTask;
import coldfusion.orm.search.Task.TaskType;
import coldfusion.orm.search.Task.UpdateLuceneTask;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.EntityWorkSpace;
import coldfusion.orm.search.lucene.DocumentBuilder;
import coldfusion.runtime.TemplateProxy;

public class LuceneTaskHelper {
    public static void createLuceneTask(TaskType type, PersistentTemplateProxy entity) {
        LuceneTask task = null;
        String entityName = ORMSearchManager.getEntityName((TemplateProxy)entity);
        if (entityName == null) {
            return;
        }
        CFCSearchMetadata metadata = ORMSearchManager.getCurrentSearchFactory().getCFCSearchMetadata(entityName);
        if (metadata == null || !metadata.isAutoIndex()) {
            return;
        }
        DocumentBuilder docBuilder = new DocumentBuilder(entityName, entity);
        switch (type) {
            case ADD: {
                task = new AddLuceneTask(entityName, docBuilder);
                break;
            }
            case DELETE: {
                task = new DeleteLuceneTask(entityName, docBuilder);
                break;
            }
            case UPDATE: {
                task = new UpdateLuceneTask(entityName, docBuilder);
                break;
            }
        }
        ORMSearchManager.addLuceneTask(task);
    }

    public static void performLuceneTask(LuceneTask task) {
        EntityWorkSpace workSpace = ORMSearchManager.getCurrentSearchFactory().getEntityWorkSpace(task.getEntityName());
        task.performTask(workSpace);
    }
}

