/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search;

import coldfusion.orm.search.ORMSearchSettings;
import coldfusion.orm.search.core.CFCSearchMetadata;
import coldfusion.orm.search.core.EntityWorkSpace;
import coldfusion.util.CaseInsensitiveMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ORMSearchFactory {
    private Map<String, CFCSearchMetadata> entityVsSearchMetadata = new CaseInsensitiveMap();
    private Map<String, CFCSearchMetadata> entityVsSearchMetadataForRefferedCFC = new CaseInsensitiveMap();
    private Map<String, EntityWorkSpace> entityVsWorkSpace = new CaseInsensitiveMap();
    private Map<String, String> cfcNameVsEntityName = new CaseInsensitiveMap();
    private ORMSearchSettings searchSettings;
    private IndexHierarchyGraph indexHierarchy;

    public void addCFCSearchMetadata(String entityName, CFCSearchMetadata smd) {
        this.entityVsSearchMetadata.put(entityName, smd);
        this.cfcNameVsEntityName.put(smd.getCfcName(), entityName);
    }

    public void addCFCSearchMetadataForReferredCFC(String entityName, CFCSearchMetadata smd) {
        this.entityVsSearchMetadataForRefferedCFC.put(entityName, smd);
        this.cfcNameVsEntityName.put(smd.getCfcName(), entityName);
    }

    public void buildIndexHierarchyGraph() {
        this.indexHierarchy = new IndexHierarchyGraph();
        for (String entityName : this.entityVsSearchMetadata.keySet()) {
            this.indexHierarchy.addIndexedEntity(entityName);
        }
    }

    public Set<String> getIndexHierarchy(String entityName) {
        return this.indexHierarchy.getIndexedEntity(entityName);
    }

    public CFCSearchMetadata getCFCSearchMetadata(String entityName) {
        return this.entityVsSearchMetadata.get(entityName);
    }

    public CFCSearchMetadata getSearchMetadataForReferredCFC(String entityName) {
        return this.entityVsSearchMetadataForRefferedCFC.get(entityName);
    }

    public EntityWorkSpace getEntityWorkSpace(String entityName) {
        EntityWorkSpace workSpace = this.entityVsWorkSpace.get(entityName);
        if (workSpace == null) {
            workSpace = new EntityWorkSpace(entityName);
            this.entityVsWorkSpace.put(entityName, workSpace);
        }
        return workSpace;
    }

    public ORMSearchSettings getSearchSettings() {
        return this.searchSettings;
    }

    public String getEntityName(String cfcName) {
        return this.cfcNameVsEntityName.get(cfcName);
    }

    public void setSearchSettings(ORMSearchSettings searchSettings) {
        this.searchSettings = searchSettings;
    }

    public boolean isEntityIndexable(String entityName) {
        return this.entityVsSearchMetadata.containsKey(entityName);
    }

    public Set<String> getEntitySet() {
        return this.entityVsSearchMetadata.keySet();
    }

    public void release() {
        for (EntityWorkSpace entityWorkSpace : this.entityVsWorkSpace.values()) {
            entityWorkSpace.close();
        }
    }

    private class IndexHierarchyGraph {
        private Map<String, Set<String>> entityToIndexedEntity = new CaseInsensitiveMap();

        IndexHierarchyGraph() {
        }

        void addIndexedEntity(String entityName) {
            this.addEntity(entityName, entityName);
            String parentEntityName = this.getParentEntityName(entityName);
            while (parentEntityName != null) {
                this.addEntity(parentEntityName, entityName);
                parentEntityName = this.getParentEntityName(parentEntityName);
            }
        }

        private String getParentEntityName(String entityName) {
            String parentEntityName = null;
            CFCSearchMetadata searchMetadata = (CFCSearchMetadata)ORMSearchFactory.this.entityVsSearchMetadata.get(entityName);
            if (searchMetadata != null) {
                parentEntityName = searchMetadata.getParentEntityName();
            }
            return parentEntityName;
        }

        private void addEntity(String parentEntityName, String entityName) {
            Set<String> entityNameSet = this.entityToIndexedEntity.get(parentEntityName);
            if (entityNameSet == null) {
                entityNameSet = new HashSet<String>();
                this.entityToIndexedEntity.put(parentEntityName, entityNameSet);
            }
            entityNameSet.add(entityName);
        }

        Set<String> getIndexedEntity(String entityName) {
            return this.entityToIndexedEntity.get(entityName);
        }
    }
}

