/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.ContainerReference;
import coldfusion.azure.blob.request.CreatePartFileRequest;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.filter.FusionContext;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import java.io.File;
import java.util.Collections;
import javax.servlet.jsp.PageContext;

public class CreatePartFileRequestConsumer
extends ConsumerMap<CreatePartFileRequest> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static CreatePartFileRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CreatePartFileRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<CreatePartFileRequestConsumer> clazz = CreatePartFileRequestConsumer.class;
        synchronized (CreatePartFileRequestConsumer.class) {
            instance = new CreatePartFileRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CreatePartFileRequestConsumer() {
        this.put("srcFile", new ConsumerValidator((request, value) -> request.setSourceFileName(Utils.getFileFullPath((String)this.cast.getStringProperty(value), (PageContext)FusionContext.getCurrent().pageContext, (boolean)true)), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blockSizeInBytes", new ConsumerValidator((request, value) -> {
            int intValue = this.cast.getIntegerProperty(value);
            ValidationUtil.validNumberInRange((long)intValue, (long)0L, (long)Integer.MAX_VALUE, (String)"blockSizeInBytes");
            request.setBlockSizeInBytes(intValue);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("destinationDirectory", new ConsumerValidator((request, value) -> {
            String path = Utils.getFileFullPath((String)this.cast.getStringProperty(value), (PageContext)FusionContext.getCurrent().pageContext, (boolean)true);
            if (!new File(path).isDirectory()) {
                throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidDirectory", (Object)"destinationDirectory"));
            }
            request.setDirectory(path);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

