/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob.consumer;

import coldfusion.azure.blob.ContainerReference;
import coldfusion.azure.blob.consumer.AbstractAccessRequestConsumer;
import coldfusion.azure.blob.request.CommitBlockList;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.util.RB;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CommitBlockListRequestConsumer
extends AbstractAccessRequestConsumer<CommitBlockList> {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;
    public static CommitBlockListRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommitBlockListRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<CommitBlockListRequestConsumer> clazz = CommitBlockListRequestConsumer.class;
        synchronized (CommitBlockListRequestConsumer.class) {
            instance = new CommitBlockListRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CommitBlockListRequestConsumer() {
        this.put("blobName", new ConsumerValidator((request, value) -> request.setBlobName(this.cast.getStringProperty(value)), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blockIds", new ConsumerValidator((request, value) -> {
            List<String> ids = value instanceof String ? Arrays.asList(this.cast.getStringProperty(value).split(",")) : this.cast.getStringListProperty(value);
            ids.forEach(id -> {
                if (Objects.isNull(id) || id.trim().isEmpty()) {
                    throw new ValidationException(RB.getString(ContainerReference.class, (String)"invalidBlockIds"));
                }
                request.add((String)id);
            });
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

