/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.syndication;

import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.FeedGenerator;
import coldfusion.syndication.FeedSyndicationException;
import com.sun.syndication.feed.module.itunes.EntryInformationImpl;
import com.sun.syndication.feed.module.itunes.FeedInformationImpl;
import com.sun.syndication.feed.module.itunes.types.Category;
import com.sun.syndication.feed.module.itunes.types.Duration;
import com.sun.syndication.feed.module.itunes.types.Subcategory;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Cloud;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Enclosure;
import com.sun.syndication.feed.rss.Guid;
import com.sun.syndication.feed.rss.Image;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.rss.Source;
import com.sun.syndication.feed.rss.TextInput;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RSSGenerator
extends Channel {
    public void createRSSChannel(Struct feedStruct, String feedType) {
        this.setFeedType(feedType);
        this.setFeedMetadata(feedStruct);
        Array items = null;
        Object itemObj = feedStruct.get((Object)"item");
        if (itemObj != null && !(itemObj instanceof Array)) {
            throw new FeedGenerator.InvalidAttributeTypeException("item", "Array");
        }
        items = (Array)feedStruct.get((Object)"item");
        if (items != null) {
            Iterator it = items.iterator();
            ArrayList<Item> feedItems = new ArrayList<Item>();
            int itemIndex = 0;
            while (it.hasNext()) {
                Object categoryObj;
                Object enclosureObj;
                Object guidObj;
                Object obj = it.next();
                if (!(obj instanceof Struct)) {
                    throw new FeedGenerator.InvalidAttributeTypeException("item", "Struct");
                }
                Struct item = (Struct)obj;
                Item currentItem = new Item();
                currentItem.setTitle(FeedGenerator.getString(item, "title"));
                Object descriptionObj = item.get((Object)"description");
                if (descriptionObj != null) {
                    Struct descriptionStruct = null;
                    if (!(descriptionObj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("description", "Struct");
                    }
                    descriptionStruct = (Struct)descriptionObj;
                    Description description = new Description();
                    description.setType(FeedGenerator.getString(descriptionStruct, "type"));
                    description.setValue(FeedGenerator.getString(descriptionStruct, "value"));
                    currentItem.setDescription(description);
                }
                currentItem.setLink(FeedGenerator.getString(item, "link"));
                currentItem.setUri(FeedGenerator.getString(item, "uri"));
                Object sourceObj = item.get((Object)"source");
                if (sourceObj != null) {
                    Struct sourceStruct = null;
                    if (!(sourceObj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("source", "Struct");
                    }
                    sourceStruct = (Struct)sourceObj;
                    Source source = new Source();
                    source.setUrl(FeedGenerator.getString(sourceStruct, "url"));
                    source.setValue(FeedGenerator.getString(sourceStruct, "value"));
                    currentItem.setSource(source);
                }
                if ((guidObj = item.get((Object)"guid")) != null) {
                    String isPermaLink;
                    Struct guidStruct = null;
                    if (!(guidObj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("guid", "Struct");
                    }
                    guidStruct = (Struct)guidObj;
                    Guid guid = new Guid();
                    String string = isPermaLink = guidStruct.get((Object)"isPermaLink") instanceof String ? FeedGenerator.checkBlankValue((String)guidStruct.get((Object)"isPermaLink")) : null;
                    if (isPermaLink != null) {
                        guid.setPermaLink(Cast._boolean((String)isPermaLink));
                    }
                    guid.setValue(FeedGenerator.getString(guidStruct, "value"));
                    currentItem.setGuid(guid);
                }
                if ((enclosureObj = item.get((Object)"enclosure")) != null) {
                    Array enclosuresArray = null;
                    if (!(enclosureObj instanceof Array)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("enclosure", "Array");
                    }
                    enclosuresArray = (Array)enclosureObj;
                    if (enclosuresArray != null && enclosuresArray.size() > 0) {
                        ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>();
                        for (Object obj1 : enclosuresArray) {
                            if (!(obj1 instanceof Struct)) {
                                throw new FeedGenerator.InvalidAttributeTypeException("enclosure", "Struct");
                            }
                            Struct enclosureStruct = (Struct)obj1;
                            Enclosure rssEnclosure = new Enclosure();
                            rssEnclosure.setLength(FeedGenerator.getLong(enclosureStruct, "length"));
                            rssEnclosure.setType(FeedGenerator.getString(enclosureStruct, "type"));
                            rssEnclosure.setUrl(FeedGenerator.getString(enclosureStruct, "url"));
                            enclosures.add(rssEnclosure);
                        }
                        currentItem.setEnclosures(enclosures);
                    }
                }
                if ((categoryObj = item.get((Object)"category")) != null) {
                    Array categoriesArray = null;
                    if (!(categoryObj instanceof Array)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("category", "Array");
                    }
                    categoriesArray = (Array)categoryObj;
                    if (categoriesArray != null && categoriesArray.size() > 0) {
                        ArrayList<com.sun.syndication.feed.rss.Category> categories = new ArrayList<com.sun.syndication.feed.rss.Category>();
                        for (Object obj1 : categoriesArray) {
                            if (!(obj1 instanceof Struct)) {
                                throw new FeedGenerator.InvalidAttributeTypeException("category", "Struct");
                            }
                            Struct categoryStruct = (Struct)obj1;
                            com.sun.syndication.feed.rss.Category rssCategory = new com.sun.syndication.feed.rss.Category();
                            rssCategory.setDomain(FeedGenerator.getString(categoryStruct, "domain"));
                            rssCategory.setValue(FeedGenerator.getString(categoryStruct, "value"));
                            categories.add(rssCategory);
                        }
                        currentItem.setCategories(categories);
                    }
                }
                currentItem.setComments(FeedGenerator.getString(item, "comments"));
                currentItem.setAuthor(FeedGenerator.getString(item, "author"));
                currentItem.setPubDate(FeedGenerator.getDate(item, "pubDate"));
                currentItem.setExpirationDate(FeedGenerator.getDate(item, "expirationDate"));
                this.createItunesItems(feedStruct, currentItem, itemIndex);
                feedItems.add(currentItem);
                ++itemIndex;
            }
            this.setItems(feedItems);
        }
    }

    private void createItunesItems(Struct feedStruct, Item currentItem, int itemIndex) {
        Array feedEntries = (Array)feedStruct.get((Object)"item");
        boolean itunesElemetnExist = false;
        if (feedEntries != null) {
            Struct item = (Struct)feedEntries.get(itemIndex);
            EntryInformationImpl entryInfo = new EntryInformationImpl();
            if (item.get((Object)"itunes_author") != null) {
                entryInfo.setAuthor((String)item.get((Object)"itunes_author"));
                itunesElemetnExist = true;
            }
            if (item.get((Object)"itunes_block") != null) {
                if (((String)item.get((Object)"itunes_block")).equalsIgnoreCase("yes")) {
                    entryInfo.setBlock(true);
                } else {
                    entryInfo.setBlock(false);
                }
                itunesElemetnExist = true;
            }
            if (item.get((Object)"itunes_explicit") != null) {
                if (((String)item.get((Object)"itunes_explicit")).equalsIgnoreCase("yes")) {
                    entryInfo.setExplicit(true);
                } else {
                    entryInfo.setExplicit(false);
                }
                itunesElemetnExist = true;
            }
            if (item.get((Object)"itunes_duration") != null) {
                entryInfo.setDuration(new Duration((String)item.get((Object)"itunes_duration")));
            }
            if (item.get((Object)"itunes_keywords") != null) {
                String keywords = (String)item.get((Object)"itunes_keywords");
                StringTokenizer token = new StringTokenizer(keywords, ",");
                String[] keyArray = new String[token.countTokens()];
                int index = 0;
                while (token.hasMoreTokens()) {
                    keyArray[index] = token.nextToken().trim();
                    ++index;
                }
                entryInfo.setKeywords(keyArray);
                itunesElemetnExist = true;
            }
            if (item.get((Object)"itunes_subtitle") != null) {
                entryInfo.setSubtitle((String)item.get((Object)"itunes_subtitle"));
                itunesElemetnExist = true;
            }
            if (item.get((Object)"itunes_summary") != null) {
                entryInfo.setSummary((String)item.get((Object)"itunes_summary"));
                itunesElemetnExist = true;
            }
            if (itunesElemetnExist) {
                ArrayList<EntryInformationImpl> modules = new ArrayList<EntryInformationImpl>();
                modules.add(entryInfo);
                currentItem.setModules(modules);
            }
        }
    }

    public void createRSSChannel(Struct feedMetadata, QueryTable feedQuery, Struct columnMap, String feedType) {
        this.setFeedType(feedType);
        this.setFeedMetadata(feedMetadata);
        int numItems = feedQuery.getRowCount();
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < numItems; ++i) {
            Item currentItem = new Item();
            feedQuery.absolute(i + 1);
            currentItem.setTitle(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "TITLE", columnMap)));
            Description description = new Description();
            String desc_type = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "CONTENTTYPE", columnMap));
            String desc_value = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "CONTENT", columnMap));
            description.setType(desc_type);
            description.setValue(desc_value);
            if (desc_type != null || desc_value != null) {
                currentItem.setDescription(description);
            }
            currentItem.setLink(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "RSSLINK", columnMap)));
            currentItem.setUri(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "URI", columnMap)));
            Source source = new Source();
            String source_url = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "SOURCEURL", columnMap));
            String source_value = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "SOURCE", columnMap));
            source.setUrl(source_url);
            source.setValue(source_value);
            if (source_url != null || source_value != null) {
                currentItem.setSource(source);
            }
            Guid guid = new Guid();
            String isPermaLink = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "IDPERMALINK", columnMap));
            if (isPermaLink != null) {
                guid.setPermaLink(Cast._boolean((String)isPermaLink));
            }
            String guid_value = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "ID", columnMap));
            guid.setValue(guid_value);
            if (isPermaLink != null || guid_value != null) {
                currentItem.setGuid(guid);
            }
            ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>();
            String length = FeedGenerator.getColumnValue(feedQuery, "LINKLENGTH", columnMap);
            String type = FeedGenerator.getColumnValue(feedQuery, "LINKTYPE", columnMap);
            String url = FeedGenerator.getColumnValue(feedQuery, "LINKHREF", columnMap);
            if (length != null && type != null && url != null) {
                StringTokenizer lengthSt = new StringTokenizer(length, ",");
                StringTokenizer typeSt = new StringTokenizer(type, ",");
                StringTokenizer urlSt = new StringTokenizer(url, ",");
                if (lengthSt.countTokens() != typeSt.countTokens() || lengthSt.countTokens() != urlSt.countTokens()) {
                    throw new FeedGenerator.UnequalColumnValuesException("enclosure");
                }
                while (lengthSt.hasMoreTokens()) {
                    Enclosure rssEnclosure = new Enclosure();
                    try {
                        String _Length = FeedGenerator.checkBlankValue(lengthSt.nextToken().trim());
                        if (_Length != null) {
                            rssEnclosure.setLength(new Long(Cast._long((String)_Length)));
                        }
                    }
                    catch (Cast.NumberConversionException e) {
                        throw new FeedGenerator.InvalidAttributeTypeException("length", "Number");
                    }
                    rssEnclosure.setType(FeedGenerator.checkBlankValue(typeSt.nextToken()));
                    rssEnclosure.setUrl(FeedGenerator.checkBlankValue(urlSt.nextToken()));
                    enclosures.add(rssEnclosure);
                }
                currentItem.setEnclosures(enclosures);
            }
            ArrayList<com.sun.syndication.feed.rss.Category> categories = new ArrayList<com.sun.syndication.feed.rss.Category>();
            String domain = FeedGenerator.getColumnValue(feedQuery, "CATEGORYSCHEME", columnMap);
            String value = FeedGenerator.getColumnValue(feedQuery, "CATEGORYLABEL", columnMap);
            if (value != null) {
                StringTokenizer domainSt = null;
                if (domain != null) {
                    domainSt = new StringTokenizer(domain, ",");
                }
                StringTokenizer valueSt = new StringTokenizer(value, ",");
                while (valueSt.hasMoreTokens()) {
                    com.sun.syndication.feed.rss.Category rssCategory = new com.sun.syndication.feed.rss.Category();
                    if (domainSt != null && domainSt.hasMoreTokens()) {
                        rssCategory.setDomain(FeedGenerator.checkBlankValue(domainSt.nextToken()));
                    }
                    rssCategory.setValue(FeedGenerator.checkBlankValue(valueSt.nextToken()));
                    categories.add(rssCategory);
                }
                currentItem.setCategories(categories);
            }
            currentItem.setComments(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "COMMENTS", columnMap)));
            currentItem.setAuthor(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "AUTHOREMAIL", columnMap)));
            String pubStr = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "PUBLISHEDDATE", columnMap, false), false);
            currentItem.setPubDate(FeedGenerator.getDate(pubStr, "PublishedDate Column"));
            String expirationStr = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "EXPIRATIONDATE", columnMap, false), false);
            currentItem.setExpirationDate(FeedGenerator.getDate(expirationStr, "ExpirationDate Column"));
            this.createItunesItemsFromQuery(currentItem, feedQuery, columnMap);
            items.add(currentItem);
        }
        if (numItems > 0) {
            this.setItems(items);
        }
    }

    private void createItunesItemsFromQuery(Item currentItem, QueryTable feedQuery, Struct columnMap) {
        String summary;
        String subtitle;
        String keys;
        String duration;
        String explicit;
        String block;
        boolean itunesExtensionsExist = false;
        EntryInformationImpl entryInfo = new EntryInformationImpl();
        String author = FeedGenerator.getColumnValue(feedQuery, "ITUNES_AUTHOR", columnMap);
        if (author != null) {
            entryInfo.setAuthor(author);
            itunesExtensionsExist = true;
        }
        if ((block = FeedGenerator.getColumnValue(feedQuery, "ITUNES_BLOCK", columnMap)) != null) {
            if (block.equals("yes")) {
                entryInfo.setBlock(true);
            } else {
                entryInfo.setBlock(false);
            }
            itunesExtensionsExist = true;
        }
        if ((explicit = FeedGenerator.getColumnValue(feedQuery, "ITUNES_EXPLICIT", columnMap)) != null) {
            if (explicit.equals("yes")) {
                entryInfo.setExplicit(true);
            } else {
                entryInfo.setExplicit(false);
            }
            itunesExtensionsExist = true;
        }
        if ((duration = FeedGenerator.getColumnValue(feedQuery, "ITUNES_DURATION", columnMap)) != null) {
            entryInfo.setDuration(new Duration(duration));
        }
        if ((keys = FeedGenerator.getColumnValue(feedQuery, "ITUNES_KEYWORDS", columnMap)) != null) {
            String keywords = keys;
            StringTokenizer token = new StringTokenizer(keywords, ",");
            String[] keyArray = new String[token.countTokens()];
            int index = 0;
            while (token.hasMoreTokens()) {
                keyArray[index] = token.nextToken().trim();
                ++index;
            }
            entryInfo.setKeywords(keyArray);
            itunesExtensionsExist = true;
        }
        if ((subtitle = FeedGenerator.getColumnValue(feedQuery, "ITUNES_SUBTITLE", columnMap)) != null) {
            entryInfo.setSubtitle(subtitle);
            itunesExtensionsExist = true;
        }
        if ((summary = FeedGenerator.getColumnValue(feedQuery, "ITUNES_SUMMARY", columnMap)) != null) {
            entryInfo.setSummary(summary);
            itunesExtensionsExist = true;
        }
        if (itunesExtensionsExist) {
            ArrayList<EntryInformationImpl> modules = new ArrayList<EntryInformationImpl>();
            modules.add(entryInfo);
            currentItem.setModules(modules);
        }
    }

    private void setFeedMetadata(Struct metadataStruct) throws FeedSyndicationException {
        Object skipHoursObj;
        Object skipDaysObj;
        this.setTitle(FeedGenerator.getString(metadataStruct, "title"));
        this.setLink(FeedGenerator.getString(metadataStruct, "link"));
        this.setDescription(FeedGenerator.getString(metadataStruct, "description"));
        this.setLanguage(FeedGenerator.getString(metadataStruct, "language"));
        this.setCopyright(FeedGenerator.getString(metadataStruct, "copyright"));
        this.setManagingEditor(FeedGenerator.getString(metadataStruct, "managingeditor"));
        this.setWebMaster(FeedGenerator.getString(metadataStruct, "webMaster"));
        this.setEncoding(FeedGenerator.getString(metadataStruct, "encoding"));
        this.setPubDate(FeedGenerator.getDate(metadataStruct, "pubDate"));
        this.setLastBuildDate(FeedGenerator.getDate(metadataStruct, "lastBuildDate"));
        Array categoriesArray = null;
        Object categoryObj = metadataStruct.get((Object)"category");
        if (categoryObj != null && !(categoryObj instanceof Array)) {
            throw new FeedGenerator.InvalidAttributeTypeException("category", "Array");
        }
        categoriesArray = (Array)metadataStruct.get((Object)"category");
        if (categoriesArray != null && categoriesArray.size() > 0) {
            ArrayList<com.sun.syndication.feed.rss.Category> categoriesList = new ArrayList<com.sun.syndication.feed.rss.Category>();
            for (int i = 0; i < categoriesArray.size(); ++i) {
                Object icategoryObj = categoriesArray.get(i);
                if (!(icategoryObj instanceof Struct)) {
                    throw new FeedGenerator.InvalidAttributeTypeException("category", "Struct");
                }
                Struct categoryStruct = (Struct)icategoryObj;
                com.sun.syndication.feed.rss.Category currCategory = new com.sun.syndication.feed.rss.Category();
                currCategory.setDomain(FeedGenerator.getString(categoryStruct, "domain"));
                currCategory.setValue(FeedGenerator.getString(categoryStruct, "value"));
                categoriesList.add(currCategory);
            }
            this.setCategories(categoriesList);
        }
        this.setGenerator(FeedGenerator.getString(metadataStruct, "generator"));
        this.setDocs(FeedGenerator.getString(metadataStruct, "docs"));
        Struct cloudStruct = null;
        Object cloudObj = metadataStruct.get((Object)"cloud");
        if (cloudObj != null && !(cloudObj instanceof Struct)) {
            throw new FeedGenerator.InvalidAttributeTypeException("cloud", "Struct");
        }
        cloudStruct = (Struct)cloudObj;
        if (cloudStruct != null) {
            Cloud feedCloud = new Cloud();
            feedCloud.setDomain(FeedGenerator.getString(cloudStruct, "domain"));
            feedCloud.setPort(FeedGenerator.getInteger(cloudStruct, "port"));
            feedCloud.setPath(FeedGenerator.getString(cloudStruct, "path"));
            feedCloud.setProtocol(FeedGenerator.getString(cloudStruct, "protocol"));
            feedCloud.setRegisterProcedure(FeedGenerator.getString(cloudStruct, "registerProcedure"));
            this.setCloud(feedCloud);
        }
        this.setTtl(FeedGenerator.getInteger(metadataStruct, "ttl"));
        Struct imageStruct = null;
        Object imageObj = metadataStruct.get((Object)"image");
        if (imageObj != null && !(imageObj instanceof Struct)) {
            throw new FeedGenerator.InvalidAttributeTypeException("image", "Struct");
        }
        imageStruct = (Struct)imageObj;
        if (imageStruct != null) {
            Image feedImage = new Image();
            feedImage.setUrl(FeedGenerator.getString(imageStruct, "url"));
            feedImage.setDescription(FeedGenerator.getString(imageStruct, "description"));
            feedImage.setTitle(FeedGenerator.getString(imageStruct, "title"));
            feedImage.setLink(FeedGenerator.getString(imageStruct, "link"));
            feedImage.setWidth(FeedGenerator.getInteger(imageStruct, "width"));
            feedImage.setHeight(FeedGenerator.getInteger(imageStruct, "height"));
            this.setImage(feedImage);
        }
        this.setRating(FeedGenerator.getString(metadataStruct, "rating"));
        Struct textInputStruct = null;
        Object textInputObj = metadataStruct.get((Object)"textInput");
        if (textInputObj != null && !(textInputObj instanceof Struct)) {
            throw new FeedGenerator.InvalidAttributeTypeException("textInput", "Struct");
        }
        textInputStruct = (Struct)metadataStruct.get((Object)"textInput");
        if (textInputStruct != null) {
            TextInput feedTextInput = new TextInput();
            feedTextInput.setTitle(FeedGenerator.getString(textInputStruct, "title"));
            feedTextInput.setDescription(FeedGenerator.getString(textInputStruct, "description"));
            feedTextInput.setLink(FeedGenerator.getString(textInputStruct, "link"));
            feedTextInput.setName(FeedGenerator.getString(textInputStruct, "name"));
            this.setTextInput(feedTextInput);
        }
        if ((skipDaysObj = metadataStruct.get((Object)"skipDays")) != null) {
            if (!(skipDaysObj instanceof String)) {
                throw new FeedGenerator.InvalidAttributeTypeException("skipDays", "List of days");
            }
            StringTokenizer skipDays = new StringTokenizer((String)skipDaysObj, ",");
            ArrayList<String> skipDaysList = new ArrayList<String>();
            while (skipDays.hasMoreTokens()) {
                skipDaysList.add(skipDays.nextToken());
            }
            try {
                this.setSkipDays(skipDaysList);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidSkipDayValueException(e.getMessage());
            }
        }
        if ((skipHoursObj = metadataStruct.get((Object)"skipHours")) != null) {
            if (!(skipHoursObj instanceof String)) {
                throw new FeedGenerator.InvalidAttributeTypeException("skipHours", "List of numbers");
            }
            StringTokenizer skipHours = new StringTokenizer((String)skipHoursObj, ",");
            ArrayList<Integer> skipHoursList = new ArrayList<Integer>();
            try {
                while (skipHours.hasMoreTokens()) {
                    skipHoursList.add(new Integer(Integer.parseInt(skipHours.nextToken())));
                }
                this.setSkipHours(skipHoursList);
            }
            catch (NumberFormatException e) {
                throw new FeedGenerator.InvalidAttributeTypeException("skipHours", "List of Numbers");
            }
            catch (IllegalArgumentException e) {
                throw new InvalidSkipHoursValueException(e.getMessage());
            }
        }
        this.setItunesMetadata(metadataStruct);
    }

    private void setItunesMetadata(Struct metadataStruct) {
        boolean itunesExtensionsExist = false;
        FeedInformationImpl feedInfo = new FeedInformationImpl();
        ArrayList<FeedInformationImpl> modules = new ArrayList<FeedInformationImpl>();
        if (metadataStruct.get((Object)"itunes_author") != null) {
            feedInfo.setAuthor((String)metadataStruct.get((Object)"itunes_author"));
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_block") != null) {
            if (((String)metadataStruct.get((Object)"itunes_block")).equalsIgnoreCase("yes")) {
                feedInfo.setBlock(true);
            } else {
                feedInfo.setBlock(false);
            }
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_category") != null) {
            Array cat = (Array)metadataStruct.get((Object)"itunes_category");
            Iterator itr = cat.iterator();
            ArrayList<Category> categories = new ArrayList<Category>();
            while (itr.hasNext()) {
                Struct category = (Struct)itr.next();
                Category categoryObj = new Category();
                categoryObj.setName((String)category.get((Object)"category"));
                String sub = (String)category.get((Object)"subcategory");
                if (sub != null) {
                    Subcategory subcat = new Subcategory();
                    subcat.setName(sub);
                    categoryObj.setSubcategory(subcat);
                }
                categories.add(categoryObj);
            }
            feedInfo.setCategories(categories);
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_explicit") != null) {
            if (((String)metadataStruct.get((Object)"itunes_explicit")).equalsIgnoreCase("yes")) {
                feedInfo.setExplicit(true);
            } else {
                feedInfo.setExplicit(false);
            }
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_image") != null) {
            try {
                feedInfo.setImage(new URL((String)metadataStruct.get((Object)"itunes_image")));
                itunesExtensionsExist = true;
            }
            catch (Exception e) {
                throw new FeedSyndicationException(e);
            }
        }
        if (metadataStruct.get((Object)"itunes_keywords") != null) {
            String keywords = (String)metadataStruct.get((Object)"itunes_keywords");
            StringTokenizer token = new StringTokenizer(keywords, ",");
            String[] keyArray = new String[token.countTokens()];
            int index = 0;
            while (token.hasMoreTokens()) {
                keyArray[index] = token.nextToken();
                ++index;
            }
            feedInfo.setKeywords(keyArray);
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_owner") != null) {
            Struct owner = (Struct)metadataStruct.get((Object)"itunes_owner");
            if (owner.get((Object)"itunes_name") != null) {
                feedInfo.setOwnerName((String)owner.get((Object)"itunes_name"));
            }
            if (owner.get((Object)"itunes_email") != null) {
                feedInfo.setOwnerEmailAddress((String)owner.get((Object)"itunes_email"));
            }
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_subtitle") != null) {
            feedInfo.setSubtitle((String)metadataStruct.get((Object)"itunes_subtitle"));
            itunesExtensionsExist = true;
        }
        if (metadataStruct.get((Object)"itunes_summary") != null) {
            feedInfo.setSummary((String)metadataStruct.get((Object)"itunes_summary"));
            itunesExtensionsExist = true;
        }
        if (itunesExtensionsExist) {
            modules.add(feedInfo);
            this.setModules(modules);
        }
    }

    public static class InvalidSkipHoursValueException
    extends FeedSyndicationException {
        String message;

        public InvalidSkipHoursValueException(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class InvalidSkipDayValueException
    extends FeedSyndicationException {
        String message;

        public InvalidSkipDayValueException(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

