/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling.mod;

import coldfusion.log.CFLogs;
import coldfusion.security.AbstractCfPathValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class CfSchedulerPathFilter
extends AbstractCfPathValidator {
    public static final String SCHEDULER_EXECUTION_PATHS = "schedulerexecutionpaths";
    private String defaultAllowedPaths = "";
    private List<Function<String, AbstractCfPathValidator.Status>> filters = new ArrayList<Function<String, AbstractCfPathValidator.Status>>();
    private String pathFilterInputs = this.loadPathFilter("schedulerexecutionpaths") + ";";

    public CfSchedulerPathFilter() {
        this.filters = this.createFilters(this.pathFilterInputs);
    }

    public String getDefaultAllowedPaths() {
        if (this.defaultAllowedPaths.isEmpty()) {
            this.defaultAllowedPaths = "";
        }
        return this.defaultAllowedPaths;
    }

    protected void onValidationComplete(AbstractCfPathValidator.Status status, String filePath, boolean logOnFailure) {
        if (status == AbstractCfPathValidator.Status.REJECTED && logOnFailure) {
            CFLogs.SERVER_LOG.debug((Object)("File is not allowed for scheduler execution: " + filePath));
        }
    }

    public boolean validatePath(String filePath, boolean logOnFailure) {
        AbstractCfPathValidator.Status status = this.checkInput(filePath, this.filters);
        this.onValidationComplete(status, filePath, logOnFailure);
        return status == AbstractCfPathValidator.Status.ALLOWED;
    }

    protected void logNoPathsWarning(String key) {
        CFLogs.SERVER_LOG.warn((Object)("No paths found for key '" + key + "' in pathfilter.json for scheduler validation"));
    }

    protected void logParseError(IOException e) {
        CFLogs.SERVER_LOG.error((Object)("Error reading path filter JSON file for scheduler validation: " + e.getMessage()));
    }
}

