/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRIntegerIncrementerFactory;

class JRIntegerCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRIntegerCountIncrementer mainInstance = new JRIntegerCountIncrementer();

    private JRIntegerCountIncrementer() {
    }

    public static JRIntegerCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRIntegerIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRIntegerIncrementerFactory.ZERO;
        }
        return new Integer(value.intValue() + 1);
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null) {
            value = calculable.getValue() == null ? (Number)JRIntegerIncrementerFactory.ZERO : (Number)((Number)calculable.getValue());
        }
        if (combineValue == null) {
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRIntegerIncrementerFactory.ZERO;
        }
        return new Integer(value.intValue() + combineValue.intValue());
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRIntegerIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

