/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import coldfusion.runtime.report.CFExprEvaluator;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup = null;
    private JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    private String altText = null;

    protected JRFillImage(JRBaseFiller filler, JRImage image, JRFillObjectFactory factory) {
        super(filler, image, factory);
        this.evaluationGroup = factory.getGroup(image.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage image, JRFillCloneFactory factory) {
        super(image, factory);
        this.evaluationGroup = image.evaluationGroup;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getPen() {
        return JRStyleResolver.getPen(this, (byte)0);
    }

    @Override
    public byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    @Override
    public Byte getOwnScaleImage() {
        return ((JRImage)this.parent).getOwnScaleImage();
    }

    @Override
    public void setScaleImage(byte scaleImage) {
    }

    @Override
    public void setScaleImage(Byte scaleImage) {
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return ((JRImage)this.parent).getOwnHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
    }

    @Override
    public void setHorizontalAlignment(Byte horizontalAlignment) {
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return ((JRImage)this.parent).getOwnVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(byte verticalAlignment) {
    }

    @Override
    public void setVerticalAlignment(Byte verticalAlignment) {
    }

    @Override
    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    @Override
    public Boolean isOwnUsingCache() {
        return ((JRImage)this.parent).isOwnUsingCache();
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
    }

    @Override
    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    @Override
    public void setLazy(boolean isLazy) {
    }

    @Override
    public byte getOnErrorType() {
        return ((JRImage)this.parent).getOnErrorType();
    }

    @Override
    public void setOnErrorType(byte onErrorType) {
    }

    @Override
    public byte getEvaluationTime() {
        return ((JRImage)this.parent).getEvaluationTime();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRBox getBox() {
        return this;
    }

    @Override
    public byte getHyperlinkType() {
        return ((JRImage)this.parent).getHyperlinkType();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getAltTextExpression() {
        return ((JRImage)this.parent).getAltTextExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getAltText() {
        return this.altText;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle style = this.getStyle();
        JRTemplateImage template = (JRTemplateImage)this.getTemplate(style);
        if (template == null) {
            template = new JRTemplateImage(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(style, template);
        }
        return template;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        if (this.getEvaluationTime() == 7 && !this.delayedEvaluationsInitialized()) {
            this.initDelayedEvaluations();
            this.collectDelayedEvaluations();
        }
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        Object source;
        JRRenderable newRenderer;
        JRExpression expression;
        block18: {
            expression = this.getExpression();
            newRenderer = null;
            source = null;
            try {
                source = this.evaluateExpression(expression, evaluation);
            }
            catch (JRException t) {
                Object o;
                boolean rethrow = true;
                if (t.getCause() instanceof CFExprEvaluator.ReportClassCastException && (o = ((CFExprEvaluator.ReportClassCastException)((Object)t.getCause())).getResult()) instanceof String && ((String)o).equals("")) {
                    source = null;
                    rethrow = false;
                }
                if (!rethrow) break block18;
                throw t;
            }
        }
        if (source != null) {
            if (this.isUsingCache() && this.filler.fillContext.hasLoadedImage(source)) {
                newRenderer = this.filler.fillContext.getLoadedImage(source).getRenderer();
            } else {
                Class expressionClass = expression.getValueClass();
                if (Image.class.getName().equals(expressionClass.getName())) {
                    Image img = (Image)source;
                    newRenderer = JRImageRenderer.getInstance(img, this.getOnErrorType());
                } else if (InputStream.class.getName().equals(expressionClass.getName())) {
                    InputStream is = (InputStream)source;
                    newRenderer = JRImageRenderer.getInstance(is, this.getOnErrorType());
                } else if (URL.class.getName().equals(expressionClass.getName())) {
                    URL url = (URL)source;
                    newRenderer = JRImageRenderer.getInstance(url, this.getOnErrorType());
                } else if (File.class.getName().equals(expressionClass.getName())) {
                    File file = (File)source;
                    newRenderer = JRImageRenderer.getInstance(file, this.getOnErrorType());
                } else if (String.class.getName().equals(expressionClass.getName())) {
                    String location = (String)source;
                    newRenderer = JRImageRenderer.getInstance(location, this.getOnErrorType(), this.isLazy(), this.filler.reportClassLoader, this.filler.urlHandlerFactory);
                } else if (JRRenderable.class.getName().equals(expressionClass.getName())) {
                    newRenderer = (JRRenderable)source;
                }
                if (this.isUsingCache()) {
                    JRTemplatePrintImage img = new JRTemplatePrintImage(this.getJRTemplateImage());
                    img.setRenderer(newRenderer);
                    this.filler.fillContext.registerLoadedImage(source, img);
                }
            }
        }
        this.setValueRepeating(this.renderer == newRenderer);
        this.renderer = newRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
        this.altText = (String)this.evaluateExpression(this.getAltTextExpression(), evaluation);
    }

    @Override
    protected boolean prepare(int availableStretchHeight, boolean isOverflow) {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage;
        JRRecordedValuesPrintImage recordedValuesImage;
        byte evaluationType = this.getEvaluationTime();
        if (evaluationType == 7) {
            recordedValuesImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage());
            printImage = recordedValuesImage;
        } else {
            printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
            recordedValuesImage = null;
        }
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        if (evaluationType == 1) {
            this.copy(printImage);
        } else if (evaluationType == 7) {
            this.initDelayedEvaluationPrint(recordedValuesImage);
        } else {
            this.filler.addBoundElement(this, printImage, evaluationType, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
        printImage.setAltText(this.getAltText());
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getImage(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeImage(this);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        this.copy((JRPrintImage)element);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRImage)this.parent).getBookmarkLevel();
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    @Override
    public void setBorder(byte border) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte topBorder) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte rightBorder) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
    }

    @Override
    public void setBorder(Byte border) {
    }

    @Override
    public void setPadding(Integer padding) {
    }

    @Override
    public void setTopBorder(Byte topBorder) {
    }

    @Override
    public void setTopPadding(Integer topPadding) {
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillImage(this, factory);
    }

    private void collectDelayedEvaluations() {
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

