/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debug;

import coldfusion.debugger.DebugEventHandler;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.Variable;
import coldfusion.runtime.VariableScope;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.Row;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class LineDebuggerHelper {
    public static final int maxRowsTodisplayInQuery = 100;

    public static boolean setVariableValue(CFPage page, String varName, String value) throws Exception {
        try {
            Object evalValue;
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return false;
            }
            if (LineDebuggerHelper.setArrayVariableValue(page, varName, value)) {
                return false;
            }
            try {
                evalValue = page.Evaluate((Object)value);
            }
            catch (Exception ex) {
                try {
                    evalValue = page.Evaluate((Object)("\"" + value + "\""));
                }
                catch (Exception ex2) {
                    try {
                        evalValue = page.Evaluate((Object)("'" + value + "'"));
                    }
                    catch (Exception ex3) {
                        evalValue = value;
                    }
                }
            }
            page._set(varName, evalValue);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isArrayVariable(String varName, Object[] retValues) throws Exception {
        if ((varName = varName.trim()).charAt(varName.length() - 1) != ']') {
            return false;
        }
        int index1 = varName.lastIndexOf(91);
        String indexStr = varName.substring(index1 + 1, varName.length() - 1);
        int arrayIndex = -1;
        try {
            arrayIndex = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException ne) {
            return false;
        }
        if (arrayIndex == -1) {
            throw new Exception("Invalid array index - " + indexStr);
        }
        String arrayVarName = varName.substring(0, index1);
        if (retValues != null && retValues.length >= 2) {
            retValues[0] = arrayVarName;
            retValues[1] = new Integer(arrayIndex);
        }
        return true;
    }

    private static boolean setArrayVariableValue(CFPage page, String varName, Object value) throws Exception {
        String arrayVarName = null;
        int index = -1;
        try {
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return false;
            }
            Object[] retValues = new Object[2];
            if (!LineDebuggerHelper.isArrayVariable(varName, retValues)) {
                return false;
            }
            arrayVarName = retValues[0].toString();
            index = (Integer)retValues[1];
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            return false;
        }
        try {
            Object evalValue = page.Evaluate((Object)value.toString());
            page._arraySetAt(arrayVarName, new Object[]{new Integer(index)}, evalValue);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            throw e;
        }
        return true;
    }

    public static Object getVariableValue(CFPage page, String varName) {
        try {
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return null;
            }
            return LineDebuggerHelper.evaluateExpression(page, varName);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            return null;
        }
    }

    private static Object getArrayElementValue(CFPage page, String varName) throws Exception {
        String arrayVarName = null;
        Integer index = null;
        if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
            return null;
        }
        Object[] retValues = new Object[2];
        if (!LineDebuggerHelper.isArrayVariable(varName, retValues)) {
            return null;
        }
        arrayVarName = retValues[0].toString();
        index = (Integer)retValues[1];
        try {
            return page._arrayGetAt(arrayVarName, (Object)index);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            throw e;
        }
    }

    public static Object evaluateExpression(CFPage page, String expr) {
        try {
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return null;
            }
            return page.Evaluate((Object)expr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map getFunctionLocalVariables(CFPage page) {
        try {
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return null;
            }
            LocalScope localScope = page.pageContext.getActiveFunctionLocalScope();
            if (localScope == null) {
                return null;
            }
            HashMap functionLocalScope = new HashMap();
            functionLocalScope.putAll(localScope);
            Object args = functionLocalScope.remove("ARGUMENTS");
            if (args != null && args instanceof Map) {
                for (Object key : ((Map)args).keySet()) {
                    functionLocalScope.remove(key);
                }
            }
            return functionLocalScope;
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            return null;
        }
    }

    public static byte[] getFunctionLocalVariablesAsByteArray(CFPage page) {
        if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
            return null;
        }
        Map funcVars = LineDebuggerHelper.getFunctionLocalVariables(page);
        if (funcVars == null) {
            return null;
        }
        try {
            Object serValue = LineDebuggerHelper.makeVariableValueSerializable(funcVars, null);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
            objStream.writeObject(serValue);
            byte[] objBytes = byteStream.toByteArray();
            byteStream.close();
            return objBytes;
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            return null;
        }
    }

    public static String getCFOutput(CFPage page, boolean onlyBody) {
        try {
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return null;
            }
            return page.GetPageContext().getOutput(onlyBody);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            return null;
        }
    }

    public static byte[] getVariableValueAsByteArray(CFPage page, String varName) {
        try {
            if (page == null && (page = LineDebuggerHelper.getPageObject()) == null) {
                return null;
            }
            Object varValue = LineDebuggerHelper.evaluateExpression(page, varName);
            Object serValue = LineDebuggerHelper.makeVariableValueSerializable(varValue, null);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
            objStream.writeObject(serValue);
            byte[] objBytes = byteStream.toByteArray();
            byteStream.close();
            return objBytes;
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
            return null;
        }
    }

    private static Object makeVariableValueSerializable(Object obj, Map parentMap) {
        try {
            if (obj == null) {
                return "";
            }
            Object duplicate = parentMap == null ? null : parentMap.get(obj);
            boolean hasDupRef = false;
            if (duplicate != null && !(duplicate instanceof String) && !(duplicate instanceof Variable)) {
                hasDupRef = true;
            }
            if (obj instanceof TemplateProxy) {
                return LineDebuggerHelper.serializeComponent((TemplateProxy)obj, parentMap, hasDupRef);
            }
            if (obj instanceof Map) {
                HashMap<String, Object> mapObj = new HashMap<String, Object>();
                Map nonSerMap = (Map)obj;
                Iterator it = nonSerMap.keySet().iterator();
                while (it.hasNext()) {
                    Object serObj;
                    String keyObj = it.next().toString();
                    String key = keyObj.toString();
                    Object valueObj = nonSerMap.get(keyObj);
                    IdentityHashMap<Object, Object> tempParentMap = null;
                    tempParentMap = parentMap != null ? parentMap : new IdentityHashMap<Object, Object>();
                    if (!tempParentMap.containsKey(obj)) {
                        tempParentMap.put(obj, obj);
                    }
                    if (hasDupRef) {
                        valueObj = LineDebuggerHelper.handleDuplicateReference(valueObj);
                    }
                    if ((serObj = LineDebuggerHelper.makeVariableValueSerializable(valueObj, tempParentMap)) == null) continue;
                    mapObj.put(key, serObj);
                }
                return mapObj;
            }
            if (obj instanceof Variable) {
                Variable var = (Variable)obj;
                Object objValue = var.getValue();
                return LineDebuggerHelper.makeVariableValueSerializable(objValue, parentMap);
            }
            if (obj instanceof QueryTable) {
                return LineDebuggerHelper.serializeQuery((QueryTable)obj, 100, parentMap);
            }
            if (obj instanceof FastArray) {
                return LineDebuggerHelper.serializeCFArray((FastArray)obj, parentMap, hasDupRef);
            }
            if (obj instanceof Object[]) {
                return LineDebuggerHelper.serializeJavaArray((Object[])obj, parentMap);
            }
            if (obj instanceof UDFMethod) {
                return null;
            }
            if (obj instanceof Throwable) {
                return LineDebuggerHelper.serializeException((Throwable)obj, parentMap);
            }
            return obj.toString();
        }
        catch (Throwable t) {
            CFLogs.APPLICATION_LOG.error(t);
            return null;
        }
    }

    private static Object serializeException(Throwable excp, Map parentMap) {
        if (excp instanceof DatabaseException) {
            return LineDebuggerHelper.serializeDatabaseException((DatabaseException)excp, parentMap);
        }
        return LineDebuggerHelper.makeVariableValueSerializable(LineDebuggerHelper.serializeExceptionHelper(excp), parentMap);
    }

    private static Map serializeExceptionHelper(Throwable excp) {
        HashMap<String, String> excpMap = new HashMap<String, String>();
        String message = excp.getMessage();
        excpMap.put("Message", message == null ? "" : message);
        excpMap.put("ExceptionClass", excp.getClass().getName());
        Throwable cause = null;
        if (excp instanceof NeoException) {
            NeoException neoExcp = (NeoException)excp;
            cause = neoExcp.getRootCause();
            String type = neoExcp.getType();
            if (type != null) {
                excpMap.put("Type", type);
            }
        } else {
            cause = excp.getCause();
        }
        if (cause != null) {
            excpMap.put("RootCause", cause.toString());
        }
        return excpMap;
    }

    private static Object serializeDatabaseException(DatabaseException excp, Map parentMap) {
        Map excpMap = LineDebuggerHelper.serializeExceptionHelper((Throwable)excp);
        String dataSource = excp.getDataSource();
        String detail = excp.getDetail();
        String errorCode = excp.getErrorCode();
        int nativeCode = excp.getNativeErrorCode();
        String sql = excp.getSql();
        if (dataSource != null) {
            excpMap.put("DataSource", dataSource);
        }
        if (detail != null) {
            excpMap.put("Detail", detail);
        }
        if (errorCode != null) {
            excpMap.put("ErrorCode", errorCode);
        }
        if (nativeCode != 0) {
            excpMap.put("NativeCode", String.valueOf(nativeCode));
        }
        if (sql != null) {
            excpMap.put("SQL", sql);
        }
        return LineDebuggerHelper.makeVariableValueSerializable(excpMap, parentMap);
    }

    private static Object serializeJavaArray(Object[] objects, Map parentMap) {
        Object[] serArray = new Object[objects.length];
        for (int i = 0; i < serArray.length; ++i) {
            Object obj = objects[i];
            serArray[i] = LineDebuggerHelper.makeVariableValueSerializable(obj, parentMap);
        }
        return serArray;
    }

    private static Object[] serializeCFArray(FastArray cfArray, Map parentMap, boolean hasDupRef) {
        Object[] serArray = new Object[cfArray.size()];
        for (int i = 0; i < serArray.length; ++i) {
            Object obj = cfArray.get(i);
            IdentityHashMap<Object, Object> tempParentMap = null;
            tempParentMap = parentMap != null ? parentMap : new IdentityHashMap<Object, Object>();
            if (!tempParentMap.containsKey(obj)) {
                tempParentMap.put(obj, obj);
            }
            if (hasDupRef) {
                obj = LineDebuggerHelper.handleDuplicateReference(obj);
            }
            serArray[i] = LineDebuggerHelper.makeVariableValueSerializable(obj, tempParentMap);
        }
        return serArray;
    }

    private static Object serializeQuery(QueryTable qTable, int maxRowsToShow, Map parentMap) {
        QueryTableMetaData queryMeta;
        Struct extendedMeta;
        int rowCount = qTable.getRecordCount();
        String[] cols = qTable.getColumnList();
        int rowsToDisplay = rowCount;
        if (maxRowsToShow != -1) {
            rowsToDisplay = rowCount > maxRowsToShow ? maxRowsToShow : rowCount;
        }
        HashMap<String, Object> queryResult = new HashMap<String, Object>();
        queryResult.put("COLUMNS", cols);
        queryResult.put("TOTAL_ROW_COUNT", String.valueOf(rowCount));
        queryResult.put("ROWS_DISPLAYED", String.valueOf(rowsToDisplay));
        ResultSetMetaData meta = qTable.getMetaData();
        if (meta != null && meta instanceof QueryTableMetaData && (extendedMeta = (queryMeta = (QueryTableMetaData)meta).getExtendedMetaData()) != null) {
            Object tmpObj = extendedMeta.get("EXECUTIONTIME");
            if (tmpObj != null) {
                queryResult.put("EXECUTIONTIME", tmpObj);
            }
            if ((tmpObj = extendedMeta.get("CACHED")) != null) {
                queryResult.put("CACHED", tmpObj);
            }
            if ((tmpObj = extendedMeta.get("SQL")) != null) {
                queryResult.put("SQL", tmpObj);
            }
        }
        Object[][] rowResult = new Object[rowsToDisplay][cols.length];
        for (int i = 0; i < rowsToDisplay; ++i) {
            Row aRow = qTable.getRow(i);
            for (int j = 0; j < cols.length; ++j) {
                Object colValue = aRow.getColumn(j);
                rowResult[i][j] = colValue == null ? "" : colValue;
            }
        }
        queryResult.put("ROWS", rowResult);
        return LineDebuggerHelper.makeVariableValueSerializable(queryResult, parentMap);
    }

    private static Object serializeComponent(TemplateProxy obj, Map parentMap, boolean hasDupRef) {
        Object resultMap = LineDebuggerHelper.serializeComponentHelper(obj, parentMap, hasDupRef);
        return LineDebuggerHelper.makeVariableValueSerializable(resultMap, parentMap);
    }

    private static Object serializeComponentHelper(TemplateProxy obj, Map parentMap, boolean hasDupRef) {
        Object pathObj;
        Object nameObj;
        Object propObj;
        Map extendsMap;
        Object varValue;
        HashMap resultMap = new HashMap();
        Map metaData = (Map)obj.getMetadata();
        HashMap<String, Object> thisVarMap = new HashMap<String, Object>();
        Iterator iter = obj.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = obj.get((Object)key);
            if ((value = LineDebuggerHelper.serializeComponentMembers(obj, value, parentMap, hasDupRef)) == null) continue;
            thisVarMap.put(key, value);
        }
        if (thisVarMap.size() > 0) {
            resultMap.put("THIS", thisVarMap);
        }
        HashMap<String, Object> varScopeMap = new HashMap<String, Object>();
        if (obj.page instanceof CFPage && (varValue = LineDebuggerHelper.evaluateExpression((CFPage)obj.page, "VARIABLES")) != null && varValue instanceof VariableScope) {
            VariableScope varScope = (VariableScope)varValue;
            Iterator iter2 = varScope.keys();
            while (iter2.hasNext()) {
                String key = (String)iter2.next();
                if (key.equals("THIS")) continue;
                Object value = varScope.get((Object)key);
                if ((value = LineDebuggerHelper.serializeComponentMembers(obj, value, parentMap, hasDupRef)) == null) continue;
                varScopeMap.put(key, value);
            }
        }
        if (varScopeMap.size() > 0) {
            resultMap.put("VARIABLES", varScopeMap);
        }
        if ((extendsMap = (Map)metaData.get("EXTENDS")) != null) {
            resultMap.put("EXTENDS", extendsMap.get("NAME"));
        }
        if ((propObj = metaData.get("PROPERTIES")) != null) {
            resultMap.put("PROPERTIES", propObj);
        }
        if ((nameObj = metaData.get("NAME")) != null) {
            resultMap.put("NAME", nameObj);
        }
        if ((pathObj = metaData.get("PATH")) != null) {
            resultMap.put("PATH", pathObj);
        }
        return resultMap;
    }

    private static Object handleDuplicateReference(Object dupRefObj) {
        if (dupRefObj instanceof String) {
            return dupRefObj;
        }
        if (dupRefObj instanceof Variable) {
            return ((Variable)dupRefObj).getValue().toString();
        }
        if (dupRefObj instanceof TemplateProxy) {
            TemplateProxy dupProxy = (TemplateProxy)dupRefObj;
            String dupObjStr = dupProxy.isComponent() ? "CFComponent" : "CFInterface";
            Map metaData = (Map)dupProxy.getMetadata();
            if (metaData != null) {
                String name = (String)metaData.get("FULLNAME");
                if (name == null) {
                    name = (String)metaData.get("NAME");
                }
                dupObjStr = dupObjStr + " = " + name;
            }
            return dupObjStr;
        }
        return "<<Recursive Reference - Cannot display value>>";
    }

    private static Object serializeComponentMembers(TemplateProxy comp, Object value, Map parentMap, boolean hasDupRef) {
        if (value instanceof UDFMethod) {
            return null;
        }
        IdentityHashMap<TemplateProxy, TemplateProxy> tempParentMap = null;
        Object result = null;
        tempParentMap = parentMap != null ? parentMap : new IdentityHashMap<TemplateProxy, TemplateProxy>();
        if (!tempParentMap.containsKey(comp)) {
            tempParentMap.put(comp, comp);
        }
        if (hasDupRef) {
            value = LineDebuggerHelper.handleDuplicateReference(value);
        }
        result = value instanceof TemplateProxy ? LineDebuggerHelper.serializeComponentHelper((TemplateProxy)value, tempParentMap, tempParentMap.containsKey(value)) : value;
        return result;
    }

    public static CFPage getPageObject() {
        FusionContext currFusionCtx = FusionContext.getCurrent();
        if (currFusionCtx == null) {
            return null;
        }
        Object pageObj = currFusionCtx.pageContext.getPage();
        if (pageObj instanceof CFPage) {
            return (CFPage)pageObj;
        }
        return null;
    }

    public static Object getPageContextObject() {
        FusionContext currFusionCtx = FusionContext.getCurrent();
        if (currFusionCtx == null) {
            return null;
        }
        return currFusionCtx.pageContext;
    }

    public static Object getExceptionStackTrace(Throwable th) {
        try {
            StackTraceElement[] stackTraces = th.getStackTrace();
            if (stackTraces == null) {
                return null;
            }
            ArrayList<String> javaTraces = new ArrayList<String>();
            ArrayList<String> cfTraces = new ArrayList<String>();
            for (int i = 0; i < stackTraces.length; ++i) {
                StackTraceElement trace = stackTraces[i];
                String fileName = trace.getFileName();
                int linenum = trace.getLineNumber();
                String pathLineNum = null;
                if (DebugEventHandler.isCfmlFile(fileName)) {
                    pathLineNum = fileName + ":" + linenum;
                    cfTraces.add(pathLineNum);
                } else {
                    pathLineNum = fileName + ":" + linenum;
                }
                javaTraces.add(pathLineNum);
            }
            Object[] javaTraceArray = javaTraces.toArray();
            Object[] cfTraceArray = cfTraces.toArray();
            Object[] resultArray = new Object[]{javaTraceArray, cfTraceArray};
            return resultArray;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

