/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.core.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.security.SecurityKeyPassword;
import com.adobe.internal.pdftoolkit.services.security.SecurityLockNoEncryption;
import com.adobe.internal.pdftoolkit.services.security.SecurityLockPassword;
import com.adobe.internal.pdftoolkit.services.security.StandardEncryptionPermissions;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;

public class PDFDocSecurityHandler {
    public SecurityLock encrypt(PDFDocument inputPDF, String newOwnerPWDStr, String newUserPWDStr, String encryptionMethod, String permissions, boolean ignorePerm) throws PDFException, UnsupportedEncodingException {
        byte[] user;
        StandardEncryptionPermissions encryptPerms;
        SecurityLockPassword securityLock = null;
        try {
            if (SecurityKeyPassword.newInstance((PDFDocument)inputPDF).getOwnerPassword() == null) {
                throw new PDFException.PDFOwnerPasswordException("PROTECT");
            }
        }
        catch (PDFSecurityException pDFSecurityException) {
            // empty catch block
        }
        if (!ignorePerm && (newOwnerPWDStr == null && permissions != null || newOwnerPWDStr != null && permissions == null) && !"NONE".equalsIgnoreCase(encryptionMethod)) {
            throw new PDFException.PDFOwnerPasswordPermException();
        }
        PermissionsManager permsMgr = PermissionsManager.newInstance((PDFDocument)inputPDF);
        StandardEncryptionPermissions standardEncryptionPermissions = encryptPerms = inputPDF.isEncrypted() ? StandardEncryptionPermissions.newInstance((PermissionProvider)permsMgr.getPermissionProvider("Security")) : StandardEncryptionPermissions.newInstanceAll();
        if (permissions != null) {
            this.setPermissions(permissions, encryptPerms);
        } else {
            this.setPreviousPermissions(inputPDF, encryptPerms);
        }
        PermissionProvider permsProvider = encryptPerms.getPermissionProvider();
        byte[] owner = newOwnerPWDStr == null ? null : newOwnerPWDStr.getBytes("US-ASCII");
        byte[] byArray = user = newUserPWDStr == null ? null : newUserPWDStr.getBytes("US-ASCII");
        if (encryptionMethod == null || encryptionMethod.equalsIgnoreCase("RC4_128")) {
            securityLock = SecurityLockPassword.newRC4_128bit((byte[])owner, (byte[])user, (PermissionProvider)permsProvider);
        } else if (encryptionMethod.equals("RC4_40")) {
            securityLock = SecurityLockPassword.newRC4_40bit((byte[])owner, (byte[])user, (PermissionProvider)permsProvider);
        } else if (encryptionMethod.equalsIgnoreCase("RC4_128M")) {
            securityLock = SecurityLockPassword.newRC4_128bit((byte[])owner, (byte[])user, (PermissionProvider)permsProvider, (boolean)false);
        } else if (encryptionMethod.equalsIgnoreCase("AES_128")) {
            securityLock = SecurityLockPassword.newAES_128bit((byte[])owner, (byte[])user, (PermissionProvider)permsProvider, (boolean)false);
        } else if (encryptionMethod.equalsIgnoreCase("AES_256R5")) {
            securityLock = SecurityLockPassword.newAES_256bitR5((byte[])owner, (byte[])user, (PermissionProvider)permsProvider, (boolean)false);
        } else if (encryptionMethod.equalsIgnoreCase("AES_256R6")) {
            securityLock = SecurityLockPassword.newAES_256bitR6((byte[])owner, (byte[])user, (PermissionProvider)permsProvider, (boolean)false);
        } else if (encryptionMethod.equalsIgnoreCase("NONE")) {
            securityLock = SecurityLockNoEncryption.newInstance();
        }
        return securityLock;
    }

    private void setPermissions(String permissions, StandardEncryptionPermissions pdfPermissions) {
        String[] permArr = permissions.split(",");
        pdfPermissions.allowPrintHigh(false);
        pdfPermissions.allowPrintLow(false);
        pdfPermissions.allowModify(false);
        pdfPermissions.allowCopy(false);
        pdfPermissions.allowAssemble(false);
        pdfPermissions.allowFill(false);
        pdfPermissions.allowExtract(false);
        pdfPermissions.allowAdd(false);
        pdfPermissions.allowSecure(false);
        for (int i = 0; i < permArr.length; ++i) {
            String perm = permArr[i].trim();
            if (perm.equalsIgnoreCase("AllowPrinting")) {
                pdfPermissions.allowPrintLow(true);
                pdfPermissions.allowPrintHigh(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowDegradedPrinting")) {
                pdfPermissions.allowPrintLow(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowModifyContents")) {
                pdfPermissions.allowModify(true);
                pdfPermissions.allowAssemble(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowCopy")) {
                pdfPermissions.allowCopy(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowAssembly")) {
                pdfPermissions.allowAssemble(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowFillIn")) {
                pdfPermissions.allowFill(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowSecure")) {
                pdfPermissions.allowSecure(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowModifyAnnotations")) {
                pdfPermissions.allowAdd(true);
                pdfPermissions.allowFill(true);
                continue;
            }
            if (perm.equalsIgnoreCase("AllowScreenReaders")) {
                pdfPermissions.allowExtract(true);
                continue;
            }
            if (perm.equalsIgnoreCase("ALL")) {
                if (permArr.length > 1) {
                    throw new PDFException.PDFInvalidPermissionException("permissions", permissions);
                }
                pdfPermissions.allowPrintHigh(true);
                pdfPermissions.allowPrintLow(true);
                pdfPermissions.allowModify(true);
                pdfPermissions.allowCopy(true);
                pdfPermissions.allowAssemble(true);
                pdfPermissions.allowFill(true);
                pdfPermissions.allowExtract(true);
                pdfPermissions.allowAdd(true);
                pdfPermissions.allowSecure(true);
                break;
            }
            if (perm.equalsIgnoreCase("NONE")) {
                if (permArr.length <= 1) break;
                throw new PDFException.PDFInvalidPermissionException("permissions", permissions);
            }
            if (perm.length() <= 0) continue;
            throw new PDFException.PDFDocumentInvalidEncryptionPermission(permissions);
        }
    }

    private void setPreviousPermissions(PDFDocument pdfDocument, StandardEncryptionPermissions pdfPermissions) throws PDFException {
        byte[] userPWDStr = null;
        String ownerPWDStr = null;
        String userPwd = null;
        try {
            ownerPWDStr = new String(SecurityKeyPassword.newInstance((PDFDocument)pdfDocument).getOwnerPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            userPWDStr = SecurityKeyPassword.newInstance((PDFDocument)pdfDocument).getUserPassword();
        }
        catch (Exception exception) {
            // empty catch block
        }
        pdfDocument.resetUnlock();
        try {
            userPwd = userPWDStr != null ? new String(userPWDStr) : null;
            this.checkNDecrypt(pdfDocument, userPwd, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PermissionsManager pm = PermissionsManager.newInstance((PDFDocument)pdfDocument);
        pdfPermissions.allowPrintHigh(false);
        pdfPermissions.allowPrintLow(false);
        pdfPermissions.allowModify(false);
        pdfPermissions.allowCopy(false);
        pdfPermissions.allowAssemble(false);
        pdfPermissions.allowFill(false);
        pdfPermissions.allowExtract(false);
        pdfPermissions.allowAdd(false);
        pdfPermissions.allowSecure(false);
        if (pm.isPermitted(ObjectOperations.FORM_FILLIN)) {
            pdfPermissions.allowFill(true);
        }
        if (pm.isPermitted(ObjectOperations.ANNOT_CREATE)) {
            pdfPermissions.allowAdd(true);
        }
        if (pm.isPermitted(ObjectOperations.PAGE_DELETE)) {
            pdfPermissions.allowAssemble(true);
        }
        if (pm.isPermitted(ObjectOperations.DOC_PRINT_HIGH)) {
            pdfPermissions.allowPrintLow(true);
            pdfPermissions.allowPrintHigh(true);
        }
        if (pm.isPermitted(ObjectOperations.DOC_PRINT_LOW)) {
            pdfPermissions.allowPrintLow(true);
        }
        if (pm.isPermitted(ObjectOperations.DOC_MODIFY)) {
            pdfPermissions.allowModify(true);
        }
        if (pm.isPermitted(ObjectOperations.DOC_SECURE)) {
            pdfPermissions.allowSecure(true);
        }
        if (pm.isPermitted(ObjectOperations.DOC_COPY)) {
            pdfPermissions.allowCopy(true);
        }
        if (pm.isPermitted(ObjectOperations.DOC_EXPORT)) {
            pdfPermissions.allowExtract(true);
        }
        pdfDocument.resetUnlock();
        try {
            if ("".equals(ownerPWDStr) && userPwd != null && !"".equals(userPwd)) {
                this.checkNDecrypt(pdfDocument, userPwd, true);
            } else {
                this.checkNDecrypt(pdfDocument, ownerPWDStr, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isActionAllowed(PDFDocument pdfDocument, ObjectOperations objp) throws PDFException {
        PermissionsManager pm;
        return pdfDocument != null && (pm = PermissionsManager.newInstance((PDFDocument)pdfDocument)).isPermitted(objp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkNDecrypt(PDFDocument inputPDF, String password, boolean absorbError) throws PDFException, UnsupportedEncodingException {
        if (Security.getProvider("JsafeJCE") == null && !Boolean.getBoolean("coldfusion.disablejsafe")) {
            Security.addProvider((Provider)new JsafeJCE());
        }
        if (!inputPDF.isEncrypted()) return;
        if (password != null) {
            if (inputPDF.getEncryptionType().equals(PDFEncryptionType.Password)) {
                try {
                    SecurityKeyPassword ownerKey = SecurityKeyPassword.newInstance((PDFDocument)inputPDF, (byte[])password.getBytes("US-ASCII"));
                    inputPDF.unlock((SecurityKey)ownerKey);
                    return;
                }
                catch (PDFSecurityAuthorizationException userE) {
                    SecurityKeyPassword defaultKey = SecurityKeyPassword.newInstance((PDFDocument)inputPDF);
                    try {
                        inputPDF.unlock((SecurityKey)defaultKey);
                        return;
                    }
                    catch (PDFSecurityAuthorizationException defaultE) {
                        if (absorbError) return;
                        inputPDF.close();
                        throw defaultE;
                    }
                }
                catch (PDFSecurityException userExcp) {
                    inputPDF.close();
                    throw userExcp;
                }
            }
            inputPDF.close();
            throw new PDFUnableToCompleteOperationException("password encryption expected");
        }
        if (inputPDF.isUnlocked()) return;
        SecurityKeyPassword defaultKey = SecurityKeyPassword.newInstance((PDFDocument)inputPDF);
        try {
            inputPDF.unlock((SecurityKey)defaultKey);
            return;
        }
        catch (PDFSecurityAuthorizationException defaultE) {
            if (absorbError) return;
            inputPDF.close();
            throw defaultE;
        }
    }
}

