/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.filter.FormScope;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.saml.RequestOptions;
import coldfusion.saml.SamlCacheHelper;
import coldfusion.saml.SpConfiguration;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.Error;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.exception.XMLEntityException;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.logout.LogoutResponse;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Constants;
import com.onelogin.saml2.util.Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlAuth {
    private boolean threatProtectionMode = Boolean.getBoolean("coldfusion.saml.threatprotectionmode.disabled");
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlAuth.class);
    private RequestOptions requestOptions;
    private SpConfiguration spConfiguration;
    private Saml2Settings settings;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String nameid;
    private String nameidFormat;
    private String nameidNameQualifier;
    private String nameidSPNameQualifier;
    private String sessionIndex;
    private DateTime sessionExpiration;
    private String lastMessageId;
    private String lastAssertionId;
    private List<Instant> lastAssertionNotOnOrAfter;
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private boolean authenticated = false;
    private List<String> errors = new ArrayList<String>();
    private String errorReason;
    private String lastRequestId;
    private String lastRequest;
    private String lastResponse;
    private boolean logoutSuccess = false;

    public SamlAuth(Saml2Settings settings, HttpServletRequest request, HttpServletResponse response, RequestOptions rq, SpConfiguration sp) {
        this.settings = settings;
        this.request = request;
        this.response = response;
        this.requestOptions = rq;
        this.spConfiguration = sp;
    }

    public void setStrict(Boolean value) {
        this.settings.setStrict(value.booleanValue());
    }

    public String login(String returnTo, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy, Boolean stay) throws IOException, SettingsException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        AuthnRequest authnRequest = new AuthnRequest(this.settings, forceAuthn.booleanValue(), isPassive.booleanValue(), setNameIdPolicy.booleanValue());
        SamlCacheHelper.updateCache(authnRequest.getId(), this.requestOptions, this.spConfiguration);
        String samlRequest = authnRequest.getEncodedAuthnRequest();
        parameters.put("SAMLRequest", samlRequest);
        String relayState = returnTo == null ? ServletUtils.getSelfRoutedURLNoQuery((HttpServletRequest)this.request) : returnTo;
        if (!relayState.isEmpty()) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getAuthnRequestsSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String ssoUrl = this.getSSOurl();
        this.lastRequestId = authnRequest.getId();
        this.lastRequest = authnRequest.getAuthnRequestXml();
        if (!stay.booleanValue()) {
            LOGGER.debug("AuthNRequest sent to " + ssoUrl + " --> " + samlRequest);
        }
        return ServletUtils.sendRedirect((HttpServletResponse)this.response, (String)ssoUrl, parameters, (Boolean)stay);
    }

    public void login(String returnTo, Boolean forceAuthn, Boolean isPassive, Boolean setNameIdPolicy) throws IOException, SettingsException {
        this.login(returnTo, forceAuthn, isPassive, setNameIdPolicy, false);
    }

    public void login() throws IOException, SettingsException {
        this.login(null, false, false, true);
    }

    public void login(String returnTo) throws IOException, SettingsException {
        this.login(returnTo, false, false, true);
    }

    public String logout(String returnTo, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) throws IOException, XMLEntityException, SettingsException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        LogoutRequest logoutRequest = new LogoutRequest(this.settings, null, nameId, sessionIndex, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier);
        String samlLogoutRequest = logoutRequest.getEncodedLogoutRequest();
        parameters.put("SAMLRequest", samlLogoutRequest);
        SamlCacheHelper.updateCache(logoutRequest.getId(), this.requestOptions, this.spConfiguration);
        String relayState = returnTo == null ? ServletUtils.getSelfRoutedURLNoQuery((HttpServletRequest)this.request) : returnTo;
        if (!relayState.isEmpty()) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getLogoutRequestSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildRequestSignature(samlLogoutRequest, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String sloUrl = this.getSLOurl();
        this.lastRequestId = logoutRequest.getId();
        this.lastRequest = logoutRequest.getLogoutRequestXml();
        if (!stay.booleanValue()) {
            LOGGER.debug("Logout request sent to " + sloUrl + " --> " + samlLogoutRequest);
        }
        return ServletUtils.sendRedirect((HttpServletResponse)this.response, (String)sloUrl, parameters, (Boolean)stay);
    }

    public String logout(String returnTo, String nameId, String sessionIndex, Boolean stay, String nameidFormat, String nameIdNameQualifier) throws IOException, XMLEntityException, SettingsException {
        return this.logout(returnTo, nameId, sessionIndex, stay, nameidFormat, nameIdNameQualifier, null);
    }

    public String logout(String returnTo, String nameId, String sessionIndex, Boolean stay, String nameidFormat) throws IOException, XMLEntityException, SettingsException {
        return this.logout(returnTo, nameId, sessionIndex, stay, nameidFormat, null);
    }

    public String logout(String returnTo, String nameId, String sessionIndex, Boolean stay) throws IOException, XMLEntityException, SettingsException {
        return this.logout(returnTo, nameId, sessionIndex, stay, null);
    }

    public void logout(String returnTo, String nameId, String sessionIndex, String nameidFormat, String nameIdNameQualifier, String nameIdSPNameQualifier) throws IOException, XMLEntityException, SettingsException {
        this.logout(returnTo, nameId, sessionIndex, false, nameidFormat, nameIdNameQualifier, nameIdSPNameQualifier);
    }

    public void logout(String returnTo, String nameId, String sessionIndex, String nameidFormat, String nameIdNameQualifier) throws IOException, XMLEntityException, SettingsException {
        this.logout(returnTo, nameId, sessionIndex, false, nameidFormat, nameIdNameQualifier);
    }

    public void logout(String returnTo, String nameId, String sessionIndex, String nameidFormat) throws IOException, XMLEntityException, SettingsException {
        this.logout(returnTo, nameId, sessionIndex, false, nameidFormat);
    }

    public void logout(String returnTo, String nameId, String sessionIndex) throws IOException, XMLEntityException, SettingsException {
        this.logout(returnTo, nameId, sessionIndex, false, null);
    }

    public void logout() throws IOException, XMLEntityException, SettingsException {
        this.logout(null, null, null, false);
    }

    public void logout(String returnTo) throws IOException, XMLEntityException, SettingsException {
        this.logout(returnTo, null, null);
    }

    public String getSSOurl() {
        return this.settings.getIdpSingleSignOnServiceUrl().toString();
    }

    public String getSLOurl() {
        return this.settings.getIdpSingleLogoutServiceUrl().toString();
    }

    public String getSLOResponseUrl() {
        return this.settings.getIdpSingleLogoutServiceResponseUrl().toString();
    }

    public void processResponse(String requestId) throws Exception {
        this.authenticated = false;
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)this.request);
        String samlResponseParameter = httpRequest.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            FormScope fs;
            String modifiedDocument;
            if (this.threatProtectionMode && Util.loadXML((String)(modifiedDocument = (String)(fs = FusionContext.getCurrent().getFormScope()).get((Object)"SAMLResponse"))) == null) {
                throw new XXEException();
            }
            SamlResponse samlResponse = new SamlResponse(this.settings, httpRequest);
            this.lastResponse = samlResponse.getSAMLResponseXml();
            if (samlResponse.isValid(requestId)) {
                this.nameid = samlResponse.getNameId();
                this.nameidFormat = samlResponse.getNameIdFormat();
                this.nameidNameQualifier = samlResponse.getNameIdNameQualifier();
                this.nameidSPNameQualifier = samlResponse.getNameIdSPNameQualifier();
                this.authenticated = true;
                this.attributes = samlResponse.getAttributes();
                this.sessionIndex = samlResponse.getSessionIndex();
                this.sessionExpiration = samlResponse.getSessionNotOnOrAfter();
                this.lastMessageId = samlResponse.getId();
                this.lastAssertionId = samlResponse.getAssertionId();
                this.lastAssertionNotOnOrAfter = samlResponse.getAssertionNotOnOrAfter();
                LOGGER.debug("processResponse success --> " + samlResponseParameter);
            } else {
                this.errors.add("invalid_response");
                LOGGER.error("processResponse error. invalid_response");
                LOGGER.debug(" --> " + samlResponseParameter);
                this.errorReason = samlResponse.getError();
            }
        } else {
            this.errors.add("invalid_binding");
            String errorMsg = "SAML Response not found, Only supported HTTP_POST Binding";
            LOGGER.error("processResponse error." + errorMsg);
            throw new Error(errorMsg, 3);
        }
    }

    public void processResponse() throws Exception {
        this.processResponse(null);
    }

    public void processSLO(String requestId) throws Exception {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)this.request);
        String samlResponseParameter = httpRequest.getParameter("SAMLResponse");
        if (samlResponseParameter != null) {
            LogoutResponse logoutResponse = new LogoutResponse(this.settings, httpRequest);
            this.lastResponse = logoutResponse.getLogoutResponseXml();
            if (!logoutResponse.isValid(requestId).booleanValue()) {
                this.errors.add("invalid_logout_response");
                LOGGER.error("processSLO error. invalid_logout_response");
                LOGGER.debug(" --> " + samlResponseParameter);
                this.errorReason = logoutResponse.getError();
            } else {
                String status = logoutResponse.getStatus();
                if (status == null || !status.equals(Constants.STATUS_SUCCESS)) {
                    this.errors.add("logout_not_success");
                    LOGGER.error("processSLO error. logout_not_success");
                    LOGGER.debug(" --> " + samlResponseParameter);
                } else {
                    this.lastMessageId = logoutResponse.getId();
                    this.logoutSuccess = true;
                    LOGGER.debug("processSLO success --> " + samlResponseParameter);
                }
            }
        } else {
            this.errors.add("invalid_binding");
            String errorMsg = "SAML LogoutRequest/LogoutResponse not found. Only supported HTTP_REDIRECT Binding";
            LOGGER.error("processSLO error." + errorMsg);
            throw new Error(errorMsg, 4);
        }
    }

    public Map processIdpInitatedSLO() throws Exception {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)this.request);
        String samlRequestParameter = httpRequest.getParameter("SAMLRequest");
        if (samlRequestParameter != null) {
            LogoutRequest logoutRequest = new LogoutRequest(this.settings, httpRequest);
            String sessionIndex = logoutRequest.id;
            this.lastRequest = logoutRequest.getLogoutRequestXml();
            if (!logoutRequest.isValid().booleanValue()) {
                this.errors.add("invalid_logout_request");
                LOGGER.error("processSLO error. invalid_logout_request");
                LOGGER.debug(" --> " + samlRequestParameter);
                this.errorReason = logoutRequest.getError();
                throw new Error(this.errorReason, 5);
            }
            this.lastMessageId = logoutRequest.getId();
            LOGGER.debug("processSLO success --> " + samlRequestParameter);
            Map nameIdData = LogoutRequest.getNameIdData((Document)Util.loadXML((String)logoutRequest.getLogoutRequestXml()), (PrivateKey)this.settings.getSPkey());
            HashMap struct = new HashMap();
            struct.put("NAMEID", nameIdData.get("Value"));
            struct.put("NAMEIDFORMAT", nameIdData.get("Format"));
            struct.put("NAMEIDQUALIFIER", nameIdData.get("NameQualifier"));
            struct.put("NAMEIDSPQUALIFIER", nameIdData.get("SPNameQualifier"));
            struct.put("SESSIONINDEX", sessionIndex);
            return struct;
        }
        this.errors.add("invalid_binding");
        String errorMsg = "SAML LogoutRequest/LogoutResponse not found. Only supported HTTP_REDIRECT Binding";
        LOGGER.error("processSLO error." + errorMsg);
        throw new Error(errorMsg, 4);
    }

    public void performLogoutRequestRedirect() throws Exception {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)this.request);
        LogoutRequest logoutRequest = new LogoutRequest(this.settings, httpRequest);
        this.lastRequest = logoutRequest.getLogoutRequestXml();
        String inResponseTo = logoutRequest.id;
        LogoutResponse logoutResponseBuilder = new LogoutResponse(this.settings, httpRequest);
        logoutResponseBuilder.build(inResponseTo);
        String samlLogoutResponse = logoutResponseBuilder.getEncodedLogoutResponse();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("SAMLResponse", samlLogoutResponse);
        String relayState = this.request.getParameter("RelayState");
        if (relayState != null) {
            parameters.put("RelayState", relayState);
        }
        if (this.settings.getLogoutResponseSigned()) {
            String sigAlg = this.settings.getSignatureAlgorithm();
            String signature = this.buildResponseSignature(samlLogoutResponse, relayState, sigAlg);
            parameters.put("SigAlg", sigAlg);
            parameters.put("Signature", signature);
        }
        String sloUrl = this.getSLOResponseUrl();
        ServletUtils.sendRedirect((HttpServletResponse)this.response, (String)sloUrl, parameters);
    }

    public void processSLO() throws Exception {
        this.processSLO(null);
    }

    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    public final List<String> getAttributesName() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public final Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public final Collection<String> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final String getNameId() {
        return this.nameid;
    }

    public final String getNameIdFormat() {
        return this.nameidFormat;
    }

    public final String getNameIdNameQualifier() {
        return this.nameidNameQualifier;
    }

    public final String getNameIdSPNameQualifier() {
        return this.nameidSPNameQualifier;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final DateTime getSessionExpiration() {
        return this.sessionExpiration;
    }

    public String getLastMessageId() {
        return this.lastMessageId;
    }

    public String getLastAssertionId() {
        return this.lastAssertionId;
    }

    public List<Instant> getLastAssertionNotOnOrAfter() {
        return this.lastAssertionNotOnOrAfter;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String getLastErrorReason() {
        return this.errorReason;
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }

    public Saml2Settings getSettings() {
        return this.settings;
    }

    public Boolean isDebugActive() {
        return this.settings.isDebugActive();
    }

    public String buildRequestSignature(String samlRequest, String relayState, String signAlgorithm) throws SettingsException {
        return this.buildSignature(samlRequest, relayState, signAlgorithm, "SAMLRequest");
    }

    public String buildResponseSignature(String samlResponse, String relayState, String signAlgorithm) throws SettingsException {
        return this.buildSignature(samlResponse, relayState, signAlgorithm, "SAMLResponse");
    }

    private String buildSignature(String samlMessage, String relayState, String signAlgorithm, String type) throws SettingsException, IllegalArgumentException {
        String signature = "";
        if (!this.settings.checkSPCerts()) {
            String errorMsg = "Trying to sign the " + type + " but can't load the SP private key";
            LOGGER.error("buildSignature error. " + errorMsg);
            throw new SettingsException(errorMsg, 4);
        }
        PrivateKey key = this.settings.getSPkey();
        String msg = type + "=" + Util.urlEncoder((String)samlMessage);
        if (StringUtils.isNotEmpty((CharSequence)relayState)) {
            msg = msg + "&RelayState=" + Util.urlEncoder((String)relayState);
        }
        if (StringUtils.isEmpty((CharSequence)signAlgorithm)) {
            signAlgorithm = Constants.RSA_SHA1;
        }
        msg = msg + "&SigAlg=" + Util.urlEncoder((String)signAlgorithm);
        try {
            signature = Util.base64encoder((byte[])Util.sign((String)msg, (PrivateKey)key, (String)signAlgorithm));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            String errorMsg = "buildSignature error." + e.getMessage();
            LOGGER.error(errorMsg);
        }
        if (signature.isEmpty()) {
            String errorMsg = "There was a problem when calculating the Signature of the " + type;
            LOGGER.error("buildSignature error. " + errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        LOGGER.debug("buildResponseSignature success. --> " + signature);
        return signature;
    }

    public String getLastRequestXML() {
        return this.lastRequest;
    }

    public String getLastResponseXML() {
        return this.lastResponse;
    }

    public boolean getLogoutSuccess() {
        return this.logoutSuccess;
    }

    public class XXEException
    extends ApplicationException {
    }
}

