/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.ConvertCMYKToRGB;
import coldfusion.image.ImageReader;
import coldfusion.image.ImageResizer;
import coldfusion.image.ImageWriter;
import coldfusion.image.core.ImageExceptions;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.Struct;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.wddx.Base64Encoder;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.GpsDirectory;
import com.twelvemonkeys.image.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.BorderExtenderCopy;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.ShearDescriptor;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.util.ImagingException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;

public class Image {
    protected static final String BMP_FORMAT = "bmp";
    protected static final String JPEG_FORMAT = "jpeg";
    protected static final String TIFF_FORMAT = "tiff";
    protected static final String TIF_FORMAT = "tif";
    protected static final String JPG_FORMAT = "jpg";
    protected static final String PNG_FORMAT = "png";
    protected static final String GIF_FORMAT = "gif";
    private String source;
    private String srcFormat;
    private BufferedImage image;
    private int width;
    private int height;
    private Graphics2D currentGraphics;
    private GraphicsAttrs grAttrs = new GraphicsAttrs();
    private Struct exifData = null;
    private Struct iptcData = null;
    private Struct imageMetadata = null;
    private Metadata metadata = null;
    private static HashMap<String, String> validFonts = null;
    private static String fontList = "";
    private static Map<String, Integer> filterTypeMap;
    private static Map<String, Integer> filterTypeMapForResampleOp;
    public static String HIGHESTQUALITY;
    private static String HIGHQUALITY;
    private static String MEDIUMQUALITY;
    private static String HIGHESTPERFORMANCE;
    private static String HIGHPERFORMANCE;
    private static String MEDIUMPERFORMANCE;
    private static String BICUBIC;
    private static String BILINEAR;
    private static String NEAREST;
    public File fullPath;
    protected Boolean isGrayScaleDone = null;
    public static final boolean isJAISupportCMYK = false;
    private boolean isSourceAnUrl = false;
    private byte[] sourceImageBytes = null;

    public Image() {
        this.source = null;
        this.srcFormat = null;
        this.image = null;
        this.width = 0;
        this.height = 0;
        this.currentGraphics = null;
    }

    public Image(byte[] data) {
        if (data == null || data.length == 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ByteArrayEmpty"));
        }
        this.image = ImageReader.readImage(data);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.source = null;
        this.srcFormat = null;
        this.currentGraphics = null;
        try {
            if ("image/png".equals(new Tika().detect(data))) {
                this.srcFormat = PNG_FORMAT;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image(BufferedImage srcImg) {
        if (srcImg == null) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceBufferedImageNull"));
        }
        this.source = null;
        this.srcFormat = null;
        this.image = srcImg;
        this.width = srcImg.getWidth();
        this.height = srcImg.getHeight();
        this.currentGraphics = null;
    }

    public Image(String source, int width, int height, String type) {
        int imageType;
        if (source.trim().length() != 0) {
            throw new IllegalArgumentException();
        }
        if (width <= 0 || height <= 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        this.source = null;
        if (type.equalsIgnoreCase("rgb")) {
            imageType = 1;
        } else if (type.equalsIgnoreCase("argb")) {
            imageType = 2;
        } else if (type.equalsIgnoreCase("GRAYSCALE")) {
            imageType = 10;
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidImageType"));
        }
        this.image = new BufferedImage(width, height, imageType);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.currentGraphics = null;
    }

    public Image(String source, int width, int height, String type, String canvasColor) {
        this(source, width, height, type);
        if (canvasColor.trim().length() != 0) {
            this.setBackground(canvasColor);
            this.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Image(String src, PageContext pageContext) {
        if (src == null) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceUndefined"));
        }
        if (src.trim().length() == 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceBlank"));
        }
        URL tempURLPath = this.getURLPath(src);
        if (tempURLPath != null) {
            this.source = tempURLPath.toString();
            this.isSourceAnUrl = true;
            this.srcFormat = this.getSrcFormatType(this.readImageAndGetURLConnection(tempURLPath));
            this.image = ImageReader.readImage(this.sourceImageBytes, this.srcFormat);
        } else {
            File tempFilePath = this.getFilePath(src, pageContext);
            if (tempFilePath != null) {
                this.source = tempFilePath.getAbsolutePath();
                this.srcFormat = this.getSrcFormatType(tempFilePath);
                this.image = ImageReader.readImage(tempFilePath, this.srcFormat);
            }
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.currentGraphics = null;
    }

    private URLConnection readImageAndGetURLConnection(URL source) {
        try {
            URLConnection uc = source.openConnection();
            uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            this.sourceImageBytes = IOUtils.toByteArray((InputStream)uc.getInputStream());
            return uc;
        }
        catch (IOException e) {
            throw new ImageExceptions.ImageReadingException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSrcFormatType(Object source) {
        String srcFormat = null;
        if (source instanceof URLConnection) {
            int y;
            block20: {
                InputStream istream = null;
                try {
                    URLConnection uc = (URLConnection)source;
                    srcFormat = uc.getContentType();
                    if (srcFormat != null && (srcFormat == null || srcFormat.length() != 0)) break block20;
                    try {
                        istream = new ByteArrayInputStream(this.sourceImageBytes);
                        ImageInputStream iis = ImageIO.createImageInputStream(istream);
                        Iterator<javax.imageio.ImageReader> imageReaders = ImageIO.getImageReaders(iis);
                        while (imageReaders.hasNext()) {
                            javax.imageio.ImageReader reader = imageReaders.next();
                            srcFormat = reader.getFormatName();
                        }
                    }
                    catch (Exception e1) {
                        CFLogs.SERVER_LOG.error((Throwable)e1);
                    }
                }
                finally {
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException uc) {}
                    }
                }
            }
            if (srcFormat != null && (y = srcFormat.lastIndexOf("/")) != -1) {
                srcFormat = srcFormat.substring(y + 1);
            }
        } else if (source instanceof File) {
            String src = ((File)source).getAbsolutePath();
            int y = src.lastIndexOf(".");
            if (y == -1) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceFileExtension"));
            }
            srcFormat = src.substring(y + 1);
        } else if (source instanceof String) {
            String src = (String)source;
            int y = src.lastIndexOf(".");
            if (y == -1) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceFileExtension"));
            }
            srcFormat = src.substring(y + 1);
        }
        if (srcFormat != null) {
            srcFormat = srcFormat.toLowerCase();
        }
        return srcFormat;
    }

    private File getFilePath(String source, PageContext pageContext) {
        File file = VFSFileFactory.getFileObject((String)Utils.getFileFullPath((String)source, (PageContext)pageContext, (boolean)true));
        if (!file.isFile()) {
            throw new ImageExceptions.ImageReadingException(new FileUtils.FileNotFoundException(file.getPath()).getMessage());
        }
        return file;
    }

    private URL getURLPath(String source) {
        URL sourceUrl = null;
        if (source.toLowerCase().startsWith("http://") || source.toLowerCase().startsWith("https://")) {
            try {
                sourceUrl = new URL(source.trim().replace(" ", "%20"));
            }
            catch (MalformedURLException e) {
                throw new ImageExceptions.ImageReadingException(e.toString());
            }
        }
        return sourceUrl;
    }

    public Image(Image srcImg) {
        if (srcImg == null) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceImageUndefined"));
        }
        this.source = srcImg.getSource();
        this.srcFormat = srcImg.getSrcFormat();
        this.isSourceAnUrl = srcImg.isSourceAnUrl;
        this.sourceImageBytes = srcImg.sourceImageBytes;
        this.width = srcImg.getWidth();
        this.height = srcImg.getHeight();
        this.grAttrs.init(srcImg.grAttrs);
        this.image = this.width == 0 && this.height == 0 ? null : srcImg.getCurrentImage();
        this.currentGraphics = null;
        this.isGrayScaleDone = srcImg.isGrayScaleDone;
        this.metadata = srcImg.metadata;
        this.exifData = srcImg.exifData;
        this.iptcData = srcImg.iptcData;
        this.imageMetadata = srcImg.imageMetadata;
    }

    public Image(Image srcImg, boolean deepCopy) {
        if (srcImg == null) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceImageUndefined"));
        }
        this.source = srcImg.getSource();
        this.srcFormat = srcImg.getSrcFormat();
        this.isSourceAnUrl = srcImg.isSourceAnUrl;
        this.sourceImageBytes = srcImg.sourceImageBytes;
        this.width = srcImg.getWidth();
        this.height = srcImg.getHeight();
        this.grAttrs.init(srcImg.grAttrs);
        this.metadata = srcImg.metadata;
        this.exifData = srcImg.exifData;
        this.iptcData = srcImg.iptcData;
        this.imageMetadata = srcImg.imageMetadata;
        this.image = this.width == 0 && this.height == 0 ? null : (deepCopy ? this.deepCopy(srcImg.getCurrentImage()) : srcImg.getCurrentImage());
        this.currentGraphics = null;
    }

    private BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public BufferedImage getCurrentImage() {
        if (this.currentGraphics != null) {
            this.currentGraphics.dispose();
            this.currentGraphics = null;
        }
        if (this.image == null) {
            return null;
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        return this.image;
    }

    public void setCurrentImage(BufferedImage img) {
        if (this.currentGraphics != null) {
            this.currentGraphics.dispose();
            this.currentGraphics = null;
        }
        if (img == null) {
            return;
        }
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.image = img;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public String getSource() {
        return this.source;
    }

    public String getSrcFormat() {
        return this.srcFormat;
    }

    public Graphics2D getCurrentGraphics() {
        Graphics2D raGr;
        if (this.currentGraphics == null) {
            if (this.image == null) {
                throw new ImageExceptions.UninitializedImageException();
            }
            this.currentGraphics = raGr = this.image.createGraphics();
            this.grAttrs.setGraphics(this.currentGraphics);
        } else {
            raGr = this.currentGraphics;
        }
        return raGr;
    }

    public void readBase64(String data) {
        if (data == null || data.trim().length() == 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidBase64Data"));
        }
        int idx = data.indexOf("base64,");
        byte[] imagedata = idx > 0 ? Base64Encoder.decode((String)data.substring(idx + 7)) : Base64Encoder.decode((String)data);
        this.image = ImageReader.readImage(imagedata);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.source = null;
        this.currentGraphics = null;
    }

    public void writeBase64(String destination, String formatName, boolean inHTMLFormat, boolean overwrite) {
        if (destination == null || destination.trim().length() == 0) {
            if (this.source != null) {
                destination = this.source;
            } else {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceBlank"));
            }
        }
        if (formatName == null || formatName.trim().length() == 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidEncodingFormat"));
        }
        try {
            String imageBase64 = this.getBase64String(formatName);
            File out = VFSFileFactory.getFileObject((String)destination);
            if (!overwrite && out.exists()) {
                throw new ImageExceptions.FileOverwriteException(destination);
            }
            PrintWriter outFile = new PrintWriter(new OutputStreamWriter(VFSFileFactory.getOutputStream((File)out)));
            if (inHTMLFormat) {
                outFile.print("data:image/" + formatName + ";base64,");
            }
            outFile.print(imageBase64);
            outFile.close();
        }
        catch (IOException e) {
            throw new ImageExceptions.ImageWritingException((Throwable)e, e.getMessage());
        }
    }

    public String getBase64String(String formatName) {
        byte[] imageBytes = this.getImageBytes(formatName);
        return Base64Encoder.encode((byte[])imageBytes);
    }

    public byte[] getImageBytes(String formatName) {
        boolean correctFormat;
        BufferedImage srcImage;
        if (formatName == null || formatName.trim().length() == 0) {
            if (this.source == null) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceFileExtension"));
            }
            formatName = this.srcFormat;
        }
        if ((srcImage = this.getCurrentImage()) == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (srcImage.getColorModel() instanceof ComponentColorModel && srcImage.getColorModel().getNumComponents() > 3 && srcImage.getColorModel().hasAlpha() && (formatName.equals(JPEG_FORMAT) || formatName.equals(JPG_FORMAT) || formatName.equals(BMP_FORMAT))) {
            srcImage = BandSelectDescriptor.create((RenderedImage)srcImage, (int[])new int[]{0, 1, 2}, null).getAsBufferedImage();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            correctFormat = ImageIO.write((RenderedImage)srcImage, formatName, out);
        }
        catch (IllegalArgumentException e) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"EncodingException"));
        }
        catch (IOException e) {
            throw new ImageExceptions.ImageEncodingException((Exception)e, formatName);
        }
        if (!correctFormat) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"EncodingException"));
        }
        return out.toByteArray();
    }

    public void write(String destination, float quality, boolean overwrite, PageContext pageContext, boolean progressive) {
        int x;
        if (destination == null || destination.trim().length() == 0) {
            if (this.source != null) {
                destination = this.source;
            } else {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceBlank"));
            }
        }
        if ((x = destination.lastIndexOf(".")) == -1) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"DestinationFileExtension"));
        }
        String formatName = destination.substring(x + 1);
        if (formatName != null) {
            formatName = formatName.toLowerCase();
        }
        if (this.srcFormat == null) {
            this.srcFormat = formatName;
        }
        if ((formatName.equals(JPEG_FORMAT) || formatName.equals(JPG_FORMAT)) && (quality < 0.0f || quality > 1.0f)) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"OutOfJPEGQualityRange"));
        }
        File blankImage = VFSFileFactory.getFileObject((String)destination);
        if (!overwrite && blankImage.exists()) {
            throw new ImageExceptions.FileOverwriteException(destination);
        }
        if (this.width == 0 && this.height == 0) {
            try {
                blankImage.createNewFile();
            }
            catch (IOException iOException) {}
        } else {
            boolean hasMetadata;
            BufferedImage srcImage = this.getCurrentImage();
            ColorModel srcCM = srcImage.getColorModel();
            if (srcCM instanceof IndexColorModel && (formatName.equals(JPEG_FORMAT) || formatName.equals(JPG_FORMAT) || formatName.equals(PNG_FORMAT) || formatName.equals(BMP_FORMAT))) {
                try {
                    BufferedImage tempSrcImage;
                    srcImage = tempSrcImage = Image.PaletteToARGB(srcImage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((formatName.equals(JPEG_FORMAT) || formatName.equals(JPG_FORMAT) || formatName.equals(BMP_FORMAT)) && srcCM.hasAlpha() && !srcCM.isAlphaPremultiplied()) {
                srcImage = this.getJPEGImage(srcImage);
            }
            if ((this.srcFormat.equals(JPEG_FORMAT) || this.srcFormat.equals(JPG_FORMAT)) && (hasMetadata = this.imageHasMetadata(pageContext))) {
                ImageWriter.writeImage(this, formatName, destination, quality, this.srcFormat, progressive);
                return;
            }
            ImageWriter.writeImage(srcImage, this, formatName, destination, quality, this.srcFormat, progressive);
        }
    }

    public boolean imageHasMetadata(PageContext pageContext) {
        Struct metadataNode;
        try {
            metadataNode = this.getExifMetadata(pageContext);
            if (!metadataNode.isEmpty()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            metadataNode = this.getIptcMetadata(pageContext);
            if (!metadataNode.isEmpty()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private BufferedImage getJPEGImage(BufferedImage src) {
        BufferedImage destImage = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        destImage.createGraphics().drawImage(src, 0, 0, Color.WHITE, null);
        return destImage;
    }

    public void shear(float shear, String direction, String interpolation) {
        BorderExtender extender;
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(shear);
        if (direction == null || direction.equalsIgnoreCase("HORIZONTAL")) {
            params.add(ShearDescriptor.SHEAR_HORIZONTAL);
        } else if (direction.equalsIgnoreCase("VERTICAL")) {
            params.add(ShearDescriptor.SHEAR_VERTICAL);
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ShearDirection"));
        }
        params.add(0.0f);
        params.add(0.0f);
        RenderingHints hints = null;
        if (interpolation == null || interpolation.equalsIgnoreCase(NEAREST)) {
            params.add(Interpolation.getInstance((int)0));
        } else if (interpolation.equalsIgnoreCase(BILINEAR)) {
            params.add(Interpolation.getInstance((int)1));
            extender = BorderExtender.createInstance((int)1);
            hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
        } else if (interpolation.equalsIgnoreCase(BICUBIC)) {
            params.add(Interpolation.getInstance((int)2));
            extender = BorderExtender.createInstance((int)1);
            hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidInterpolationRestricted"));
        }
        Color backgroundColor = this.grAttrs.getBackgroundColor();
        double[] bg = new double[]{backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()};
        params.add(bg);
        this.image = JAI.create((String)"shear", (ParameterBlock)params, (RenderingHints)hints).getAsBufferedImage();
    }

    public void grayscale() {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        this.isGrayScaleDone = Boolean.TRUE;
        BufferedImage img = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 10);
        Graphics2D g2 = img.createGraphics();
        g2.drawImage(this.image, new AffineTransformOp(AffineTransform.getTranslateInstance(0.0, 0.0), 1), 0, 0);
        g2.dispose();
        this.image = img;
    }

    public void translate(int x, int y, String interpolation) {
        BorderExtender extender;
        RenderingHints interp;
        if (interpolation == null || interpolation.equalsIgnoreCase(NEAREST)) {
            interp = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (interpolation.equalsIgnoreCase(BILINEAR)) {
            interp = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            extender = BorderExtender.createInstance((int)1);
            interp.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender));
        } else if (interpolation.equalsIgnoreCase(BICUBIC)) {
            interp = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            extender = BorderExtender.createInstance((int)1);
            interp.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender));
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidInterpolationRestricted"));
        }
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.image);
        BufferedImage img = JAI.create((String)"translate", (ParameterBlock)pb).getAsBufferedImage();
        Graphics2D g2 = img.createGraphics();
        g2.clearRect(0, 0, img.getWidth(), img.getHeight());
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        g2.drawImage(this.image, new AffineTransformOp(at, interp), x, y);
        g2.dispose();
        this.image = img;
    }

    public void flip(String transpose) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        if (transpose == null || transpose.equalsIgnoreCase("vertical")) {
            params.add(TransposeDescriptor.FLIP_VERTICAL);
        } else if (transpose.equalsIgnoreCase("horizontal")) {
            params.add(TransposeDescriptor.FLIP_HORIZONTAL);
        } else if (transpose.equalsIgnoreCase("diagonal")) {
            params.add(TransposeDescriptor.FLIP_DIAGONAL);
        } else if (transpose.equalsIgnoreCase("antidiagonal")) {
            params.add(TransposeDescriptor.FLIP_ANTIDIAGONAL);
        } else if (transpose.equalsIgnoreCase("90")) {
            params.add(TransposeDescriptor.ROTATE_90);
        } else if (transpose.equalsIgnoreCase("180")) {
            params.add(TransposeDescriptor.ROTATE_180);
        } else if (transpose.equalsIgnoreCase("270")) {
            params.add(TransposeDescriptor.ROTATE_270);
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidFlipDirection"));
        }
        this.image = JAI.create((String)"transpose", (ParameterBlock)params).getAsBufferedImage();
    }

    public void blur(int blurRadius) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (blurRadius < 3 || blurRadius > 10) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidBlurRadius"));
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(blurRadius);
        RenderingHints hint = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        this.image = JAI.create((String)"boxfilter", (ParameterBlock)params, (RenderingHints)hint).getAsBufferedImage();
    }

    public void brighten() {
    }

    public void crop(float x, float y, float width, float height) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (width < 0.0f || height < 0.0f) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(x);
        params.add(y);
        if ((float)this.width < x + width) {
            width = (float)this.width - x;
        }
        params.add(width);
        if ((float)this.height < y + height) {
            height = (float)this.height - y;
        }
        params.add(height);
        this.image = JAI.create((String)"crop", (ParameterBlock)params).getAsBufferedImage();
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public void sharpenEdge() {
    }

    public void sharpen(float gain) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (gain < -1.0f || gain > 2.0f) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"GainOutOfRange"));
        }
        RenderingHints hint = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtenderCopy.createInstance((int)1));
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(null);
        params.add(new Float(gain));
        this.image = JAI.create((String)"unsharpmask", (ParameterBlock)params, (RenderingHints)hint).getAsBufferedImage();
    }

    public void scaleToFit(int fitSize) {
        if (this.width > this.height) {
            this.resize("" + fitSize, "", "lanczos", 1.0);
        } else {
            this.resize("", "" + fitSize, "lanczos", 1.0);
        }
    }

    public void scaleToFit(String fitWidth, String fitHeight, String interpolation) {
        this.scaleToFit(fitWidth, fitHeight, interpolation, 1.0);
    }

    public void scaleToFit(String fitWidth, String fitHeight, String interpolation, double blurFactor) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (fitWidth.trim().length() == 0) {
            this.resize("", fitHeight, interpolation, blurFactor);
        } else if (fitHeight.trim().length() == 0) {
            this.resize(fitWidth, "", interpolation, blurFactor);
        } else {
            try {
                float scaleWidth = Float.parseFloat(fitWidth) / (float)this.width;
                float scaleHeight = Float.parseFloat(fitHeight) / (float)this.height;
                if (scaleWidth < scaleHeight) {
                    this.resize(fitWidth, "", interpolation, blurFactor);
                } else {
                    this.resize("", fitHeight, interpolation, blurFactor);
                }
            }
            catch (NumberFormatException e) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"DimensionError", (Object)"fitWidth and fitHeight", (Object)"scaleToFit"));
            }
        }
    }

    public void resize(String width, String height, String interpolation) {
        this.resize(width, height, interpolation, 1.0);
    }

    public void resize(String width, String height, String interpolation, double blurFactor) {
        float scaleWidth;
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        float scaleHeight = 1.0f;
        if (!(width != null && width.trim().length() != 0 || height != null && height.trim().length() != 0)) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidDimension"));
        }
        if (blurFactor == 0.0) {
            blurFactor = 1.0;
        }
        if (blurFactor < 0.0 || blurFactor > 10.0) {
            throw new ImageExceptions.InvalidBlurFactorException(blurFactor);
        }
        try {
            if (height != null && height.trim().length() != 0 && (scaleHeight = height.charAt(height.length() - 1) == '%' ? Float.parseFloat(height.substring(0, height.length() - 1)) / 100.0f : Float.parseFloat(height) / (float)this.height) <= 0.0f) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"DimensionError", (Object)"height", (Object)"resize"));
            }
        }
        catch (NumberFormatException e) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ResizeDimensionError", (Object)"height"));
        }
        if (width != null && width.trim().length() != 0) {
            try {
                scaleWidth = width.charAt(width.length() - 1) == '%' ? Float.parseFloat(width.substring(0, width.length() - 1)) / 100.0f : Float.parseFloat(width) / (float)this.width;
                if (scaleWidth <= 0.0f) {
                    throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"DimensionError", (Object)"width", (Object)"resize"));
                }
            }
            catch (NumberFormatException e) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ResizeDimensionError", (Object)"width"));
            }
            if (height == null || height.trim().length() == 0) {
                scaleHeight = scaleWidth;
            }
        } else {
            scaleWidth = scaleHeight;
        }
        if (scaleWidth * (float)this.width * scaleHeight * (float)this.height > 1.0E8f) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"UnsupportedResolution"));
        }
        if (scaleWidth == 1.0f && scaleHeight == 1.0f) {
            return;
        }
        if ((interpolation = interpolation.toLowerCase()).equals(HIGHESTPERFORMANCE)) {
            interpolation = BICUBIC;
        }
        if (this.image.getColorModel().getColorSpace().getType() == 6 && this.image.getColorModel().getComponentSize()[0] == 8) {
            if (interpolation.equals(HIGHESTQUALITY) || interpolation.equals(HIGHPERFORMANCE) || interpolation.equals(HIGHQUALITY) || interpolation.equals(MEDIUMPERFORMANCE) || interpolation.equals(MEDIUMQUALITY)) {
                interpolation = BICUBIC;
            }
            if (!(interpolation.equals(BICUBIC) || interpolation.equals(BILINEAR) || interpolation.equals(NEAREST))) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidGrayScaleInterpolation"));
            }
        }
        if (interpolation.equals(BICUBIC) || interpolation.equals(BILINEAR) || interpolation.equals(NEAREST)) {
            this.image = this.resizeImageWithJAI(scaleWidth, scaleHeight, interpolation);
        } else if (blurFactor == 1.0) {
            int rows = Math.round(scaleHeight * (float)this.height);
            int columns = Math.round(scaleWidth * (float)this.width);
            ResampleOp resampler = new ResampleOp(columns, rows, this.getFilterForResampleOp(interpolation));
            this.image = resampler.filter(this.image, null);
        } else {
            int filterType = this.getFilterType(interpolation);
            if (scaleHeight == scaleWidth) {
                this.image = ImageResizer.scale(this.image, scaleHeight, filterType, blurFactor);
            } else {
                int rows = Math.round(scaleHeight * (float)this.height);
                int columns = Math.round(scaleWidth * (float)this.width);
                this.image = ImageResizer.resize(this.image, columns, rows, filterType, blurFactor);
            }
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    private int getFilterForResampleOp(String interpolation) {
        Integer filterTypeForResampleOp = filterTypeMapForResampleOp.get(interpolation);
        if (filterTypeForResampleOp == null) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidInterpolation"));
        }
        return filterTypeForResampleOp;
    }

    private int getFilterType(String interpolation) {
        Integer filterType = filterTypeMap.get(interpolation);
        if (filterType == null) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidInterpolation"));
        }
        return filterType;
    }

    private BufferedImage resizeImageWithJAI(float scaleWidth, float scaleHeight, String interpolation) {
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(scaleWidth);
        params.add(scaleHeight);
        params.add(0.0f);
        params.add(0.0f);
        RenderingHints hints = null;
        if (interpolation != null) {
            if (interpolation.equalsIgnoreCase(NEAREST)) {
                params.add(Interpolation.getInstance((int)0));
            } else if (interpolation.equalsIgnoreCase(BILINEAR)) {
                params.add(Interpolation.getInstance((int)1));
                BorderExtender extender = BorderExtender.createInstance((int)1);
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
            } else if (interpolation.equalsIgnoreCase("bicubic")) {
                params.add(Interpolation.getInstance((int)2));
                BorderExtender extender = BorderExtender.createInstance((int)1);
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
            } else {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidInterpolation"));
            }
        }
        try {
            return JAI.create((String)"scale", (ParameterBlock)params, hints).getAsBufferedImage();
        }
        catch (ImagingException e) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidResizeInputs"));
        }
    }

    public void addBorder(int thickness, String type, String color) {
        BorderExtender borderExtender;
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (thickness < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"BorderWidthNegative"));
        }
        int borderType = 0;
        if (type.equalsIgnoreCase("zero")) {
            borderType = 0;
        } else if (type.equalsIgnoreCase("copy")) {
            borderType = 1;
        } else if (type.equalsIgnoreCase("reflect")) {
            borderType = 2;
        } else if (type.equalsIgnoreCase("wrap")) {
            borderType = 3;
        } else if (!type.equalsIgnoreCase("constant")) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"UnkownBorderType"));
        }
        if (type.equalsIgnoreCase("constant")) {
            Color imgColor = this.getColor(color);
            double[] colorArray = new double[]{imgColor.getRed(), imgColor.getGreen(), imgColor.getBlue()};
            borderExtender = new BorderExtenderConstant(colorArray);
        } else {
            borderExtender = BorderExtender.createInstance((int)borderType);
        }
        ColorModel cmSource = this.image.getColorModel();
        if (cmSource instanceof IndexColorModel && cmSource.hasAlpha() && !cmSource.isAlphaPremultiplied()) {
            this.image = Image.PaletteToARGB(this.image);
            cmSource = this.image.getColorModel();
        }
        BufferedImage alpha = null;
        if (cmSource.getNumComponents() > 3 && cmSource.hasAlpha()) {
            alpha = Image.getAlpha(this.image);
            this.image = Image.removeAlpha(this.image);
        }
        if (alpha != null) {
            ParameterBlock params1 = new ParameterBlock();
            params1.addSource(alpha);
            params1.add(thickness);
            params1.add(thickness);
            params1.add(thickness);
            params1.add(thickness);
            params1.add(new BorderExtenderConstant(new double[]{255.0}));
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE));
            alpha = JAI.create((String)"border", (ParameterBlock)params1, (RenderingHints)hints).getAsBufferedImage();
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(thickness);
        params.add(thickness);
        params.add(thickness);
        params.add(thickness);
        params.add(borderExtender);
        this.image = JAI.create((String)"border", (ParameterBlock)params).getAsBufferedImage();
        if (alpha != null) {
            this.image = Image.addAlpha(this.image, alpha, thickness, thickness);
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    static BufferedImage getAlpha(BufferedImage src) {
        return JAI.create((String)"bandselect", (RenderedImage)src, (Object)new int[]{3}).getAsBufferedImage();
    }

    static BufferedImage removeAlpha(BufferedImage src) {
        return JAI.create((String)"bandselect", (RenderedImage)src, (Object)new int[]{0, 1, 2}).getAsBufferedImage();
    }

    static BufferedImage addAlpha(BufferedImage src, BufferedImage alpha, int x, int y) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 2);
        WritableRaster wr = bi.getWritableTile(0, 0);
        WritableRaster wr3 = wr.createWritableChild(0, 0, w, h, 0, 0, new int[]{0, 1, 2});
        WritableRaster wr1 = wr.createWritableChild(0, 0, w, h, 0, 0, new int[]{3});
        wr3.setRect(src.getData());
        wr1.setRect(alpha.getData());
        bi.releaseWritableTile(0, 0);
        return bi;
    }

    static BufferedImage PaletteToARGB(BufferedImage src) {
        IndexColorModel icm = (IndexColorModel)src.getColorModel();
        int numBands = 3;
        if (icm.hasAlpha()) {
            numBands = 4;
        }
        byte[][] data = new byte[numBands][icm.getMapSize()];
        if (icm.hasAlpha()) {
            icm.getAlphas(data[3]);
        }
        icm.getReds(data[0]);
        icm.getGreens(data[1]);
        icm.getBlues(data[2]);
        LookupTableJAI lut = new LookupTableJAI(data);
        BufferedImage dst = JAI.create((String)"lookup", (RenderedImage)src, (Object)lut).getAsBufferedImage();
        return dst;
    }

    public void rotate(float x, float y, float angle, String interpolation) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        angle = (float)Math.toRadians(angle);
        ColorModel cmSource = this.image.getColorModel();
        if (cmSource instanceof IndexColorModel && cmSource.hasAlpha() && !cmSource.isAlphaPremultiplied()) {
            this.image = Image.PaletteToARGB(this.image);
            cmSource = this.image.getColorModel();
        }
        BufferedImage alpha = null;
        if (cmSource.hasAlpha() && !cmSource.isAlphaPremultiplied()) {
            alpha = Image.getAlpha(this.image);
            this.image = Image.removeAlpha(this.image);
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            BufferedImage bi = new BufferedImage(w, h, 1);
            WritableRaster wr = bi.getWritableTile(0, 0);
            WritableRaster wr3 = wr.createWritableChild(0, 0, w, h, 0, 0, new int[]{0, 1, 2});
            wr3.setRect(this.image.getData());
            bi.releaseWritableTile(0, 0);
            this.image = bi;
        }
        Interpolation interp = Interpolation.getInstance((int)0);
        if (interpolation != null && !interpolation.equalsIgnoreCase(NEAREST)) {
            if (interpolation.equalsIgnoreCase(BILINEAR)) {
                interp = Interpolation.getInstance((int)1);
            } else if (interpolation.equalsIgnoreCase("bicubic")) {
                interp = Interpolation.getInstance((int)2);
            } else {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidInterpolationRestricted"));
            }
        }
        if (alpha != null) {
            ParameterBlock params1 = new ParameterBlock();
            params1.addSource(alpha);
            params1.add(x);
            params1.add(y);
            params1.add(angle);
            params1.add(interp);
            params1.add(new double[]{0.0});
            RenderingHints hints1 = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hints1.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, new BorderExtenderConstant(new double[]{255.0})));
            hints1.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE));
            alpha = JAI.create((String)"rotate", (ParameterBlock)params1, (RenderingHints)hints1).getAsBufferedImage();
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add(x);
        params.add(y);
        params.add(angle);
        params.add(interp);
        params.add(new double[]{0.0});
        BorderExtender extender = BorderExtender.createInstance((int)1);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
        hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE));
        this.image = JAI.create((String)"rotate", (ParameterBlock)params, (RenderingHints)hints).getAsBufferedImage();
        if (alpha != null) {
            this.image = Image.addAlpha(this.image, alpha, 0, 0);
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public void invert() {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        this.image = JAI.create((String)"invert", (ParameterBlock)params).getAsBufferedImage();
    }

    public Struct info() {
        Struct hm = new Struct();
        if (this.getCurrentImage() != null) {
            String CS_Name;
            String transparency_string;
            Struct colorm = new Struct();
            ColorModel cm = this.getCurrentImage().getColorModel();
            if (cm instanceof ComponentColorModel) {
                colorm.put((Object)"colormodel_type", (Object)"ComponentColorModel");
            } else if (cm instanceof IndexColorModel) {
                colorm.put((Object)"colormodel_type", (Object)"IndexColorModel");
            } else if (cm instanceof PackedColorModel) {
                colorm.put((Object)"colormodel_type", (Object)"PackedColorModel");
            } else {
                colorm.put((Object)"colormodel_type", (Object)"");
            }
            int transparency = cm.getTransparency();
            switch (transparency) {
                case 2: {
                    transparency_string = "BITMASK";
                    break;
                }
                case 1: {
                    transparency_string = "OPAQUE";
                    break;
                }
                case 3: {
                    transparency_string = "TRANSLUCENT";
                    break;
                }
                default: {
                    transparency_string = "Unknown type of transparency";
                }
            }
            colorm.put((Object)"transparency", (Object)transparency_string);
            if (cm.hasAlpha()) {
                colorm.put((Object)"alpha_channel_support", (Object)Boolean.TRUE);
            } else {
                colorm.put((Object)"alpha_channel_support", (Object)Boolean.FALSE);
            }
            if (cm.isAlphaPremultiplied()) {
                colorm.put((Object)"alpha_premultiplied", (Object)Boolean.TRUE);
            } else {
                colorm.put((Object)"alpha_premultiplied", (Object)Boolean.FALSE);
            }
            int[] bitspercomponent = cm.getComponentSize();
            for (int i = 0; i < bitspercomponent.length; ++i) {
                colorm.put((Object)("bits_component_" + (i + 1)), (Object)new Integer(bitspercomponent[i]));
            }
            colorm.put((Object)"pixel_size", (Object)new Integer(cm.getPixelSize()));
            colorm.put((Object)"num_color_components", (Object)new Integer(cm.getNumColorComponents()));
            colorm.put((Object)"num_components", (Object)new Integer(cm.getNumComponents()));
            int cs = cm.getColorSpace().getType();
            switch (cs) {
                case 1001: {
                    CS_Name = "CIEXYZ";
                    break;
                }
                case 1003: {
                    CS_Name = "GRAY";
                    break;
                }
                case 1004: {
                    CS_Name = "LINEAR_RGB";
                    break;
                }
                case 1002: {
                    CS_Name = "PYCC";
                    break;
                }
                case 1000: {
                    CS_Name = "sRGB";
                    break;
                }
                case 12: {
                    CS_Name = "Generic 2 component color space.";
                    break;
                }
                case 13: {
                    CS_Name = "Generic 3 component color space.";
                    break;
                }
                case 14: {
                    CS_Name = "Generic 4 component color space.";
                    break;
                }
                case 15: {
                    CS_Name = "Generic 5 component color space.";
                    break;
                }
                case 16: {
                    CS_Name = "Generic 6 component color space.";
                    break;
                }
                case 17: {
                    CS_Name = "Generic 7 component color space.";
                    break;
                }
                case 18: {
                    CS_Name = "Generic 8 component color space.";
                    break;
                }
                case 19: {
                    CS_Name = "Generic 9 component color space.";
                    break;
                }
                case 20: {
                    CS_Name = "Generic 10 component color space.";
                    break;
                }
                case 21: {
                    CS_Name = "Generic 11 component color space.";
                    break;
                }
                case 22: {
                    CS_Name = "Generic 12 component color space.";
                    break;
                }
                case 11: {
                    CS_Name = "Any of the family of CMY color spaces";
                    break;
                }
                case 9: {
                    CS_Name = "Any of the family of CMYK color spaces";
                    break;
                }
                case 23: {
                    CS_Name = "Generic 13 component color space.";
                    break;
                }
                case 24: {
                    CS_Name = "Generic 14 component color space.";
                    break;
                }
                case 25: {
                    CS_Name = "Generic 15 component color space.";
                    break;
                }
                case 6: {
                    CS_Name = "Any of the family of GRAY color spaces";
                    break;
                }
                case 8: {
                    CS_Name = "Any of the family of HLS color spaces";
                    break;
                }
                case 7: {
                    CS_Name = "Any of the family of HSV color spaces";
                    break;
                }
                case 1: {
                    CS_Name = "Any of the family of Lab color spaces";
                    break;
                }
                case 2: {
                    CS_Name = "Any of the family of Luv color spaces";
                    break;
                }
                case 5: {
                    CS_Name = "Any of the family of RGB color spaces";
                    break;
                }
                case 0: {
                    CS_Name = "Any of the family of XYZ color spaces";
                    break;
                }
                case 3: {
                    CS_Name = "Any of the family of YCbCr color spaces";
                    break;
                }
                case 4: {
                    CS_Name = "Any of the family of Yxy color spaces";
                    break;
                }
                default: {
                    CS_Name = "Unknown ColorSpace" + cs;
                }
            }
            colorm.put((Object)"colorspace", (Object)CS_Name);
            hm.put((Object)"source", (Object)(this.source != null ? this.source : ""));
            hm.put((Object)"width", (Object)new Integer(this.width));
            hm.put((Object)"height", (Object)new Integer(this.height));
            hm.put((Object)"colormodel", (Object)colorm);
        }
        return hm;
    }

    public void setColor(String color) {
        Graphics2D raGr = this.getCurrentGraphics();
        Color c = this.getColor(color);
        raGr.setColor(c);
        this.grAttrs.setColor(c);
    }

    public void setAntiAliasing(String value) {
        Graphics2D raGr = this.getCurrentGraphics();
        if (value.equalsIgnoreCase("off") || value.equalsIgnoreCase("false")) {
            raGr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            raGr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else if (value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true")) {
            raGr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            raGr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidAliasingValue"));
        }
        this.grAttrs.setRenderingHints(raGr.getRenderingHints());
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.setRenderingHint(hintKey, hintValue);
    }

    public void setDrawingTranparency(double percent) {
        if (percent < 0.0 || percent > 100.0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"TransparencyOutOfRange"));
        }
        float alpha = (float)percent / 100.0f;
        alpha = 1.0f - alpha;
        int type = 3;
        AlphaComposite rule = AlphaComposite.getInstance(type, alpha);
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.setComposite(rule);
        this.grAttrs.setComposite(rule);
    }

    public Color getColor(String color) {
        int b;
        int g;
        int r;
        if (color.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (color.equalsIgnoreCase("green")) {
            return Color.GREEN;
        }
        if (color.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (color.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (color.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (color.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        if (color.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (color.equalsIgnoreCase("darkgray")) {
            return Color.DARK_GRAY;
        }
        if (color.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (color.equalsIgnoreCase("lightgray")) {
            return Color.LIGHT_GRAY;
        }
        if (color.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (color.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (color.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (color.charAt(0) == '#') {
            if (color.length() != 7) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperHexFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
            }
            try {
                r = Integer.parseInt(color.substring(1, 3), 16);
                g = Integer.parseInt(color.substring(3, 5), 16);
                b = Integer.parseInt(color.substring(5, 7), 16);
            }
            catch (NumberFormatException e) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperHexFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
            }
        } else if (color.indexOf(",") != -1) {
            try {
                int idx = color.indexOf(",");
                r = Integer.parseInt(color.substring(0, idx));
                color = color.substring(idx + 1);
                idx = color.indexOf(",");
                g = Integer.parseInt(color.substring(0, idx));
                color = color.substring(idx + 1);
                b = Integer.parseInt(color);
            }
            catch (NumberFormatException e) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperRGBFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
            }
        } else if (color.length() == 6) {
            try {
                r = Integer.parseInt(color.substring(0, 2), 16);
                g = Integer.parseInt(color.substring(2, 4), 16);
                b = Integer.parseInt(color.substring(4, 6), 16);
            }
            catch (NumberFormatException e) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperHexFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
            }
        } else {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperColorFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
        }
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperRGBFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
        }
        return new Color(r, g, b);
    }

    protected List<Integer> getRGBColors(List<String> inputColors) {
        if (inputColors != null && inputColors.size() > 0) {
            ArrayList<Integer> colors = new ArrayList<Integer>();
            for (String inputColor : inputColors) {
                if (inputColor == null) continue;
                Array colorArray = ListFunc.ListToArray((String)inputColor, (String)",");
                Color currentColor = this.getRGBColor((List)colorArray);
                if (currentColor != null) {
                    colors.add(currentColor.getRGB() | 0xFF000000);
                    continue;
                }
                for (int i = 0; i < colorArray.size(); ++i) {
                    colors.add(this.getColor((String)colorArray.get(i)).getRGB() | 0xFF000000);
                }
            }
            return colors;
        }
        return null;
    }

    protected Color getRGBColor(List colors) {
        if (colors != null && colors.size() == 3) {
            int[] rgb = new int[3];
            for (int i = 0; i < 3; ++i) {
                try {
                    rgb[i] = Integer.parseInt(((String)colors.get(i)).trim());
                    if (rgb[i] >= 0 && rgb[i] <= 255) continue;
                    throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"ImproperRGBFormat") + "\n" + RB.getString((Object)this, (String)"ValidDirectColorStrings"));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        return null;
    }

    public void setXorMode(String color) {
        Color imagecolor = this.getColor(color);
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.setXORMode(imagecolor);
        this.grAttrs.setXORMode(imagecolor);
    }

    public void drawPoint(int x, int y) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.drawLine(x, y, x + 1, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height, boolean filled) {
        Graphics2D raGr = this.getCurrentGraphics();
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        if (filled) {
            raGr.fillRect(x, y, width, height);
        } else {
            raGr.drawRect(x, y, width, height);
        }
    }

    public void clearRect(int x, int y, int width, int height) {
        Graphics2D raGr = this.getCurrentGraphics();
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        raGr.clearRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean filled) {
        if (width < 0 || height < 0 || arcWidth < 0 || arcHeight < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        Graphics2D raGr = this.getCurrentGraphics();
        if (filled) {
            raGr.fillRoundRect(x, y, width + 1, height + 1, arcWidth, arcHeight);
        } else {
            raGr.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised, boolean filled) {
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        Graphics2D raGr = this.getCurrentGraphics();
        if (filled) {
            raGr.fill3DRect(x, y, width + 1, height + 1, raised);
        } else {
            Color c = raGr.getColor();
            Color brighter = c.brighter();
            Color darker = c.darker();
            raGr.setColor(raised ? brighter : darker);
            this.drawLine(x, y, x, y + height);
            this.drawLine(x + 1, y, x + width - 1, y);
            raGr.setColor(raised ? darker : brighter);
            this.drawLine(x + 1, y + height, x + width, y + height);
            this.drawLine(x + width, y, x + width, y + height - 1);
            raGr.setColor(c);
        }
    }

    public void drawOval(int x, int y, int width, int height, boolean filled) {
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        Graphics2D raGr = this.getCurrentGraphics();
        if (filled) {
            raGr.fillOval(x, y, width, height);
        } else {
            raGr.drawOval(x, y, width, height);
        }
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean filled) {
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        Graphics2D raGr = this.getCurrentGraphics();
        if (filled) {
            raGr.fillArc(x, y, width, height, startAngle, arcAngle);
        } else {
            raGr.drawArc(x, y, width, height, startAngle, arcAngle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Struct drawString(String string, int x, int y, Struct attr) {
        Struct result = new Struct();
        FontMetrics fontMetrics = null;
        if (validFonts == null) {
            Class<Image> clazz = Image.class;
            // MONITORENTER : coldfusion.image.Image.class
            validFonts = new HashMap();
            GraphicsEnvironment graphicsEvn = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] availableFonts = graphicsEvn.getAllFonts();
            for (int i = 0; i < availableFonts.length; ++i) {
                validFonts.put(availableFonts[i].getFontName().toLowerCase(), availableFonts[i].getFontName());
                fontList = fontList + "<br>" + availableFonts[i].getFontName();
                if (System.getProperty("fonts.debug") == null || !System.getProperty("fonts.debug").equals("verbose")) continue;
                System.out.println(availableFonts[i].getFontName().toLowerCase());
            }
            // MONITOREXIT : clazz
        }
        Graphics2D raGr = this.getCurrentGraphics();
        if (attr != null && !attr.isEmpty()) {
            Object value1;
            String fontName = "Serif";
            int size = 10;
            int style = 0;
            AttributedString as = new AttributedString(string);
            String value = (String)attr.get((Object)"font");
            if (value != null && value.trim().length() > 0) {
                if (!validFonts.containsKey(value.toLowerCase())) {
                    throw new ImageExceptions.UnknownFontException(fontName, fontList);
                }
                fontName = validFonts.get(value.toLowerCase());
            }
            if ((value1 = attr.get((Object)"size")) != null) {
                size = Cast._int((Object)value1, (boolean)false);
            }
            if ((value = (String)attr.get((Object)"style")) != null) {
                if (value.equalsIgnoreCase("plain")) {
                    style = 0;
                } else if (value.equalsIgnoreCase("bold")) {
                    style = 1;
                } else if (value.equalsIgnoreCase("italic")) {
                    style = 2;
                } else if (value.equalsIgnoreCase("bolditalic")) {
                    style = 3;
                }
            }
            Font font = new Font(fontName, style, size);
            as.addAttribute(TextAttribute.FONT, font);
            value1 = attr.get((Object)"strikethrough");
            if (value1 != null && Cast._boolean((Object)value1, (boolean)false)) {
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if ((value1 = attr.get((Object)"underline")) != null && Cast._boolean((Object)value1, (boolean)false)) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            raGr.drawString(as.getIterator(), x, y);
            fontMetrics = raGr.getFontMetrics(font);
        } else {
            raGr.drawString(string, x, y);
            fontMetrics = raGr.getFontMetrics();
        }
        if (fontMetrics == null) return result;
        result.put((Object)"TextWidth", (Object)fontMetrics.stringWidth(string));
        result.put((Object)"TextHeight", (Object)fontMetrics.getHeight());
        return result;
    }

    public void setBackground(String color) {
        Graphics2D raGr = this.getCurrentGraphics();
        Color backgroundColor = this.getColor(color);
        raGr.setBackground(backgroundColor);
        this.grAttrs.setBackgroundColor(backgroundColor);
    }

    public void drawLines(int[] xcoords, int[] ycoords, boolean isPolygon, boolean filled) {
        Graphics2D raGr = this.getCurrentGraphics();
        if (isPolygon) {
            if (filled) {
                raGr.fillPolygon(xcoords, ycoords, xcoords.length);
            } else {
                raGr.drawPolygon(xcoords, ycoords, xcoords.length);
            }
        } else {
            raGr.drawPolyline(xcoords, ycoords, xcoords.length);
        }
    }

    public void rotateAxis(double theta) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.rotate(Math.toRadians(theta));
    }

    public void rotateAxis(double theta, double x, double y) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.rotate(Math.toRadians(theta), x, y);
    }

    public void shearAxis(double shx, double shy) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.shear(shx, shy);
    }

    public Image copyArea(int srcX, int srcY, int width, int height) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add((float)srcX);
        params.add((float)srcY);
        params.add((float)width);
        params.add((float)height);
        BufferedImage tImage = JAI.create((String)"crop", (ParameterBlock)params).getAsBufferedImage();
        return new Image(tImage);
    }

    public Image copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        if (width < 0 || height < 0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"NegativeDimensions"));
        }
        int dx = destX - srcX;
        int dy = destY - srcY;
        ParameterBlock params = new ParameterBlock();
        params.addSource(this.image);
        params.add((float)srcX);
        params.add((float)srcY);
        params.add((float)width);
        params.add((float)height);
        BufferedImage tImage = JAI.create((String)"crop", (ParameterBlock)params).getAsBufferedImage();
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.copyArea(srcX, srcY, width, height, dx, dy);
        return new Image(tImage);
    }

    public void paste(Image img2, int x, int y) {
        Graphics2D raGr = this.getCurrentGraphics();
        RenderingHints interp = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        BorderExtender extender = BorderExtender.createInstance((int)1);
        raGr.addRenderingHints(new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender));
        BufferedImage src = img2.getCurrentImage();
        if (src == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        raGr.drawImage(src, new AffineTransformOp(AffineTransform.getTranslateInstance(x, y), interp), 0, 0);
    }

    public void setDrawingStroke(Struct attr) {
        float width = 1.0f;
        int cap = 2;
        int joins = 0;
        float miterlimit = 10.0f;
        float[] dash = null;
        float dash_phase = 0.0f;
        if (attr == null || attr.isEmpty()) {
            Graphics2D raGr = this.getCurrentGraphics();
            raGr.setStroke(new BasicStroke());
        }
        if (attr != null && !attr.isEmpty()) {
            Object w = attr.get((Object)"width");
            width = (float)Cast._double((Object)w);
            if (width < 0.0f) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"FontWidthNegative"));
            }
            String value = (String)attr.get((Object)"endcaps");
            if (value != null) {
                if (value.equalsIgnoreCase("SQUARE")) {
                    cap = 2;
                } else if (value.equalsIgnoreCase("BUTT")) {
                    cap = 0;
                } else if (value.equalsIgnoreCase("ROUND")) {
                    cap = 1;
                } else {
                    throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidEndcaps"));
                }
            }
            if ((value = (String)attr.get((Object)"linejoins")) != null) {
                if (value.equalsIgnoreCase("BEVEL")) {
                    joins = 2;
                } else if (value.equalsIgnoreCase("MITER")) {
                    joins = 0;
                    value = (String)attr.get((Object)"miterlimit");
                    if (value != null && (miterlimit = Float.parseFloat(value)) < 1.0f) {
                        throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidMiterLimit"));
                    }
                } else if (value.equalsIgnoreCase("ROUND")) {
                    joins = 1;
                } else {
                    throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"InvalidLineJoins"));
                }
            }
            if (attr.get((Object)"dashArray") != null) {
                Object[] arr = ((Array)attr.get((Object)"dashArray")).toArray();
                dash = new float[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    dash[i] = Float.parseFloat((String)arr[i]);
                }
                value = (String)attr.get((Object)"dash_phase");
                if (value != null) {
                    dash_phase = Float.parseFloat(value);
                }
            }
        }
        this.setDrawingStroke(width, cap, joins, miterlimit, dash, dash_phase);
    }

    public void setDrawingStroke(float width, int cap, int joins, float miterlimit, float[] dash, float dash_phase) {
        BasicStroke st = new BasicStroke(width, cap, joins, miterlimit, dash, dash_phase);
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.setStroke(st);
        this.grAttrs.setStroke(st);
    }

    public void drawQuadraticCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        QuadCurve2D.Double qCurve = new QuadCurve2D.Double(x1, y1, ctrlx, ctrly, x2, y2);
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.draw(qCurve);
    }

    public void drawCubicCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        CubicCurve2D.Double cCurve = new CubicCurve2D.Double(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.draw(cCurve);
    }

    public void translateAxis(int x, int y) {
        Graphics2D raGr = this.getCurrentGraphics();
        raGr.translate(x, y);
    }

    public void initializeMetadata(PageContext pageContext) {
        block22: {
            if (this.metadata == null) {
                InputStream is = null;
                try {
                    if (this.source == null) {
                        throw new ImageExceptions.ReadImageMetadataException(RB.getString((Object)this, (String)"NoMetadataForBase64AndBLOBS"));
                    }
                    is = this.getInputStreamFromSource(pageContext);
                    if (is != null) {
                        if (this.srcFormat.equals(TIFF_FORMAT) || this.srcFormat.equals(TIF_FORMAT)) {
                            this.metadata = TiffMetadataReader.readMetadata((InputStream)is);
                        } else if (this.srcFormat.equals(JPG_FORMAT) || this.srcFormat.equals(JPEG_FORMAT)) {
                            try {
                                this.metadata = JpegMetadataReader.readMetadata((InputStream)is);
                            }
                            catch (Exception e) {
                                if (is != null) {
                                    is.close();
                                }
                                is = this.getInputStreamFromSource(pageContext);
                                this.getGenericMetadata(is);
                            }
                        } else {
                            this.getGenericMetadata(is);
                        }
                        break block22;
                    }
                    throw new ImageExceptions.ReadImageMetadataException(RB.getString((Object)this, (String)"Metadata.1"));
                }
                catch (IOException e) {
                    throw new ImageExceptions.ReadImageMetadataException(RB.getString((Object)this, (String)"Metadata.2") + " \n" + e.getMessage());
                }
                catch (JpegProcessingException e) {
                    throw new ImageExceptions.ReadImageMetadataException(RB.getString((Object)this, (String)"JpegProcessingException") + "\n" + e.getMessage());
                }
                catch (ImageProcessingException e) {
                    throw new ImageExceptions.ReadImageMetadataException(RB.getString((Object)this, (String)"JpegProcessingException") + "\n" + e.getMessage());
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    InputStream getInputStreamFromSource(PageContext pageContext) throws IOException, MalformedURLException, FileNotFoundException {
        InputStream is = null;
        if (this.isSourceAnUrl) {
            if (this.sourceImageBytes != null) {
                return new ByteArrayInputStream(this.sourceImageBytes);
            }
            if (this.source != null) {
                is = new URL(this.source).openStream();
            }
        } else if (this.source != null) {
            is = VFSFileFactory.getInputStream((String)Utils.getFileFullPath((String)this.source, (PageContext)pageContext, (boolean)true));
        }
        return is;
    }

    private void getGenericMetadata(InputStream is) throws IOException, ImageProcessingException {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            this.metadata = ImageMetadataReader.readMetadata((InputStream)new BufferedInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (Exception e) {
            throw new ImageExceptions.ReadImageMetadataException(e.getMessage());
        }
    }

    public Struct getExifMetadata(PageContext pageContext) {
        if (this.metadata == null) {
            this.initializeMetadata(pageContext);
        }
        if (this.exifData == null) {
            this.exifData = this.getMetadata("exif");
            Collection gpsDirs = this.metadata.getDirectoriesOfType(GpsDirectory.class);
            if (gpsDirs == null) {
                return this.exifData;
            }
            for (GpsDirectory gpsDir : gpsDirs) {
                Collection tags = gpsDir.getTags();
                for (Tag tag : tags) {
                    String tagDesc = tag.getDescription() != null ? tag.getDescription() : "";
                    this.exifData.put((Object)tag.getTagName(), (Object)tagDesc);
                }
            }
        }
        return this.exifData;
    }

    private Struct getMetadata(String type) {
        if (type == null) {
            type = "";
        }
        Struct data = null;
        Iterable directories = this.metadata.getDirectories();
        Iterator dirIter = directories.iterator();
        if (directories != null) {
            data = new Struct();
            while (dirIter.hasNext()) {
                Directory directory = (Directory)dirIter.next();
                if (directory == null || type.length() != 0 && !directory.getClass().getName().contains(type + ".")) continue;
                Collection tags = directory.getTags();
                for (Tag tag : tags) {
                    String tagDesc = tag.getDescription() != null ? tag.getDescription() : "";
                    data.put((Object)tag.getTagName(), (Object)tagDesc);
                }
            }
        }
        return data;
    }

    public Struct getIptcMetadata(PageContext pageContext) {
        if (this.metadata == null) {
            this.initializeMetadata(pageContext);
        }
        if (this.iptcData == null) {
            this.iptcData = this.getMetadata("iptc");
        }
        return this.iptcData;
    }

    public Struct getImageMetadata(PageContext pageContext) {
        if (this.metadata == null) {
            this.initializeMetadata(pageContext);
        }
        if (this.imageMetadata == null) {
            this.imageMetadata = this.getMetadata("");
        }
        return this.imageMetadata;
    }

    public String getExifTag(String tagname, PageContext pageContext) {
        if (this.exifData == null) {
            this.exifData = this.getExifMetadata(pageContext);
        }
        if (this.exifData == null) {
            return "";
        }
        return (String)this.exifData.get((Object)tagname);
    }

    public String getIptcTag(String tagname, PageContext pageContext) {
        if (this.iptcData == null) {
            this.iptcData = this.getIptcMetadata(pageContext);
        }
        if (this.iptcData == null) {
            return "";
        }
        return (String)this.iptcData.get((Object)tagname);
    }

    public BufferedImage convertCMYKToRGB() {
        ColorModel cm = this.image.getColorModel();
        if (this.source != null && !this.source.toLowerCase().startsWith("http://") && !this.source.toLowerCase().startsWith("https://")) {
            int x = this.source.lastIndexOf(".");
            if (x == -1) {
                throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"SourceFileExtension"));
            }
            String formatName = this.source.substring(x + 1);
            if ((formatName.equalsIgnoreCase(JPEG_FORMAT) || formatName.equalsIgnoreCase(JPG_FORMAT)) && 9 == this.image.getColorModel().getColorSpace().getType()) {
                try {
                    return ConvertCMYKToRGB.returnRGBImage(VFSFileFactory.getFileObject((String)this.source));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public Image makeColorTransparent(List list) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        int vsize = list.size();
        if (vsize == 0) {
            return this;
        }
        final List<Integer> colors = this.getRGBColors(list);
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if (colors != null) {
                    for (Integer color : colors) {
                        if ((rgb | 0xFF000000) != color) continue;
                        return 0xFFFFFF & rgb;
                    }
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(this.image.getSource(), filter);
        java.awt.Image transImg = Toolkit.getDefaultToolkit().createImage(ip);
        BufferedImage bufferedImage = new BufferedImage(transImg.getWidth(null), transImg.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(transImg, 0, 0, null);
        g2.dispose();
        return new Image(bufferedImage);
    }

    public Image makeTranslucent(double percent) {
        if (percent < 0.0 || percent > 100.0) {
            throw new ImageExceptions.InvalidImageArgumentException(RB.getString((Object)this, (String)"TransparencyOutOfRange"));
        }
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        float alpha = (float)percent / 100.0f;
        alpha = 1.0f - alpha;
        BufferedImage aimg = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 3);
        Graphics2D g = aimg.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.drawImage(this.image, null, 0, 0);
        g.dispose();
        return new Image(aimg);
    }

    public void overlay(Image img2, String rule, String f) {
        this.getCurrentImage();
        if (this.image == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        BufferedImage src2 = img2.getCurrentImage();
        if (src2 == null) {
            throw new ImageExceptions.UninitializedImageException();
        }
        Graphics2D raGr = this.getCurrentGraphics();
        float alpha = Float.valueOf(f).floatValue();
        AlphaComposite ac = AlphaComposite.getInstance(this.getRule(rule.toUpperCase()), alpha);
        raGr.setComposite(ac);
        RenderingHints interp = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        BorderExtender extender = BorderExtender.createInstance((int)1);
        raGr.addRenderingHints(new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender));
        raGr.drawImage(src2, new AffineTransformOp(AffineTransform.getTranslateInstance(0.0, 0.0), interp), 0, 0);
    }

    private int getRule(String rule) {
        int alphaComp = 0;
        if ("SRC".equalsIgnoreCase(rule)) {
            alphaComp = 2;
        } else if ("DST_IN".equalsIgnoreCase(rule)) {
            alphaComp = 6;
        } else if ("DST_OUT".equalsIgnoreCase(rule)) {
            alphaComp = 8;
        } else if ("DST_OVER".equalsIgnoreCase(rule)) {
            alphaComp = 4;
        } else if ("SRC_IN".equalsIgnoreCase(rule)) {
            alphaComp = 5;
        } else if ("SRC_OVER".equalsIgnoreCase(rule)) {
            alphaComp = 3;
        } else if ("SRC_OUT".equalsIgnoreCase(rule)) {
            alphaComp = 7;
        } else {
            throw new ImageExceptions.InvalidRuleImageException(rule);
        }
        return alphaComp;
    }

    static {
        HIGHESTQUALITY = "highestquality";
        HIGHQUALITY = "highquality";
        MEDIUMQUALITY = "mediumquality";
        HIGHESTPERFORMANCE = "highestperformance";
        HIGHPERFORMANCE = "highperformance";
        MEDIUMPERFORMANCE = "mediumperformance";
        BICUBIC = "bicubic";
        BILINEAR = "bilinear";
        NEAREST = "nearest";
        filterTypeMap = new CaseInsensitiveMap();
        filterTypeMap.put("lanczos", new Integer(7));
        filterTypeMap.put("bessel", new Integer(8));
        filterTypeMap.put("blackman", new Integer(4));
        filterTypeMap.put("hamming", new Integer(3));
        filterTypeMap.put("hanning", new Integer(2));
        filterTypeMap.put("hermite", new Integer(1));
        filterTypeMap.put("mitchell", new Integer(6));
        filterTypeMap.put("quadratic", new Integer(5));
        filterTypeMap.put(HIGHESTQUALITY, new Integer(7));
        filterTypeMap.put(HIGHQUALITY, new Integer(6));
        filterTypeMap.put(MEDIUMQUALITY, new Integer(3));
        filterTypeMap.put(HIGHPERFORMANCE, new Integer(3));
        filterTypeMap.put(MEDIUMPERFORMANCE, new Integer(6));
        filterTypeMapForResampleOp = new CaseInsensitiveMap();
        filterTypeMapForResampleOp.put("lanczos", new Integer(13));
        filterTypeMapForResampleOp.put("bessel", new Integer(14));
        filterTypeMapForResampleOp.put("blackman", new Integer(7));
        filterTypeMapForResampleOp.put("hamming", new Integer(6));
        filterTypeMapForResampleOp.put("hanning", new Integer(5));
        filterTypeMapForResampleOp.put("hermite", new Integer(4));
        filterTypeMapForResampleOp.put("mitchell", new Integer(12));
        filterTypeMapForResampleOp.put("quadratic", new Integer(9));
        filterTypeMapForResampleOp.put(HIGHESTQUALITY, new Integer(13));
        filterTypeMapForResampleOp.put(HIGHQUALITY, new Integer(12));
        filterTypeMapForResampleOp.put(MEDIUMQUALITY, new Integer(6));
        filterTypeMapForResampleOp.put(HIGHPERFORMANCE, new Integer(6));
        filterTypeMapForResampleOp.put(MEDIUMPERFORMANCE, new Integer(12));
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        JAI.getDefaultInstance();
                        return null;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class GraphicsAttrs {
        Color backgroundColor = Color.BLACK;
        Color color = Color.WHITE;
        Composite composite = null;
        RenderingHints renderingHints = null;
        Stroke stroke = null;
        Color XORMode = null;

        GraphicsAttrs() {
        }

        void init(GraphicsAttrs src) {
            this.backgroundColor = src.backgroundColor;
            this.color = src.color;
            this.composite = src.composite;
            this.renderingHints = src.renderingHints;
            this.stroke = src.stroke;
            this.XORMode = src.XORMode;
        }

        void setGraphics(Graphics2D gr) {
            if (this.backgroundColor != null) {
                gr.setBackground(this.backgroundColor);
            }
            if (this.color != null) {
                gr.setColor(this.color);
            }
            if (this.composite != null) {
                gr.setComposite(this.composite);
            }
            if (this.renderingHints != null) {
                gr.setRenderingHints(this.renderingHints);
            }
            if (this.stroke != null) {
                gr.setStroke(this.stroke);
            }
            if (this.XORMode != null) {
                gr.setXORMode(this.XORMode);
            }
        }

        Color getBackgroundColor() {
            return this.backgroundColor;
        }

        void setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        void setColor(Color color) {
            this.color = color;
        }

        void setComposite(Composite composite) {
            this.composite = composite;
        }

        void setRenderingHints(RenderingHints renderingHints) {
            this.renderingHints = renderingHints;
        }

        void setStroke(Stroke stroke) {
            this.stroke = stroke;
        }

        void setXORMode(Color XORMode) {
            this.XORMode = XORMode;
        }
    }
}

