/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import macromedia.db2util.externals.org.bouncycastle.crypto.CryptoException;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithID;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.signers.SM2Signer;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.db2util.externals.org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import macromedia.db2util.externals.org.bouncycastle.jcajce.util.BCJcaJceHelper;
import macromedia.db2util.externals.org.bouncycastle.jcajce.util.JcaJceHelper;

public class GMSignatureSpi
extends SignatureSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private AlgorithmParameters engineParams;
    private SM2ParameterSpec paramSpec;
    private final SM2Signer signer;

    GMSignatureSpi(SM2Signer sM2Signer) {
        this.signer = sM2Signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        dda dda10 = ECUtils.generatePublicKeyParameter(publicKey);
        if (this.paramSpec != null) {
            dda10 = new ParametersWithID(dda10, this.paramSpec.getID());
        }
        this.signer.init(false, dda10);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        dda dda10 = ECUtil.generatePrivateKeyParameter(privateKey);
        if (this.appRandom != null) {
            dda10 = new ParametersWithRandom(dda10, this.appRandom);
        }
        if (this.paramSpec != null) {
            this.signer.init(true, new ParametersWithID(dda10, this.paramSpec.getID()));
        } else {
            this.signer.init(true, dda10);
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.signer.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.signer.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException("unable to create signature: " + cryptoException.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.signer.verifySignature(byArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof SM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
        }
        this.paramSpec = (SM2ParameterSpec)algorithmParameterSpec;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("PSS");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class sm3WithSM2
    extends GMSignatureSpi {
        public sm3WithSM2() {
            super(new SM2Signer());
        }
    }
}

