/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.generators;

import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.DerivationFunction;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.ddb;
import macromedia.db2util.externals.org.bouncycastle.crypto.macs.HMac;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.HKDFParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;

public class HKDFBytesGenerator
implements DerivationFunction {
    private HMac hMacHash;
    private int hashLen;
    private byte[] info;
    private byte[] currentT;
    private int generatedBytes;

    public HKDFBytesGenerator(Digest digest) {
        this.hMacHash = new HMac(digest);
        this.hashLen = digest.getDigestSize();
    }

    public void init(ddb ddb10) {
        if (!(ddb10 instanceof HKDFParameters)) {
            throw new IllegalArgumentException("HKDF parameters required for HKDFBytesGenerator");
        }
        HKDFParameters hKDFParameters = (HKDFParameters)ddb10;
        if (hKDFParameters.skipExtract()) {
            this.hMacHash.init(new KeyParameter(hKDFParameters.getIKM()));
        } else {
            this.hMacHash.init(this.extract(hKDFParameters.getSalt(), hKDFParameters.getIKM()));
        }
        this.info = hKDFParameters.getInfo();
        this.generatedBytes = 0;
        this.currentT = new byte[this.hashLen];
    }

    private final KeyParameter extract(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            this.hMacHash.init(new KeyParameter(new byte[this.hashLen]));
        } else {
            this.hMacHash.init(new KeyParameter(byArray));
        }
        this.hMacHash.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[this.hashLen];
        this.hMacHash.doFinal(byArray3, 0);
        return new KeyParameter(byArray3);
    }

    private final void expandNext() throws DataLengthException {
        int n2 = this.generatedBytes / this.hashLen + 1;
        if (n2 >= 256) {
            throw new DataLengthException("HKDF cannot generate more than 255 blocks of HashLen size");
        }
        if (this.generatedBytes != 0) {
            this.hMacHash.update(this.currentT, 0, this.hashLen);
        }
        this.hMacHash.update(this.info, 0, this.info.length);
        this.hMacHash.update((byte)n2);
        this.hMacHash.doFinal(this.currentT, 0);
    }

    public Digest getDigest() {
        return this.hMacHash.getUnderlyingDigest();
    }

    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (this.generatedBytes + n3 > 255 * this.hashLen) {
            throw new DataLengthException("HKDF may only be used for 255 * HashLen bytes of output");
        }
        if (this.generatedBytes % this.hashLen == 0) {
            this.expandNext();
        }
        int n4 = n3;
        int n5 = this.generatedBytes % this.hashLen;
        int n6 = this.hashLen - this.generatedBytes % this.hashLen;
        int n7 = Math.min(n6, n4);
        System.arraycopy(this.currentT, n5, byArray, n2, n7);
        this.generatedBytes += n7;
        n4 -= n7;
        n2 += n7;
        while (n4 > 0) {
            this.expandNext();
            n7 = Math.min(this.hashLen, n4);
            System.arraycopy(this.currentT, 0, byArray, n2, n7);
            this.generatedBytes += n7;
            n4 -= n7;
            n2 += n7;
        }
        return n3;
    }
}

