/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.db2util.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.db2util.externals.org.bouncycastle.crypto.Wrapper;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.CBCBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher blockCipher) {
        this.engine = new CBCBlockCipher(blockCipher);
    }

    public void init(boolean bl, dda dda10) {
        this.forWrapping = bl;
        if (dda10 instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda10;
            this.rand = parametersWithRandom.getRandom();
            this.param = (ParametersWithIV)parametersWithRandom.getParameters();
        } else {
            if (bl) {
                this.rand = CryptoServicesRegistrar.getSecureRandom();
            }
            this.param = (ParametersWithIV)dda10;
        }
    }

    public String getAlgorithmName() {
        return this.engine.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        int n4;
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.engine.init(true, this.param);
        int n5 = this.engine.getBlockSize();
        byte[] byArray2 = n3 + 4 < n5 << 1 ? new byte[n5 << 1] : new byte[(n3 + 4) % n5 == 0 ? n3 + 4 : ((n3 + 4) / n5 + 1) * n5];
        byArray2[0] = (byte)n3;
        byArray2[1] = ~byArray[n2];
        byArray2[2] = ~byArray[n2 + 1];
        byArray2[3] = ~byArray[n2 + 2];
        System.arraycopy(byArray, n2, byArray2, 4, n3);
        byte[] byArray3 = new byte[byArray2.length - (n3 + 4)];
        this.rand.nextBytes(byArray3);
        System.arraycopy(byArray3, 0, byArray2, n3 + 4, byArray3.length);
        for (n4 = 0; n4 < byArray2.length; n4 += n5) {
            this.engine.processBlock(byArray2, n4, byArray2, n4);
        }
        for (n4 = 0; n4 < byArray2.length; n4 += n5) {
            this.engine.processBlock(byArray2, n4, byArray2, n4);
        }
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n5 = this.engine.getBlockSize();
        if (n3 < 2 * n5) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), byArray3));
        for (n4 = n5; n4 < byArray2.length; n4 += n5) {
            this.engine.processBlock(byArray2, n4, byArray2, n4);
        }
        System.arraycopy(byArray2, byArray2.length - byArray3.length, byArray3, 0, byArray3.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), byArray3));
        this.engine.processBlock(byArray2, 0, byArray2, 0);
        this.engine.init(false, this.param);
        for (n4 = 0; n4 < byArray2.length; n4 += n5) {
            this.engine.processBlock(byArray2, n4, byArray2, n4);
        }
        if ((byArray2[0] & 0xFF) > byArray2.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] byArray4 = new byte[byArray2[0] & 0xFF];
        System.arraycopy(byArray2, 4, byArray4, 0, byArray2[0]);
        int n6 = 0;
        for (int i2 = 0; i2 != 3; ++i2) {
            byte by = ~byArray2[1 + i2];
            n6 |= by ^ byArray4[i2];
        }
        if (n6 != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return byArray4;
    }
}

