/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import macromedia.db2util.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.OutputLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;

public class NoekeonEngine
implements BlockCipher {
    private static final int genericSize = 16;
    private static final int[] nullVector = new int[]{0, 0, 0, 0};
    private static final int[] roundConstants = new int[]{128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212};
    private int[] state = new int[4];
    private int[] subKeys = new int[4];
    private int[] decryptKeys = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "Noekeon";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, dda dda10) {
        if (!(dda10 instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to Noekeon init - " + dda10.getClass().getName());
        }
        this._forEncryption = bl;
        this._initialised = true;
        KeyParameter keyParameter = (KeyParameter)dda10;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n2 + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 16 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(byArray, n2, byArray2, n3) : this.decryptBlock(byArray, n2, byArray2, n3);
    }

    public void reset() {
    }

    private final void setKey(byte[] byArray) {
        this.subKeys[0] = this.bytesToIntBig(byArray, 0);
        this.subKeys[1] = this.bytesToIntBig(byArray, 4);
        this.subKeys[2] = this.bytesToIntBig(byArray, 8);
        this.subKeys[3] = this.bytesToIntBig(byArray, 12);
    }

    private final int encryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        this.state[0] = this.bytesToIntBig(byArray, n2);
        this.state[1] = this.bytesToIntBig(byArray, n2 + 4);
        this.state[2] = this.bytesToIntBig(byArray, n2 + 8);
        this.state[3] = this.bytesToIntBig(byArray, n2 + 12);
        for (n4 = 0; n4 < 16; ++n4) {
            this.state[0] = this.state[0] ^ roundConstants[n4];
            NoekeonEngine noekeonEngine = this;
            noekeonEngine.theta(noekeonEngine.state, this.subKeys);
            NoekeonEngine noekeonEngine2 = this;
            noekeonEngine2.pi1(noekeonEngine2.state);
            NoekeonEngine noekeonEngine3 = this;
            noekeonEngine3.gamma(noekeonEngine3.state);
            NoekeonEngine noekeonEngine4 = this;
            noekeonEngine4.pi2(noekeonEngine4.state);
        }
        this.state[0] = this.state[0] ^ roundConstants[n4];
        NoekeonEngine noekeonEngine = this;
        noekeonEngine.theta(noekeonEngine.state, this.subKeys);
        NoekeonEngine noekeonEngine5 = this;
        noekeonEngine5.intToBytesBig(noekeonEngine5.state[0], byArray2, n3);
        NoekeonEngine noekeonEngine6 = this;
        noekeonEngine6.intToBytesBig(noekeonEngine6.state[1], byArray2, n3 + 4);
        NoekeonEngine noekeonEngine7 = this;
        noekeonEngine7.intToBytesBig(noekeonEngine7.state[2], byArray2, n3 + 8);
        NoekeonEngine noekeonEngine8 = this;
        noekeonEngine8.intToBytesBig(noekeonEngine8.state[3], byArray2, n3 + 12);
        return 16;
    }

    private final int decryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        this.state[0] = this.bytesToIntBig(byArray, n2);
        this.state[1] = this.bytesToIntBig(byArray, n2 + 4);
        this.state[2] = this.bytesToIntBig(byArray, n2 + 8);
        this.state[3] = this.bytesToIntBig(byArray, n2 + 12);
        System.arraycopy(this.subKeys, 0, this.decryptKeys, 0, this.subKeys.length);
        NoekeonEngine noekeonEngine = this;
        noekeonEngine.theta(noekeonEngine.decryptKeys, nullVector);
        for (n4 = 16; n4 > 0; --n4) {
            NoekeonEngine noekeonEngine2 = this;
            noekeonEngine2.theta(noekeonEngine2.state, this.decryptKeys);
            this.state[0] = this.state[0] ^ roundConstants[n4];
            NoekeonEngine noekeonEngine3 = this;
            noekeonEngine3.pi1(noekeonEngine3.state);
            NoekeonEngine noekeonEngine4 = this;
            noekeonEngine4.gamma(noekeonEngine4.state);
            NoekeonEngine noekeonEngine5 = this;
            noekeonEngine5.pi2(noekeonEngine5.state);
        }
        NoekeonEngine noekeonEngine6 = this;
        noekeonEngine6.theta(noekeonEngine6.state, this.decryptKeys);
        this.state[0] = this.state[0] ^ roundConstants[n4];
        NoekeonEngine noekeonEngine7 = this;
        noekeonEngine7.intToBytesBig(noekeonEngine7.state[0], byArray2, n3);
        NoekeonEngine noekeonEngine8 = this;
        noekeonEngine8.intToBytesBig(noekeonEngine8.state[1], byArray2, n3 + 4);
        NoekeonEngine noekeonEngine9 = this;
        noekeonEngine9.intToBytesBig(noekeonEngine9.state[2], byArray2, n3 + 8);
        NoekeonEngine noekeonEngine10 = this;
        noekeonEngine10.intToBytesBig(noekeonEngine10.state[3], byArray2, n3 + 12);
        return 16;
    }

    private final void gamma(int[] nArray) {
        nArray[1] = nArray[1] ^ ~nArray[3] & ~nArray[2];
        nArray[0] = nArray[0] ^ nArray[2] & nArray[1];
        int n2 = nArray[3];
        nArray[3] = nArray[0];
        nArray[0] = n2;
        nArray[2] = nArray[2] ^ (nArray[0] ^ nArray[1] ^ nArray[3]);
        nArray[1] = nArray[1] ^ ~nArray[3] & ~nArray[2];
        nArray[0] = nArray[0] ^ nArray[2] & nArray[1];
    }

    private final void theta(int[] nArray, int[] nArray2) {
        int n2 = nArray[0] ^ nArray[2];
        n2 ^= this.rotl(n2, 8) ^ this.rotl(n2, 24);
        nArray[1] = nArray[1] ^ n2;
        nArray[3] = nArray[3] ^ n2;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = i2;
            nArray[n3] = nArray[n3] ^ nArray2[i2];
        }
        n2 = nArray[1] ^ nArray[3];
        n2 ^= this.rotl(n2, 8) ^ this.rotl(n2, 24);
        nArray[0] = nArray[0] ^ n2;
        nArray[2] = nArray[2] ^ n2;
    }

    private final void pi1(int[] nArray) {
        nArray[1] = this.rotl(nArray[1], 1);
        nArray[2] = this.rotl(nArray[2], 5);
        nArray[3] = this.rotl(nArray[3], 2);
    }

    private final void pi2(int[] nArray) {
        nArray[1] = this.rotl(nArray[1], 31);
        nArray[2] = this.rotl(nArray[2], 27);
        nArray[3] = this.rotl(nArray[3], 30);
    }

    private final int bytesToIntBig(byte[] byArray, int n2) {
        return byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private final void intToBytesBig(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }

    private final int rotl(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }
}

