/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.asn1.cms;

import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERTaggedObject;
import macromedia.db2util.externals.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import macromedia.db2util.externals.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.dda;

public class KeyAgreeRecipientIdentifier
extends ASN1Object
implements dda {
    private IssuerAndSerialNumber issuerSerial;
    private RecipientKeyIdentifier rKeyID;

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KeyAgreeRecipientIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object object) {
        if (object == null || object instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)object;
        }
        if (object instanceof ASN1Sequence) {
            return new KeyAgreeRecipientIdentifier(IssuerAndSerialNumber.getInstance(object));
        }
        if (object instanceof ASN1TaggedObject && ((ASN1TaggedObject)object).getTagNo() == 0) {
            return new KeyAgreeRecipientIdentifier(RecipientKeyIdentifier.getInstance((ASN1TaggedObject)object, false));
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier: " + object.getClass().getName());
    }

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.issuerSerial = issuerAndSerialNumber;
        this.rKeyID = null;
    }

    public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.issuerSerial = null;
        this.rKeyID = recipientKeyIdentifier;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerSerial;
    }

    public RecipientKeyIdentifier getRKeyID() {
        return this.rKeyID;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.issuerSerial != null) {
            return this.issuerSerial.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.rKeyID);
    }
}

