/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.excelant;

import org.apache.poi.ss.excelant.util.ExcelAntEvaluationResult;
import org.apache.poi.ss.excelant.util.ExcelAntWorkbookUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ExcelAntEvaluateCell
extends Task {
    private String cell;
    private double expectedValue;
    private double precision;
    private double globalPrecision;
    private boolean requiredToPass;
    private ExcelAntEvaluationResult result;
    private ExcelAntWorkbookUtil wbUtil;
    private boolean showDelta;

    protected void setWorkbookUtil(ExcelAntWorkbookUtil wb) {
        this.wbUtil = wb;
    }

    public void setShowDelta(boolean value) {
        this.showDelta = value;
    }

    protected boolean showDelta() {
        return this.showDelta;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public void setRequiredToPass(boolean val) {
        this.requiredToPass = val;
    }

    protected boolean requiredToPass() {
        return this.requiredToPass;
    }

    public void setExpectedValue(double expectedValue) {
        this.expectedValue = expectedValue;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    protected void setGlobalPrecision(double prec) {
        this.globalPrecision = prec;
    }

    protected String getCell() {
        return this.cell;
    }

    protected double getExpectedValue() {
        return this.expectedValue;
    }

    protected double getPrecision() {
        this.log("test precision = " + this.precision + "\tglobal precision = " + this.globalPrecision, 3);
        if (this.globalPrecision > 0.0) {
            if (this.precision > 0.0) {
                this.log("Using evaluate precision of " + this.precision + " over the " + "global precision of " + this.globalPrecision, 3);
                return this.precision;
            }
            this.log("Using global precision of " + this.globalPrecision, 3);
            return this.globalPrecision;
        }
        this.log("Using evaluate precision of " + this.precision, 3);
        return this.precision;
    }

    public void execute() throws BuildException {
        this.result = this.wbUtil.evaluateCell(this.cell, this.expectedValue, this.getPrecision());
        StringBuilder sb = new StringBuilder();
        sb.append("evaluation of cell ");
        sb.append(this.cell);
        sb.append(" resulted in ");
        sb.append(this.result.getReturnValue());
        if (this.showDelta) {
            sb.append(" with a delta of ").append(this.result.getDelta());
        }
        this.log(sb.toString(), 4);
    }

    public ExcelAntEvaluationResult getResult() {
        return this.result;
    }
}

