/*
 * Copyright (c) 1997-2019 IDRsolutions (https://www.idrsolutions.com)
 */
var FDFXFA_FormType = document.getElementById("FDFXFA_FormType");
var FDFXFA_PDFName = document.getElementById("FDFXFA_PDFName");
var FDFXFA_PageLabel = document.getElementById("FDFXFA_PageLabel");
var FDFXFA_PageCount = document.getElementById("FDFXFA_PageCount");
var FDFXFA_SubmitFormat = document.getElementById("FDFXFA_SubmitFormat");
var FDFXFA_SubmitURL = document.getElementById("FDFXFA_SubmitURL");

console.println = console.log;

var XFAOptions = {
	HIGHLIGHT: true
};

function APP() {

	var xfa;

	var LCT = document.createElement("canvas");
	var LCPX = "px";

	var LCStroke = {
		"solid": "solid", "dotted": "dotted", "dashed": "dashed",
		"dashedDot": "dashed", "dashedDotDot": "dotted", "embossed": "ridge",
		"etched": "solid", "lowered": "outset", "raised": "inset"
	};

	var LCO = {
		ARC: 96850, AREA: 3002509, ASSIST: -1408204183, BARCODE: -333584256,
		BIND: 3023933, BINDITEMS: -950341245, BOOKEND: 64682322, BOOLEAN: 64711720,
		BORDER: -1383304148, BREAK: 94001407, BREAKAFTER: 1275364381, BREAKBEFORE: 908888414,
		BUTTON: -1377687758, CALCULATE: -1283652762, CAPTION: 552573414,
		CERTIFICATE: 1952399767, CERTIFICATES: 394850748, CHECKBUTTON: 282923610,
		CHOICELIST: 535284191, COLOR: 94842723, COMB: 3059457, COMMAND: 950394699,
		CONNECT: 951351530, CONNECTIONSET: -513216348, CONNECTSTRING: -1138299493,
		CONTENTAREA: -389704538, CORNER: -1354665387, DATAGROUP: -385593099,
		DATAMODEL: -380152417, DATAVALUE: -372249625, DATAWINDOW: 1381224506,
		DATE: 3076014, DATETIME: 1792749467, DATETIMEEDIT: 609537093,
		DECIMAL: 1542263633, DEFAULTUI: -1502128971, DELETE: -1335458389,
		DELTA: 95468472, DELTAS: -1335444549, DESC: 3079825, DIGESTMETHOD: 123926469,
		DIGESTMETHODS: -453246642, DRAW: 3091780, DSIGDATA: 1939042071, EDGE: 3108285,
		ENCODING: 1711222099, ENCODINGS: 1508277632, ENCRYPT: -1607257499,
		EVENT: 96891546, EVENTPSEUDOMODEL: 673505553, EXCLGROUP: 1644111747,
		EXDATA: -1290477827, EXECUTE: -1319569547, EXOBJECT: 1411910098,
		EXTRAS: -1289032093, FIELD: 97427706, FILL: 3143043, FILTER: -1274492040,
		FLOAT: 97526364, FONT: 3148879, FORM: 3148996, FORMAT: -1268779017,
		HANDLER: 692803402, HOSTPSEUDOMODEL: -1160672957, IMAGE: 100313435,
		IMAGEEDIT: -878615035, INSERT: -1183792455, INSTANCEMANAGER: -752111272,
		INTEGER: 1958052158, ISSUERS: 2100749530, ITEMS: 100526016, KEEP: 3287941,
		KEYUSAGE: 491852418, LAYOUTPSEUDOMODEL: 257449601, LINE: 3321844,
		LINEAR: -1102672091, MANIFEST: 130625071, MAP: 107868, MARGIN: -1081309778,
		MDP: 107961, MEDIUM: -1078030475, MESSAGE: 954925063, NUMERICEDIT: 68595383,
		OCCUR: 105559020, OID: 110026, OIDS: 3410921, OPERATION: 1662702951,
		OVERFLOW: 529642498, PACKET: -995865464, PAGEAREA: 858900412, PAGESET: -803560621,
		PARA: 3433440, PASSWORD: 1216985755, PASSWORDEDIT: 566613829, PATTERN: -791090288,
		PICTURE: -577741570, PROTO: 106940904, QUERY: 107944136, RADIAL: -938579425,
		REASON: -934964668, REASONS: 1080866479, RECORDSET: 993536593,
		RECTANGLE: 1121299823, REF: 112787, ROOTELEMENT: -1786784838, SCRIPT: -907685685,
		SELECT: -906021636, SETPROPERTY: 996179031, SIGNATURE: 1073584312,
		SIGNATUREPROPERTIES: 903838731, SIGNATUREPESUDOMODEL: 983907983,
		SIGNDATA: 310844167, SIGNING: 2088273157, SOAPACTION: -62240351,
		SOAPADDRESS: -1915339287, SOLID: 109618859, SOURCE: -896505829,
		SOURCESET: -1698422201, SPEAK: 109641682, STIPPLE: -1889860191,
		SUBFORM: -1867994364, SUBFORMSET: 471239358, SUBJECTDN: 258589366,
		SUBJECTDNS: -573664131, SUBMIT: -891535336, TEMPLATE: -1321546630, TEXT: 3556653,
		TEXTEDIT: -1004091177, TIME: 3560141, TIMESTAMP: 25573622, TOOLTIP: -1140107293,
		TRAVERSAL: 1269131454, TRAVERSE: 1287865714, UI: 3732, UPDATE: -838846263,
		URI: 116076, USER: 3599307, VALIDATE: -1421272810, VALUE: 111972721,
		VARIABLES: -82477705, WSDLADDRESS: -807966992, WSDLCONNECTION: 1030423138,
		XFA: 118579, XMLCONNECTION: 757086805, XSDCONNECTION: -1272675193
	};

	var LCV = {
		ABOVE: 92611485, ABOVEEMBEDDED: 744207687, ACTUAL: -1422939762,
		ADDNEW: -1422530241, ALIGN: 92903173, ALL: 96673,
		ALLOWRICHTEXT: -300285294, ALWAYS: -1414557169, AMBIENT: -892145000,
		ANY: 96748, AUTHOR: -1406328437, AUTO: 3005871, BACK: 3015911,
		BASE64: -1396204209, BATCHOPTMISTIC: 289754416, BELOW: 93621297,
		BLANK: 93819220, BOLD: 3029637, BOTH: 3029889, BOTTOMCENTER: 1781909088,
		BOTTOMLEFT: -1682792238, BOTTOMRIGHT: -621290831, BUTT: 3035667,
		CAPTION: 552573414, CENTER: -1364013995, CHANGE: -1361636432,
		CHECK: 94627080, CHOICE: -1361224287, CIRCLE: -1360216880, CLEAR: 94746189,
		CLICK: 94750088, CLIENT: -1357712437, CLOSE: 94756344,
		CONTENTAREA: -389704538, CROSS: 94935104, CUSTOM: -1349088399,
		DASHDOT: 1442454615, DASHDOTDOT: 1017707890, DASHED: -1338941519,
		DATA: 3076010, DATAREF: 1443213481, DECIMAL: 1542263633, DEFAULT: 1544803905,
		DIAMOND: 1655054676, DISABLED: 270940796, DISMISE: -958641572,
		DOCCLOSE: 815524768, DOCREADY: 829155147, DOTTED: -1325970902, DOWN: 3089570,
		DUPLEX: -1320556608, EMBED: 96620249, EMBOSSED: 795545460, ENTER: 96667352,
		ERROR: 96784904, ETCHED: -1293242125, EVEN: 3125530, EXCLUDE: -1321148966,
		EXIT: 3127582, FILLER: -1274499728, FIRST: 97440432, FIT: 101393,
		FLATECOMPRESS: -1036553330, FORMDATA: 474151534, FULL: 3154575,
		GLOBAL: -1243020381, HEIGHT: -1221029593, HIDDEN: -1217487446,
		IGNORE: -1190396462, IMPORT: -1184795739, INCLUDE: 1942574248,
		INITIALIZE: 871091088, INLINE: -1183997287, INVERTED: 627674869,
		INVISIBLE: -1901805651, ITALIC: -1178781136, JUSTIFY: -1249482096,
		JUSTIFYALL: 1160498417, LANDSCAPE: 1430647483, LEFT: 3317767, LRTB: 103183381,
		LETTER: -1106172890, LINK: 3321850, LOCALE: -1097462182, LOWERED: 357006176,
		MANUAL: -1081415738, METADATA: -450957489, MIDDLECENTER: -641184182,
		MIDDLELEFT: -818275524, MIDDLERIGHT: 408923527, MOUSEDOWN: 585890535,
		MOUSEENTER: 983628083, MOUSEEXIT: 585928547, MOUSEUP: 1243066912,
		MOVELAST: -104664569, MULTISELECT: -274045035, NAME: 3373707, NEXT: 3377907,
		NO: 2529, NONE: 3387192, NORMAL: -1039745817, NOTBLANK: 1549517377,
		OFF: 109935, ON: 3551, ONCE: 3415681, ONENTRY: -1349984813, ONLY: 3415980,
		OPEN: 3417674, OPTIMISTIC: 1312630381, OPTIONAL: -79017120,
		ORDERED: -1207109523, OUTLINE: -1106245566, OVERRIDE: 594640876,
		PAGEAREA: 858900412, PAGEEVEN: 859023433, PAGEFRONT: 860736730,
		PAGEODD: -803564512, PDF: 110834, PDFENVELOPE: 767496930,
		PESSIMISTIC: 1012469707, PLAINTEXTONLY: -1300672925, PORTRAIT: 729267099,
		POSITION: 747804969, POSTEXECUTE: -784465227, POSTPRINT: 1989053933,
		POSTSAVE: 756973117, PREEXECUTE: -150786222, PREPRINT: -1308607030,
		PRESAVE: -319234368, PRESUBMIT: -1823663973, PROTECTED: -608539730,
		PUSH: 3452698, RADIX: 108270596, RAISED: -938420744, READONLY: -867683742,
		READY: 108386723, REMERGE: 1091534309, REQUIRED: -393139297, RIGHT: 108511772,
		RLTB: 108545761,
		ROUND: 108704142, ROW: 113114, SELECT: -906021636, SERVER: -905826493,
		SIMPLEX: 2093876486, SOLID: 109618859, SQUARE: -894674659, STAR: 3540562,
		STAYEOF: -1897022493, TABLE: 110115790, TB: 3694, TOBOTTOM: 2026802310,
		TOCENTER: 2046017200, TOEDGE: -869319976, TOLEFT: -869110494,
		TOOLTIP: -1140076541, TOPCENTER: -696883702, TOPLEFT: -1140120836,
		TOPRIGHT: -978346553, TORIGHT: -1166960543, TOTOP: 110519514,
		UNORDERED: 504691636, UNSPECIFIED: -1626174665, UP: 3739,
		USERCONTROL: 649676562, VERIFY: -819951495, VISIBLE: 466743410,
		WARNING: 1124446108, WIDTH: 113126854, WORD: 3655434, XDP: 118532,
		XMLENVELOPE: -451658489, YES: 88775
	};

	var LCP = {
		ACCESS: -1423461020, ACCESSKEY: -2115058085, ACTION: -1422950858,
		ACTIVITY: -1655966961, ADDREVOCATIONINFO: -2093253523, AFTER: 92734940,
		AFTERTARGET: 237866637, ALIASNODE: 1599803506, ALL: 96673,
		ALLOWMACRO: -1358909949, ALLOWNEUTRAL: 776306238, ALLOWRICHTEXT: -300285294,
		ANCHORTYPE: -1297063025, APPTYPE: -793934597, ARC: 96850, ARCHIVE: -748101438,
		AREA: 3002509, ASPECT: -1408297896, ASSIST: -1408204183, BARCODE: -333584256,
		BASELINESHIFT: 275888445, BEFORE: -1392885889, BEFORETARGET: 86622704,
		BIND: 3023933, BINDING: -108220795, BINDITEMS: -950341245, BLANK: 93819220,
		BLANKORNOTBLANK: 1652192696, BOFACTION: 1428486479, BOOKEND: 64682322,
		BOOKENDLEADER: -1591188229, BOOKENDTRAILER: 1095201665, BOOLEAN: 64711720,
		BORDER: -1383304148, BORDERCOLOR: 722830999, BORDERWIDTH: 741115130,
		BOTTOMINSET: -629442126, BREAK: 94001407, BREAKAFTER: 1275364381,
		BREAKBEFORE: 908888414, BUTTON: -1377687758, CALCULATE: -1283652762,
		CALCULATIONSENABLED: -558477033, CAP: 98258, CAPTION: 552573414,
		CERTIFICATE: 1952399767, CERTIFICATES: 394850748, CHANGE: -1361636432,
		CHARENCODING: 1992453833, CHECKBUTTON: 282923610, CHECKSUM: 1536908355,
		CHOICELIST: 535284191, CIRCULAR: -1498085729, CLASSALL: 692405513,
		CLASSID: 853619891, CLASSINDEX: -310789574, CLASSNAME: -9888733,
		CODEBASE: -868521378, CODETYPE: -867962169, COLOR: 94842723, COLSPAN: 948710634,
		COLUMNWIDTHS: -346492317, COMB: 3059457, COMMAND: 950394699,
		COMMANDTYPE: -1461238491, COMMITKEY: -1491182168, COMMITON: -602291850,
		CONNECT: 951351530, CONNECTION: -775651618, CONNECTIONSET: -513216348,
		CONNECTSTRING: -1138299493, CONTAINS: -567445985, CONTENT: 951530617,
		CONTENTAREA: -389704538, CONTENTTYPE: -389131437, CONTEXT: 951530927,
		CORNER: -1354665387, COUNT: 94851343, CREDENTIALSERVERPOLICY: 1299280972,
		CRLSIGN: 1034591546, CSPACE: -1380596125, CURRENTPAGE: 601108392,
		CURRENTRECORDNUMBER: -1047685357, CURRENTVALUE: 1460037496,
		CURSORLOCATION: 301621547, CURSORTYPE: 87587760, DATA: 3076010,
		DATACOLUMNCOUNT: -594977457, DATADESCRIPTION: -1458786830,
		DATAENCIPHERMENT: -641720292, DATAGROUP: -385593099, DATALENGTH: 1062612784,
		DATAMODEL: -380152417, DATAPREP: 1788944631, DATAROWCOUNT: 1344981279,
		DATAVALUE: -372249625, DATE: 3076014, DATETIME: 1792749467,
		DATETIMEEDIT: 609537093, DB: 3198, DECIMAL: 1542263633,
		DECIPHERONLY: -1427596392, DEFAULTUI: -1502129003, DELAYEDOPEN: 642943692,
		DELETE: -1335458389, DELIMITER: -250518009, DESC: 3079825,
		DIGESTMETHOD: 123926469, DIGESTMETHODS: -453246642, DIGITALSIGNATURE: 1501898112,
		DISABLE: 1671308008, DRAW: 3091780, DSIGDATA: 1939042071, EDGE: 3108285,
		EDITVALUE: -1874892409, EMBEDPDF: 785828697, ENCIPHERONLY: -291206720,
		ENCODING: 1711222099, ENCODINGS: 1508277632, ENCRYPT: -1607257499,
		ENDCHAR: -1607750959, EOFACTION: 301090386, ERRORCORRECTIONLEVEL: -1237447778,
		EVENT: 96891546, EXCLGROUP: 1644111747, EXDATA: -1290477827,
		EXECUTE: -1319569547, EXECUTETYPE: -459392945, EXOBJECT: 1411910098,
		EXTRAS: -1289032093, FIELD: 97427706, FILL: 3143043, FILLCOLOR: -1141881952,
		FILTER: -1274492040, FLOAT: 97526364, FONT: 3148879, FONTCOLOR: -1565881260,
		FORM: 3148996, FORMAT: -1268779017, FORMATMESSAGE: -1955460080,
		FORMATTEDVALUE: -1695807979, FORMATTEST: 323804457, FRACDIGITS: -1491532684,
		FROM: 3151786, FULLTEXT: 1331035228, H: 104, HALIGN: -1254185091,
		HAND: 3194991, HANDLER: 692803402, HIGHLIGHT: -681210700, HREF: 3211051,
		HSCROLLPOLICY: -1114152217, ID: 3355, IMAGE: 100313435, IMAGEEDIT: -878615035,
		IMAGINGBBOX: -2105051775, INDEX: 100346066, INITIAL: 1948342084,
		INITIALNUMBER: -295068755, INPUT: 100358090, INSERT: -1183792455,
		INSTANCEINDEX: -1402980035, INSTANCEMANAGER: -752111272, INTACT: -1183766973,
		INTEGER: 1958052158, INVERTED: 627674869, ISCONTAINER: 767463031,
		ISDEFINED: 965256575, ISNULL: -1180261935, ISSUERS: 2100749530,
		ITEMS: 100526016, JOIN: 3267882, KEEP: 3287941, KEYAGREEMENT: 499945067,
		KEYCERTSIGN: -2000724608, KEYDOWN: -815927391, KEYENCIPHERMENT: 1604413265,
		KEYUSAGE: 491852418, LABELREF: -1959269121, LANGUAGE: -1613589672,
		LAYOUT: -1109722326, LEADDIGITS: 238961506, LEADER: -1106754295,
		LEFTINSET: 1721482582, LINE: 3321844, LINEAR: -1102672091,
		LINEHEIGHT: -515807685, LINETHROUGH: -950577103, LINETHROUGHPERIOD: 2093945170,
		LOCALE: -1097462182, LOCKTYPE: 1909340933, LONG: 3327612, MANDATORY: -392910375,
		MANDATORYMESSAGE: 1502468078, MANIFEST: 130625071, MAP: 107868,
		MARGIN: -1081309778, MARGINLEFT: 1970934485, MARGINRIGHT: 975087886,
		MARK: 3344077, MATCH: 103668165, MAX: 107876, MAXCHARS: 381878489,
		MAXH: 3344228, MAXLENGTH: -791400086, MAXW: 3344243, MDP: 107961,
		MEDIUM: -1078030475, MESSAGE: 954925063, MIN: 108114, MINH: 3351606,
		MINW: 3351621, MODEL: 104069929, MODIFIER: -615513385, MODULEHEIGHT: 943039155,
		MODULEWIDTH: -1202537798, MULTILINE: -1207192371, NAME: 3373707,
		NEWCONTENTTYPE: 113905043, NEWTEXT: 1845203693, NEXT: 3377907,
		NONREPUDIATION: -1825590773, NS: 3525, NULLTEST: -1906351431,
		NUMBERED: -1886439000, NUMBEROFCELLS: -1338319823, NUMERICEDIT: 68595383,
		NUMPAGES: -1903192098, OCCUR: 105559020, ODDOREVEN: 348603308,
		OID: 110026, OIDS: 3410921, ONEOFCHILD: -1575874497, OPEN: 3417674,
		OPERATION: 1662702951, ORIENTATION: -1439500848, OUTPUT: -1005512447,
		OVERFLOW: 529642498, OVERFLOWLEADER: 1102338987, OVERFLOWTARGET: 1328187443,
		OVERFLOWTRAILER: -1304800559, OVERLINE: 529818312, OVERLINEPERIOD: 627674793,
		OVERRIDE: 529996748, PACKET: -995865464, PAGEAREA: 858900412,
		PAGEPOSITION: -1051107112, PAGESET: -803560621, PARA: 3433440,
		PARENT: -995424086, PARENTSUBFORM: -1379596550, PASSWORD: 1216985755,
		PASSWORDCHAR: 566557841, PASSWORDEDIT: 566613829, PATTERN: -791090288,
		PERMISSIONS: 1133704324, PICTURE: -577741570, PLACEMENT: 1792938725,
		PLATFORM: 1874684019, POSTURE: -391190328, PRESENCE: -1276666629,
		PRESERVE: -1276662196, PREVCONTENTTYPE: -695334112, PREVIOUS: -1273775369,
		PREVTEXT: -1274410496, PRINTCHECKDIGIT: -723426414, PRIORITY: -1165461084,
		PROTO: 106940904, QUERY: 107944136, RADIAL: -938579425, RADIUS: -938578798,
		RADIXOFFSET: -1135980105, RATE: 3493088, RAWVALUE: 494715433,
		READY: 108386723, REASON: -934964668, REASONS: 1080866479,
		RECORDSAFTER: -1583378246, RECORDSBEFORE: -1812787103, RECORDSET: 993536593,
		RECTANGLE: 1121299823, REENTER: 1084416133, REF: 112787, RELATION: -554436100,
		RELEVANT: -550690147, RESERVE: 1097075900, RESTORESTATE: 1637903011,
		RIGHTINSET: -1408130975, ROLE: 3506294, ROOTELEMENT: -1786784838,
		ROTATE: -925180581, ROWCOLUMNRATIO: -1005562853, RUNAT: 108874782,
		SAVE: 3522941, SAVEDVALUE: 1528442666, SCOPE: 109264468, SCRIPT: -907685685,
		SCRIPTPROPERTY: 167909312, SCRIPTTEST: -841864195, SELECT: -906021636,
		SELECTEDINDEX: 1436069623, SELEND: -906052063, SELSTART: 1175437352,
		SERVER: -905826493, SHAPE: 109399969, SHIFT: 109407362, SHORT: 109413500,
		SIGNATURE: 1073584312, SIGNATURETYPE: 1639612434, SIGNDATA: 310844167,
		SIGNING: 2088273157, SIZE: 3530753, SLOPE: 109532587, SOAPACTION: -62240351,
		SOAPADDRESS: -1915339287, SOAPFAULTCODE: -1732545564,
		SOAPFAULTSTRING: 1934132296, SOLID: 109618859, SOMEXPRESSION: -334484727,
		SOURCE: -896505829, SOURCESET: -1698422201, SPACEABOVE: 476378679,
		SPACEBELOW: 477388491, SPEAK: 109641682, STARTANGLE: -1601031791,
		STARTCHAR: -2129802536, STARTNEW: 1316780510, STATELESS: -2085177942,
		STIPPLE: -1889860191, STOCK: 109770518, STROKE: -891980232,
		SUBFORM: -1867994364, SUBFORMSET: 471239358, SUBJECTDN: 258589366,
		SUBJECTDNS: -573664131, SUBMIT: -891535336, SWEEPANGLE: 1180683591,
		TABDEFAULT: 1656024300, TABSTOPS: -918045156, TARGET: -880905839,
		TARGETTYPE: 486622315, TEMPLATE: -1321546630, TEXT: 3556653,
		TEXTEDIT: -1004091177, TEXTENCODING: 1442994592, TEXTENTRY: -1061746875,
		TEXTINDENT: 1559612473, TEXTLOCATION: 1632816130, THICKNESS: -1007552652,
		TIME: 3560141, TIMEOUT: -1313911455, TIMESTAMP: 25573622, TITLE: 110371416,
		TOOLTIP: -1140107293, TOPINSET: -986497848, TRAILER: -1067215565,
		TRANSFERENCODING: -463655330, TRANSIENT: 1052746378, TRAVERSAL: 1269131454,
		TRAVERSE: 1287865714, TRUNCATE: 1852984678, TYPE: 3575610, TYPEFACE: -675792745,
		UI: 3732, UNDERLINE: -1026963764, UNDERLINEPERIOD: -1885544531,
		UPDATE: -838846263, UPSMODE: -221178117, URI: 116076, URL: 116079,
		URLPOLICY: -444577919, USAGE: 111574433, USE: 116103, USEHREF: -147412686,
		USER: 3599307, UUID: 3601339, VALIDATE: -1421272810,
		VALIDATIONMESSAGE: 2062124366, VALIDATIONSENABLED: -1486419257,
		VALIGN: -853376977, VALUE: 111972721, VALUEREF: -1410175646,
		VARIATION: -81944045, VERSION: 351608024, VSCOLLPOLICY: 1192070555,
		W: 119, WEIGHT: -791592328, WIDENARROWRATIO: -1827512419,
		WSDLADDRESS: -807966992, WSDLCONNECTION: 1030423138, X: 120,
		XDPCONTENT: 2073809109, XFA: 118579, XMLCONNECTION: 757086805,
		XSDCONNECTION: -1272675193, Y: 121
	};

	/**
	 * contains ecmascript 6 keywords
	 * @type type
	 */
	var LCECMA = {
		"break": 0, "case": 0, "catch": 0, "continue": 0, "console": 0,
		"debugger": 0, "default": 0, "delete": 0, "do": 0, "else": 0, "false": 0,
		"finally": 0, "for": 0, "function": 0, "if": 0, "in": 0, "instanceOf": 0,
		"new": 0, "null": 0, "return": 0, "switch": 0, "this": 0, "throw": 0,
		"true": 0, "try": 0, "typeof": 0, "var": 0, "void": 0, "while": 0,
		"with": 0
	};

	var LCDollar = {
		"config": 0, "connectionSet": 0, "data": 0, "dataWindow": 0, "event": 0,
		"form": 0, "host": 0, "layout": 0, "record": 0, "template": 0, "xfa": 0
	};

	var LCFORMCALC = {
		keywords: {
			"and": "&&", "break": "break", "do": "do", "continue": "continue",
			"downto": "downto", "elseif": "}else if", "else": "} else {", "eq": "==",
			"endif": "}", "endwhile": "}", "endfor": "}", "end": "}", "endfunc": "}",
			"for": "for", "foreach": "foreach", "func": "function", "ge": ">=", "gt": ">",
			"in": "in", "if": "if", "le": "<=", "lt": "<", "infinity": "infinity",
			"ne": "!=", "nan": "nan", "not": "!", "null": "null", "or": "||", "return": "return",
			"step": "step", "this": "this", "then": "{", "throw": "throw",
			"upto": "upto", "var": "var", "while": "while"
		},
		functions: {
			"abs": 0, "avg": 0, "ceil": 0, "count": 0, "floor": 0, "max": 0, "min": 0,
			"mod": 0, "round": 0, "sum": 0, "date": 0, "date2num": 0, "num2date": 0,
			"datefmt": 0, "localdatefmt": 0, "time": 0, "time2num": 0, "num2gmtime": 0,
			"num2time": 0, "timefmt": 0, "localtimefmt": 0, "isodate2num": 0,
			"isotime2num": 0, "apr": 0, "cterm": 0, "fv": 0, "ipmt": 0, "npv": 0,
			"pmt": 0, "ppmt": 0, "pv": 0, "rate": 0, "term": 0, "choose": 0, "oneof": 0,
			"within": 0, "exists": 0, "hasvalue": 0, "unitvalue": 0, "unittype": 0,
			"at": 0, "concat": 0, "decode": 0, "encode": 0, "format": 0, "left": 0,
			"len": 0, "lower": 0, "ltrim": 0, "parse": 0, "replace": 0, "rtrim": 0,
			"right": 0, "space": 0, "str": 0, "stuff": 0, "substr": 0, "upper": 0,
			"wordnum": 0, "get": 0, "post": 0, "put": 0
		}
	};

	var LCMath = {
		px: function (str) {
			var len = str.length;
			if (len === 0) {
				return 0;
			}
			var n = str.charCodeAt(0);
			if (n >= 0x30 && n <= 0x39) {
				str = str.toLowerCase();
				var digit = str.substring(0, len - 2);
				var cal = str.substring(digit.length, len);
				var result = parseFloat(digit);
				if (cal === "px") {
				} else if (cal === "pt") {
					result *= 96 / 72;
				} else if (cal === "mm") {
					result *= 3.779527559;
				} else if (cal === "cm") {
					result *= 37.79527559;
				} else if (cal === "in") {
					result *= 96;
				} else if (cal === "em") {
					result *= 16;
				}
				return Math.round(result * 100.0) / 100.0;
			}
			return 0;
		},
		hash: function (str) {
			if (!str || str.length === 0) {
				return 0;
			}
			var h = 0;
			for (var i = 0, ii = str.length; i < ii; i++) {
				h = 31 * h + str.charCodeAt(i);
				h |= 0;
			}
			return h;
		},
		loanTerm: function (prin, rate, pmt) {
			var rem = prin;
			var nMonths = 0;
			while (rem > 0.0) {
				rem = rem - pmt + rem * rate;
				nMonths++;
			}
			return nMonths;
		}
	};

	//node utilities
	var LCU = {
		isNumber: function (v) {
			return v !== null && v !== undefined && !isNaN(v);
		},
		hasValue: function (v) {
			return v !== null && v !== undefined;
		},
		getFieldType: function (f) {
			var ui = LCU.findChild(f, LCO.UI);
			if (ui) {
				for (var i = 0, ii = ui.nodes.length; i < ii; i++) {
					var it = ui.nodes.item(i);
					return it._classHash;
				}
			}
			return 0;
		},
		isMultiLine: function (f) {
			var ui = LCU.findChild(f, LCO.UI);
			if (ui) {
				for (var i = 0, ii = ui.nodes.length; i < ii; i++) {
					var it = ui.nodes.item(i);
					if (it._classHash === LCO.TEXTEDIT && it.multiLine === "1") {
						return true;
					}
				}
			}
			return false;
		},
		getBindMatch: function (f) {
			var bind = LCU.findChild(f, LCO.BIND);
			if (bind) {
				return bind.match;
			}
			return "once";
		},
		removeComments: function (text) {
			var strs = text + " ";
			var len = strs.length - 1;
			var res = [];
			var cc, cc2, p = 0, p1, ch;
			var sglQuote = false, dblQuote = false;

			while (p < len) {
				p1 = p + 1;
				ch = strs.charAt(p);
				cc = strs.charCodeAt(p);
				cc2 = strs.charCodeAt(p1);

				if (cc === 92) { //backlash
					res.push(ch);
					ch = strs.charAt(p1);
					res.push(ch);
					p += 2;
					continue;
				} else if (sglQuote) {
					res.push(ch);
					if (cc === 39) {
						sglQuote = false;
					}
					p++;
					continue;
				} else if (dblQuote) {
					res.push(ch);
					if (cc === 34) {
						dblQuote = false;
					}
					p++;
					continue;
				}

				if (cc === 47 && cc2 === 47) { //line comment
					p += 2;
					while (p < len) {
						cc = strs.charCodeAt(p);
						cc2 = strs.charCodeAt(p + 1);
						if (cc === 0xd) {
							p++;
							if (cc2 === 0xa) {
								p++;
								break;
							}
							break;
						} else if (cc === 0xa) {
							p++;
							break;
						}
						p++;
					}
					res.push("\n");
					continue;
				}
				if (cc === 47 && cc2 === 42) { // multiline comment /*
					p += 2;
					while (p < len) {
						cc = strs.charCodeAt(p);
						cc2 = strs.charCodeAt(p + 1);
						if (cc === 42 && cc2 === 47) {
							p += 2;
							break;
						}
						p++;
					}
					continue;
				}
				sglQuote = cc === 39;
				dblQuote = cc === 34;
				res.push(ch);
				p++;
			}
			return res.join('');
		},
		somScriptToJavascript: function (scriptStr) {
			var varObj = this.grabVariableFunctionObject(scriptStr);
			var input = varObj["LCScriptSplit"];
			input.push(";");
			input.push(";");
			var a, b, c, t, a0;
			var output = [];
			var funcStart = false;
			var inBrackets = false;
			var funcBrackets = 0;
			var funcBraces = 0;
			var funcVars = {};

			for (var i = 0, ii = input.length - 2; i < ii; i++) {
				a = input[i];
				b = input[i + 1];
				c = input[i + 2];
				a0 = a.charCodeAt(0);
				if (funcStart && a.length === 1) {
					switch (a0) {
						case 0x28:
							funcBrackets++;
							output.push(a);
							continue;
						case 0x29:
							funcBrackets--;
							if (funcBrackets === 0) {
								inBrackets = false;
							}
							output.push(a);
							continue;
						case 0x7b:
							funcBraces++;
							output.push(a);
							continue;
						case 0x7d:
							funcBraces--;
							if (funcBraces === 0) {
								funcStart = false;
								funcVars = {};
							}
							output.push(a);
							continue;
					}
				}

				if (inBrackets) {
					funcVars[a] = 0;
					output.push(a + " ");
					continue;
				}

				if (a === "function" || a === "catch") {
					funcStart = inBrackets = true;
				}

				if (a in LCECMA) {
					output.push(a + " ");
					continue;
				}

				if (a.length > 3 && a0 === 0x24) {
					t = "";
					var aa = a.substring(1);
					if (aa === "xfa") {
						t = "xfa.";
					} else if (aa === "data") {
						t = "xfa.datasets.data.";
					} else if (aa in LCDollar) {
						t = "xfa." + a.substring(1) + ".";
					}
					if (t.length > 0) {
						output.push(t);
						i++;
						continue;
					}
				}

				if (a in varObj || a in funcVars) {
					output.push(a + " ");
					continue;
				} else if (b === "." || b === ".." || b === "..." || b === "," || b === ")") {
					if (a === "xfa" && c in LCDollar) {
						output.push(a + b + c);
						i++;
					} else if (a === "xfa" || a === "app" || a === "SOAP" || a === "this" || a === "host") {
						output.push(a + b);
					} else if (isStartAsChar(a0)) {
						if (i - 1 > -1 && input[i - 1] === ".") {
							output.push("_xquery(\"" + a + "\")" + b);
						} else {
							output.push("this._xquery(\"" + a + "\")" + b);
						}
					} else {
						output.push(a + b);
					}
					i++;
				} else {
					if (b === "++" || b === "--" || a === "\n" || a === ".") {
						output.push(a);
					} else {
						output.push(a + " ");
					}
				}
			}
			return output.join('');

			function isStartAsChar(t) {
				return t === 0x5f || t === 0x23 || (t >= 0x41 && t <= 0x5a) || (t >= 0x61 && t <= 0x7a);
			}
		},
		formCalcToJavascript: function (scriptStr) {
			var input = this.splitToBunches(scriptStr);
			if (input.length < 3) {
				return input.join('');
			}
			input.push(";");
			input.push(";");

			var a, b, c, a0;
			var output = [];
			var varArr = [];
			var temp = new LCNode(null, "field");

			for (var i = 0, ii = input.length - 2; i < ii; i++) {
				a = input[i];
				b = input[i + 1];
				c = input[i + 2];
				a0 = a.charCodeAt(0);

				if (a0 === 0x24) {
					if (a.length === 1) {
						output.push("this");
						continue;
					} else {
						var aa = a.substring(1);
						if (aa in LCDollar) {
							output.push(LCDollar[aa]);
							continue;
						}
					}
				}

				if (a.length > 3 && a0 === 0x24) {
					var t = "";
					var aa = a.substring(1);
					if (aa === "xfa") {
						t = "xfa.";
					} else if (aa === "data") {
						t = "xfa.datasets.data.";
					} else if (aa in LCDollar) {
						t = "xfa." + a.substring(1) + ".";
					}
					if (t.length > 0) {
						output.push(t);
						i++;
						continue;
					}
				}

				var lower = a.toLowerCase();
				if (lower in LCFORMCALC.keywords) {
					output.push(LCFORMCALC.keywords[lower] + " ");
					if (isStartAsChar(b.charCodeAt(0))) {
						if (a === "func" || a === "var") {
							varArr.push(b);
						}
					}
					continue;
				} else if (lower in LCFORMCALC.functions) {
					output.push("FormCalc." + lower);
					continue;
				}

				if (isStartAsChar(a0) && !isInArray(a, varArr)
						&& a !== "xfa" && a !== "SOAP" && a !== "app" && c !== "=" && b !== "(") {
					var ss = a0 === "#" ? a.substring(1) : a;
					if (ss in temp || ss in LCP) {
						output.push(ss);
					} else {
						var suffix = b === "." ? "" : ".rawValue";
						if (i > 0 && input[i - 1] === ".") {
							output.push("_xquery(\"" + a + "\")" + suffix);
						} else {
							output.push("this._xquery(\"" + a + "\")" + suffix);
						}
					}

				} else {
					if (b === "++" || b === "--" || a === "\n" || a === ".") {
						output.push(a);
					} else {
						output.push(a + " ");
					}
				}
			}
			return output.join('');

			function isInArray(t, arr) {
				for (var i = 0, ii = arr.length; i < ii; i++) {
					if (t === varArr[i]) {
						return true;
					}
				}
				return false;
			}
			function isStartAsChar(t) {
				return t === 0x5f || t === 0x23 || (t >= 0x41 && t <= 0x5a) || (t >= 0x61 && t <= 0x7a);
			}
		},
		splitToBunches: function (scriptStr) {
			var strs = LCU.removeComments(scriptStr);
			strs = strs + "  "; // suffix extra space for fast looping
			var res = [];
			var len = strs.length - 2;
			var c, c1, c2, p = 0;
			var ch, t;
			var sglQuote = false, dblQuote = false, prevTab = false;
			var isLine = false, isSpace = false;
			var curWord = [];

			function addAndClear() {
				if (curWord.length > 0) {
					res.push(curWord.join(''));
					curWord = [];
				}
			}

			while (p < len) {
				ch = strs.charAt(p);
				c = strs.charCodeAt(p);
				isLine = c === 0xa || c === 0xd;
				isSpace = c === 0xb || c === 0xc || c === 0x9 || c === 0x20;

				if (p > 0) {
					if (prevTab && (isLine || isSpace)) {
						p++;
						continue;
					}
				}

				if (c === 92) { //backlash
					curWord.push(ch);
					ch = strs.charAt(p + 1);
					curWord.push(ch);
					p += 2;
					continue;
				} else if (sglQuote) {
					curWord.push(ch);
					if (c === 39) {
						sglQuote = false;
						addAndClear();
					}
					p++;
					continue;
				} else if (dblQuote) {
					curWord.push(ch);
					if (c === 34) {
						dblQuote = false;
						addAndClear();
					}
					p++;
					continue;
				}

				c1 = strs.charCodeAt(p + 1);
				c2 = strs.charCodeAt(p + 2);

				prevTab = isLine || isSpace;
				sglQuote = c === 39;
				dblQuote = c === 34;

				if (prevTab) {
					addAndClear();
					if (isLine) {
						res.push("\n");
					}
					p++;
					continue;
				}

				if (c === 0x5b && c1 === 0x2a && c2 === 0x5d) { // [*]
					curWord.push("[*]");
					p += 3;
					continue;
				} else {
					switch (c) {
						case 0x2c: // ,
						case 0x28: // (
						case 0x29: // )
						case 0x3a: // :
						case 0x3b: // ;
						case 0x3f: // ?
						case 0x7b: // {
						case 0x7d: // }
							addAndClear();
							res.push(ch);
							p++;
							continue;
						case 0x25: // %
						case 0x26: // &
						case 0x2b: // +
						case 0x2d: // -
						case 0x2e: // .
						case 0x2f: // /
						case 0x5e: // ^
						case 0x7c: // |
						case 0x7e: // ~
							addAndClear();
							t = (c1 === 0x3d) ? ch + "=" : (c === c1) ? ch + ch : ch;
							res.push(t === ".." ? "." : t);
							p += t.length;
							continue;
						case 0x2a: // *
						case 0x3c: // <
						case 0x3d: // =
						case 0x3e: // >
							addAndClear();
							t = ch;
							if (c1 === 0x3d) {
								t = t + "=";
							} else if (c === c1) {
								t = t + t;
								if (c === c2) {
									t = t + ch;
								}
							} else if (c === c1 && c2 === 0x3d) {
								t = t + t + "=";
							}
							res.push(t);
							p += t.length;
							continue;
						case 0x21: // !
							addAndClear();
							t = (c1 === 0x3d) ? (c2 === 0x3d) ? ch + "==" : ch + "=" : ch;
							res.push(t);
							p += t.length;
							continue;
					}
				}
				curWord.push(ch);
				p++;
			}
			if (curWord.length > 0) {
				res.push(curWord.join(''));
			}
			return res;
		},
		grabVariableFunctionObject: function (scriptStr) {
			var varObj = {};
			varObj["LCScriptSplit"] = this.splitToBunches(scriptStr);
			var input = varObj["LCScriptSplit"];
			input.push(";");
			input.push(";");
			var a, b, a0;

			var isFunction = false, isVar = false;

			for (var i = 0, ii = input.length - 2; i < ii; i++) {
				a = input[i];
				b = input[i + 1];
				a0 = a.charCodeAt(0);

				if (a === "{" || a === "(") {
					var bc = 1;
					while (i < ii) {
						i++;
						a = input[i];
						if (a === "}" || a === ")") {
							bc--;
						}
						if (a === "{" || a === "(") {
							bc++;
						}
						if (bc <= 0) {
							break;
						}
					}
					continue;
				}

				if (isFunction) {
					if (isStartAsChar(a0)) {
						varObj[a] = 0;
						isFunction = false;
					}
					if (a0 > 0x20 && a0 < 0x40) {
						isFunction = false;
					}
				}
				if (isVar) {
					if (isStartAsChar(a0)) {
						varObj[a] = 0;
						isVar = false;
					}
					if (a0 > 0x20 && a0 < 0x40) {
						isVar = false;
					}
				}

				if (a === "function") {
					isFunction = true;
					continue;
				} else if (a === "var" || a === "let") {
					isVar = true;
					continue;
				}
			}
			return varObj;
			function isStartAsChar(t) {
				return t === 0x5f || t === 0x23 || (t >= 0x41 && t <= 0x5a) || (t >= 0x61 && t <= 0x7a);
			}
		},
		variablesToObj: function (scriptStr) {
			var varObj = this.grabVariableFunctionObject(scriptStr);
			delete varObj["LCScriptSplit"];
			var str = "";
			for (var nn in varObj) {
				if (nn !== "_xquery") {
					str += "\nthis." + nn + " = " + nn + ";";
				}
			}
			return "{" + scriptStr + str + "}\n";
		},
		searchDownName: function (n, hash, list, isSingle) {
			if (isSingle && list.length > 0) {
				return;
			}
			var p;
			for (var i = 0, ii = n.nodes.length; i < ii; i++) {
				p = n.nodes.item(i);
				if (p._nameHash === hash) {
					list.append(p);
				}
				if (p.isContainer) {
					this.searchDownName(p, hash, list, isSingle);
				}
			}
		},
		searchUpName: function (n, hash, list, isSingle) {
			var p;
			var k = n.parent;
			while (k) {
				if (isSingle && list.length > 0) {
					return;
				}
				for (var i = 0, ii = k.nodes.length; i < ii; i++) {
					p = k.nodes.item(i);
					if (p._nameHash === hash) {
						list.append(p);
					}
					if (p._nameHash === 0 && (p._classHash === LCO.SUBFORM || p._classHash === LCO.SUBFORMSET)) {
						this.searchDownName(p, hash, list, isSingle);
					}
				}
				k = k.parent;
			}
		},
		searchDown: function (n, hash, list, isClass, isSingle) {
			if (isSingle && list.length > 0) {
				return;
			}
			var p, h;
			for (var i = 0, ii = n.nodes.length; i < ii; i++) {
				p = n.nodes.item(i);
				h = isClass ? p._classHash : p._nameHash;
				if (h === hash) {
					list.append(p);
				}
				this.searchDown(p, hash, list, isClass, isSingle);
			}
		},
		searchUp: function (n, hash, list, isClass, isSingle) {
			var p, h;
			var k = n.parent;
			while (k) {
				if (isSingle && list.length > 0) {
					return;
				}
				for (var i = 0, ii = k.nodes.length; i < ii; i++) {
					p = k.nodes.item(i);
					h = isClass ? p._classHash : p._nameHash;
					if (h === hash) {
						list.append(p);
					}
				}
				k = k.parent;
			}
		},
		findSomId: function (s, id) {
			var ll = new LCList();
			searchSomId(s, id, ll);
			return ll.item(0);

			function searchSomId(n, somId, list) {
				if (list.length > 0) {
					return;
				}
				var p;
				for (var i = 0, ii = n.nodes.length; i < ii; i++) {
					p = n.nodes.item(i);
					if (p._somId === somId) {
						list.append(p);
					}
					searchSomId(p, somId, list);
				}
			}
		},
		findById: function (s, id) {
			var ll = new LCList();
			searchById(s, id, ll);
			return ll.item(0);
			function searchById(n, id, list) {
				if (list.length > 0) {
					return;
				}
				var p;
				for (var i = 0, ii = n.nodes.length; i < ii; i++) {
					p = n.nodes.item(i);
					if (p.id === id) {
						list.append(p);
					}
					searchById(p, id, list);
				}
			}
		},
		findChild: function (n, hash) {
			var p;
			for (var i = 0, ii = n.nodes.length; i < ii; i++) {
				p = n.nodes.item(i);
				if (p._classHash === hash) {
					return p;
				}
			}
			return null;
		},
		findChildren: function (n, hash) {
			var list = new LCList();
			var p;
			for (var i = 0, ii = n.nodes.length; i < ii; i++) {
				p = n.nodes.item(i);
				if (p._classHash === hash) {
					list.append(p);
				}
			}
			return list;
		},
		findDesc: function (n, hash) {
			var list = new LCList();
			this.searchDown(n, hash, list, true, true);
			return list.item(0);
		},
		findDescs: function (n, hash) {
			var list = new LCList();
			this.searchDown(n, hash, list, true, false);
			return list;
		},
		findNextSibls: function (n) {
			var sid = n._somId;
			var arr = new LCList();
			var found = false;
			for (var i = 0, ii = n.parent.nodes.length; i < ii; i++) {
				var it = n.parent.nodes.item(i);
				if (found) {
					arr.append(it);
				}
				if (sid === it._somId) {
					found = true;
				}
			}
			return arr;
		},
		findNextSibling: function (n) {
			var sid = n._somId;
			var arr = new LCList();
			var found = false;
			for (var i = 0, ii = n.parent.nodes.length; i < ii; i++) {
				var it = n.parent.nodes.item(i);
				if (found) {
					arr.append(it);
					break;
				}
				if (sid === it._somId) {
					found = true;
				}
			}
			return (arr.length > 0) ? arr[0] : null;
		},
		getTextWidth: function (textStr, font, isHTML) {
			var LCEX = document.getElementById("preRenderer");
			var context = LCT.getContext("2d");
			context.font = font;
			var text = textStr.trim();
			if (isHTML) {
				LCEX.innerHTML = text;
				return LCEX.clientWidth;
			}
//			var metrics = context.measureText(text);
//			var mm = metrics.width;
			var totalW = 0;
			for (var i = 0; i < text.length; i++) {
				totalW += context.measureText(text.charAt(i)).width;
			}
			return totalW;
		},
		getTextHeight: function (textStr, font, fontH, isHTML, paraW) {
			var LCEX = document.getElementById("preRenderer");
			var result = 1;
			var text = textStr.trim();
			if (isHTML) {
				LCEX.innerHTML = text;
				return LCEX.clientHeight;
			}
			var cc, ch, charW, totalW = 0, wordW = 0;
			var context = LCT.getContext("2d");
			context.font = font;
			for (var i = 0; i < text.length; i++) {
				ch = text.charAt(i);
				cc = ch.charCodeAt(0);
				charW = context.measureText(ch).width;
				if ((totalW + charW) > paraW) {
					if (totalW === wordW) {
						result++;
						totalW = 0;
						wordW = 0;
					} else {
						result++;
						totalW = wordW;
					}
				}
				totalW += charW;
				wordW += charW;

				switch (cc) {
					case 0xa:
					case 0xd:
						result++;
						totalW = 0;
						wordW = 0;
						break;
					case 0:
					case 0x9:
					case 0xc:
					case 0x20:
						wordW = 0;
						break;
				}
			}
			return (result * fontH) * 1.2;
		},
		generateXMLString: function (xmlDom) {
			var ee = xmlDom;
			if (!ee) {
				return "";
			}
			if (ee.nodeType === 3 || ee.nodeType === 8 || ee.nodeType === 4 || ee.nodeType === 7) {
				return ee.textContent;
			} else {
				if (ee.nodeName === "span" && ee.getAttribute("style") === "xfa-spacerun:yes") {
					return "<span>&nbsp;</span>";
				}
				var attr = "";
				for (var i = 0, ii = ee.attributes.length; i < ii; i++) {
					attr += " " + ee.attributes[i].nodeName + "=\"" + ee.attributes[i].nodeValue + "\"";
				}
				var cLen = ee.childNodes.length;
				if (cLen > 0) {
					var str = "<" + ee.nodeName + attr + ">";
					for (var i = 0; i < cLen; i++) {
						str += this.generateXMLString(ee.childNodes[i]);
					}
					str += "</" + ee.nodeName + ">";
					return str;
				} else {
					return "<" + ee.nodeName + attr + "/>";
				}
			}
		},
		recursiveReset: function (som) {
			var it;
			for (var i = 0, ii = som.nodes.length; i < ii; i++) {
				it = som.nodes.item(i);
				if (it._classHash === LCO.FIELD || it._classHash === LCO.EXCLGROUP) {
					it._rawValue = null;
				}
				this.recursiveReset(it);
			}
		},
		log: function (str) {
			console.log(str + " not defined");
		}
	};


	var FormCalc = {
		isZeroArgs: function (arr) {
			for (var i = 0, ii = arr.length; i < ii; i++) {
				if (!arr[i] || arr[i] > 0) {
					return false;
				}
			}
			return true;
		},
		isNumber: function (v) {
			return v !== null && v !== undefined && !isNaN(v);
		},
		getArgsArray: function (args) {
			var rr = [];
			for (var i = 0, ii = args.length; i < ii; i++) {
				if (args[i] !== null) {
					if (args[i] instanceof LCList) {
						for (var j = 0, jj = args[i].length; j < jj; j++) {
							if (args[i].item(j) !== null) {
								rr.push(args[i].item(j));
							}
						}
					} else {
						rr.push(args[i]);
					}
				}
			}
			return rr;
		},

		/*##############################################################################
		 *  Arithmetic Functions
		 *##############################################################################
		 */
		abs: function (n) {
			return LCU.isNumber(n) ? Math.abs(n) : null;
		},
		avg: function () {
			var sum = 0;
			var arr = FormCalc.getArgsArray(arguments);
			for (var i = 0; i < len; i++) {
				sum += arr[i];
			}
			return (sum / len);
		},
		ceil: function (n) {
			return LCU.isNumber(n) ? Math.ceil(n) : null;
		},
		count: function () {
			var arr = FormCalc.getArgsArray(arguments);
			return arr.length;
		},
		floor: function (n) {
			return LCU.isNumber(n) ? Math.floor(n) : null;
		},
		max: function () {
			var maxim = 0;
			var arr = FormCalc.getArgsArray(arguments);
			for (var i = 0, ii = arr.length; i < ii; i++) {
				maxim = Math.max(maxim, arr[i]);
			}
			return maxim;
		},
		min: function () {
			var mm = Number.MAX_VALUE;
			var arr = FormCalc.getArgsArray(arguments);
			for (var i = 0, ii = arr.length; i < ii; i++) {
				mm = Math.min(mm, arr[i]);
			}
			return mm;
		},
		mod: function (x, y) {
			return (x && y) ? (x % y) : null;
		},
		round: function () {
			var arr = FormCalc.getArgsArray(arguments);
			var nums = arr[0];
			if (!FormCalc.isNumber(nums)) {
				return 0;
			}
			var dec = arr.length === 2 ? arr[1] : 0;
			return Math.round(nums * Math.pow(10, dec)) / Math.pow(10, dec);
		},
		sum: function () {
			var total = 0;
			var arr = FormCalc.getArgsArray(arguments);
			for (var i = 0, ii = arr.length; i < ii; i++) {
				if (LCU.isNumber(arr[i])) {
					total += arr[i];
				}
			}
			return total;
		},
		date: function () {
			return Math.ceil((new Date().getTime() - new Date(1900, 0, 1).getTime()) / (24 * 60 * 60 * 1000));
		},
		date2num: function (str1, f1, k1) {
			if (f1) {
				var dLen = 2;
				var dIdx = f1.indexOf("DD");
				if (dIdx === -1) {
					dIdx = f1.indexOf("D");
					dLen = 1;
				}
				var mLen = 3;
				var mIdx = f1.indexOf("MMM");
				if (mIdx === -1) {
					mIdx = f1.indexOf("MM");
					mLen = 2;
					if (mIdx === -1) {
						mIdx = f1.indexOf("MM");
						mLen = 1;
					}
				}
				var yLen = 4;
				var yIdx = f1.indexOf("YYYY");
				if (yIdx === -1) {
					yIdx = f1.indexOf("YY");
					yLen = 2;
				}
				if (dIdx !== -1 && mIdx !== -1 && yIdx !== -1) {
					var d = (str1.substring(dIdx, dIdx + dLen));
					var m = (str1.substring(mIdx, mIdx + mLen));
					var y = (str1.substring(yIdx, yIdx + yLen));
					var d1 = new Date("1900/01/01");
					var d2 = new Date(y + "-" + m + "-" + d);
					return Math.round(1 + (d2.getTime() / (1000 * 60 * 60 * 24)
							- d1.getTime() / (1000 * 60 * 60 * 24)));
				}
			} else {
				var d1 = new Date("1900/01/01");
				var d2 = new Date(str1);
				return Math.round(1 + (d2.getTime() / (1000 * 60 * 60 * 24)
						- d1.getTime() / (1000 * 60 * 60 * 24)));
			}
			return 0;
		},
		datefmt: function (x) {
			var formats = ["med", "short", "med", "long", "full"];

//            var LOCALEFORMAT = {
//                "en-us" : ["MMM D, YYYY","M/D/YY", "YY-MM-DD", "MMMM D, YYYY"],
//                "en-uk" : ["", "DD/MM/YY", ""]
//            };

			if (x) {
				switch (x) {
					case 1:
						return;
					case 2:
						return;
					case 3:
						return;
					case 4:
						break;
				}
			}
			return "MMM D, YYYY";
		},
		isodate2num: function (str1, f1, k1) {
			if (f1) {
				var dLen = 2;
				var dIdx = f1.indexOf("DD");
				if (dIdx === -1) {
					dIdx = f1.indexOf("D");
					dLen = 1;
				}
				var mLen = 3;
				var mIdx = f1.indexOf("MMM");
				if (mIdx === -1) {
					mIdx = f1.indexOf("MM");
					mLen = 2;
					if (mIdx === -1) {
						mIdx = f1.indexOf("MM");
						mLen = 1;
					}
				}
				var yLen = 4;
				var yIdx = f1.indexOf("YYYY");
				if (yIdx === -1) {
					yIdx = f1.indexOf("YY");
					yLen = 2;
				}
				if (dIdx !== -1 && mIdx !== -1 && yIdx !== -1) {
					var d = (str1.substring(dIdx, dIdx + dLen));
					var m = (str1.substring(mIdx, mIdx + mLen));
					var y = (str1.substring(yIdx, yIdx + yLen));
					var d1 = new Date("1900/01/01");
					var d2 = new Date(y + "-" + m + "-" + d);
					return Math.round(1 + (d2.getTime() / (1000 * 60 * 60 * 24)
							- d1.getTime() / (1000 * 60 * 60 * 24)));
				}
			} else {
				var d1 = new Date("1900/01/01");
				var d2 = new Date(str1);
				return Math.round(1 + (d2.getTime() / (1000 * 60 * 60 * 24)
						- d1.getTime() / (1000 * 60 * 60 * 24)));
			}
			return 0;
		},
		localdatefmt: function (x, k1) {
			if (x) {
				switch (x) {
					case 1:
						return "M/D/YY";
					case 2:
						return "YY-MM-DD";
					case 3:
						return "MMMM D, YYYY";
					case 4:
						break;
				}
			}
			return "MMM D, YYYY";
		},
		localtimefmt: function (n1, k1) {
			LCU.log("LocalTimeFmt not implemented");
			return "HH:mm:ss";
		},
		num2date: function (n1, f1, k1) {
			LCU.log("Num2Date not implemented");
			return "01/01/1900";
		},
		num2gmttime: function (n1, f1, k1) {
			LCU.log("Num2GMTTime not implemented");
			return "00:00:00";
		},
		num2time: function (n1, f1, k1) {
			LCU.log("Num2Time not implemented");
			return "00:00:00";
		},
		time: function () {
			var d = new Date();
			return d.getTime();
		},
		time2num: function (d1, f1, k1) {
			LCU.log("Time2Num not implemented");
			return 0;
		},
		timefmt: function (n1, k1) {
			LCU.log("TimeFmt not implemented");
			return "HH:mm:ss";
		},
		/*##############################################################################
		 *  Financial Functions
		 *##############################################################################
		 */

		apr: function (principal, payment, periods) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			var maxIter = 500;
			var eps = 0.005;
			var delta = 0.0000001;
			var rr = 0.05;
			var nPmtZero = principal / periods;
			var nPmtCur = this.tempPmt(principal, rr, periods);
			var i = 1;

			do {
				if (Math.abs(nPmtCur - nPmtZero) < delta) {
					break;
				}
				rr *= (payment - nPmtZero) / (nPmtCur - nPmtZero);
				nPmtCur = this.tempPmt(principal, rr, periods);
			} while (!(++i > maxIter || Math.abs(payment - nPmtCur) < eps));

			return (Math.abs(nPmtCur - nPmtZero) < delta) ? 0 : 12 * rr;
		},
		tempPmt: function (nPrincipal, nInterest, nPeriods) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			var intRate = Math.pow((1 + nInterest), nPeriods);
			return (nPrincipal * nInterest / ((1 - 1 / intRate)));
		},
		cterm: function (r, fv, pv) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			return Math.log(fv / pv) / Math.log(1 + r);
		},
		fv: function (payment, r, periods) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			if (r === 0) {
				return payment * periods;
			} else {
				var intRate = Math.pow((1 + r), periods - 1);
				return payment * (1 + r) * (intRate - 1) / r + payment;
			}
		},
		ipmt: function (principal, rate, payment, startMon, nMonths) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			rate /= 12;
			startMon = parseInt(startMon);
			nMonths = parseInt(nMonths);
			if (payment <= principal * rate) {
				return 0;
			} else if (nMonths + startMon - 1 > LCMath.loanTerm(principal, rate, payment)) {
				return 0;
			} else {
				var principalRemaining = principal;
				var principalPaidInPeriod = 0;
				var ratePaidInPeriod = 0;
				for (var i = 1; i < startMon; i++) {
					ratePaidInPeriod = principalRemaining * rate;
					principalPaidInPeriod = payment - ratePaidInPeriod;
					principalRemaining -= principalPaidInPeriod;
					if (principalRemaining <= 0)
						break;
				}
				var ratePaid = 0.;
				for (var i = startMon; i < startMon + nMonths; i++) {
					ratePaidInPeriod = principalRemaining * rate;
					principalPaidInPeriod = payment - ratePaidInPeriod;
					principalRemaining -= principalPaidInPeriod;
					ratePaid += ratePaidInPeriod;
					if (principalRemaining <= 0)
						break;
				}
				return ratePaid;
			}
		},
		npv: function () {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			var rate = parseFloat(arguments[0]);
			var nVal = 0;
			var nDenom = 1;
			for (var i = 1; i < arguments.length; i++) {
				if (null === arguments[i]) {
					return null;
				}
				nDenom *= (1 + rate);
				nVal += parseFloat(arguments[i]) / nDenom;
			}
			return nVal;
		},
		pmt: function (prn, pr, prd) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			var payment = (pr * prn) / (1 - (Math.pow((1 + pr), -prd)));
			return Math.round(payment * Math.pow(10, 2)) / Math.pow(10, 2);
		},
		ppmt: function (prn, rate, payment, startMon, nMonths) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			prn = parseFloat(prn);
			rate = parseFloat(rate);
			payment = parseFloat(payment);
			startMon = parseInt(startMon);
			nMonths = parseInt(nMonths);

			rate /= 12;
			if (payment <= prn * rate) {
				return 0;
			} else if (nMonths + startMon - 1 > LCMath.loanTerm(prn, rate, payment)) {
				return 0;
			} else {
				var prnRemaining = prn;
				var prnPaidIperiod = 0;
				var rpp = 0;
				for (var i = 1; i < startMon; i++) {
					rpp = prnRemaining * rate;
					prnPaidIperiod = payment - rpp;
					prnRemaining -= prnPaidIperiod;
					if (prnRemaining <= 0) {
						break;
					}
				}
				var principlePaid = 0;
				for (var i = startMon; i < startMon + nMonths; i++) {
					rpp = prnRemaining * rate;
					prnPaidIperiod = payment - rpp;
					prnRemaining -= prnPaidIperiod;
					principlePaid += prnPaidIperiod;
					if (prnRemaining <= 0) {
						break;
					}
				}
				return principlePaid;
			}
			return 0;
		},
		pv: function (payment, rate, periods) {
			if (this.isZeroArgs(arguments) || payment === null || rate === null) {
				return null;
			}
			var pay = parseFloat(payment);
			var r = parseFloat(rate);
			var prd = parseInt(periods);
			if (r === 0) {
				return pay * prd;
			} else {
				var intRate = Math.pow((1 + r), prd);
				return pay * (1 - 1 / intRate) / r;
			}
		},
		rate: function (fv, pv, prd) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			return Math.exp(Math.log(parseFloat(fv) / parseFloat(pv)) / parseInt(prd)) - 1;
		},
		term: function (payment, rate, fv) {
			if (this.isZeroArgs(arguments)) {
				return null;
			}
			return fv <= payment ? 1 : Math.log((fv - payment) / payment * rate + (1 + rate)) / Math.log(1 + rate);
		},
		/*##############################################################################
		 *  Logical Functions
		 *##############################################################################
		 */

		choose: function () {
			var n1 = arguments[0];
			return arguments[n1];
		},
		exists: function (v) {
			if (FormCalc.isNumber(v) || v) {
				return 1;
			}
			return 0;
		},
		hasvalue: function (v) {
			return LCU.hasValue(v);
		},
		oneof: function () {
			var arr = FormCalc.getArgsArray(arguments);
			var ss = arr[0];
			for (var i = 1; i < arr.length; i++) {
				if (ss === arr[i]) {
					return true;
				}
			}
			return false;
		},
		within: function () {
			var arr = FormCalc.getArgsArray(arguments);
			return arr[1] < arr[0] && arr[2] > arr[0];
		},
		/*##############################################################################
		 *  String Functions
		 *##############################################################################
		 */

		at: function (s1, s2) {
			return s1.indexof(s2) + 1;
		},
		concat: function () {
			var arr = FormCalc.getArgsArray(arguments);
			var str = "";
			for (var i = 0, ii = arr.length; i < ii; i++) {
				str += arr[i];
			}
			return str;
		},
		decode: function (s1, s2) {
			if (s2 === "url") {
				return decodeURI(s1);
			} else if (s2 === "html" || s2 === "xml") {
				var HTML_SPECIAL_CHARS = {
					"gt": ">", "lt": "<", "apos": "'", "amp": "&",
					"nbsp": '\u00A0', "iexcl": '\u00A1', "cent": '\u00A2', "pound": '\u00A3',
					"curren": '\u00A4', "yen": '\u00A5', "brvbar": '\u00A6', "sect": '\u00A7',
					"uml": '\u00A8', "copy": '\u00A9', "ordf": '\u00AA', "laquo": '\u00AB',
					"not": '\u00AC', "shy": '\u00AD', "reg": '\u00AE', "macr": '\u00AF',
					"deg": '\u00B0', "plusmn": '\u00B1', "sup2": '\u00B2', "sup3": '\u00B3',
					"acute": '\u00B4', "micro": '\u00B5', "para": '\u00B6', "middot": '\u00B7',
					"cedil": '\u00B8', "sup1": '\u00B9', "ordm": '\u00BA', "raquo": '\u00BB',
					"frac14": '\u00BC', "frac12": '\u00BD', "frac34": '\u00BE', "iquest": '\u00BF',
					"Agrave": '\u00C0', "Aacute": '\u00C1', "Acirc": '\u00C2', "Atilde": '\u00C3',
					"Aum1": '\u00C4', "Aring": '\u00C5', "AElig": '\u00C6', "Ccedil": '\u00C7',
					"Egrave": '\u00C8', "Eacute": '\u00C9', "Ecirc": '\u00CA', "Eum1": '\u00CB',
					"Igrave": '\u00CC', "Iacute": '\u00CD', "Icirc": '\u00CE', "Ium1": '\u00CF',
					"ETH": '\u00D0', "Ntilde": '\u00D1', "Ograve": '\u00D2', "Oacute": '\u00D3',
					"Ocirc": '\u00D4', "Otilde": '\u00D5', "Oum1": '\u00D6', "times": '\u00D7',
					"Oslash": '\u00D8', "Ugrave": '\u00D9', "Uacute": '\u00DA', "Ucirc": '\u00DB',
					"Uum1": '\u00DC', "Yacute": '\u00DD', "THORN": '\u00DE', "szlig": '\u00DF',
					"agrave": '\u00E0', "aacute": '\u00E1', "acirc": '\u00E2', "atilde": '\u00E3',
					"aum1": '\u00E4', "aring": '\u00E5', "aelig": '\u00E6', "ccedil": '\u00E7',
					"egrave": '\u00E8', "eacute": '\u00E9', "ecirc": '\u00EA', "eum1": '\u00EB',
					"igrave": '\u00EC', "iacute": '\u00ED', "icirc": '\u00EE', "ium1": '\u00EF',
					"eth": '\u00F0', "ntilde": '\u00F1', "ograve": '\u00F2', "oacute": '\u00F3',
					"ocirc": '\u00F4', "otilde": '\u00F5', "oum1": '\u00F6', "divide": '\u00F7',
					"oslash": '\u00F8', "ugrave": '\u00F9', "uacute": '\u00FA', "ucirc": '\u00FB',
					"uum1": '\u00FC', "yacute": '\u00FD', "thorn": '\u00FE', "yum1": '\u00FF',
					"fnof": '\u0192', "Alpha": '\u0391', "Beta": '\u0392', "Gamma": '\u0393',
					"Delta": '\u0394'
				};

				var str = s1;

				str = str.replace(/&#([0-9]{1,3});/gi, function (match, numStr) {
					var num = parseInt(numStr, 10);
					return String.fromCharCode(num);
				});

				str = str.replace(/&([A-z]{1,8});/gi, function (match, charStr) {
					if (charStr in HTML_SPECIAL_CHARS) {
						return HTML_SPECIAL_CHARS[charStr];
					}
					return charStr;
				});
				return str;
			}
			return s1;
		},
		encode: function (s1, s2) {
			if (s2 === "url") {
				return encodeURI(s1);
			} else if (s2 === "html" || s2 === "xml") {
				var htmlStr = "";
				for (var i = 0; i < s1.length; i++) {
					var p = s1.charAt(i);
					p = escapeCharOther(p);
					htmlStr += p;
				}
				return htmlStr;
			}
			function escapeCharOther(original) {
				var HEX = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'];
				var thechar = original.charCodeAt(0);
				switch (thechar) {
					case 10:
						return "<br/>";
					case 13://carriage return has some special case;
						return "";
					case 32:
						return "&nbsp;";
					case 34:
						return "&quot;";
					case 38:
						return "&amp;";
					case 60:
						return "&lt;";
					case 62:
						return "&gt;";
				}

				if (thechar > 127) {
					var c = thechar;
					var a4 = c % 16;
					c = Math.floor(c / 16);
					var a3 = c % 16;
					c = Math.floor(c / 16);
					var a2 = c % 16;
					c = Math.floor(c / 16);
					var a1 = c % 16;
					return "&#x" + HEX[a1] + HEX[a2] + HEX[a3] + HEX[a4] + ";";
				} else {
					return original;
				}
			}
		},
		format: function () {
			var s1 = arguments[0]; //picture clause
			var s2 = arguments[1]; //YYYY[MM[DD]] or YYYY[-MM[-DD]]
			LCU.log("Format not implemented");
			return "";
		},
		left: function (s1, n1) {
			return s1.substring(0, n1);
		},
		len: function (s1) {
			var arr = FormCalc.getArgsArray(arguments);
			return arr.length;
		},
		lower: function (s1) {
			return s1.toLowerCase();
		},
		ltrim: function (s1) {
			return s1.replace(/^\s+/, "");
		},
		parse: function (s1, s2) {
			LCU.log("parse not implemented");
			return s2;
		},
		replace: function () {
			var s1 = arguments[0];
			var s2 = arguments[1];
			if (arguments.length === 3) {
				var s3 = arguments[2];
				return s1.replace(s2, s3);
			} else {
				return s1.replace(s2, "");
			}
		},
		right: function (s1, n1) {
			var len = s1.length;
			var maxRead = Math.min(len, n1);
			var result = "";
			for (var i = 0; i < maxRead; i++) {
				result = s1.charAt(len - i - 1) + result;
			}
			return result;
		},
		rtrim: function (s1) {
			var arr = FormCalc.getArgsArray(arguments);
			return arr[0] ? arr[0].replace(/\s+$/, "") : null;
		},
		space: function (s1) {
			var str = "";
			for (var i = 0; i < s1; i++) {
				str += " ";
			}
			return str;
		},
		str: function () {
			var result = "";
			var outLen = 10;
			var val = arguments[0];
			var strLen = val.length;
			switch (arguments.length) {
				case 1:
					if (strLen < outLen) {
						var gap = outLen - strLen;
						result = val;
						for (var i = 0; i < gap; i++) {
							result = " " + result;
						}
					} else {
						result = result.subString(0, outLen);
					}
					break;
				case 2:
					outLen = arguments[1];
					if (strLen < outLen) {
						var gap = outLen - strLen;
						result = val;
						for (var i = 0; i < gap; i++) {
							result = " " + result;
						}
					} else {
						result = result.subString(0, outLen);
					}
					break;
				case 3:
					outLen = arguments[1];
					LCU.log("Str not implemented");
					break;
			}
			return result;
		},
		stuff: function () {
			var s1 = arguments[0];
			var n1 = arguments[1];
			var n2 = arguments[2];

			if (arguments.length === 4) {
				var s2 = arguments[3];
				n1 = n1 < 1 ? 1 : n1;
				var prefix = s1.substring(0, n1 - 1);
				var suffix = s1.substring(n1 - 1, s1.length);
				var encSuff = suffix.substring(n2, suffix.length);
				return prefix + s2 + encSuff;
			} else {
				n1 = n1 < 1 ? 1 : n1;
				var prefix = s1.substring(0, n1 - 1);
				var suffix = s1.substring(n1 - 1, s1.length);
				var encSuff = suffix.substring(n2, suffix.length);
				return prefix + encSuff;
			}
		},
		substr: function (s1, n1, n2) {
			return s1.substring(n1 - 1, n1 + n2 - 1);
		},
		uuid: function () {
			return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(
					/[xy]/g,
					function (match) {
						var randomNibble = Math.random() * 16 | 0;
						var nibble = (match === 'y') ?
								(randomNibble & 0x3 | 0x8) :
								randomNibble;
						return nibble.toString(16);
					}
			);
		},
		upper: function (s1) {
			return s1.toUpperCase();
		},
		wordNum: function () {
			var Ones = new Array("Zero", "One", "Two", "Three", "Four", "Five", "Six",
					"Seven", "Eight", "Nine");
			var Teens = new Array("Ten", "Eleven", "Twelve", "Thirteen", "Fourteen",
					"Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen");
			var Tens = new Array("Zero", "Ten", "Twenty", "Thirty", "Forty", "Fifty",
					"Sixty", "Seventy", "Eighty", "Ninety", "Hundred");
			var Thousands = new Array("Thousand", "Million", "Billion", "Trillion",
					"Quadrillion", "Quintillion");
			var Cents = new Array("Cent");
			var Comma = new Array("");
			var Ands = new Array("", "And ");
			var Dollars = new Array("Dollar");
			var Space = " ";
			var Hyphen = "-";
			var QUINTILLION = 1000000000000000000;
			var n = arguments[0];
			var f = arguments[1];
			if (isNaN(n) || !isFinite(n) || n < 0) {
				return "xxxxxxxxxx";
			}
			if (f < 0 || 2 < f) {
				f = 0;
			}
			var dollars = n;
			var cents = Math.floor(((n - Math.floor(dollars) + 0.005) * 100));
			if (cents >= 100) {
				dollars += 1;
				cents -= 100;
			}
			var s = [];
			var thousands = 6;
			for (var div = QUINTILLION; div >= 1; div /= 1000) {
				var number = Math.floor(dollars / div);
				var hundreds = Math.floor(number / 100);
				var tens = Math.floor((number - hundreds * 100) / 10);
				var ones = Math.floor(number - hundreds * 100 - tens * 10);
				if (number >= 1) {
					dollars -= (div * number);
				}
				if (hundreds >= 1) {
					s.push(Ones[hundreds]);
					s.push(Space);
					s.push(Tens[10]);
					s.push(Space);
					if (tens > 0 || ones > 0)
						s.push(Ands[0]);
				}
				if (tens >= 1) {
					s.push((tens === 1) ? Teens[ones] : Tens[tens]);
					s.push((ones > 0 && tens !== 1) ? Hyphen : Space);
				}
				if (ones >= 1 && tens !== 1) {
					if (tens > 0 && ones > 0) {
						var o = Ones[ones];
						s.push(o.toLowerCase());
					} else {
						s.push(Ones[ones]);
					}
					s.push(Space);
				}
				thousands--;
				if (thousands >= 0 && number >= 1) {
					s.push(Thousands[thousands]);
					s.push(Comma[0]);
					s.push(Space);
				}
			}
			if (n < 1.) {
				s.push(Ones[0]);
				s.push(Space);
			}
			if (f === 1 || f === 2) {
				s.push(Dollars[0]);
				if (Math.floor(n) !== 1) {
					s.push('s');
				}
				if (f === 2) {
					s.push(Space);
					s.push(Ands[1]);
					var tens = Math.floor(cents / 10);
					var ones = Math.floor(cents - tens * 10);
					if (tens > 0) {
						s.push((tens === 1) ? Teens[ones] : Tens[tens]);
					}
					if (tens !== 1) {
						if (tens > 0 && ones > 0) {
							var o = Ones[ones];
							s.push(Hyphen);
							s.push(o.toLowerCase());
						} else if (tens === 0) {
							s.push(Ones[ones]);
						}
					}
					s.push(Space);
					s.push(Cents[0]);
					if (cents !== 1.)
						s.push('s');
				}
			}
			if (s[s.length - 1] === ' ') {
				s.pop();
			}
			return s.join("");
		},
		/*##############################################################################
		 *  URL Functions
		 *##############################################################################
		 */

		get: function () {
			var arr = FormCalc.getArgsArray(arguments);
			var s1 = arr[0];//url
			var s2 = arr[1];//parameters

			var xmlhttp;
			if (window) {
				if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
					xmlhttp = new XMLHttpRequest();
				} else {// code for IE6, IE5
					xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
				}
				xmlhttp.open("GET", s1, true);
//                xmlhttp.setRequestHeader("Content-type", s3);
//                xmlhttp.setRequestHeader("Content-type", s3+";charset="+s4);
				xmlhttp.send(s2);
			}
			return "";
		},
		post: function () {
			var arr = FormCalc.getArgsArray(arguments);
			var s1 = arr[0];//url
			var s2 = arr[1];//parameters

			var xmlhttp;
			if (window) {
				if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
					xmlhttp = new XMLHttpRequest();
				} else {// code for IE6, IE5
					xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
				}
				xmlhttp.open("POST", s1, true);
//                xmlhttp.setRequestHeader("Content-type", s3);
//                xmlhttp.setRequestHeader("Content-type", s3+";charset="+s4);
				xmlhttp.send(s2);
			}

			return "";
		},
		put: function () {
			LCU.log("put is not implemented yet");
		},
		/*##############################################################################
		 *  Miscellaneous Built-in Functions
		 *##############################################################################
		 */

		ref: function () {
			LCU.log("Ref is not implemented in javascript");
		},
		unittype: function (str) {
			if (str.indexOf("in") !== -1) {
				return "in";
			} else if (str.indexOf("mm") !== -1 || str.indexOf("millimeters") !== -1) {
				return "mm";
			} else if (str.indexOf("cm") !== -1 || str.indexOf("centimeters") !== -1) {
				return "cm";
			} else if (str.indexOf("mp") !== -1 || str.indexOf("millipoints") !== -1) {
				return "mp";
			} else {
				return "pt";
			}
		},
		unitvalue: function (str, name) {
			if (arguments.length === 1) {
				return parseInt(str);
			} else {
				if (name === "pt" || name === "points") {
					if (str.indexOf("in") !== -1) {
						return 72 * parseInt(str);
					} else if (str.indexOf("mm") !== -1 || str.indexOf("millimeters") !== -1) {
						return 2.83464 * parseInt(str);
					} else if (str.indexOf("cm") !== -1 || str.indexOf("centimeters") !== -1) {
						return 28.3464 * parseInt(str);
					} else if (str.indexOf("mp") !== -1 || str.indexOf("millipoints") !== -1) {
						return 1000 * parseInt(str);
					} else {
						return parseInt(str);
					}
				} else if (name === "in" || name === "inches") {
					if (str.indexOf("in") !== -1) {
						return parseInt(str);
					} else if (str.indexOf("mm") !== -1 || str.indexOf("millimeters") !== -1) {
						return 25.4 * parseInt(str);
					} else if (str.indexOf("cm") !== -1 || str.indexOf("centimeters") !== -1) {
						return 2.54 * parseInt(str);
					} else if (str.indexOf("mp") !== -1 || str.indexOf("millipoints") !== -1) {
						return 72571.42 * parseInt(str);
					} else {
						return 72 * parseInt(str);
					}
				} else if (name === "mm") {
					if (str.indexOf("in") !== -1) {
						return 25.4 * parseInt(str);
					} else if (str.indexOf("mm") !== -1 || str.indexOf("millimeters") !== -1) {
						return parseInt(str);
					} else if (str.indexOf("cm") !== -1 || str.indexOf("centimeters") !== -1) {
						return 10 * parseInt(str);
					} else if (str.indexOf("mp") !== -1 || str.indexOf("millipoints") !== -1) {
						return 0.0003528 * parseInt(str);
					} else {
						return 0.3528 * parseInt(str);
					}
				} else if (name === "cm" || name === "centimeters") {
					if (str.indexOf("in") !== -1) {
						return 2.54 * parseInt(str);
					} else if (str.indexOf("mm") !== -1 || str.indexOf("millimeters") !== -1) {
						return 0.1 * parseInt(str);
					} else if (str.indexOf("cm") !== -1 || str.indexOf("centimeters") !== -1) {
						return parseInt(str);
					} else if (str.indexOf("mp") !== -1 || str.indexOf("millipoints") !== -1) {
						return 0.000035 * parseInt(str);
					} else {
						return 0.035 * parseInt(str);
					}
				} else if (name === "mp" || name === "millipoints") {
					if (str.indexOf("in") !== -1) {
						return 72000 * parseInt(str);
					} else if (str.indexOf("mm") !== -1 || str.indexOf("millimeters") !== -1) {
						return 2834.65 * parseInt(str);
					} else if (str.indexOf("cm") !== -1 || str.indexOf("centimeters") !== -1) {
						return 28346.45 * parseInt(str);
					} else if (str.indexOf("mp") !== -1 || str.indexOf("millipoints") !== -1) {
						return parseInt(str);
					} else {
						return 0.001 * parseInt(str);
					}
				}
			}
		}
	};

	function LCList() {
		this._arr = [];
	}

	Object.defineProperty(LCList.prototype, "length", {
		get: function () {
			return this._arr.length;
		}, set: function (v) {
			this._arr.length = v;
		}
	});

	LCList.prototype.append = function (node) {
		this._arr.push(node);
	};

	LCList.prototype.insert = function (objParam1, objParam2) {
		var pos = -1;
		for (var i = 0, ii = this._arr.length; i < ii; i++) {
			if (this._arr[i] === objParam2) {
				pos = i;
				break;
			}
		}
		if (pos !== -1) {
			this._arr.splice(pos, 0, objParam1);
		} else {
			this._arr.push(objParam1);
		}
	};

	LCList.prototype.insertAfter = function (objParam1, objParam2) {
		var pos = -1;
		for (var i = 0, ii = this._arr.length; i < ii; i++) {
			if (this._arr[i] === objParam2) {
				pos = i;
				break;
			}
		}
		if (pos !== -1) {
			this._arr.splice(pos + 1, 0, objParam1);
		} else {
			this._arr.push(objParam1);
		}
	};

	LCList.prototype.item = function (i) {
		return this._arr[i];
	};

	LCList.prototype.replaceItem = function (obj, i) {
		return this._arr[i] = obj;
	};

	LCList.prototype.remove = function (objParam) {
		for (var i = 0, ii = this._arr.length; i < ii; i++) {
			if (objParam === this._arr[i]) {
				this._arr.splice(i, 1);
				break;
			}
		}
	};

	LCList.prototype.namedItem = function (str) {
		var strHash = LCMath.hash(str);
		for (var i = 0, ii = this._arr.length; i < ii; i++) {
			if (this._arr[i]._nameHash === strHash) {
				return this._arr[i];
			}
		}
		return null;
	};

	LCList.prototype.clear = function () {
		this._arr = [];
	};

//process convert xml to lcnodes
//insert name, nameHash x,y,w,h,min... and instance managers

	function LCBox() {
		this.x = 0;
		this.y = 0;
		this.w = 0;
		this.h = 0;
		this.minW = 0;
		this.minH = 0;
		this.maxW = 0;
		this.maxH = 0;
		this.marL = 0;
		this.marR = 0;
		this.marT = 0;
		this.marB = 0;
		this.capW = 0;
		this.capH = 0;
		this.resW = 0;
		this.calX = 0;
		this.calY = 0;
		this.calW = 0;
		this.calH = 0;
		this.temp = 0;
	}

	var somIdCount = 0;

	function LCNode(parentObj, cn) {
		this._somId = somIdCount++;
		this.parent = parentObj;
		this.className = cn;
		this.nodes = new LCList();
		this.isContainer = false;
		this._classHash = LCMath.hash(cn);
		this._nameHash = 0;
		this._propName = {};
		this._textStream = "";
		this._ns = "";
		this._box = null;
		this._layout = LCV.POSITION;
		this._rawValue = null;
		this._initialize = false;
		if (parentObj) {
			parentObj.nodes.append(this);
		}
	}

	Object.defineProperty(LCNode.prototype, "rawValue", {
		get: function () {
			if (this.parent._classHash === LCO.EXCLGROUP) {
				return this.parent._rawValue;
			}
			if (this._classHash === LCO.EXCLGROUP) {
				return this._rawValue;
			}

			if (LCU.isNumber(this._rawValue)) {
				var val = LCU.findChild(this, LCO.VALUE);
				var ui = LCU.findChild(this, LCO.UI);
				var intg = null;
				if (val) {
					intg = LCU.findChild(val, LCO.INTEGER);
				}
				if (ui) {
					for (var i = 0, ii = ui.nodes.length; i < ii; i++) {
						switch (ui.nodes.item(i)._classHash) {
							case LCO.NUMERICEDIT:
								if (intg) {
									return parseInt(this._rawValue);
								} else {
									return parseFloat(this._rawValue);
								}
						}
					}
				}
			}

			if (LCU.hasValue(this._rawValue)) {
				return this._rawValue;
			}

			var val = LCU.findChild(this, LCO.VALUE);
			var ui = LCU.findChild(this, LCO.UI);
			if (val && ui) {
				switch (LCU.getFieldType(this)) {
					case LCO.TEXTEDIT:
					case LCO.DATETIMEEDIT:
					case LCO.PASSWORDEDIT:
					case LCO.CHOICELIST:
						var t = LCU.findChild(val, LCO.TEXT);
						if (t) {
							return t._textStream;
						}
						var ex = LCU.findChild(val, LCO.EXDATA);
						if (ex) {
							var exv = ex._textStream.replace(/<\s*br[^>]?>/, '\n').replace(/(<([^>]+)>)/g, "");
							return exv;
						}
						break;
					case LCO.NUMERICEDIT:
						for (var i = 0, ii = val.nodes.length; i < ii; i++) {
							var n = val.nodes.item(i);
							switch (n._classHash) {
								case LCO.DECIMAL:
								case LCO.FLOAT:
									return parseFloat(n._textStream);
								case LCO.INTEGER:
									return parseInt(n._textStream);
							}
						}
						break;
					case LCO.CHECKBUTTON:
						if (this.parent._classHash === LCO.EXCLGROUP) {
							return this.parent.rawValue;
						} else {
							var ig = LCU.findChild(val, LCO.INTEGER);
							if (ig) {
								return ig._textStream;
							}
						}
						break;
					case LCO.IMAGEEDIT:
						var img = LCU.findChild(val, LCO.IMAGE);
						if (img && img._textStream.length > 0) {
							return img._textStream;
						}
						break;
				}
			}
			return null;
		},
		set: function (v) {
			if (this.parent._classHash === LCO.EXCLGROUP) {
				this.parent._rawValue = v;
			} else {
				this._rawValue = v;
			}

		}
	});

	function recursiveClone(orig, clone) {
		clone._nameHash = orig._nameHash;
		clone.isContainer = orig.isContainer;
		clone._textStream = orig._textStream;
		clone._layout = orig._layout;
		clone._propName = {};
		clone._rawValue = null;

		if (orig._box !== null) {
			clone._box = new LCBox();
			clone._box.x = orig._box.x;
			clone._box.y = orig._box.y;
			clone._box.w = orig._box.w;
			clone._box.h = orig._box.h;
			clone._box.minW = orig._box.minW;
			clone._box.minH = orig._box.minH;
			clone._box.maxW = orig._box.maxW;
			clone._box.maxH = orig._box.maxH;
			clone._box.marL = orig._box.marL;
			clone._box.marR = orig._box.marR;
			clone._box.marT = orig._box.marT;
			clone._box.marB = orig._box.marB;
			clone._box.capW = orig._box.capW;
			clone._box.capH = orig._box.capH;
			clone._box.resW = orig._box.resW;
		}

		for (var key in orig._propName) {
			clone._propName[key] = orig._propName[key];
		}

		for (var i = 0, ii = orig.nodes.length; i < ii; i++) {
			var childClone = new LCNode(clone, orig.nodes.item(i).className);
			recursiveClone(orig.nodes.item(i), childClone);
		}

		if (clone._classHash === LCO.SUBFORM && clone._nameHash !== 0) {
			clone.instanceHolder = orig.instanceHolder;
		}
	}

	function recursiveInstanceUpdate(som) {
		var ch;
		if (som._classHash !== LCO.PROTO) {
			for (var i = 0, ii = som.nodes.length; i < ii; i++) {
				ch = som.nodes.item(i);
				if (ch._classHash === LCO.SUBFORM && ch._nameHash !== 0) {
					var im = ch.instanceManager;
					if (im) {
						var m = im.min;
						var c = im.count;
						if (m > 0) {
							if (c === m) {
								ch.execInitialize();
							} else if (c < m) {
								for (var j = 0, jj = (m - c); j < jj; j++) {
									im.addInstance(1);
								}
							}
						}
					}
				}
			}
		}
		for (var i = 0, ii = som.nodes.length; i < ii; i++) {
			ch = som.nodes.item(i);
			recursiveInstanceUpdate(ch);
		}
	}

	function recursiveEventFire(som, eaHash) {
		var ch;
		for (var i = 0, ii = som.nodes.length; i < ii; i++) {
			ch = som.nodes.item(i);
			if (ch.isContainer) {
				var events = LCU.findChildren(ch, LCO.EVENT);
				for (var j = 0, jj = events.length; j < jj; j++) {
					var act = events.item(j).activity;
					if (LCMath.hash(act) === eaHash) {
						ch.execEventHash(eaHash);
					}
				}
				recursiveEventFire(ch, eaHash);
			}
		}
	}

	function recursiveMapXMLToSom(dom, som) {

		som.className = dom.nodeName;
		som._classHash = LCMath.hash(dom.nodeName);
				
		switch (som._classHash) {
			case LCO.SUBFORM:
			case LCO.SUBFORMSET:
			case LCO.AREA:
			case LCO.PAGEAREA:
			case LCO.PAGESET:
			case LCO.CONTENTAREA:
			case LCO.FIELD:
			case LCO.DRAW:
			case LCO.VARIABLES:
			case LCO.EXCLGROUP:
				som.isContainer = true;
				break;
			default:
				som.isContainer = false;
		}
		var attr;
		for (var i = 0, ii = dom.attributes.length; i < ii; i++) {
			attr = dom.attributes[i];
			som.setAttribute(attr.nodeName, attr.nodeValue);
		}
		var name = som.getAttribute("name");
		if (name.length > 0) {
			som._nameHash = LCMath.hash(name);
		}
		var layout = som.getAttribute("layout");
		if (layout.length > 0) {
			som._layout = LCMath.hash(layout);
		}

		if (som._classHash === LCO.SCRIPT) {
			var ct = som.contentType;
			if (ct === "application/x-javascript") {
				som._textStream = LCU.somScriptToJavascript(dom.textContent);
			} else {
				som._textStream = LCU.formCalcToJavascript(dom.textContent);
			}
		} else if (som._classHash === LCO.EXDATA) {
			var exC;
			for (var i = 0, max = dom.childNodes.length; i < max; i++) {
				if (dom.childNodes[i].nodeType === Node.ELEMENT_NODE) {
					exC = dom.childNodes[i];
					break;
				}
			}
			som._textStream = LCU.generateXMLString(exC);
		} else if (dom.childNodes.length === 1 && dom.childNodes[0].nodeType === 3) {
			som._textStream = dom.textContent;
		} else {

			if (som._classHash !== LCO.exData && som._classHash !== LCO.VARIABLES) {
				var ch;
				for (var i = 0, ii = dom.childNodes.length; i < ii; i++) {
					ch = dom.childNodes[i];
					if (ch.nodeType === 1) {
						var lc = new LCNode(som, ch.className);
						recursiveMapXMLToSom(ch, lc);
					}
				}
			}
		}

		if (som.isContainer) {
			som._box = new LCBox();
			som._box.x = LCMath.px(som.x);
			som._box.y = LCMath.px(som.y);
			som._box.w = LCMath.px(som.w);
			som._box.h = LCMath.px(som.h);
			som._box.minW = LCMath.px(som.minW);
			som._box.minH = LCMath.px(som.minH);
			som._box.maxW = LCMath.px(som.maxW);
			som._box.maxH = LCMath.px(som.maxH);

			var margin = LCU.findChild(som, LCO.MARGIN);
			if (margin) {
				som._box.marT = LCMath.px(margin.getAttribute("topInset"));
				som._box.marR = LCMath.px(margin.getAttribute("rightInset"));
				som._box.marB = LCMath.px(margin.getAttribute("bottomInset"));
				som._box.marL = LCMath.px(margin.getAttribute("leftInset"));
			}

			if (som._classHash === LCO.PAGEAREA) {
				var medium = LCU.findChild(som, LCO.MEDIUM);
				var pw, ph, t;
				if (medium) {
					pw = LCMath.px(medium.short);
					ph = LCMath.px(medium.long);
					if (medium.orientation === "landscape") {
						t = pw;
						pw = ph;
						ph = t;
					}
				} else {
					pw = 816;
					ph = 1056;
				}
				som._box.w = pw;
				som._box.h = ph;
			}
		}
		
		if (som._classHash === LCO.IMAGE) {
			var ct = som.contentType;
			if (som._textStream.length > 0 && ct === "image/tif" || ct === "image/tiff") {
				try{
					var enc = new FDFXFAENCODING();
					var b64 = enc.tiffToJpeg64(enc.b64ToBytes(som._textStream));
					var ct = "image/jpeg";
					som.contentType = ct;
					som._textStream = b64;
				}catch(err){
					
				}
			}
		}

		if (som._classHash === LCO.SUBFORM
				|| som._classHash === LCO.SUBFORMSET
				|| som._classHash === LCO.AREA
				|| som._classHash === LCO.TEMPLATE
				|| som._classHash === LCO.PAGESET
				|| som._classHash === LCO.PAGEAREA) {
			som.instanceHolder = new InstanceHolder(som);
		}
	}
	
	function recursiveMapDataToSom(dom, som) {
		var dn = dom.nodeName;
		if ((dom.getAttribute("xfa:dataNode") !== "dataGroup" && dom.childNodes.length === 0)
				|| (dom.childNodes.length === 1 && dom.childNodes[0].nodeType === 3)) {
			som.className = "dataValue";
			if (dom.childNodes.length === 1) {
				som._textStream = dom.childNodes[0].textContent;
			}
			if (dn.indexOf(":") > -1) {
				dn = dn.substring(dn.indexOf(":") + 1);
			}
		} else {
			if (dn === "xfa:datasets" || dn === "xfa:data") {
				som.className = dn;
				som._classHash = LCMath.hash(dn);
				if (dn === "xfa:data") {
					xfa.datasets.data = som;
				} else {
					xfa.datasets = som;
				}
			} else {
				som.className = "dataGroup";
				if (dn.indexOf(":") > -1) {
					dn = dn.substring(dn.indexOf(":") + 1);
				}
				var attr;
				for (var i = 0, ii = dom.attributes.length; i < ii; i++) {
					attr = dom.attributes[i];
					som.setAttribute(attr.nodeName, attr.nodeValue);
				}
			}
			var ch;
			for (var i = 0, ii = dom.childNodes.length; i < ii; i++) {
				ch = dom.childNodes[i];
				if (ch.nodeType === 1) {
					var lc = new LCNode(som, "dataGroup");
					recursiveMapDataToSom(ch, lc);
				}
			}
		}
		som.setAttribute("name", dn);
		som._nameHash = LCMath.hash(dn);
		som._classHash = LCMath.hash(som.className);
	}
	Object.defineProperty(LCNode.prototype, "all", {
		get: function () {
			var found = new LCList();
			var process = this.parent;
			while (process !== null) {
				for (var i = 0, ii = process.nodes.length; i < ii; i++) {
					var item = process.nodes.item(i);
					if (item._nameHash === this._nameHash) {
						found.append(item);
					}
				}
				if (found.length > 0) {
					break;
				}
				process = process.parent;
			}
			return found;
		}
	});
	Object.defineProperty(LCNode.prototype, "isWidget", {
		get: function () {
			return this._classHash === LCO.DRAW || this._classHash === LCO.FIELD;
		}
	});
	Object.defineProperty(LCNode.prototype, "classAll", {
		get: function () {
			var found = new LCList();
			var process = this.parent;
			while (process !== null) {
				for (var i = 0, ii = process.nodes.length; i < ii; i++) {
					var item = process.nodes.item(i);
					if (item._classHash === this._classHash) {
						found.append(item);
					}
				}
				if (found.length > 0) {
					break;
				}
				process = process.parent;
			}
			return found;
		}
	});
	Object.defineProperty(LCNode.prototype, "index", {
		get: function () {
			var found = -1;
			var count = 0;
			var process = this.parent;
			for (var i = 0, ii = process.nodes.length; i < ii; i++) {
				var item = process.nodes.item(i);
				if (item._somId === this._somId) {
					found = count;
					break;
				}
				if (item._nameHash === this._nameHash) {
					count++;
				}
			}
			return found;
		}
	});
	Object.defineProperty(LCNode.prototype, "classIndex", {
		get: function () {
			var found = -1, count = 0;
			var process = this.parent;
			for (var i = 0, ii = process.nodes.length; i < ii; i++) {
				var item = process.nodes.item(i);
				if (item === this) {
					found = count;
					break;
				}
				if (item._classHash === this._classHash) {
					count++;
				}
			}
			return found;
		}
	});
	Object.defineProperty(LCNode.prototype, "somExpression", {
		get: function () {
			LCU.log("somExpression");
			return "";
		}
	});
	Object.defineProperty(LCNode.prototype, "isNull", {
		get: function () {
			return this._textStream.length === 0 && this.nodes.length === 0;
		}
	});
	Object.defineProperty(LCNode.prototype, "applyXSL", {
		writable: true, enumerable: true, configurable: true,
		value: function (strParam) {
			LCU.log("applyXSL not implemented");
			return "";
		}
	});
	Object.defineProperty(LCNode.prototype, "assignNode", {
		writable: true, enumerable: true, configurable: true,
		value: function (strParam1, strParam2, intParam) {
			LCU.log("assignNode not implemented");
			return {};
		}
	});
	Object.defineProperty(LCNode.prototype, "clone", {
		writable: true, enumerable: true, configurable: true,
		value: function (boolParam) {
			var cloneObj = new LCNode(this.parent, this.className);
			recursiveClone(this, cloneObj);
			return cloneObj;
		}
	});
	Object.defineProperty(LCNode.prototype, "getAttribute", {
		writable: true, enumerable: true, configurable: true,
		value: function (str) {
			var v = this._propName[str];
			return v === undefined ? "" : v;
		}
	});
	Object.defineProperty(LCNode.prototype, "setAttribute", {
		writable: true, enumerable: true, configurable: true,
		value: function (str, vv) {
			this._propName[str] = vv;
		}
	});
	Object.defineProperty(LCNode.prototype, "isPropertySpecfied", {
		writable: true, enumerable: true, configurable: true,
		value: function (str) {
			return str in this._propName;
		}
	});
	Object.defineProperty(LCNode.prototype, "x", {
		get: function () {
			var vv = this.getAttribute("x");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.x = val;
			this.setAttribute("x", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "y", {
		get: function () {
			var vv = this.getAttribute("y");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.y = val;
			this.setAttribute("y", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "w", {
		get: function () {
			var vv = this.getAttribute("w");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.w = val;
			this.setAttribute("w", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "h", {
		get: function () {
			var vv = this.getAttribute("h");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.h = val;
			this.setAttribute("h", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "minH", {
		get: function () {
			var vv = this.getAttribute("minH");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.minH = val;
			this.setAttribute("minH", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "maxH", {
		get: function () {
			var vv = this.getAttribute("maxH");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.maxH = val;
			this.setAttribute("maxH", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "minW", {
		get: function () {
			var vv = this.getAttribute("minW");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.minW = val;
			this.setAttribute("minW", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "maxW", {
		get: function () {
			var vv = this.getAttribute("maxW");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.maxW = val;
			this.setAttribute("maxW", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "marginLeft", {
		get: function () {
			var vv = this.getAttribute("marginLeft");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.marL = val;
			this.setAttribute("marginLeft", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "marginRight", {
		get: function () {
			var vv = this.getAttribute("marginRight");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			var val = LCMath.px(v);
			this._box.marR = val;
			this.setAttribute("marginRight", val + LCPX);
		}
	});
	Object.defineProperty(LCNode.prototype, "access", {
		get: function () {
			var vv = this.getAttribute("access");
			return vv.length === 0 ? "open" : vv;
		}, set: function (v) {
			this.setAttribute("access", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "accessKey", {
		get: function () {
			var vv = this.getAttribute("accessKey");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("accessKey", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "action", {
		get: function () {
			var vv = this.getAttribute("action");
			return vv.length === 0 ? "include" : vv;
		}, set: function (v) {
			this.setAttribute("action", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "name", {
		get: function () {
			var nn = this.nodes.namedItem("name");
			if (nn) {
				return nn;
			}
			var vv = this.getAttribute("name");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this._nameHash = LCMath.hash(v);
			this.setAttribute("name", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "activity", {
		get: function () {
			var vv = this.getAttribute("activity");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("activity", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "addRevocationInfo", {
		get: function () {
			var vv = this.getAttribute("addRevocationInfo");
			return vv.length === 0 ? "required" : vv;
		}, set: function (v) {
			this.setAttribute("addRevocationInfo", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "after", {
		get: function () {
			var vv = this.getAttribute("after");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("after", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "afterTarget", {
		get: function () {
			var vv = this.getAttribute("afterTarget");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("afterTarget", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "aliasNode", {
		get: function () {
			var vv = this.getAttribute("aliasNode");
			return vv.length === 0 ? "form" : vv;
		}, set: function (v) {
			this.setAttribute("aliasNode", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "allowMacro", {
		get: function () {
			var vv = this.getAttribute("allowMacro");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("allowMacro", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "allowNeutral", {
		get: function () {
			var vv = this.getAttribute("allowNeutral");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("allowNeutral", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "allowRichText", {
		get: function () {
			var vv = this.getAttribute("allowRichText");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("allowRichText", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "anchorType", {
		get: function () {
			var vv = this.getAttribute("anchorType");
			return vv.length === 0 ? "topLeft" : vv;
		}, set: function (v) {
			this.setAttribute("anchorType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "appType", {
		get: function () {
			var vv = this.getAttribute("appType");
			return vv.length === 0 ? "Reader" : vv;
		}, set: function (v) {
			this.setAttribute("appType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "archive", {
		get: function () {
			var vv = this.getAttribute("archive");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("archive", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "aspect", {
		get: function () {
			var vv = this.getAttribute("aspect");
			return vv.length === 0 ? "fit" : vv;
		}, set: function (v) {
			this.setAttribute("aspect", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "baselineShift", {
		get: function () {
			var vv = this.getAttribute("baselineShift");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("baselineShift", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "before", {
		get: function () {
			var vv = this.getAttribute("before");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("before", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "beforeTarget", {
		get: function () {
			var vv = this.getAttribute("beforeTarget");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("beforeTarget", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "bind", {
		get: function () {
			var vv = this.getAttribute("bind");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("bind", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "binding", {
		get: function () {
			var vv = this.getAttribute("binding");
			return vv.length === 0 ? "xfa" : vv;
		}, set: function (v) {
			this.setAttribute("binding", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "blank", {
		get: function () {
			var vv = this.getAttribute("blank");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("blank", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "blankOrNotBlank", {
		get: function () {
			var vv = this.getAttribute("blankOrNotBlank");
			return vv.length === 0 ? "any" : vv;
		}, set: function (v) {
			this.setAttribute("blankOrNotBlank", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "bofAction", {
		get: function () {
			var vv = this.getAttribute("bofAction");
			return vv.length === 0 ? "moveLast" : vv;
		}, set: function (v) {
			this.setAttribute("bofAction", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "bookendLeader", {
		get: function () {
			var vv = this.getAttribute("bookendLeader");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("bookendLeader", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "bookendTrailer", {
		get: function () {
			var vv = this.getAttribute("bookendTrailer");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("bookendTrailer", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "borderColor", {
		get: function () {
			var border = LCU.findChild(this, LCO.BORDER);
			if (border) {
				var fill = LCU.findChild(border, LCO.FILL);
				if (fill) {
					var color = LCU.findChild(border, LCO.COLOR);
					if (color) {
						var val = color.getAttribute("value");
						if (val.length > 0) {
							return val;
						}
					}
				}
			}
			return "255,255,255";
		}, set: function (v) {
			var border = LCU.findChild(this, LCO.BORDER);
			if (!border) {
				border = new LCNode(this, "border");
			}
			var fill = LCU.findChild(border, LCO.FILL);
			if (!fill) {
				fill = new LCNode(border, "fill");
			}
			var color = LCU.findChild(border, LCO.COLOR);
			if (!color) {
				color = new LCNode(fill, "color");
			}
			fill.setAttribute("value", v);
			xfa.layout.thrashing = true;
		}
	});
	Object.defineProperty(LCNode.prototype, "borderWidth", {
		get: function () {
			var vv = this.getAttribute("borderWidth");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("borderWidth", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "bottomInset", {
		get: function () {
			var vv = this.getAttribute("bottomInset");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			if (this.parent.isContainer) {
				this.parent._box.marB = LCMath.px(v);
			}
			this.setAttribute("bottomInset", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "break", {
		get: function () {
			var vv = this.getAttribute("break");
			return vv.length === 0 ? "close" : vv;
		}, set: function (v) {
			this.setAttribute("break", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "calculationsEnabled", {
		get: function () {
			var vv = this.getAttribute("calculationEnabled");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("calculationsEnabled", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "cap", {
		get: function () {
			var vv = this.getAttribute("cap");
			return vv.length === 0 ? "square" : vv;
		}, set: function (v) {
			this.setAttribute("cap", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "change", {
		get: function () {
			var vv = this.getAttribute("change");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("change", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "charEncoding", {
		get: function () {
			var vv = this.getAttribute("charEncoding");
			return vv.length === 0 ? "UTF-8" : vv;
		}, set: function (v) {
			this.setAttribute("charEncoding", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "checksum", {
		get: function () {
			var vv = this.getAttribute("checksum");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("checksum", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "circular", {
		get: function () {
			var vv = this.getAttribute("circular");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("circular", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "codeBase", {
		get: function () {
			var vv = this.getAttribute("codeBase");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("codeBase", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "codeType", {
		get: function () {
			var vv = this.getAttribute("codeType");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("codeType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "colSpan", {
		get: function () {
			var vv = this.getAttribute("colSpan");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("colSpan", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "columnWidths", {
		get: function () {
			var vv = this.getAttribute("columnWidths");
			return vv.length === 0 ? "-1" : vv;
		}, set: function (v) {
			this.setAttribute("columnWidths", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "commandType", {
		get: function () {
			var vv = this.getAttribute("commandType");
			return vv.length === 0 ? "unknown" : vv;
		}, set: function (v) {
			this.setAttribute("commandType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "commitKey", {
		get: function () {
			var vv = this.getAttribute("commitKey");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("commitKey", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "commitOn", {
		get: function () {
			var vv = this.getAttribute("commitOn");
			return vv.length === 0 ? "select" : vv;
		}, set: function (v) {
			this.setAttribute("commitOn", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "connection", {
		get: function () {
			var vv = this.getAttribute("connection");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("connection", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "contains", {
		get: function () {
			var vv = this.getAttribute("contains");
			return vv.length === 0 ? "data" : vv;
		}, set: function (v) {
			this.setAttribute("contains", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "content", {
		get: function () {
			var vv = this.getAttribute("content");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("content", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "contentType", {
		get: function () {
			var vv = this.getAttribute("contentType");
			return vv.length === 0 ? "text/plain" : vv;
		}, set: function (v) {
			this.setAttribute("contentType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "context", {
		get: function () {
			var vv = this.getAttribute("context");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("context", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "credentialServerPolicy", {
		get: function () {
			var vv = this.getAttribute("credentialServerPolicy");
			return vv.length === 0 ? "Optional" : vv;
		}, set: function (v) {
			this.setAttribute("credentialServerPolicy", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "crlSign", {
		get: function () {
			var vv = this.getAttribute("crlSign");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("crlSign", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "cSpace", {
		get: function () {
			var vv = this.getAttribute("cSpace");
			return vv.length === 0 ? "SRGB" : vv;
		}, set: function (v) {
			this.setAttribute("cSpace", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "data", {
		get: function () {
			var vv = this.getAttribute("data");
			return vv.length === 0 ? "embed" : vv;
		}, set: function (v) {
			this.setAttribute("data", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "dataColumnCount", {
		get: function () {
			var vv = this.getAttribute("dataColumnCount");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("dataColumnCount", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "dataDescription", {
		get: function () {
			var vv = this.getAttribute("dataDescription");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("dataDescription", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "dataEncipherment", {
		get: function () {
			var vv = this.getAttribute("dataEncipherment");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("dataEncipherment", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "dataLength", {
		get: function () {
			var vv = this.getAttribute("dataLength");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("dataLength", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "dataPrep", {
		get: function () {
			var vv = this.getAttribute("dataPrep");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("dataPrep", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "dataRowCount", {
		get: function () {
			var vv = this.getAttribute("dataRowCount");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("dataRowCount", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "db", {
		get: function () {
			var vv = this.getAttribute("db");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("db", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "decipherOnly", {
		get: function () {
			var vv = this.getAttribute("decipherOnly");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("decipherOnly", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "delayedOpen", {
		get: function () {
			var vv = this.getAttribute("delayedOpen");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("delayedOpen", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "delimiter", {
		get: function () {
			var vv = this.getAttribute("delimiter");
			return vv.length === 0 ? "," : vv;
		}, set: function (v) {
			this.setAttribute("delimiter", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "digitalSignature", {
		get: function () {
			var vv = this.getAttribute("digitalSignature");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("digitalSignature", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "disable", {
		get: function () {
			var vv = this.getAttribute("disable");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("disable", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "editValue", {
		get: function () {
			return this.rawValue;
		}, set: function (v) {
			this.rawValue = v;
		}
	});
	Object.defineProperty(LCNode.prototype, "embedPDF", {
		get: function () {
			var vv = this.getAttribute("embedPDF");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("embedPDF", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "encipherOnly", {
		get: function () {
			var vv = this.getAttribute("encipherOnly");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("encipherOnly", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "endChar", {
		get: function () {
			var vv = this.getAttribute("endChar");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("endChar", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "eofAction", {
		get: function () {
			var vv = this.getAttribute("eofAction");
			return vv.length === 0 ? "moveLast" : vv;
		}, set: function (v) {
			this.setAttribute("eofAction", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "errorCorrectionLevel", {
		get: function () {
			var vv = this.getAttribute("errorCorrectionLevel");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("errorCorrectionLevel", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "executeType", {
		get: function () {
			var vv = this.getAttribute("executeType");
			return vv.length === 0 ? "import" : vv;
		}, set: function (v) {
			this.setAttribute("executeType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "fillColor", {
		get: function () {
			var border = LCU.findChild(this, LCO.BORDER);
			if (border) {
				var fill = LCU.findChild(border, LCO.FILL);
				if (fill) {
					var color = LCU.findChild(border, LCO.COLOR);
					if (color) {
						var val = color.getAttribute("value");
						if (val.length > 0) {
							return val;
						}
					}
				}
			}
			return "255,255,255";
		}, set: function (v) {
			var border = LCU.findChild(this, LCO.BORDER);
			if (!border) {
				border = new LCNode(this, "border");
			}
			var fill = LCU.findChild(border, LCO.FILL);
			if (!fill) {
				fill = new LCNode(border, "fill");
			}
			var color = LCU.findChild(border, LCO.COLOR);
			if (!color) {
				color = new LCNode(fill, "color");
			}
			fill.setAttribute("value", v);
			xfa.layout.thrashing = true;
		}
	});
	Object.defineProperty(LCNode.prototype, "fontColor", {
		get: function () {
			var vv = this.getAttribute("fontColor");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("fontColor", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "format", {
		get: function () {
			var vv = this.getAttribute("format");
			if (vv.length === 0) {
				switch (this._classHash) {
					case LCO.ENCRYPT:
						return "pdfEnvelope";
					default:
						return "xdp";
				}
			} else {
				return vv;
			}
		}, set: function (v) {
			this.setAttribute("format", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "formatMessage", {
		get: function () {
			var vv = this.getAttribute("formatMessage");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("formatMessage", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "formattedValue", {
		get: function () {
			var vv = this.getAttribute("formattedValue");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("formattedValue", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "formatTest", {
		get: function () {
			var vv = this.getAttribute("formatTest");
			return vv.length === 0 ? "warning" : vv;
		}, set: function (v) {
			this.setAttribute("formatTest", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "fracDigits", {
		get: function () {
			var vv = this.getAttribute("fracDigits");
			;
			return vv.length === 0 ? "2" : vv;
		}, set: function (v) {
			this.setAttribute("fracDigits", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "from", {
		get: function () {
			var vv = this.getAttribute("from");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("from", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "hAlign", {
		get: function () {
			var vv = this.getAttribute("hAlign");
			return vv.length === 0 ? "left" : vv;
		}, set: function (v) {
			this.setAttribute("hAlign", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "hand", {
		get: function () {
			var vv = this.getAttribute("hand");
			return vv.length === 0 ? "even" : vv;
		}, set: function (v) {
			this.setAttribute("hand", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "highlight", {
		get: function () {
			var vv = this.getAttribute("highlight");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("highlight", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "href", {
		get: function () {
			var vv = this.getAttribute("href");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("href", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "hScrollPolicy", {
		get: function () {
			var vv = this.getAttribute("hScrollPolicy");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("hScrollPolicy", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "id", {
		get: function () {
			var vv = this.getAttribute("id");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("id", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "imagingBBox", {
		get: function () {
			var vv = this.getAttribute("imagingBox");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("imagingBBox", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "initial", {
		get: function () {
			var vv = this.getAttribute("initial");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("initial", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "initialNumber", {
		get: function () {
			var vv = this.getAttribute("initialNumber");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("initialNumber", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "input", {
		get: function () {
			var vv = this.getAttribute("input");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("input", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "instanceIndex", {
		get: function () {
			var vv = this.getAttribute("instanceIndex");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("instanceIndex", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "intact", {
		get: function () {
			var vv = this.getAttribute("intact");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("intact", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "inverted", {
		get: function () {
			var vv = this.getAttribute("inverted");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("inverted", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "isDefined", {
		get: function () {
			var vv = this.getAttribute("isDefined");
			return vv.length === 0 ? true : vv;
		}, set: function (v) {
			this.setAttribute("isDefined", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "join", {
		get: function () {
			var vv = this.getAttribute("join");
			return vv.length === 0 ? "square" : vv;
		}, set: function (v) {
			this.setAttribute("join", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "keyAgreement", {
		get: function () {
			var vv = this.getAttribute("keyAgreement");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("keyAgreement", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "keyCertSign", {
		get: function () {
			var vv = this.getAttribute("keyCertSign");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("keyCertSign", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "keyEncipherment", {
		get: function () {
			var vv = this.getAttribute("keyEncipherment");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("keyEncipherment", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "labelRef", {
		get: function () {
			var vv = this.getAttribute("labelRef");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("labelRef", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "language", {
		get: function () {
			var vv = this.getAttribute("language");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("language", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "layout", {
		get: function () {
			var vv = this.getAttribute("layout");
			return vv.length === 0 ? "position" : vv;
		}, set: function (v) {
			this.setAttribute("layout", v);
			this._layout = LCMath.hash(v);
		}
	});
	Object.defineProperty(LCNode.prototype, "leadDigits", {
		get: function () {
			var vv = this.getAttribute("leadDigits");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("leadDigits", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "leader", {
		get: function () {
			var vv = this.getAttribute("leader");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("leader", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "leftInset", {
		get: function () {
			var vv = this.getAttribute("leftInset");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			if (this.parent.isContainer) {
				this.parent._box.marL = LCMath.px(v);
			}
			this.setAttribute("leftInset", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "lineHeight", {
		get: function () {
			var vv = this.getAttribute("lineHeight");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("lineHeight", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "lineThrough", {
		get: function () {
			var vv = this.getAttribute("lineThrough");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("lineThrough", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "lineThroughPeriod", {
		get: function () {
			var vv = this.getAttribute("lineThroughPeriod");
			return vv.length === 0 ? "all" : vv;
		}, set: function (v) {
			this.setAttribute("lineThroughPeriod", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "locale", {
		get: function () {
			var vv = this.getAttribute("locale");
			return vv.length === 0 ? "ambient" : vv;
		}, set: function (v) {
			this.setAttribute("locale", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "lockType", {
		get: function () {
			var vv = this.getAttribute("lockType");
			return vv.length === 0 ? "unspecified" : vv;
		}, set: function (v) {
			this.setAttribute("lockType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "long", {
		get: function () {
			var vv = this.getAttribute("long");
			return vv.length === 0 ? "1056" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("long", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "mandatory", {
		get: function () {
			var vv = this.getAttribute("mandatory");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("mandatory", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "mandatoryMessage", {
		get: function () {
			var vv = this.getAttribute("mandatoryMessage");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("mandatoryMessage", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "mark", {
		get: function () {
			var vv = this.getAttribute("mark");
			return vv.length === 0 ? "default" : vv;
		}, set: function (v) {
			this.setAttribute("mark", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "match", {
		get: function () {
			var vv = this.getAttribute("match");
			return vv.length === 0 ? "once" : vv;
		}, set: function (v) {
			this.setAttribute("match", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "max", {
		get: function () {
			var vv = this.getAttribute("max");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("max", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "maxChars", {
		get: function () {
			var vv = this.getAttribute("maxChars");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("maxChars", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "maxLength", {
		get: function () {
			var vv = this.getAttribute("maxLength");
			return vv.length === 0 ? "-1" : vv;
		}, set: function (v) {
			this.setAttribute("maxLength", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "min", {
		get: function () {
			var vv = this.getAttribute("min");
			return vv.length === 0 ? "1" : vv;
		}, set: function (v) {
			this.setAttribute("min", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "moduleHeight", {
		get: function () {
			var vv = this.getAttribute("moduleHeight");
			return vv.length === 0 ? "5mm" : vv;
		}, set: function (v) {
			this.setAttribute("moduleHeight", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "moduleWidth", {
		get: function () {
			var vv = this.getAttribute("moduleWidth");
			return vv.length === 0 ? "0.25mm" : vv;
		}, set: function (v) {
			this.setAttribute("moduleWidth", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "multiLine", {
		get: function () {
			var vv = this.getAttribute("multiLine");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("multiLine", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "next", {
		get: function () {
			var vv = this.getAttribute("next");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("next", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "nonRepudiation", {
		get: function () {
			var vv = this.getAttribute("nonRepudiation");
			return vv.length === 0 ? "Yes" : vv;
		}, set: function (v) {
			this.setAttribute("nonRepudiation", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "nullTest", {
		get: function () {
			var vv = this.getAttribute("nullTest");
			return vv.length === 0 ? "disabled" : vv;
		}, set: function (v) {
			this.setAttribute("nullTest", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "numbered", {
		get: function () {
			var vv = this.getAttribute("numbered");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("numbered", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "numberOfCells", {
		get: function () {
			var vv = this.getAttribute("numberOfCells");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("numberOfCells", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "oddOrEven", {
		get: function () {
			var vv = this.getAttribute("oddOrEven");
			return vv.length === 0 ? "any" : vv;
		}, set: function (v) {
			this.setAttribute("oddOrEven", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "open", {
		get: function () {
			var vv = this.getAttribute("open");
			return vv.length === 0 ? "userControl" : vv;
		}, set: function (v) {
			this.setAttribute("open", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "operation", {
		get: function () {
			var vv = this.getAttribute("operation");
			return vv.length === 0 ? "next" : vv;
		}, set: function (v) {
			this.setAttribute("operation", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "orientation", {
		get: function () {
			var vv = this.getAttribute("orientation");
			return vv.length === 0 ? "portrait" : vv;
		}, set: function (v) {
			this.setAttribute("orientation", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "output", {
		get: function () {
			var vv = this.getAttribute("output");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("output", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "overflowLeader", {
		get: function () {
			var vv = this.getAttribute("overflowLeader");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("overflowLeader", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "overflowTarget", {
		get: function () {
			var vv = this.getAttribute("overflowTarget");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("overflowTarget", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "overflowTrailer", {
		get: function () {
			var vv = this.getAttribute("overflowTrailer");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("overflowTrailer", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "overline", {
		get: function () {
			var vv = this.getAttribute("overline");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("overline", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "overlinePeriod", {
		get: function () {
			var vv = this.getAttribute("overlinePeriod");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("overlinePeriod", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "override", {
		get: function () {
			var vv = this.getAttribute("override");
			return vv.length === 0 ? "error" : vv;
		}, set: function (v) {
			this.setAttribute("override", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "pagePosition", {
		get: function () {
			var vv = this.getAttribute("pagePosition");
			return vv.length === 0 ? "any" : vv;
		}, set: function (v) {
			this.setAttribute("pagePosition", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "passwordChar", {
		get: function () {
			var vv = this.getAttribute("passwordChar");
			return vv.length === 0 ? "*" : vv;
		}, set: function (v) {
			this.setAttribute("passwordChar", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "permissions", {
		get: function () {
			var vv = this.getAttribute("permissions");
			return vv.length === 0 ? "2" : vv;
		}, set: function (v) {
			this.setAttribute("permissions", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "placement", {
		get: function () {
			var vv = this.getAttribute("placement");
			return vv.length === 0 ? "left" : vv;
		}, set: function (v) {
			this.setAttribute("placement", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "platform", {
		get: function () {
			var vv = this.getAttribute("platform");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("platform", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "posture", {
		get: function () {
			var vv = this.getAttribute("posture");
			return vv.length === 0 ? "normal" : vv;
		}, set: function (v) {
			this.setAttribute("posture", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "presence", {
		get: function () {
			var vv = this.getAttribute("presence");
			return vv.length === 0 ? "visible" : vv;
		}, set: function (v) {
			xfa.layout.thrashing = true;
			this.setAttribute("presence", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "preserve", {
		get: function () {
			var vv = this.getAttribute("preserve");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("preserve", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "previous", {
		get: function () {
			var vv = this.getAttribute("previous");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("previous", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "printCheckDigit", {
		get: function () {
			var vv = this.getAttribute("printCheckDigit");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("printCheckDigit", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "priority", {
		get: function () {
			var vv = this.getAttribute("priority");
			return vv.length === 0 ? "custom" : vv;
		}, set: function (v) {
			this.setAttribute("priority", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "radius", {
		get: function () {
			var vv = this.getAttribute("radius");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("radius", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "radixOffset", {
		get: function () {
			var vv = this.getAttribute("radixOffset");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("radixOffset", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "rate", {
		get: function () {
			var vv = this.getAttribute("rate");
			return vv.length === 0 ? "50" : vv;
		}, set: function (v) {
			this.setAttribute("rate", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "ref", {
		get: function () {
			var vv = this.getAttribute("ref");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("ref", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "relation", {
		get: function () {
			var vv = this.getAttribute("relation");
			return vv.length === 0 ? "ordered" : vv;
		}, set: function (v) {
			this.setAttribute("relation", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "relevant", {
		get: function () {
			var vv = this.getAttribute("relevant");
			return vv.length === 0 ? "print" : vv;
		}, set: function (v) {
			this.setAttribute("relevant", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "reserve", {
		get: function () {
			var vv = this.getAttribute("reserve");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("reserve", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "restoreState", {
		get: function () {
			var vv = this.getAttribute("restoreState");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("restoreState", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "rightInset", {
		get: function () {
			var vv = this.getAttribute("rightInset");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			if (this.parent.isContainer) {
				this.parent._box.marR = LCMath.px(v);
			}
			this.setAttribute("rightInset", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "role", {
		get: function () {
			var vv = this.getAttribute("role");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("role", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "rotate", {
		get: function () {
			var vv = this.getAttribute("rotate");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("rotate", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "rowColumnRatio", {
		get: function () {
			var vv = this.getAttribute("rowColumnRation");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("rowColumnRatio", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "runAt", {
		get: function () {
			var vv = this.getAttribute("runAt");
			return vv.length === 0 ? "client" : vv;
		}, set: function (v) {
			this.setAttribute("runAt", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "save", {
		get: function () {
			var vv = this.getAttribute("save");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("save", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "savedValue", {
		get: function () {
			var vv = this.getAttribute("savedValue");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("savedValue", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "scope", {
		get: function () {
			var vv = this.getAttribute("scope");
			return vv.length === 0 ? "name" : vv;
		}, set: function (v) {
			this.setAttribute("scope", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "scriptTest", {
		get: function () {
			var vv = this.getAttribute("scriptTest");
			return vv.length === 0 ? "error" : vv;
		}, set: function (v) {
			this.setAttribute("scriptTest", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "server", {
		get: function () {
			var vv = this.getAttribute("server");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("server", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "shape", {
		get: function () {
			var vv = this.getAttribute("shape");
			return vv.length === 0 ? "square" : vv;
		}, set: function (v) {
			this.setAttribute("shape", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "short", {
		get: function () {
			var vv = this.getAttribute("short");
			return vv.length === 0 ? "816" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("short", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "signatureType", {
		get: function () {
			var vv = this.getAttribute("signatureType");
			return vv.length === 0 ? "filler" : vv;
		}, set: function (v) {
			this.setAttribute("signatureType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "size", {
		get: function () {
			var vv = this.getAttribute("size");
			return vv.length === 0 ? "13.33" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("size", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "slope", {
		get: function () {
			var vv = this.getAttribute("slope");
			return vv.length === 0 ? "\\" : vv;
		}, set: function (v) {
			this.setAttribute("slope", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "soapFaultCode", {
		get: function () {
			var vv = this.getAttribute("soapFaultCode");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("soapFaultCode", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "soapFaultString", {
		get: function () {
			var vv = this.getAttribute("soapFaultString");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("soapFaultString", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "spaceAbove", {
		get: function () {
			var vv = this.getAttribute("spaceAbove");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("spaceAbove", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "spaceBelow", {
		get: function () {
			var vv = this.getAttribute("spaceBelow");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("spaceBelow", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "startAngle", {
		get: function () {
			var vv = this.getAttribute("startAngle");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("startAngle", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "startChar", {
		get: function () {
			var vv = this.getAttribute("startChar");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("startChar", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "startNew", {
		get: function () {
			var vv = this.getAttribute("startNew");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("startNew", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "stateless", {
		get: function () {
			var vv = this.getAttribute("stateless");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("stateless", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "stock", {
		get: function () {
			var vv = this.getAttribute("stock");
			return vv.length === 0 ? "letter" : vv;
		}, set: function (v) {
			this.setAttribute("stock", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "stroke", {
		get: function () {
			var vv = this.getAttribute("stroke");
			return vv.length === 0 ? "solid" : vv;
		}, set: function (v) {
			this.setAttribute("stroke", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "sweepAngle", {
		get: function () {
			var vv = this.getAttribute("sweepAngle");
			return vv.length === 0 ? "360" : vv;
		}, set: function (v) {
			this.setAttribute("sweepAngle", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "tabDefault", {
		get: function () {
			var vv = this.getAttribute("tabDefault");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("tabDefault", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "tabStops", {
		get: function () {
			var vv = this.getAttribute("tabStops");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("tabStops", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "target", {
		get: function () {
			var vv = this.getAttribute("target");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("target", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "targetType", {
		get: function () {
			var vv = this.getAttribute("targetType");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("targetType", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "textEncoding", {
		get: function () {
			var vv = this.getAttribute("textEncoding");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("textEncoding", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "textEntry", {
		get: function () {
			var vv = this.getAttribute("textEntry");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("textEntry", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "textIndent", {
		get: function () {
			var vv = this.getAttribute("textIndent");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("textIndent", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "textLocation", {
		get: function () {
			var vv = this.getAttribute("textLocation");
			return vv.length === 0 ? "below" : vv;
		}, set: function (v) {
			this.setAttribute("textLocation", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "thickness", {
		get: function () {
			var vv = this.getAttribute("thickness");
			return vv.length === 0 ? "0.66" + LCPX : vv;
		}, set: function (v) {
			this.setAttribute("thickness", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "timeout", {
		get: function () {
			var vv = this.getAttribute("timeout");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("timeout", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "timeStamp", {
		get: function () {
			var vv = this.getAttribute("timeStamp");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("timeStamp", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "topInset", {
		get: function () {
			var vv = this.getAttribute("topInset");
			return vv.length === 0 ? "0" + LCPX : vv;
		}, set: function (v) {
			if (this.parent.isContainer) {
				this.parent._box.marT = LCMath.px(v);
			}
			this.setAttribute("topInset", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "trailer", {
		get: function () {
			var vv = this.getAttribute("trailer");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("trailer", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "transferEncoding", {
		get: function () {
			var vv = this.getAttribute("transferEncoding");
			return vv.length === 0 ? "none" : vv;
		}, set: function (v) {
			this.setAttribute("transferEncoding", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "transient", {
		get: function () {
			var vv = this.getAttribute("transient");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("transient", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "truncate", {
		get: function () {
			var vv = this.getAttribute("truncate");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("truncate", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "type", {
		get: function () {
			var vv = this.getAttribute("type");
			return vv.length === 0 ? "toRight" : vv;
		}, set: function (v) {
			this.setAttribute("type", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "typeface", {
		get: function () {
			var vv = this.getAttribute("typeface");
			return vv.length === 0 ? "Courier" : vv;
		}, set: function (v) {
			this.setAttribute("typeface", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "underline", {
		get: function () {
			var vv = this.getAttribute("underline");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("underline", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "underlinePeriod", {
		get: function () {
			var vv = this.getAttribute("underlinePeriod");
			return vv.length === 0 ? "all" : vv;
		}, set: function (v) {
			this.setAttribute("underlinePeriod", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "upsMode", {
		get: function () {
			var vv = this.getAttribute("upsMode");
			return vv.length === 0 ? "usCarrier" : vv;
		}, set: function (v) {
			this.setAttribute("upsMode", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "url", {
		get: function () {
			var vv = this.getAttribute("url");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("url", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "urlPolicy", {
		get: function () {
			var vv = this.getAttribute("urlPolicy");
			return vv.length === 0 ? "enrollmentServer" : vv;
		}, set: function (v) {
			this.setAttribute("urlPolicy", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "usage", {
		get: function () {
			var vv = this.getAttribute("usage");
			return vv.length === 0 ? "exportAndImport" : vv;
		}, set: function (v) {
			this.setAttribute("usage", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "use", {
		get: function () {
			var vv = this.getAttribute("use");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("use", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "usehref", {
		get: function () {
			var vv = this.getAttribute("usehref");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("usehref", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "uuid", {
		get: function () {
			var vv = this.getAttribute("uuid");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("uuid", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "validationMessage", {
		get: function () {
			var vv = this.getAttribute("validationMessage");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("validationMessage", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "validationsEnabled", {
		get: function () {
			var vv = this.getAttribute("validationEnabled");
			return vv.length === 0 ? "0" : vv;
		}, set: function (v) {
			this.setAttribute("validationsEnabled", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "vAlign", {
		get: function () {
			var vv = this.getAttribute("vAlign");
			return vv.length === 0 ? "top" : vv;
		}, set: function (v) {
			this.setAttribute("vAlign", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "value", {
		get: function () {
			switch (this._classHash) {
				case LCO.BOOLEAN:
					return this._textStream === "true" || this._textStream === "TRUE";
				case LCO.DECIMAL:
				case LCO.FLOAT:
					return parseFloat(this._textStream);
					break;
				case LCO.INTEGER:
					return parseInt(this._textStream);
				case LCO.IMAGE:
				case LCO.PICTURE:
				case LCO.SCRIPT:
				case LCO.TEXT:
					return this._textStream;
				case LCO.DATE:
				case LCO.DATETIME:
				case LCO.TIME:
					return this._textStream;
				case LCO.COLOR:
					var vv = this.getAttribute("value");
					return vv.length === 0 ? "255,255,255" : vv;
			}
			return null;
		}, set: function (v) {
			switch (this._classHash) {
				case LCO.BOOLEAN:
				case LCO.DECIMAL:
				case LCO.FLOAT:
				case LCO.INTEGER:
				case LCO.IMAGE:
				case LCO.PICTURE:
				case LCO.SCRIPT:
				case LCO.TEXT:
				case LCO.DATE:
				case LCO.DATETIME:
				case LCO.TIME:
					this._textStream = "" + v;
					break;
				case LCO.COLOR:
					this.getAttribute("value", v);
					break;
			}
		}
	});
	Object.defineProperty(LCNode.prototype, "valueRef", {
		get: function () {
			var vv = this.getAttribute("valueRef");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("valueRef", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "variation", {
		get: function () {
			var vv = this.getAttribute("variation");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("variation", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "version", {
		get: function () {
			var vv = this.getAttribute("version");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("version", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "vScollPolicy", {
		get: function () {
			var vv = this.getAttribute("vScrollPolicy");
			return vv.length === 0 ? "auto" : vv;
		}, set: function (v) {
			this.setAttribute("vScollPolicy", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "weight", {
		get: function () {
			var vv = this.getAttribute("weight");
			return vv.length === 0 ? "normal" : vv;
		}, set: function (v) {
			this.setAttribute("weight", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "wideNarrowRatio", {
		get: function () {
			var vv = this.getAttribute("wideNarrowRatio");
			return vv.length === 0 ? "3:1" : vv;
		}, set: function (v) {
			this.setAttribute("wideNarrowRatio", v);
		}
	});
	Object.defineProperty(LCNode.prototype, "xdpContent", {
		get: function () {
			var vv = this.getAttribute("xdpContent");
			return vv.length === 0 ? "" : vv;
		}, set: function (v) {
			this.setAttribute("xdpContent", v);
		}
	});

	Object.defineProperties(LCList.prototype, {
		access: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).access);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).access = v;
				}
			}
		},
		accessKey: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).accessKey);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).accessKey = v;
				}
			}
		},
		action: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).action);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).action = v;
				}
			}
		},
		activity: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).activity);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).activity = v;
				}
			}
		},
		addRevocationInfo: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).addRevocationInfo);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).addRevocationInfo = v;
				}
			}
		},
		after: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).after);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).after = v;
				}
			}
		},
		afterTarget: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).afterTarget);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).afterTarget = v;
				}
			}
		},
		aliasNode: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).aliasNode);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).aliasNode = v;
				}
			}
		},
		all: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).all);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).all = v;
				}
			}
		},
		allowMacro: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).allowMacro);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).allowMacro = v;
				}
			}
		},
		allowNeutral: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).allowNeutral);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).allowNeutral = v;
				}
			}
		},
		allowRichText: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).allowRichText);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).allowRichText = v;
				}
			}
		},
		anchorType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).anchorType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).anchorType = v;
				}
			}
		},
		archive: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).archive);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).archive = v;
				}
			}
		},
		aspect: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).aspect);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).aspect = v;
				}
			}
		},
		baselineShift: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).baselineShift);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).baselineShift = v;
				}
			}
		},
		before: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).before);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).before = v;
				}
			}
		},
		beforeTarget: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).beforeTarget);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).beforeTarget = v;
				}
			}
		},
		bind: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).bind);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).bind = v;
				}
			}
		},
		binding: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).binding);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).binding = v;
				}
			}
		},
		blank: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).blank);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).blank = v;
				}
			}
		},
		blankOrNotBlank: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).blankOrNotBlank);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).blankOrNotBlank = v;
				}
			}
		},
		bofAction: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).bofAction);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).bofAction = v;
				}
			}
		},
		bookendLeader: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).bookendLeader);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).bookendLeader = v;
				}
			}
		},
		bookendTrailer: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).bookendTrailer);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).bookendTrailer = v;
				}
			}
		},
		borderColor: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).borderColor);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).borderColor = v;
				}
			}
		},
		borderWidth: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).borderWidth);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).borderWidth = v;
				}
			}
		},
		bottomInset: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).bottomInset);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).bottomInset = v;
				}
			}
		},
		break: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).break);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).break = v;
				}
			}
		},
		cap: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).cap);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).cap = v;
				}
			}
		},
		charEncoding: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).charEncoding);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).charEncoding = v;
				}
			}
		},
		checksum: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).checksum);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).checksum = v;
				}
			}
		},
		circular: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).circular);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).circular = v;
				}
			}
		},
		classAll: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).classAll);
				}
				return rr;
			}
		},
		classId: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).classId);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).classId = v;
				}
			}
		},
		classIndex: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).classIndex);
				}
				return rr;
			}
		},
		className: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).className);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).className = v;
				}
			}
		},
		codeBase: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).codeBase);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).codeBase = v;
				}
			}
		},
		codeType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).codeType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).codeType = v;
				}
			}
		},
		colSpan: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).colSpan);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).colSpan = v;
				}
			}
		},
		columnWidths: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).columnWidths);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).columnWidths = v;
				}
			}
		},
		commandType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).commandType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).commandType = v;
				}
			}
		},
		commitKey: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).commitKey);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).commitKey = v;
				}
			}
		},
		commitOn: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).commitOn);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).commitOn = v;
				}
			}
		},
		connection: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).connection);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).connection = v;
				}
			}
		},
		contains: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).contains);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).contains = v;
				}
			}
		},
		content: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).content);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).content = v;
				}
			}
		},
		contentType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).contentType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).contentType = v;
				}
			}
		},
		context: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).context);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).context = v;
				}
			}
		},
		credentialServerPolicy: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).credentialServerPolicy);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).credentialServerPolicy = v;
				}
			}
		},
		crlSign: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).crlSign);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).crlSign = v;
				}
			}
		},
		cSpace: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).cSpace);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).cSpace = v;
				}
			}
		},
		currentValue: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).currentValue);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).currentValue = v;
				}
			}
		},
		cursorLocation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).cursorLocation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).cursorLocation = v;
				}
			}
		},
		cursorType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).cursorType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).cursorType = v;
				}
			}
		},
		data: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).data);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).data = v;
				}
			}
		},
		dataColumnCount: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).dataColumnCount);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).dataColumnCount = v;
				}
			}
		},
		dataDescription: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).dataDescription);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).dataDescription = v;
				}
			}
		},
		dataEncipherment: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).dataEncipherment);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).dataEncipherment = v;
				}
			}
		},
		dataLength: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).dataLength);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).dataLength = v;
				}
			}
		},
		dataPrep: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).dataPrep);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).dataPrep = v;
				}
			}
		},
		dataRowCount: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).dataRowCount);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).dataRowCount = v;
				}
			}
		},
		db: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).db);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).db = v;
				}
			}
		},
		decipherOnly: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).decipherOnly);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).decipherOnly = v;
				}
			}
		},
		delayedOpen: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).delayedOpen);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).delayedOpen = v;
				}
			}
		},
		delimiter: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).delimiter);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).delimiter = v;
				}
			}
		},
		digitalSignature: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).digitalSignature);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).digitalSignature = v;
				}
			}
		},
		disable: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).disable);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).disable = v;
				}
			}
		},
		editValue: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).editValue);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).editValue = v;
				}
			}
		},
		encipherOnly: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).encipherOnly);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).encipherOnly = v;
				}
			}
		},
		endChar: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).endChar);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).endChar = v;
				}
			}
		},
		eofAction: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).eofAction);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).eofAction = v;
				}
			}
		},
		errorCorrectionLevel: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).errorCorrectionLevel);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).errorCorrectionLevel = v;
				}
			}
		},
		executeType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).executeType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).executeType = v;
				}
			}
		},
		fillColor: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).fillColor);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).fillColor = v;
				}
			}
		},
		fontColor: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).fontColor);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).fontColor = v;
				}
			}
		},
		format: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).format);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).format = v;
				}
			}
		},
		formatMessage: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).formatMessage);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).formatMessage = v;
				}
			}
		},
		formattedValue: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).formattedValue);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).formattedValue = v;
				}
			}
		},
		formatTest: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).formatTest);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).formatTest = v;
				}
			}
		},
		fracDigits: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).fracDigits);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).fracDigits = v;
				}
			}
		},
		from: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).from);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).from = v;
				}
			}
		},
		h: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).h);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).h = v;
				}
			}
		},
		hAlign: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).hAlign);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).hAlign = v;
				}
			}
		},
		hand: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).hand);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).hand = v;
				}
			}
		},
		highlight: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).highlight);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).highlight = v;
				}
			}
		},
		href: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).href);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).href = v;
				}
			}
		},
		hScrollPolicy: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).hScrollPolicy);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).hScrollPolicy = v;
				}
			}
		},
		id: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).id);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).id = v;
				}
			}
		},
		imagingBBox: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).imagingBBox);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).imagingBBox = v;
				}
			}
		},
		index: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).index);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).index = v;
				}
			}
		},
		initial: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).initial);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).initial = v;
				}
			}
		},
		initialNumber: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).initialNumber);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).initialNumber = v;
				}
			}
		},
		input: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).input);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).input = v;
				}
			}
		},
		instanceIndex: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).instanceIndex);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).instanceIndex = v;
				}
			}
		},
		intact: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).intact);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).intact = v;
				}
			}
		},
		inverted: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).inverted);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).inverted = v;
				}
			}
		},
		isContainer: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).isContainer);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).isContainer = v;
				}
			}
		},
		isDefined: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).isDefined);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).isDefined = v;
				}
			}
		},
		isNull: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).isNull);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).isNull = v;
				}
			}
		},
		keyAgreement: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).keyAgreement);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).keyAgreement = v;
				}
			}
		},
		keyCertSign: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).keyCertSign);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).keyCertSign = v;
				}
			}
		},
		keyDown: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).keyDown);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).keyDown = v;
				}
			}
		},
		keyEncipherment: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).keyEncipherment);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).keyEncipherment = v;
				}
			}
		},
		labelRef: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).labelRef);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).labelRef = v;
				}
			}
		},
		layout: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).layout);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).layout = v;
				}
			}
		},
		leadDigits: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).leadDigits);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).leadDigits = v;
				}
			}
		},
		leader: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).leader);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).leader = v;
				}
			}
		},
		leftInset: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).leftInset);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).leftInset = v;
				}
			}
		},
		lineHeight: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).lineHeight);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).lineHeight = v;
				}
			}
		},
		lineThrough: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).lineThrough);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).lineThrough = v;
				}
			}
		},
		lineThroughPeriod: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).lineThroughPeriod);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).lineThroughPeriod = v;
				}
			}
		},
		locale: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).locale);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).locale = v;
				}
			}
		},
		lockType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).lockType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).lockType = v;
				}
			}
		},
		long: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).long);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).long = v;
				}
			}
		},
		mandatory: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).mandatory);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).mandatory = v;
				}
			}
		},
		mandatoryMessage: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).mandatoryMessage);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).mandatoryMessage = v;
				}
			}
		},
		marginLeft: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).marginLeft);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).marginLeft = v;
				}
			}
		},
		marginRight: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).marginRight);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).marginRight = v;
				}
			}
		},
		mark: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).mark);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).mark = v;
				}
			}
		},
		match: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).match);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).match = v;
				}
			}
		},
		max: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).max);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).max = v;
				}
			}
		},
		maxChars: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).maxChars);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).maxChars = v;
				}
			}
		},
		maxH: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).maxH);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).maxH = v;
				}
			}
		},
		maxLength: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).maxLength);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).maxLength = v;
				}
			}
		},
		maxW: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).maxW);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).maxW = v;
				}
			}
		},
		min: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).min);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).min = v;
				}
			}
		},
		minH: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).minH);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).minH = v;
				}
			}
		},
		minW: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).minW);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).minW = v;
				}
			}
		},
		model: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).model);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).model = v;
				}
			}
		},
		modifier: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).modifier);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).modifier = v;
				}
			}
		},
		moduleHeight: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).moduleHeight);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).moduleHeight = v;
				}
			}
		},
		moduleWidth: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).moduleWidth);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).moduleWidth = v;
				}
			}
		},
		multiLine: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).multiLine);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).multiLine = v;
				}
			}
		},
		name: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).name);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).name = v;
				}
			}
		},
		next: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).next);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).next = v;
				}
			}
		},
		nonRepudiation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).nonRepudiation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).nonRepudiation = v;
				}
			}
		},
		ns: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).ns);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).ns = v;
				}
			}
		},
		nullTest: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).nullTest);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).nullTest = v;
				}
			}
		},
		numbered: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).numbered);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).numbered = v;
				}
			}
		},
		numberOfCells: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).numberOfCells);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).numberOfCells = v;
				}
			}
		},
		oddOrEven: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).oddOrEven);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).oddOrEven = v;
				}
			}
		},
		oneOfChild: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).oneOfChild);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).oneOfChild = v;
				}
			}
		},
		open: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).open);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).open = v;
				}
			}
		},
		operation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).operation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).operation = v;
				}
			}
		},
		orientation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).orientation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).orientation = v;
				}
			}
		},
		output: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).output);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).output = v;
				}
			}
		},
		overflowLeader: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).overflowLeader);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).overflowLeader = v;
				}
			}
		},
		overflowTarget: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).overflowTarget);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).overflowTarget = v;
				}
			}
		},
		overflowTrailer: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).overflowTrailer);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).overflowTrailer = v;
				}
			}
		},
		overline: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).overline);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).overline = v;
				}
			}
		},
		overlinePeriod: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).overlinePeriod);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).overlinePeriod = v;
				}
			}
		},
		override: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).override);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).override = v;
				}
			}
		},
		pagePosition: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).pagePosition);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).pagePosition = v;
				}
			}
		},
		parent: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).parent);
				}
				return rr;
			}
		},
		parentSubform: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).parentSubform);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).parentSubform = v;
				}
			}
		},
		passwordChar: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).passwordChar);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).passwordChar = v;
				}
			}
		},
		permissions: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).permissions);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).permissions = v;
				}
			}
		},
		placement: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).placement);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).placement = v;
				}
			}
		},
		posture: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).posture);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).posture = v;
				}
			}
		},
		presence: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).presence);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).presence = v;
				}
			}
		},
		preserve: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).preserve);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).preserve = v;
				}
			}
		},
		previous: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).previous);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).previous = v;
				}
			}
		},
		printCheckDigit: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).printCheckDigit);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).printCheckDigit = v;
				}
			}
		},
		priority: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).priority);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).priority = v;
				}
			}
		},
		radius: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).radius);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).radius = v;
				}
			}
		},
		radixOffset: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).radixOffset);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).radixOffset = v;
				}
			}
		},
		rate: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).rate);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).rate = v;
				}
			}
		},
		rawValue: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).rawValue);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).rawValue = v;
				}
			}
		},
		ready: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).ready);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).ready = v;
				}
			}
		},
		recordsAfter: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).recordsAfter);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).recordsAfter = v;
				}
			}
		},
		recordsBefore: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).recordsBefore);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).recordsBefore = v;
				}
			}
		},
		ref: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).ref);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).ref = v;
				}
			}
		},
		relation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).relation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).relation = v;
				}
			}
		},
		relevant: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).relevant);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).relevant = v;
				}
			}
		},
		reserve: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).reserve);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).reserve = v;
				}
			}
		},
		restoreState: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).restoreState);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).restoreState = v;
				}
			}
		},
		rightInset: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).rightInset);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).rightInset = v;
				}
			}
		},
		role: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).role);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).role = v;
				}
			}
		},
		rotate: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).rotate);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).rotate = v;
				}
			}
		},
		rowColumnRatio: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).rowColumnRatio);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).rowColumnRatio = v;
				}
			}
		},
		runAt: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).runAt);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).runAt = v;
				}
			}
		},
		save: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).save);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).save = v;
				}
			}
		},
		savedValue: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).savedValue);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).savedValue = v;
				}
			}
		},
		scope: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).scope);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).scope = v;
				}
			}
		},
		scriptTest: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).scriptTest);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).scriptTest = v;
				}
			}
		},
		selectedIndex: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).selectedIndex);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).selectedIndex = v;
				}
			}
		},
		server: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).server);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).server = v;
				}
			}
		},
		shape: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).shape);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).shape = v;
				}
			}
		},
		short: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).short);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).short = v;
				}
			}
		},
		signatureType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).signatureType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).signatureType = v;
				}
			}
		},
		size: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).size);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).size = v;
				}
			}
		},
		slope: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).slope);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).slope = v;
				}
			}
		},
		soapFaultCode: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).soapFaultCode);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).soapFaultCode = v;
				}
			}
		},
		soapFaultString: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).soapFaultString);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).soapFaultString = v;
				}
			}
		},
		somExpression: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).somExpression);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).somExpression = v;
				}
			}
		},
		spaceAbove: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).spaceAbove);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).spaceAbove = v;
				}
			}
		},
		spaceBelow: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).spaceBelow);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).spaceBelow = v;
				}
			}
		},
		startAngle: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).startAngle);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).startAngle = v;
				}
			}
		},
		startChar: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).startChar);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).startChar = v;
				}
			}
		},
		startNew: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).startNew);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).startNew = v;
				}
			}
		},
		stateless: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).stateless);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).stateless = v;
				}
			}
		},
		stock: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).stock);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).stock = v;
				}
			}
		},
		stroke: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).stroke);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).stroke = v;
				}
			}
		},
		sweepAngle: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).sweepAngle);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).sweepAngle = v;
				}
			}
		},
		tabDefault: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).tabDefault);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).tabDefault = v;
				}
			}
		},
		tabStops: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).tabStops);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).tabStops = v;
				}
			}
		},
		target: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).target);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).target = v;
				}
			}
		},
		targetType: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).targetType);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).targetType = v;
				}
			}
		},
		textEncoding: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).textEncoding);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).textEncoding = v;
				}
			}
		},
		textEntry: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).textEntry);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).textEntry = v;
				}
			}
		},
		textIndent: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).textIndent);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).textIndent = v;
				}
			}
		},
		textLocation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).textLocation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).textLocation = v;
				}
			}
		},
		thickness: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).thickness);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).thickness = v;
				}
			}
		},
		timeout: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).timeout);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).timeout = v;
				}
			}
		},
		topInset: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).topInset);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).topInset = v;
				}
			}
		},
		trailer: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).trailer);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).trailer = v;
				}
			}
		},
		transferEncoding: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).transferEncoding);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).transferEncoding = v;
				}
			}
		},
		transient: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).transient);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).transient = v;
				}
			}
		},
		truncate: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).truncate);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).truncate = v;
				}
			}
		},
		type: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).type);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).type = v;
				}
			}
		},
		typeface: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).typeface);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).typeface = v;
				}
			}
		},
		underline: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).underline);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).underline = v;
				}
			}
		},
		underlinePeriod: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).underlinePeriod);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).underlinePeriod = v;
				}
			}
		},
		upsMode: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).upsMode);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).upsMode = v;
				}
			}
		},
		url: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).url);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).url = v;
				}
			}
		},
		urlPolicy: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).urlPolicy);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).urlPolicy = v;
				}
			}
		},
		usage: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).usage);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).usage = v;
				}
			}
		},
		use: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).use);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).use = v;
				}
			}
		},
		usehref: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).usehref);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).usehref = v;
				}
			}
		},
		uuid: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).uuid);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).uuid = v;
				}
			}
		},
		validationMessage: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).validationMessage);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).validationMessage = v;
				}
			}
		},
		vAlign: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).vAlign);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).vAlign = v;
				}
			}
		},
		value: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).value);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).value = v;
				}
			}
		},
		valueRef: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).valueRef);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).valueRef = v;
				}
			}
		},
		variation: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).variation);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).variation = v;
				}
			}
		},
		version: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).version);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).version = v;
				}
			}
		},
		vScollPolicy: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).vScollPolicy);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).vScollPolicy = v;
				}
			}
		},
		w: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).w);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).w = v;
				}
			}
		},
		weight: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).weight);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).weight = v;
				}
			}
		},
		wideNarrowRatio: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).wideNarrowRatio);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).wideNarrowRatio = v;
				}
			}
		},
		x: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).x);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).x = v;
				}
			}
		},
		xdpContent: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).xdpContent);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).xdpContent = v;
				}
			}
		},
		y: {
			get: function () {
				var rr = new LCList();
				for (var i = 0, ii = this.length; i < ii; i++) {
					rr.append(this.item(i).y);
				}
				return rr;
			},
			set: function (v) {
				for (var i = 0, ii = this.length; i < ii; i++) {
					this.item(i).y = v;
				}
			}
		}
	});

	LCNode.prototype.addItem = function (s1, s2) {
		var items = LCU.findChildren(this, LCO.ITEMS);
		if (s2) {
			switch (items.length) {
				case 0:
					items = new LCNode(this, "items");
					var text = new LCNode(items, "text");
					text._textStream = s1;
					items = new LCNode(this, "items");
					var text2 = new LCNode(items, "text");
					text2._textStream = s2;
					break;
				case 1:
					var text = new LCNode(items.item(0), "text");
					text._textStream = s1;
					break;
				case 2:
					var text = new LCNode(items.item(0), "text");
					text._textStream = s1;
					var text2 = new LCNode(items.item(1), "text");
					text2._textStream = s2;
					break;
			}
		} else {
			switch (items.length) {
				case 0:
					items = new LCNode(this, "items");
					var text = new LCNode(items, "text");
					text._textStream = s1;
					break;
				case 1:
					var text = new LCNode(items.item(0), "text");
					text._textStream = s1;
					break;
				case 2:
					var text = new LCNode(items.item(0), "text");
					text._textStream = s1;
					var text2 = new LCNode(items.item(1), "text");
					text2._textStream = s1;
					break;
			}

		}
	};
	LCNode.prototype.addNew = function () {
		LCU.log("addNew");
	};
	LCNode.prototype.applyXSL = function () {
		LCU.log("applyXSL");
	};
	LCNode.prototype.assignNode = function () {
		LCU.log("assignNode");
	};
	LCNode.prototype.boundItem = function () {
		LCU.log("boundItem");
	};
	LCNode.prototype.cancel = function () {
		LCU.log("cancel");
	};
	LCNode.prototype.cancelBatch = function () {
		LCU.log("cancelBatch");
	};
	LCNode.prototype.clear = function () {
		LCU.log("clear");
	};
	LCNode.prototype.clearErrorList = function () {
		LCU.log("clearErrorList");
	};
	LCNode.prototype.clearItems = function () {
		var items = LCU.findChildren(this, LCO.ITEMS);
		for (var i = 0, ii = items.length; i < ii; i++) {
			items.item(i).nodes.clear();
		}
	};
	LCNode.prototype.close = function () {
		LCU.log("close");
	};
	LCNode.prototype.createNode = function (s1, s2, s3) {
		if (s2) {
			var node = new LCNode(null, s1);
			node.name = s2;
			return node;
		} else {
			var node = new LCNode(null, s1);
			node.name = "";
			return node;
		}
	};
	LCNode.prototype.delete = function () {
		LCU.log("delete");
	};
	LCNode.prototype.deleteItem = function () {
		LCU.log("deleteItem");
	};
	LCNode.prototype.emit = function () {
		LCU.log("emit");
	};
	LCNode.prototype.enumerate = function () {
		LCU.log("enumerate");
	};
	LCNode.prototype.evaluate = function () {
		LCU.log("evaluate");
	};
	LCNode.prototype.execCalculate = function () {
		var calc = LCU.findChild(this, LCO.CALCULATE);
		if (calc) {
			var script = LCU.findChild(calc, LCO.SCRIPT);
			if (script && script._textStream) {
				try {
					if (script.contentType === "application/x-javascript") {
						eval(script._textStream);
					} else {
						var vv = eval(script._textStream);
						if (LCU.hasValue(vv)) {
							if (LCU.getFieldType(this) === LCO.NUMERICEDIT) {
								if (LCU.isNumber(vv)) {
									this.rawValue = vv;
								} else {
									this.rawValue = undefined;
								}
							} else {
								this.rawValue = vv;
							}
						} else {
							this.rawValue = undefined;
						}
					}
				} catch (e) {
					console.log(e);
					console.log(script._textStream);
				}
			}
		}
	};
	LCNode.prototype.execEvent = function (act) {
		this.execEventHash(LCMath.hash(act));
	};
	LCNode.prototype.execEventHash = function (eaHash) {
		var events = LCU.findChildren(this, LCO.EVENT);
		for (var i = 0, ii = events.length; i < ii; i++) {
			var ei = events.item(i);
			var act = ei.activity;
			if (LCMath.hash(act) === eaHash) {
				var scr = LCU.findChild(ei, LCO.SCRIPT);
				if (scr) {
					try {
						eval(scr._textStream);
					} catch (e) {
						console.log(e);
						console.log(scr._textStream);
					}
					break;
				}
			}
		}
	};

	LCNode.prototype.execInitialize = function () {
		if (this._initialize) {
			return;
		}
		var events = LCU.findChildren(this, LCO.EVENT);
		for (var j = 0, jj = events.length; j < jj; j++) {
			var act = events.item(j).activity;
			if (LCMath.hash(act) === LCV.INITIALIZE) {
				this.execEventHash(LCV.INITIALIZE);
				this._initialize = true;
			}
		}
		var ch;
		for (var i = 0, ii = this.nodes.length; i < ii; i++) {
			ch = this.nodes.item(i);
			if (ch.isContainer) {
				ch.execInitialize(ch);
			}
		}
	};
	LCNode.prototype.execute = function () {
		LCU.log("execute");
	};
	LCNode.prototype.execValidate = function () {
		LCU.log("execValidate");
	};
	LCNode.prototype.first = function () {
		LCU.log("first");
	};
	LCNode.prototype.formNodes = function () {
		LCU.log("formNodes");
	};
	LCNode.prototype.getDelta = function () {
		LCU.log("getDelta");
	};
	LCNode.prototype.getDeltas = function () {
		LCU.log("getDeltas");
	};
	LCNode.prototype.getDisplayItem = function () {
		LCU.log("getDisplayItem");
	};
	LCNode.prototype.getElement = function () {
		LCU.log("getElement");
	};
	LCNode.prototype.getItemState = function () {
		LCU.log("getItemState");
	};
	LCNode.prototype.getSaveItem = function () {
		LCU.log("getSaveItem");
	};
	LCNode.prototype.gotoRecord = function () {
		LCU.log("gotoRecord");
	};
	LCNode.prototype.hasDataChanged = function () {
		LCU.log("hasDataChanged");
	};
	LCNode.prototype.isBOF = function () {
		LCU.log("isBOF");
	};
	LCNode.prototype.isPropertySpecified = function () {
		LCU.log("isPropertySpecified");
	};
	LCNode.prototype.isRecordGroup = function () {
		LCU.log("isRecordGroup");
	};
	LCNode.prototype.item = function () {
		LCU.log("item");
	};
	LCNode.prototype.last = function () {
		LCU.log("last");
	};
	LCNode.prototype.loadXML = function () {
		LCU.log("loadXML");
	};
	LCNode.prototype.metadata = function () {
		LCU.log("metadata");
	};
	LCNode.prototype.moveCurrentRecord = function () {
		LCU.log("moveCurrentRecord");
	};
	LCNode.prototype.namedItem = function () {
		LCU.log("namedItem");
	};
	LCNode.prototype.recalculate = function () {
		recursiveCalculate(xfa.form);
		function recursiveCalculate(som) {
			var ch;
			for (var i = 0, ii = som.nodes.length; i < ii; i++) {
				ch = som.nodes.item(i);
				if (ch.isContainer) {
					if (ch.isWidget) {
						ch.execCalculate();
					} else {
						recursiveCalculate(ch);
					}
				}
			}
		}

	};
	LCNode.prototype.record = function () {
		LCU.log("record");
	};
	LCNode.prototype.remerge = function () {
		LCU.log("remerge");
	};
	LCNode.prototype.remove = function () {
		LCU.log("remove");
	};
	LCNode.prototype.removeAttribute = function () {
		LCU.log("removeAttribute");
	};
	LCNode.prototype.requery = function () {
		LCU.log("requery");
	};
	LCNode.prototype.reset = function () {
		LCU.log("reset");
	};
	LCNode.prototype.resolveData = function () {
		LCU.log("resolveData");
	};

	Object.prototype._xquery = function (prop) {
		if (prop in xfa.variables) {
			return xfa.variables[prop];
		}
		if (prop.charCodeAt(0) === 0x24) {
			if (prop.length === 1) {
				return this;
			}
			var aa = prop.substring(1);
			if (aa in LCDollar) {
				return xfa[LCDollar];
			}
		}
		if (this.classHash === LCO.XFA && prop in LCDollar) {
			return xfa[prop];
		}

		var list = new LCList();
		var hash = LCMath.hash(prop);

//		console.log("searching " + prop + " " + hash);
		var sBrack = prop.indexOf("[");
		var suffix = "";
		if (sBrack > -1) {
			var pref = prop.substring(0, sBrack);
			suffix = prop.substring(sBrack + 1, prop.indexOf("]"));
			hash = LCMath.hash(pref);
			if (pref.charCodeAt(0) === 0x23) {
				hash = LCMath.hash(pref.substring(0));
				list = LCU.findChildren(this, hash);
			} else {
				resolveSearchNameAndClass(this, hash, list);
			}
		} else if ("_somId" in this) {
			switch (prop.charCodeAt(0)) {
				case 0x5F: // INSTANCE MANAGER
					hash = LCMath.hash(prop.substring(1));
					LCU.searchDownName(this, hash, list, true);
					if (list.length === 0) {
						LCU.searchUpName(this, hash, list, true);
					}
					return list.item(0).instanceManager;
				case 0x23: // #
					hash = LCMath.hash(prop.substring(1));
					var cf = LCU.findChild(this, hash);
					if (cf) {
						return cf;
					}
					break;
				default:
					resolveSearchNameAndClass(this, hash, list);
			}
		} else if ("_arr" in this) {
			resolveSearchNameAndClass(this, hash, list);
		}
		if ("_somId" in this) {
			if (list.length === 0) {
				if (prop in this) {
					return this[prop];
				}
				if (hash in LCO) {
					return searchClassOrCreate(this, prop);
				} else {
					return null;
				}
			}
			if (suffix.length > 0) {
				if (suffix === "*") {
					return list;
				} else if (!isNaN(suffix)) {
					return list.item(parseInt(suffix));
				}
			}
			return list.item(0);

		} else if ("_arr" in this && this.length > 0) {
			if (list.length === 0) {
				if (prop in this) {
					return this[prop];
				}
				if (hash in LCO) {
					for (var i = 0, ii = this.length; i < ii; i++) {
						list.append(searchClassOrCreate(this.item(i), prop));
					}
				} else {
					return null;
				}
			}
			if (suffix.length > 0) {
				if (suffix === "*") {
					return list;
				} else if (!isNaN(suffix)) {
					return list.item(parseInt(suffix));
				}
			}
			return list;
		}
		if (prop in this) {
			return this[prop];
		}
		return null;

		function searchClassOrCreate(n, prop) {
			var list = new LCList();
			var hash = LCMath.hash(prop);
			LCU.searchDown(n, hash, list, true, true);
			if (list.length > 0) {
				return list.item(0);
			}
			var node = new LCNode(n, prop);
			return node;
		}

		function resolveSearchNameAndClass(s, h, list) {
			if ("_arr" in s) {
				for (var i = 0, ii = s.length; i < ii; i++) {
					var si = s.item(i);
					if (si._classHash === LCO.XFA) {
						LCU.searchDownName(xfa.form, h, list, false);
					} else {
						LCU.searchUpName(si, h, list, false);
					}
				}
				if (list.length === 0) {
					for (var i = 0, ii = s.length; i < ii; i++) {
						LCU.searchDownName(s.item(i), h, list, false);
					}
				}
				if (list.length === 0) {
					for (var i = 0, ii = s.length; i < ii; i++) {
						LCU.searchDown(s.item(i), h, list, true, false);
					}
				}
			} else {
				if (s.className === "xfa") {
					LCU.searchDownName(xfa.form, h, list, false);
				} else {
					LCU.searchUpName(s, h, list, false);
					if (list.length === 0) {
						LCU.searchDownName(s, h, list, false);
					}
				}
				if (list.length === 0) {
					LCU.searchDown(s, h, list, true, false);
				}
			}
		}
	};

	LCNode.prototype.resolveNode = function (str) {
		return this.resolveNodes(str);
	};
	LCNode.prototype.resolveNodes = function (str) {
		var chunks = splitExpression(str);
		var result = this;
		for (var i = 0, ii = chunks.length; i < ii; i++) {
			var cc = chunks[i];
			if (cc.length > 0) {
				if (cc === "xfa") {
					result = xfa;
				} else {
					result = result._xquery(cc);
				}
			}
		}
		return result;

		function splitExpression(expr) {
			var arr = [];
			var buf = "";
			var inBrace = 0;
			var bEscape = false;
			for (var j = 0; j < expr.length; j++) {
				var s = expr.charAt(j);
				if (s === "[") {
					inBrace++;
					buf += s;
				} else if (s === "]") {
					--inBrace;
					buf += s;
				} else if (s === "\\") {
					bEscape = true;
					buf += s;
				} else if (s === "." && inBrace === 0 && bEscape === false) {
					if (buf.length === 0) {
						arr.push(".."); // elipsis
					} else {
						if (buf.indexOf("#variables") < 0) {
							arr.push(buf);
						}
					}
					buf = "";
				} else {
					buf += s;
					bEscape = false;
				}

				if (j === expr.length - 1) {
					if (buf.indexOf("#variables") < 0) {
						arr.push(buf);
					}
				}
			}

			if (arr.length === 1)
				return arr;

			var out = [];
			var pattern = /^\[.*\]/;
			for (var i = 0; i < arr.length; i++) {
				var seg = String(arr[i]);
				if (seg.match(pattern) && i > 0) {
					out.splice(i - 1, 1, arr[i - 1] + "." + seg);
				} else {
					out.push(arr[i]);
				}
			}
			return out;
		}

	};
	LCNode.prototype.restore = function () {
		LCU.log("restore");
	};
	LCNode.prototype.resync = function () {
		LCU.log("resync");
	};
	LCNode.prototype.saveFilteredXML = function () {
		LCU.log("saveFilteredXML");
	};
	LCNode.prototype.saveXML = function () {
		var str = "<" + this.className;
		for (var aa in this._propName) {
			if (aa !== "_xquery") {
				str += " " + aa + "=\"" + this._propName[aa] + "\"";
			}
		}
		if (this.nodes.length === 0 && this._textStream === null) {
			str += "/>";
		} else {
			str += ">";
			for (var i = 0, ii = this.nodes.length; i < ii; i++) {
				str += this.nodes.item(i).saveXML();
			}
			if (this._textStream !== null) {
				str += this._textStream;
			}
			str += "</" + this.className + ">";
		}
		return str;

	};
	LCNode.prototype.setElement = function () {
		LCU.log("setElement");
	};
	LCNode.prototype.setItemState = function () {
		LCU.log("setItemState");
	};
	LCNode.prototype.sign = function () {
		LCU.log("sign");
	};
	LCNode.prototype.update = function () {
		LCU.log("update");
	};
	LCNode.prototype.updateBatch = function () {
		LCU.log("updateBatch");
	};
	LCNode.prototype.verify = function () {
		LCU.log("verify");
	};

	Object.defineProperty(LCNode.prototype, "instanceManager", {
		get: function () {
			if (this.parent && this._nameHash !== 0) {
				return this.parent.instanceHolder.instances[this.name];
			}
			return null;
		}
	});

	function InstanceHolder(owner) {

		this.instances = {};

		for (var i = 0, ii = owner.nodes.length; i < ii; i++) {
			var it = owner.nodes.item(i);
			if (it._classHash === LCO.SUBFORM && it._nameHash !== 0) {
				var occur = LCU.findChild(it, LCO.OCCUR);
				var max = 1;
				var min = 1;
				if (occur) {
					var m = occur.max;
					if (m.length > 0) {
						max = parseInt(m);
						if (max === -1) {
							max = 1000000; //allow upto one million forms
						}
					}
					m = occur.min;
					if (m.length > 0) {
						min = parseInt(m);
					}
				}
				if (this.instances[it.name]) {
					this.instances[it.name].count++;
				} else {
					var cln = new LCNode(null, it.className);
					recursiveClone(it, cln);
					cln.parent = owner;
					this.instances[it.name] = new InstanceManager(owner, cln, Math.min(min, 1), min, max);
				}
			}
		}
	}

	function InstanceManager(owner, clone, count, min, max) {
		this._owner = owner;
		this._clone = clone;
		this.count = count;
		this.min = min;
		this.max = max;

		this.getInstances = function () {
			var list = new LCList();
			for (var i = 0, ii = this._owner.nodes.length; i < ii; i++) {
				var it = this._owner.nodes.item(i);
				if (it._classHash === LCO.SUBFORM && it._nameHash === this._clone._nameHash) {
					list.append(this._owner.nodes.item(i));
				}
			}
			return list;
		};

		this.addInstance = function () {
			var m = this.max;
			var obj;
			if (this.count === 0) {
				this.count++;
			} else if (this.count < m) {
				xfa.layout.thrashing = true;
				obj = new LCNode(null, this._clone.className);
				recursiveClone(this._clone, obj);
				obj.parent = this._owner;
				var last = null;
				for (var i = 0, ii = this._owner.nodes.length; i < ii; i++) {
					var it = this._owner.nodes.item(i);
					if (it._classHash === LCO.SUBFORM && it._nameHash === this._clone._nameHash) {
						last = this._owner.nodes.item(i);
					}
				}
				if (last) {
					this._owner.nodes.insertAfter(obj, last);
				} else {
					this._owner.nodes.append(obj);
				}
				obj.execInitialize();
				this.count++;
			}
			xfa.layout.thrashing = true;
			xfa.form.recalculate();
			return obj;
		};

		this.insertInstance = function () {};

		this.moveInstance = function (n1, n2) {
			if (n1 === n2) {
				return;
			}
			if (this.count === 0) {
				this.count++;
			} else if (this.count > 1) {
				xfa.layout.thrashing = true;
				var nPos = 0;
				var p = this._owner;
				var rem = null;
				var aft = null;
				var last = null;
				for (var i = 0, ii = p.nodes.length; i < ii; i++) {
					var it = p.nodes.item(i);
					if (it._classHash === LCO.SUBFORM && it._nameHash === this._clone._nameHash) {
						if (nPos === n1) {
							rem = it;
						}
						if (nPos === n2) {
							aft = it;
						}
						last = it;
						nPos++;
					}
				}
				if (rem) {
					if (aft) {
						p.nodes.remove(rem);
						p.nodes.insertAfter(rem, aft);
					} else if (last) {
						p.nodes.remove(rem);
						p.nodes.insertAfter(rem, aft);
					}
				}
			}
			xfa.layout.thrashing = true;
			xfa.form.recalculate();
		};

		this.removeInstance = function (n) {
			var c = this.count;
			if (c === 1) {
				var p = this._owner;
				var pos = 0;
				for (var i = 0, ii = p.nodes.length; i < ii; i++) {
					var it = p.nodes.item(i);
					if (it._nameHash === this._clone._nameHash && it._classHash === LCO.SUBFORM) {
						LCU.recursiveReset(it);
						break;
					}
				}
			} else if (c > 1) {
				var p = this._owner;
				var pos = 0;
				for (var i = 0, ii = p.nodes.length; i < ii; i++) {
					var it = p.nodes.item(i);
					if (it._nameHash === this._clone._nameHash && it._classHash === LCO.SUBFORM) {
						if (pos === n) {
							p.nodes.remove(it);
							break;
						}
						pos++;
					}
				}
			}
			this.count--;
			xfa.layout.thrashing = true;
			xfa.form.recalculate();
		};

		this.setInstances = function (n) {
			var c = this.count;
			if (c === n || (this.max !== -1 && n > this.max)) {
				return;
			}
			xfa.layout.thrashing = true;
			if (c < n) {
				var ii = n - c;
				for (var i = 0; i < ii; i++) {
					this.addInstance();
				}
			} else {
				var ii = c - n;
				for (var i = 0; i < ii; i++) {
					this.removeInstance(this.count - 1);
				}
			}
			xfa.layout.thrashing = true;
			xfa.form.recalculate();
		};

	}

//model definitions
	function LCModel() {
		this.aliasNode = null;
		this.context = null;
		this.createNode = function () {};
		this.clearErrorList = function () {};
		this.isComptaibleNS = function () {};
	}

	function LCEventPsudoModel() {
		this.change = "";
		this.commitKey = 0;
		this.fullText = "";
		this.keyDown = false;
		this.modifier = false;
		this.newContentType = "";
		this.newText = "";
		this.prevContentType = "";
		this.prevText = "";
		this.reenter = false;
		this.selEnd = 0;
		this.selStart = 0;
		this.shift = false;
		this.soapDefaultCod = "";
		this.soapFaultString = "";
		this.target = "";

		this.emit = function () {
			LCU.log("emit not initialized");
		};

		this.reset = function () {
			LCU.log("reset not initialized");
		};
	}

	function LCLayoutPseudoModel() {
		this.read = false; //Specifies whether the form layout process is complete and scripting tasks can begin.
		this.thrashing = false;

		this.absPage = function () {
			LCU.log("absPage");
		};
		this.absPageCount = function () {
			LCU.log("absPageCount");
		};
		this.absPageCountInBatch = function () {
			LCU.log("absPageCountInBatch");
		};
		this.absPageInBatch = function () {
			LCU.log("absPageInBatch");
		};
		this.absPageSpan = function () {
			LCU.log("absPageSpan");
		};
		this.h = function () {
			LCU.log("h");
		};
		this.page = function () {
			LCU.log("page");
		};
		this.pageContent = function () {
			LCU.log("pageContent");
		};
		this.pageDown = function () {
			LCU.log("pageDown");
		};
		this.pageSpan = function () {
			LCU.log("pageSpan");
		};
		this.w = function () {
			LCU.log("w");
		};
		this.x = function () {
			LCU.log("x");
		};
		this.y = function () {
			LCU.log("y");
		};
		this.relayout = function () {
			xfa.form.recalculate();
			var ss = this.generateDom(xfa);
			document.getElementById("mainXFAForm").innerHTML = ss;
			var dd = document.getElementById("FDFXFA_PageCount");
			if (dd) {
				dd.textContent = "/ " + this.pageCount();
			}
		};
		this.relayoutPageArea = function () {
			LCU.log("relayoutPageArea");
		};
		this.sheet = function () {
			LCU.log("sheet");
		};
		this.sheetCount = function () {
			LCU.log("sheetCount");
		};
		this.sheetCountInBatch = function () {
			LCU.log("sheetCountInBatch");
		};
		this.pageCount = function () {
			return app.activeDocs[0].numPages;
		};
	}

	function LCHostPseudoModel() {
		this.name = "Acrobat";
		this.appType = app.viewerType;
		this.calculationsEnabled = true;
		this.language = app.language;
		this.platform = app.platform;
		this.title = app.activeDocs[0].title;
		this.variation = app.viewerVariation;
		this.version = app.viewerVersion;
		this.beep = app.beep;

		this.documentCountInBatch = function () {
			return 1;
		};
		this.documentInBatch = function () {
			return 1;
		};
		this.exportData = function (p1, p2) {
			app.activeDocs[0].exportXFAData(p1, p2);
		};
		this.getFocus = function () {
			LCU.log("getFocus");
		};
		this.gotoURL = function (v) {
			app.launchURL(v);
		};
		this.importData = function (p1) {
			app.activeDocs[0].importXFAData(p1);
		};
		this.messageBox = function (p1, p2, p3, p4) {
			app.alert(p1, p2, p3, p4);
		};
		this.openList = function () {
			LCU.log("openList");
		};
		this.pageUp = function () {
			app.activeDocs[0].pageNum--;
		};
		this.pageDown = function () {
			app.activeDocs[0].pageNum++;
		};
		this.print = function (p1, p2, p3, p4, p5, p6, p7, p8) {
			app.activeDocs[0].print(p1, p2, p3, p4, p5, p6, p7, p8);
		};
		this.resetData = function () {
			app.activeDocs[0].resetForm();
		};
		this.response = function (p1, p2, p3, p4) {
			app.response(p1, p2, p3, p4);
		};
		this.setFocus = function () {
			LCU.log("setFocus");
		};
	}

	Object.defineProperty(LCHostPseudoModel.prototype, "numPages", {
		get: function () {
			return app.activeDocs[0].numPages;
		}, set: function (v) {
			app.activeDocs[0].numPages = v;
		}
	});

	Object.defineProperty(LCHostPseudoModel.prototype, "currentPage", {
		get: function () {
			return app.activeDocs[0].pageNum;
		}, set: function (v) {
			app.activeDocs[0].pageNum = v;
		}
	});

	LCLayoutPseudoModel.prototype.generateDom = function (xfa) {

		var mainForm = xfa.form;
		var pAreas = LCU.findDescs(mainForm, LCO.PAGEAREA);

		var pa;
		for (var i = 0, ii = pAreas.length; i < ii; i++) {
			pa = pAreas.item(i);
			pa.occurIndex = i;
			pa.occurCount = 0;
			pa.occurMax = 100000;
			var occ = LCU.findChild(pa, LCO.OCCUR);
			if (occ) {
				var max = occ.getAttribute("max");
				if (max.length > 0) {
					pa.occurMax = parseInt(max);
				}
			}
		}

		var move = {x: 0, y: 0, xx: 0, yy: 0};
		mainForm.layout = "tb";
		mainForm._layout = LCMath.hash("tb");

		var curP = pAreas.item(0);
		var curC = null;
		var pItems = 0;


		var sb = new Array();
		startPageArea(sb);
		recurseDraw(mainForm, 1, sb, "visible");
		endPageArea(sb);
		return sb.join('');

		function startPageArea(sb) {
			if (curP.count >= curP.occurMax) {
				var np = pAreas.item(curP.occurIndex + 1);
				if (np) {
					curP = np;
				}
			}

			sb.push("<div class='pageArea' style='width:" + curP._box.w + LCPX + ";height:" + curP._box.h + LCPX + ";'>");
			move.x = 0, move.y = 0;
			recurseDraw(curP, 1, sb, "visible");
			move.x = 0, move.y = 0;
			curC = LCU.findChild(curP, LCO.CONTENTAREA);
			sb.push("<div class='contentArea' style='width:" + curC._box.w + LCPX + ";height:"
					+ curC._box.h + LCPX + "; margin-top:+" + curC._box.y + LCPX + ";margin-left:" + curC._box.x + LCPX + ";'>");
		}

		function endPageArea(sb) {
			curC = null;
			pItems = 0;
			sb.push("</div>");
			sb.push("</div>");
			curP.count++;
		}

		function intactSplit(s) {
			var keep = LCU.findChild(s, LCO.KEEP);
			if (keep) {
				var intact = keep.intact;
				if (intact === "none" || intact.length === 0) {
					return true;
				} else {
					return false;
				}
			} else {
				var lay = s._layout;
				if (lay === LCV.POSITION || lay === LCV.ROW) {
					return false;
				} else {
					return true;
				}
			}
		}

		function checkBreakBefore(s, sb) {
			var bb = LCU.findChild(s, LCO.BREAKBEFORE);
			if (bb) {
				var sn = bb.startNew;
				var bf = bb.targetType;
				var bt = bb.target;
				pickPage(bt);
				if (pItems > 0) {
					endPageArea(sb);
					startPageArea(sb);
				}
			} else {
				bb = LCU.findChild(s, LCO.BREAK);
				if (bb) {
					var bf = bb.before;
					var bt = bb.beforeTarget;
					if (bf === "pageArea") {
						pickPage(bt);
						if (pItems > 0) {
							endPageArea(sb);
							startPageArea(sb);
						}
					}
				}
			}
		}

		function checkBreakAfter(s, sb) {
			var ba = LCU.findChild(s, LCO.BREAKAFTER);
			if (ba) {
				var sn = ba.startNew;
				var bf = ba.targetType;
				var bt = ba.target;
				pickPage(bt);
				if (pItems > 0) {
					endPageArea(sb);
					startPageArea(sb);
				}
			} else {
				var brk = LCU.findChild(s, LCO.BREAK);
				if (brk) {
					var ba = brk.after;
					var bt = brk.afterTarget;
					if (ba === "pageArea") {
						pickPage(bt);
						if (pItems > 0) {
							endPageArea(sb);
							startPageArea(sb);
						}
					}
				}
			}
		}

		function pickPage(id) {
			if (id.length > 0) {
				var found = -1;
				var pid = id;
				if (pid.indexOf("#") === 0) {
					pid = id.substring(1);
					for (var i = 0, ii = pAreas.length; i < ii; i++) {
						if (pAreas.item(i).id === pid) {
							found = i;
							break;
						}
					}
				} else {
					for (var i = 0, ii = pAreas.length; i < ii; i++) {
						if (pAreas.item(i).name === id) {
							found = i;
							break;
						}
					}
				}
				if (found > -1) {
					curP = pAreas.item(found);
				}
			}
		}

		function getPresence(s, ancPres) {
			var pres = s.presence;
			if (ancPres === "hidden" || pres === "hidden") {
				return "hidden";
			}
			if (ancPres === "invisible" || pres === "invisible") {
				return "invisible";
			}
			if (ancPres === "inactive" || pres === "inactive") {
				return "inactive";
			}
			return "visible";
		}

		function moveToNewPage(s, sb) {
			var p = s.parent;
			endPageArea(sb);
			startPageArea(sb);

			var pArr = [];
			while (p && p._classHash !== LCO.TEMPLATE) {
				if (p.isContainer) {
					pArr.push(p);
				}
				p = p.parent;
			}
			var len = pArr.length;
			var l = 0, t = 0;
			while (len > 0) {
				p = pArr.pop();
				p._box.calH = 0, p._box.calW = 0, p._box.calX = l, p._box.calY = t;
				l += p._box.marL;
				t += p._box.marT;
				if (p.parent._layout === LCV.POSITION) {
					l += p._box.x;
					t += p._box.y;
				}
				len--;
			}
			if (s.parent._layout === LCV.POSITION) {
				l += s._box.x;
				var pbox = s.parent._box;
				var curY = s._box.y;
				pbox.calY = 0, pbox.calH = 0, s._box.calY = 0;
				var sibs = LCU.findNextSibls(s);
				s._box.temp = 0;
				for (var i = 0, ii = sibs.length; i < ii; i++) {
					var it = sibs.item(i);
					if (it.isContainer) {
						var dif = it._box.temp - curY;
						it._box.temp = dif > 0 ? dif : 0;
					}
				}
				move.y = 0;
			} else {
				move.y = t;
			}
			move.x = l;
		}

		function recurseDraw(s, zIndex, sb, ancPres) {
			if (curC && s._classHash === LCO.PAGESET) {
				return;
			}

			if ((s._classHash === LCO.SUBFORM || s._classHash === LCO.SUBFORMSET) && s._nameHash !== 0) {
				var im = s.instanceManager;
				if (im && im.count === 0) {
					return;
				}
			}

			var pres = getPresence(s, ancPres);

			var mar = getAncsMargins(s);
			if (s.isWidget) {
				updateWidgetDim(s, pres);
				if (pItems > 0 && sb && curC && (curC._box.h + 1) < (move.y + s._box.calH + mar.B)) {
					moveToNewPage(s, sb);
				}
				s._box.calX = move.x;
				s._box.calY = move.y;
				if (sb) {
					if (curC) {
						pItems++;
					}
					sb.push(genWidgetDom(s, zIndex, pres));
				}
			} else if (s.isContainer) {
				if (curC && sb) {
					checkBreakBefore(s, sb);
				}
				var lay = s.layout;
				if (sb && curC && !intactSplit(s)) {
					var prevX = move.x, prevY = move.y;
					recurseDraw(s, zIndex, null, pres);
					move.x = prevX, move.y = prevY;
					if (pItems > 0 && (curC._box.h + 1) < (move.y + s._box.calH + mar.B)) {
						moveToNewPage(s, sb);
					}
				}

				s._box.calX = move.x;
				s._box.calY = move.y;
				switch (s._layout) {
					case LCV.POS:
						recursePOS(s, zIndex + 1, sb, pres);
						break;
					case LCV.TB:
						recurseTB(s, zIndex + 1, sb, pres);
						break;
					case LCV.LRTB:
					case LCV.RLTB:
						recurseLRTB(s, zIndex + 1, sb, pres);
						break;
					case LCV.TABLE:
						recurseTABLE(s, zIndex + 1, sb, pres);
						break
					case LCV.ROW:
						recurseROW(s, zIndex + 1, sb, pres);
						break;
					default:
						recursePOS(s, zIndex + 1, sb, pres);
						break;
				}

				move.x = s._box.calX;
				move.y = s._box.calY;

				if (pres === "hidden") {
					s._box.calH = 0;
					s._box.calW = 0;
				} else if (sb && pres !== "hidden" && pres !== "invisible") {
					var bdr = LCU.findChild(s, LCO.BORDER);
					if (bdr) {
						var clsCSS = [];
						clsCSS.push("subform");
						var stlCSS = [];
						stlCSS.push("z-index:" + zIndex);
						stlCSS.push("width:" + s._box.calW + LCPX);
						stlCSS.push("height:" + s._box.calH + LCPX);
						stlCSS.push("margin-top:" + s._box.calY + LCPX);
						stlCSS.push("margin-left:" + s._box.calX + LCPX);
						updateBorder(bdr, clsCSS, stlCSS);
						sb.push("<div class=\"" + clsCSS.join(' ') + "\"");
						sb.push(" style=\"" + stlCSS.join(';') + "\"");
						sb.push("></div>");
					}
				}
				if (curC && sb) {
					checkBreakAfter(s, sb);
				}
			}
		}

		function recursePOS(s, zIndex, sb, pres) {
			var res = [s._box.w, s._box.h];
			s._box.calH = 0, s._box.calW = 0;
			if (s._box.h > 0) {
				s._box.calH = s._box.h;
			}

			for (var i = 0, ii = s.nodes.length; i < ii; i++) {
				var somC = s.nodes.item(i);
				if (somC.isContainer) {
					somC._box.temp = somC._box.y;
				}
			}

			for (var i = 0, ii = s.nodes.length; i < ii; i++) {
				var somC = s.nodes.item(i);
				if (somC.isContainer) {
					move.x = s._box.calX + (s._box.marL + somC._box.x);
					move.y = s._box.calY + (s._box.marT + somC._box.temp);
					recurseDraw(somC, zIndex + 1, sb, pres);
					if (somC.isWidget) {
						var rot = somC.rotate;
						if (rot === "90" || rot === "270") {
							continue;
						}
					}
					s._box.calW = Math.max(somC._box.calW + somC._box.x, s._box.calW);
					s._box.calH = Math.max(somC._box.calH + somC._box.temp, s._box.calH);
				}
			}
			if (s._box.h === 0) {
				s._box.calH = s._box.calH + s._box.marB + s._box.marT;
			}
			if (s._box.w > 0) {
				s._box.calW = s._box.w;
			} else {
				s._box.calW = s._box.calW + s._box.marR + s._box.marL;
			}
			return res;
		}

		function recurseTB(s, zIndex, sb, pres) {
			move.x += s._box.marL;
			move.y += s._box.marT;
			s._box.calH = 0, s._box.calW = 0;
			for (var i = 0, ii = s.nodes.length; i < ii; i++) {
				var somC = s.nodes.item(i);
				if (somC.isContainer) {
					recurseDraw(somC, zIndex + 1, sb, pres);
					if (somC._classHash === LCO.SUBFORM && somC._nameHash !== 0) {
						var im = somC.instanceManager;
						if (im && im.count === 0) {
							continue;
						}
					}
					move.y += (somC._box.calH);
					s._box.calH += somC._box.calH;
					s._box.calW = Math.max(somC._box.calW, s._box.calW);
				}
			}
			if (s._box.h > 0) {
				s._box.calH = s._box.h;
			} else {
				s._box.calH = s._box.calH + s._box.marB + s._box.marT;
			}
			if (s._box.w > 0) {
				s._box.calW = s._box.w;
			} else {
				s._box.calW = s._box.calW + s._box.marR + s._box.marL;
			}
		}

		function recurseLRTB(s, zIndex, sb, pres) {
			var bw = Math.round(s._box.w);
			move.x += s._box.marL;
			move.y += s._box.marT;
			s._box.calH = 0, s._box.calW = 0;
			for (var i = 0, ii = s.nodes.length; i < ii; i++) {
				var somC = s.nodes.item(i);
				if (somC.isContainer) {
					var prevX = move.x;
					var prevY = move.y;
					recurseDraw(somC, zIndex + 1, null, pres);
					move.x = prevX;
					move.y = prevY;

					if (bw > 0 && Math.round((move.x - s._box.calX) + somC._box.calW) > bw) {
						move.y = s._box.calY + s._box.calH;
						move.x = s._box.calX;
					}
					somC._box.calW = 0, somC._box.calH = 0;
					recurseDraw(somC, zIndex + 1, sb, pres);
					move.x += somC._box.calW;
					s._box.calH = Math.max((move.y - s._box.calY) + somC._box.calH, s._box.calH);
					s._box.calW = Math.max(s._box.calW, (move.x - s._box.calX));
				}
			}

			if (s._box.h > 0) {
				s._box.calH = s._box.h;
			} else {
				s._box.calH = s._box.calH + s._box.marB + s._box.marT;
			}
			if (s._box.w > 0) {
				s._box.calW = s._box.w;
			} else {
				s._box.calW = s._box.calW + s._box.marR + s._box.marL;
			}
			move.y += s._box.marB;
		}

		function recurseTABLE(s, zIndex, sb, pres) {
			move.x += s._box.marL;
			move.y += s._box.marT;

			s._box.calH = 0, s._box.calW = 0;
			var temp = s.columnWidths;
			if (temp.length > 0) {
				var cols = temp.split(" ");
				for (var i = 0, ii = cols.length; i < ii; i++) {
					s._box.calW += LCMath.px(cols[i]);
				}
			}
			for (var i = 0, ii = s.nodes.length; i < ii; i++) {
				var somC = s.nodes.item(i);
				if (somC.isContainer) {
					recurseDraw(somC, zIndex + 1, sb, pres);
					move.y += (somC._box.calH);
					s._box.calH += somC._box.calH;
					s._box.calW = Math.max(somC._box.calW, s._box.calW);
				}
			}
			s._box.calH = Math.max(s._box.calH + s._box.marB + s._box.marT, s._box.h);
			s._box.calW = Math.max(s._box.calW + s._box.marR + s._box.marL, s._box.w);
		}

		function recurseROW(s, zIndex, sb, pres) {
			move.x += s._box.marL;
			move.y += s._box.marT;

			var ps = s.parent;
			while (ps !== null) {
				if (ps._classHash === LCO.SUBFORM) {
					break;
				}
				ps = ps.parent;
			}

			s._box.calH = 0, s._box.calW = 0;
			var temp = ps.columnWidths;
			var cols;
			if (temp.length > 0) {
				var colStr = temp.split(" ");
				cols = new Array(colStr.length);
				for (var i = 0, ii = colStr.length; i < ii; i++) {
					cols[i] = LCMath.px(colStr[i]);
					s._box.calW += cols[i];
				}
			}
			var p = 0;

			var sub = LCU.findChild(s, LCO.SUBFORM);
			var maxH = 0;
			if (!sub) {
				for (var i = 0, ii = s.nodes.length; i < ii; i++) {
					var somC = s.nodes.item(i);
					if (somC.isContainer) {
						var prevX = move.x;
						var prevY = move.y;
						recurseDraw(somC, zIndex + 1, null, pres);
						move.x = prevX;
						move.y = prevY;
						maxH = Math.max(somC._box.calH, maxH);
					}
				}
			}

			for (var i = 0, ii = s.nodes.length; i < ii; i++) {
				var somC = s.nodes.item(i);
				if (somC.isContainer) {
					var cSpan = parseInt(somC.colSpan);
					var spanW = 0;
					for (var j = 0; j < cSpan; j++) {
						spanW += cols[p++];
					}
					somC._box.calW = spanW;
					if (maxH > 0) {
						somC._box.calH = maxH;
					}
					recurseDraw(somC, zIndex + 1, sb, pres);
					move.x += spanW;
					s._box.calH = Math.max(somC._box.calH, s._box.calH);

				}
			}

			s._box.calH = Math.max(s._box.calH + s._box.marB + s._box.marT, s._box.h);
			s._box.calW = Math.max(s._box.calW + s._box.marR + s._box.marL, s._box.w);
		}

		function getAncsMargins(s) {
			var res = {T: 0, R: 0, B: 0, L: 0};
			var p = s.parent;
			while (p && p._classHash !== LCO.TEMPLATE) {
				if (p._box) {
					res.L += p._box.marL;
					res.R += p._box.marR;
					res.T += p._box.marT;
					res.B += p._box.marB;
				}
				p = p.parent;
			}
			return res;
		}

		function genWidgetDom(som, zIndex, pres) {
			var sb = [];
			var classCSS = [];
			var outCSS = [];
			var internal = "";

			switch (som._classHash) {
				case LCO.FIELD:
				case LCO.DRAW:
					classCSS.push(som._classHash === LCO.FIELD ? "field" : "draw");
					var font = LCU.findChild(som, LCO.FONT);
					var ctxFont = ["normal", "13px", "Courier"];
					if (font) {
						updateFont(font, ctxFont, outCSS);
					}
					internal = som._classHash === LCO.FIELD ? updateField(som, outCSS, ctxFont)
							: updateDraw(som, classCSS, outCSS, ctxFont);
					if (pres === "hidden") {
						classCSS.push("hidden");
					} else if (pres === "invisible") {
						classCSS.push("invisible");
					} else {
						var border = LCU.findChild(som, LCO.BORDER);
						if (border) {
							updateBorder(border, classCSS, outCSS);
						}
						if (XFAOptions.HIGHLIGHT) {
							classCSS.push("highlight");
						}
						var zz = som._classHash === LCO.FIELD ? zIndex + 1000 : zIndex;
						outCSS.push("z-index:" + zz);
						if (som._box.calX > 0) {
							outCSS.push("margin-left:" + (som._box.calX) + LCPX);
						}
						if (som._box.calY > 0) {
							outCSS.push("margin-top:" + (som._box.calY) + LCPX);
						}
					}
					break;
			}
			sb.push("<div class=\"" + classCSS.join(' ') + "\"");
			if (outCSS.length > 0) {
				sb.push(" style=\"" + outCSS.join(';') + "\"");
			}
			sb.push(">");
			sb.push(internal);
			sb.push("</div>");
			return sb.join('');
		}

		function getFieldDim(som) {
			var font = LCU.findChild(som, LCO.FONT);
			var ctxFont = ["normal", "13px", "Courier"];
			if (font) {
				updateFont(font, ctxFont, []);
			}
			var fontH = LCMath.px(ctxFont[1]);

			var f = som;
			var b = f._box;

			var cw = 0, ch = 0, cx = 0, cy = 0, iw = 0, ih = 0, ix = 0, iy = 0;
			var tw = 0, th = 0;
			var capStr = "", capV = "";


			var fiw = b.calW > 0 ? b.calW : b.w > 0 ? b.w : b.minW > 0 ? b.minW :
					b.maxW > 0 ? b.maxW : 0;
			var fih = b.h > 0 ? b.h : b.minH > 0 ? b.minH :
					b.maxH > 0 ? b.maxH : 0;

			var ui, cap;
			for (var i = 0, ii = f.nodes.length; i < ii; i++) {
				var it = f.nodes.item(i);
				switch (it._classHash) {
					case LCO.UI:
						ui = it;
						break;
					case LCO.CAPTION:
						cap = it;
						break;
				}
			}

			if (cap) {
				if (b.resW === 0) {
					var res = cap.reserve;
					if (res.length > 0) {
						b.resW = LCMath.px(res);
					}
				}
				var val = LCU.findChild(cap, LCO.VALUE);
				var plc = cap.placement;
				var capFont = LCU.findChild(cap, LCO.FONT);

				if (val) {
					var t = LCU.findChild(val, LCO.TEXT);
					if (t) {
						capStr = t._textStream;
					}
					var ex = LCU.findChild(val, LCO.EXDATA);
					if (ex) {
						capStr = ex._textStream;
					}
					if (plc === "top" || plc === "bottom") {
						th = b.resW;
					} else {
						tw = b.resW;
					}
					var cFont = ctxFont.join(' ');
					var cFontH = fontH;

					if (capFont) {
						updateFont(capFont, ctxFont, []);
						cFont = ctxFont.join(' ');
						cFontH = LCMath.px(ctxFont[1]);
					}

					if (tw === 0) {
						tw = b.capW > 0 ? b.capW : LCU.getTextWidth(capStr, cFont, ex);
						b.capW = tw;
					}
					if (th === 0) {
						th = b.capH > 0 ? b.capH : LCU.getTextHeight(capStr, cFont, cFontH, ex, tw);
						b.capH = th;
					}
					fiw = fiw === 0 ? tw + b.marL + b.marR : fiw;
					fih = fih === 0 ? th + b.marT + b.marB : fih;
				}

				var cPara = LCU.findChild(cap, LCO.PARA);
				if (cPara) {
					capV = cPara.vAlign;
				}
				var bih = fih - b.marT - b.marB;
				if (plc === "top" || plc === "bottom") {
					var isT = plc === "top";
					cx = ix = b.marL;
					ch = th;
					cw = fiw - b.marL - b.marT;
					ih = fih - ch - b.marT - b.marB;
					iw = fiw - b.marL - b.marT;
					cy = isT ? b.marT : ih + b.marT;
					iy = isT ? ch + b.marT : b.marT;
				} else {
					var isR = plc === "right";
					if (capV === "middle") {
						cy = th < bih ? (bih - th) / 2 + b.marT : b.marT;
					} else if (capV === "bottom") {
						cy = th < bih ? (bih - th) + b.marT : b.marT;
					} else {
						cy = b.marT;
					}
					cw = tw;
					ch = th;
					iy = b.marT;
					iw = fiw - cw - b.marL - b.marR;
					ih = fih - b.marT - b.marB;
					cx = isR ? b.marL + iw : b.marL;
					ix = isR ? b.marL : cw + b.marL;
				}
			} else {
				ix = b.marL;
				iy = b.marT;
				iw = fiw > 0 ? fiw - b.marL - b.marR : 2;
				ih = fih > 0 ? fih - b.marT - b.marB : 10;
			}
			switch (LCU.getFieldType(f)) {
				case LCO.CHECKBUTTON:
					if (iw > 13) {
						ix += (iw - 13) / 2;
						iw = 13;
					}
					if (ih > 13) {
						iy += (ih - 13) / 2;
						ih = 13;
					}
					break;
				case LCO.BUTTON:
					ix = 0, iy = 0, iw = fiw, ih = fih;
					break;
				case LCO.TEXTEDIT:
					var def = f.rawValue;
					if (b.minH > 0 && LCU.hasValue(def) && LCU.isMultiLine(f)) {
						var hh = LCU.getTextHeight(def, font, fontH, null, iw);
						if (hh > ih) {
							ih = hh;
							if (cap) {
								if (plc === "top") {
									fih = iy + hh + b.marB;
								} else if (plc === "bottom") {
									fih = hh + ch + b.marT + b.marB;
									cy = hh + b.marT;
								} else {
									fih = hh + b.marT + b.marL;
								}
							} else {
								fih = hh + b.marT + b.marL;
							}
						}
					}
					break;
			}

			return {
				caption: {x: cx, y: cy, w: cw, h: ch},
				field: {x: ix, y: iy, w: iw, h: ih},
				total: {w: fiw, h: fih}
			};
		}

		function updateWidgetDim(som, pres) {

			var b = som._box;
			if (pres === "hidden") {
				b.calW = 0;
				b.calH = 0;
				return;
			}
			var result = [0, 0];
			if (b.calW > 0) {
				result[0] = b.calW;
			} else if (b.w > 0) {
				result[0] = b.w;
			}

			if (b.calH > 0) {
				if (LCU.getFieldType(som) === LCO.TEXTEDIT && (b.minH > 0 && LCU.isMultiLine(som))) {
					result[1] = 0;
				} else {
					result[1] = b.calH;
				}
			} else if (b.h > 0) {
				result[1] = b.h;
			}

			if (result[0] > 0 && result[1] > 0) {
				som._box.calW = result[0];
				som._box.calH = result[1];
				return;
			}
			var capStr = "", calW = 0, calH = 0, tw = 0, th = 0;
			var font = LCU.findChild(som, LCO.FONT);
			var ctxFont = ["normal", "13px", "Courier"];
			if (font) {
				var t = font.typeface;
				var s = font.size;
				var w = font.weight;
				var p = font.posture;
				ctxFont[2] = t;
				var ps = LCMath.px(s);
				ctxFont[1] = ps + LCPX;
				ctxFont[0] = w;
			}
			var ui = LCU.findChild(som, LCO.UI);

			switch (som._classHash) {
				case LCO.FIELD:
					var dims = getFieldDim(som);
					calW = dims.total.w;
					calH = dims.total.h;
					break;
				case LCO.DRAW:
					var val = LCU.findChild(som, LCO.VALUE);
					if (ui) {
						var textEdit = LCU.findChild(ui, LCO.TEXTEDIT);
						if (textEdit) {
							var fontH = LCMath.px(ctxFont[1]);
							var cFont = ctxFont.join(' ');

							if (val) {
								var t = LCU.findChild(val, LCO.TEXT);
								if (t) {
									capStr = t._textStream;
								}
								var ex = LCU.findChild(val, LCO.EXDATA);
								if (ex) {
									capStr = ex._textStream;
								}
								var tw = b.w > 0 ? b.w - b.marR - b.marL : LCU.getTextWidth(capStr, cFont, ex);
								calW = b.marL + b.marR + tw;
								var th = LCU.getTextHeight(capStr, cFont, fontH, ex, tw);
								calH = b.marT + b.marB + th;
							}
						}
					}
					break;
			}
			if (som._classHash === LCO.FIELD || som._classHash === LCO.DRAW) {
				if (b.w === 0) {
					calW = Math.max(calW, b.minW);
					if (b.maxW > 0) {
						calW = Math.min(calW, b.maxW);
					}
					result[0] = calW;
				}
				if (b.h === 0) {
					calH = Math.max(calH, b.minH);
					if (b.maxH > 0) {
						calH = Math.min(calH, b.maxH);
					}
					result[1] = calH;
				}
			}
			som._box.calW = result[0];
			som._box.calH = result[1];
		}

		function updateBorder(border, classCSS, outCSS) {
			var eList = LCU.findChildren(border, LCO.EDGE);
			var fill = LCU.findChild(border, LCO.FILL);
			var e, c, t, s, color, sc, ec, lt, cv = "", fcv = "";
			if (fill) {
				c = LCU.findChild(fill, LCO.COLOR);
				if (c) {
					cv = c.value;
				}
				var noPattern = true;
				for (var i = 0, ii = fill.nodes.length; i < ii; i++) {
					var fi = fill.nodes.item(i);
					var fic = LCU.findChild(fi, LCO.COLOR);
					if (fic) {
						fcv = fic.value;
					}
					sc = cv.length > 0 ? cv : "255,255,255";
					ec = fcv.length > 0 ? fcv : "0,0,0";
					switch (fi._classHash) {
						case LCO.LINEAR:
							lt = fi.type;
							noPattern = false;
							var suffix = "";
							if (lt === "toBottom") {
							} else if (lt === "toLeft") {
								suffix = "to left,";
							} else if (lt === "toTop") {
								suffix = "to top,";
							} else {
								suffix = "to right,";
							}
							outCSS.push("background:linear-gradient(" + suffix + "rgb(" + sc + "),rgb(" + ec + "))");
							break;
						case LCO.RADIAL:
							lt = fi.type;
							if (lt === "toCenter") {
								outCSS.push("background:radial-gradient(circle,rgb(" + ec + "),rgb(" + sc + "))");
							} else {
								outCSS.push("background:radial-gradient(circle,rgb(" + sc + "),rgb(" + ec + "))");
							}
							noPattern = false;
							break;
						case LCO.PATTERN:
							lt = fi.type;
							var deg = "";
							if (lt === "horizontal") {
							} else if (lt === "vertical") {
								deg = "90deg,";
							} else if (lt === "diagonalLeft") {
								deg = "45deg,";
							} else if (lt === "diagonalRight") {
								deg = "135deg,";
							}
							outCSS.push("background: repeating-linear-gradient(" + deg
									+ "rgb(" + sc + "), rgb(" + sc + ") 5px,rgb(" + ec + ") 6px)");
							break;
					}
				}
				if (noPattern && cv.length > 0) {
					outCSS.push("background-color:rgb(" + cv + ")");
				}
			}

			if (eList.length === 1 && eList.item(0).presence !== "hidden") {
				e = eList.item(0);
				c = LCU.findChild(e, LCO.COLOR);
				t = e.thickness;
				s = e.stroke;
				if (c) {
					color = c.value;
					color = color.length === 0 ? "#000" : "rgb(" + color + ")";
					outCSS.push("outline:" + color + " " + LCStroke[s] + " " + LCMath.px(t) + LCPX);
				} else {
					classCSS.push("default");
				}
			} else {
				var pc = 0, cc = 0, pos = 0;
				var sstr = "box-shadow:";
				for (var i = 0, ii = eList.length; i < ii; i++) {
					e = eList.item(i);
					if (e.presence !== "hidden") {
						pc++;
						pos = i;
						c = LCU.findChild(e, LCO.COLOR);
						color = "#000";
						if (c) {
							cc++;
							var cAtr = c.value;
							color = cAtr.length === 0 ? "#000" : "rgb(" + cAtr + ")";
						}
						var t = LCMath.px(e.thickness);
						if (pc > 1) {
							sstr += ",";
						}
						switch (i) {
							case 0:
								sstr += "0px -" + t + "px " + color;
								break;
							case 1:
								sstr += t + "px 0px " + color;
								break;
							case 2:
								sstr += "0px " + t + "px " + color;
								break;
							case 3:
								sstr += "-" + t + "px 0px " + color;
								break;
						}
					}
				}
				if (pc === 1 && cc === 0) {
					classCSS.push("edge" + pos);
				} else if (pc > 1) {
					outCSS.push(sstr);
				}
			}
		}

		function updateFont(font, ctxFont, outCSS) {
			var t = font.typeface;
			var s = font.size;
			var w = font.weight;
			var p = font.posture;
			var c = LCU.findDesc(font, LCO.COLOR);

			if (t.indexOf("Myriad Pro") > -1) {
				outCSS.push("font-family:" + "Myriad Pro");
			} else {
				outCSS.push("font-family:" + t);
			}
			ctxFont[2] = t;

			var ps = LCMath.px(s);
			outCSS.push("font-size:" + ps + LCPX);
			ctxFont[1] = ps + LCPX;

			outCSS.push("font-weight:" + w);
			ctxFont[0] = w;

			if (p.length > 0) {
				outCSS.push("font-style:" + p);
			}
			if (c) {
				var cv = c.value;
				if (cv.length > 0) {
					outCSS.push("color:rgb(" + cv + ")");
				}
			}
		}

		function updateWH(som, tw, th) {
			var wh = [0, 0];
			var b = som._box;
			var twm = tw + b.marL + b.marR;
			var thm = th + b.marT + b.marB;
			if (b.calW > 0) {
				wh[0] = b.calW;
			} else if (b.w > 0) {
				wh[0] = b.w;
			} else {
				if (b.minW > 0) {
					wh[0] = Math.max(b.minW, twm);
				}
				if (b.maxW > 0) {
					wh[0] = Math.min(b.maxW, twm);
				}
			}
			if (b.calH > 0) {
				wh[1] = b.calH;
			} else if (b.h > 0) {
				wh[1] = b.h;
			} else {
				if (b.minH > 0) {
					wh[1] = Math.max(b.minH, thm);
				}
				if (b.maxH > 0) {
					wh[1] = Math.min(b.maxH, thm);
				}
			}
			wh[0] = wh[0] === 0 ? twm : wh[0];
			wh[1] = wh[1] === 0 ? thm : wh[1];
			return wh;
		}

		function updateField(f, outCSS, ctxFont) {
			var ui, cap, img, intg, flt, dcml, value;
			var paraH = "left";
			for (var i = 0, ii = f.nodes.length; i < ii; i++) {
				var it = f.nodes.item(i);
				switch (it._classHash) {
					case LCO.UI:
						ui = it;
						break;
					case LCO.CAPTION:
						cap = it;
						break;
					case LCO.PARA:
						paraH = it.hAlign;
						break;
					case LCO.VALUE:
						value = it;
						var img = LCU.findChild(it, LCO.IMAGE);
						intg = LCU.findChild(it, LCO.INTEGER);
						flt = LCU.findChild(it, LCO.FLOAT);
						dcml = LCU.findChild(it, LCO.DECIMAL);
						break;
				}
			}
			var eObj = updateEvents(f);
			var access = f.access;

			var def = f.rawValue, sid = f._somId;
			var sb = [], capCSS = [], inCSS = [], inClass = [];
			var capStr = "", capH = "";
			var dim = getFieldDim(f);

			if (cap) {
				var val = LCU.findChild(cap, LCO.VALUE);

				if (val) {
					var t = LCU.findChild(val, LCO.TEXT);
					if (t) {
						capStr = t._textStream;
					}
					var ex = LCU.findChild(val, LCO.EXDATA);
					if (ex) {
						capStr = ex._textStream;
					}
				}
				var cPara = LCU.findChild(cap, LCO.PARA);
				if (cPara) {
					capH = cPara.hAlign;
				}

				var capFont = LCU.findChild(cap, LCO.FONT);
				if (capFont) {
					updateFont(capFont, ctxFont, capCSS);
				}

				capCSS.push("margin-left:" + dim.caption.x + LCPX);
				capCSS.push("margin-top:" + dim.caption.y + LCPX);
				capCSS.push("width:" + dim.caption.w + LCPX);
				capCSS.push("height:" + dim.caption.h + LCPX);
				if (capH.length > 0) {
					capCSS.push("text-align:" + capH);
				}
			}

			if (ui) {
				var comb;

				for (var i = 0, ii = ui.nodes.length; i < ii; i++) {
					var it = ui.nodes.item(i);
					var nn = "", tt = "", opts = "", extra = "";
					var isButton = false;

					comb = LCU.findChild(it, LCO.COMB);
					var nCells = 0;
					if (comb) {
						nCells = parseInt(comb.numberOfCells);
					}

					switch (it._classHash) {
						case LCO.TEXTEDIT:
							var multi = it.multiLine;
							if (multi === "1") {
								nn = "textArea";
								if (def) {
									opts = def;
								}
							} else {
								nn = "input", tt = "text";
								if (def) {
									extra += " value=\"" + def + "\"";
								}
							}
							break;
						case LCO.NUMERICEDIT:
							nn = "input", tt = "number"; // pattern = "[-+]?[0-9]*[.,]?[0-9]+";
							if (!intg) {
								extra += " step=\"any\"";
								if (LCU.isNumber(def)) {
									if (intg) {
										def = parseInt(def);
									} else if (dcml) {
										def = parseFloat(def).toFixed(2);
									} else {
										def = parseFloat(def).toFixed(2);
									}
									extra += " value=\"" + def + "\"";
								}
							} else {
								if (LCU.isNumber(def)) {
									extra += " value=\"" + parseInt(def) + "\"";
								}
							}
							break;
						case LCO.DATETIMEEDIT:
							nn = "input", tt = "date";
							if (value) {
								var time = LCU.findChild(value, LCO.TIME);
								if (time) {
									tt = "time";
									if (def) {
										def = def.replace(/\./g, ':');
									}
								}
							}
							if (def) {
								extra += " value=\"" + def + "\"";
							}
							break;
						case LCO.CHECKBUTTON:
							nn = "input";
							var items = LCU.findChild(f, LCO.ITEMS);
							if (f.parent._classHash === LCO.EXCLGROUP) {
								if (Object.keys(eObj).length === 0) {
									eObj = updateEvents(f.parent);
								}
								extra += " name=\"" + f.parent._somId + "\"";
								if (items) {
									var num = LCU.findChild(items, LCO.INTEGER);
									if (!num) {
										num = LCU.findChild(items, LCO.TEXT);
									}
									if (num) {
										var val = num._textStream;
										extra += " value=\"" + val + "\"";
										if (val === f.parent.rawValue) {
											extra += " checked";
										}
									}
								}

								tt = "radio";
							} else {
								extra += def === "1" ? " checked" : "";
								tt = "checkbox";
							}
							break;
						case LCO.CHOICELIST:
							nn = "select";
							extra += it.open === " multiSelect" ? " multiple" : "";
							var its = LCU.findChildren(f, LCO.ITEMS);
							var items = [];
							var itemsV = [];
							if (its) {
								if (its.length === 2) {
									var texts0 = LCU.findChildren(its.item(0), LCO.TEXT);
									var texts1 = LCU.findChildren(its.item(1), LCO.TEXT);
									var max = Math.min(texts0.length, texts1.length);
									for (var i = 0, ii = max; i < ii; i++) {
										items.push(texts0.item(i)._textStream);
										itemsV.push(texts1.item(i)._textStream);
									}
								} else if (its.item(0)) {
									var texts = LCU.findChildren(its.item(0), LCO.TEXT);
									for (var i = 0, ii = texts.length; i < ii; i++) {
										items.push(texts.item(i)._textStream);
									}
								}
							}
							if (!def && items.length > 0 && items[0].trim().length > 0) {
								opts += "<option></option>";
							}
							var hasValues = itemsV.length > 0;
							for (var j = 0, jj = items.length; j < jj; j++) {
								if (hasValues) {
									if (def && def === itemsV[j]) {
										opts += "<option selected>" + items[j] + "</option>";
									} else {
										opts += "<option value='" + itemsV[j] + "'>" + items[j] + "</option>";
									}
								} else {
									if (def && def === items[j]) {
										opts += "<option selected>" + items[j] + "</option>";
									} else {
										opts += "<option>" + items[j] + "</option>";
									}
								}
							}
							break;
						case LCO.BUTTON:
							isButton = true;
							nn = "button";
							break;
						case LCO.PASSWORDEDIT:
							nn = "input", tt = "password";
							if (def) {
								extra += " value=\"" + def + "\"";
							}
							break;
						case LCO.IMAGEEDIT:
							extra += " onchange = \"app.changeImageEdit(this,'" + sid + "')\"";
							nn = "input", tt = "image";
							break;
						case LCO.SIGNATURE:
							nn = "input", tt = "image";
							break;
					}
					var border = LCU.findDesc(ui, LCO.BORDER);
					if (border && (it._classHash !== LCO.CHECKBUTTON)) {
						updateBorder(border, inClass, inCSS);
					}
					inCSS.push("margin-left:" + dim.field.x + LCPX + ";"
							+ "margin-top:" + dim.field.y + LCPX);
					inCSS.push("width:" + dim.field.w + LCPX + ";"
							+ "height:" + dim.field.h + LCPX);

					if (access === "readOnly") {
						inCSS.push("background-color: white");
						extra += " readonly";
					}
					if (nn.length > 0) {
						for (var en in eObj) {
							if (en.indexOf("on") === 0) {
								extra += " " + en + "=\"app.fireEvent(event," + eObj[en] + ")\"";
							}
						}
						if (!eObj["onchange"]) {
							extra += " onchange ='app.fireValue(event)'";
						}

						if (isButton) {
							opts = capStr;
							for (var i = 0, max = capCSS.length; i < max; i++) {
								if (capCSS[i].indexOf("font-size") !== -1 || capCSS[i].indexOf("color") !== -1) {
									inCSS.push(capCSS[i]);
								}
							}
						} else {
							var calc = LCU.findChild(f, LCO.CALCULATE);
							inCSS.push("text-align:" + paraH);
							if (calc) {
								inClass.push("calculate");
							}
							if (comb && nCells > 0) {
								inClass.push("comb");
								var fs = LCMath.px(ctxFont[1]);
								var combW = fs * 0.6 * nCells;
								if (dim.field.w > combW && nCells > 1) {
									var spc = ((dim.field.w - combW) / nCells);
									inCSS.push("letter-spacing:" + spc + LCPX);
								}
							}
							if (capStr.length > 0) {
								sb.push("<label style=\"" + capCSS.join(';') + "\">" + capStr + "</label>");
							}
						}
						var ttStr = tt.length > 0 ? " type=\"" + tt + "\"" : "";
						if (inClass.length > 0) {
							ttStr += " class=\"" + inClass.join(' ') + "\"";
						}
						if (it._classHash === LCO.IMAGEEDIT) {
							var image64 = "";
							if (def) {
								var ct = "image/jpeg";
								if (img) {
									ct = img.contentType;
								}
								image64 = "data:" + ct + ";base64," + def + "\"";
							}
							var imfu = "IMFU" + sid;
							sb.push("<img style=\"position:absolute; max-width:"
									+ dim.field.w + "px; left:" + dim.field.x + "px; top: " + dim.field.y
									+ "px; max-height:" + dim.field.h
									+ "px\" id='" + imfu + "' src=\"" + image64
									+ "\" alt='image' /> ");
							sb.push("<input type=\"file\" style=\"left:" + dim.field.x
									+ "px;top:" + dim.field.y + "px;width:" + dim.field.w + "px;\" " + extra + "/>");
						} else {
							sb.push("<" + nn + " " + ttStr + extra + " id=\"" + sid + "\""
									+ " style=\"" + inCSS.join(';') + "\"" + " >" + opts + "</" + nn + ">");
						}
					}
				}
			}
			outCSS.push("width:" + dim.total.w + LCPX);
			outCSS.push("height:" + dim.total.h + LCPX);
			return sb.join('');
		}

		function updateEvents(f) {
			var e = {};
			var events = LCU.findChildren(f, LCO.EVENT);
			for (var i = 0, ii = events.length; i < ii; i++) {
				var act = LCMath.hash(events.item(i).activity);
				var hh = f._somId + "," + act;
				switch (act) {
					case LCV.MOUSEUP:
						e["onmouseup"] = hh;
						break;
					case LCV.MOUSEDOWN:
						e["onmousedown"] = hh;
						break;
					case LCV.MOUSEENTER:
						e["onmouseenter"] = hh;
						break;
					case LCV.MOUSEEXIT:
						e["onmouseleave"] = hh;
						break;
					case LCV.ENTER:
						e["onfocus"] = hh;
						break;
					case LCV.EXIT:
						e["onblur"] = hh;
						break;
					case LCV.CHANGE:
						e["onchange"] = hh;
						break;
					case LCV.CLICK:
						e["onclick"] = hh;
						break;
				}
			}
			return e;
		}

		function updateDraw(d, classCSS, outCSS, ctxFont) {
			var sb = [], capCSS = [];
			var cw = 0, ch = 0, cx = 0, cy = 0, tw, th;
			var b = d._box;
			var diw = b.calW > 0 ? b.calW : b.w > 0 ? b.w : b.minW > 0 ? b.minW :
					b.maxW > 0 ? b.maxW : 0;
			var dih = b.calH > 0 ? b.calH : b.h > 0 ? b.h : b.minH > 0 ? b.minH :
					b.maxH > 0 ? b.maxH : 0;
			var hAlign = "", vAlign = "";

			var val = LCU.findChild(d, LCO.VALUE);

			var rot = d.rotate;
			if (rot === "90" || rot === "270") {
				classCSS.push("rotate" + rot);
			}

			if (val) {
				for (var i = 0, ii = val.nodes.length; i < ii; i++) {
					var vi = val.nodes.item(i);
					switch (vi._classHash) {
						case LCO.LINE:
							var slp = vi.slope;
							var x1 = 0, y1 = 0, x2 = 0, y2 = 0;
							if (slp === "/") {
								x2 = diw;
								y2 = dih;
							} else {
								x1 = diw;
								y2 = dih;
							}
							if (dih === 0) {
								dih = 1;
								x2 = diw;
							} else if (diw === 0) {
								diw = 1;
								y2 = dih;
							}
							sb.push("<svg width=\"" + diw + LCPX + "\" height=\"" + dih + LCPX + "\">");
							sb.push("<line x1='" + x1 + LCPX + "' x2='" + x2 + LCPX + "' y1='" + y1 + LCPX + "' y2='" + y2 + LCPX + "' style=\"stroke:rgb(0,0,0)\"></line>");
							sb.push("</svg>");
							break;
						case LCO.ARC:
							var sweep = vi.sweepAngle;
							sb.push("<svg width=\"" + diw + LCPX + "\" height=\"" + dih + LCPX + "\">");
							if (sweep.length > 0) {

							} else {
								var crcl = vi.circular;
								var cx = diw >> 1, cy = dih >> 1, rx = diw >> 1, ry = dih >> 1;
								if (crcl !== "0") {
									var whm = Math.min(diw, dih);
									rx = ry = whm >> 1;
								}
								sb.push("<ellipse cx=\"" + cx + LCPX + "\" cy=\"" + cy + LCPX
										+ "\" rx=\"" + rx + LCPX + "\" ry=\"" + ry + LCPX
										+ "\" style='fill:rgba(0,0,0,0);stroke:black;stroke-width:1'/>");
							}
							sb.push("</svg>");
							break;
						case LCO.IMAGE:
							updateImage(vi, sb, diw, dih);
							break;
						case LCO.RECTANGLE:
							updateBorder(vi, classCSS, outCSS);
							break;
						case LCO.TEXT:
						case LCO.EXDATA:
							var cPara = LCU.findChild(d, LCO.PARA);
							if (cPara) {
								vAlign = cPara.vAlign;
								hAlign = cPara.hAlign;
							}
							var capStr = "";
							var fontH = LCMath.px(ctxFont[1]);
							var cFont = ctxFont.join(' ');
							capStr = vi._textStream;
							if (vi._classHash === LCO.TEXT) {
//                                capStr = FormCalc.encode(capStr, "html");
//                                capStr = capStr.replace("&#x2029;", "<br/>");
//                                capStr = capStr.replace("&nbsp;", " ");
							}
							tw = b.calW > 0 ? b.calW - b.marL - b.marR : b.w > 0 ? b.w - b.marL - b.marR : LCU.getTextWidth(capStr, cFont, vi._classHash === LCO.EXDATA);
							th = LCU.getTextHeight(capStr, cFont, fontH, vi._classHash === LCO.EXDATA, tw);
							var wh = updateWH(d, tw, th);
							diw = wh[0];
							dih = wh[1];
							cw = diw - b.marL - b.marR;
							ch = th;
							cx = b.marL;
							var dihm = dih - b.marT - b.marB;
							if (vAlign === "middle") {
								cy = th < dihm ? (dihm - th) / 2 + b.marT : b.marT;
							} else if (vAlign === "bottom") {
								cy = th < dihm ? (dihm - th) + b.marT : b.marT;
							} else {
								cy = b.marT;
							}
							capCSS.push("left:" + cx + LCPX);
							capCSS.push("top:" + cy + LCPX);
							capCSS.push("width:" + cw + LCPX);
							capCSS.push("height:" + ch + LCPX);
							if (hAlign.length > 0) {
								capCSS.push("text-align:" + hAlign);
							}
							sb.push("<label style=\"" + capCSS.join(';') + "\">" + capStr + "</label>");
							break;
					}
				}
			}
			var border = LCU.findChild(d, LCO.BORDER);
			if (border) {
				updateBorder(border, classCSS, outCSS);
			}
			outCSS.push("width:" + diw + LCPX);
			outCSS.push("height:" + dih + LCPX);
			return sb.join('');
		}

		function updateImage(img, sb, diw, dih) {
			var ct = img.contentType;
			var b64 = img._textStream;
			var aspect = img.aspect;
			var suffix = "";
			if (aspect === "none") {
				suffix = "style='width:" + diw + LCPX + ";height:" + dih + LCPX + "'";
			} else if (aspect === "width") {
				suffix = "style='width:" + diw + LCPX + "'";
			} else if (aspect === "height") {
				suffix = "style='height:" + dih + LCPX + "'";
			} else {
				suffix = "onload=\"app.fitImageEdit(this," + diw + "," + dih + ")\"";
			}
			sb.push("<img src=\"data:" + ct + ";base64, " + b64 + "\" alt='Image' " + suffix + "/>");

		}
	};

	this.parseDocument = function () {
		var xml64 = document.getElementById("templateDump").innerHTML;
		var encoding = new FDFXFAENCODING();
		var xmlStr = encoding.toUTF8(encoding.b64ToBytes(xml64));
		var data64 = document.getElementById("dataDump").innerHTML;
		
		var xfaDoc, dataDoc;
		if (window.DOMParser) {
			xfaDoc = (new window.DOMParser()).parseFromString(xmlStr, "text/xml");
		} else if (window.ActiveXObject && new window.ActiveXObject("Microsoft.XMLDOM")) {
			xfaDoc = new window.ActiveXObject("Microsoft.XMLDOM");
			xfaDoc.async = "false";
			xfaDoc.loadXML(xmlStr);
		}
		
		var dataDoc = getDataDoc(data64);

		var template = xfaDoc.getElementsByTagName("template")[0];

		xfa = new LCNode(null, "xfa");
		app.activeDocs[0].xfa = xfa;
		xfa.template = new LCNode(null, "template");
		xfa.layout = new LCLayoutPseudoModel();
		xfa.host = new LCHostPseudoModel();
		xfa.event = new LCEventPsudoModel();
		xfa.variables = {};
		xfa.templateStr = xmlStr;

		var variables = template.getElementsByTagName("variables");
		for (var i = 0, ii = variables.length; i < ii; i++) {
			var vchildren = variables[i].childNodes;
			for (var j = 0, jj = vchildren.length; j < jj; j++) {
				var vc = vchildren[j];
				var vn = vc.nodeName;
				if (vn === "script") {
					try {
						eval("function funcVariables ()" + LCU.variablesToObj(vc.textContent));
						xfa.variables[vc.getAttribute("name")] = new funcVariables();
					} catch (e) {
						console.log(e);
					}
				} else if (vn === "text") {
					var tNode = new LCNode(null, "text");
					tNode._textStream = vc.textContent;
					xfa.variables[vc.getAttribute("name")] = tNode;
				}
			}
		}
		
		recursiveMapXMLToSom(template, xfa.template);
		xfa.form = LCU.findDesc(xfa.template, LCO.SUBFORM);
		xfa.nodes.append(xfa.form);		

		recursiveInstanceUpdate(xfa.template);

		if (dataDoc) {
			var dataSets = new LCNode(null, "xfa:datasets");
			var domSets = dataDoc.getElementsByTagName("xfa:datasets")[0];
			recursiveMapDataToSom(domSets, dataSets);
			var dForm = LCU.findChild(xfa.datasets.data, LCO.DATAGROUP);
			if (dForm) {
				mapDataToSom(dForm, xfa.form);
			}
			xfa.form.recalculate();
		}

		recursiveEventFire(xfa.form, LCV.READY);
		recursiveEventFire(xfa.form, LCV.DOCREADY);
		//handle prototypes
		xfa.layout.thrashing = false;
		xfa.layout.relayout();

		function getDataDoc(data64) {
			if (data64 && data64.length > 0) {
				var enc = new FDFXFAENCODING();
				var dataStr = enc.toUTF8(enc.b64ToBytes(data64));
				dataStr = dataStr.substring(0, dataStr.lastIndexOf(">") + 1);
				if (window.DOMParser) {
					dataDoc = (new window.DOMParser()).parseFromString(dataStr, "text/xml");
				} else if (window.ActiveXObject && new window.ActiveXObject("Microsoft.XMLDOM")) {
					dataDoc = new window.ActiveXObject("Microsoft.XMLDOM");
					dataDoc.async = "false";
					dataDoc.loadXML(dataStr);
				}
				return dataDoc;
			}
			return null;
		}

		function mapDataToSom(data, form) {
			passOnce(data, form);
			passGlobal(data, form);
			passDataRef(data, form);

			function passOnce(dd, ff) {

				if (ff.isContainer || ff.isWidget) {
					var ffMatch = getBindMatch(ff);
					if (ff._classHash === LCO.AREA || ff._nameHash === 0) {
						ffMatch = "none";
					}

					if (isDataGroup(dd)) {
						if (dd.mapped) {
							for (var i = 0, max = dd.nodes.length; i < max; i++) {
								passOnce(dd.nodes.item(i), dd.mapped);
							}
						} else if (ff.mapped && dd.parent._somId === ff.mapped._somId) {
							for (var i = 0, max = ff.nodes.length; i < max; i++) {
								passOnce(dd, ff.nodes.item(i));
							}
						} else if (ffMatch === "none") {
							for (var i = 0, max = ff.nodes.length; i < max; i++) {
								passOnce(dd, ff.nodes.item(i));
							}
						} else if (ffMatch === "once") {
							if (dd._nameHash === ff._nameHash && isFormGroup(ff)) {
								var im = ff.instanceManager;
								if (im) {
									if (im.count === im.max) {
										if (!ff.mapped) {
											dd.mapped = ff;
											ff.mapped = dd;
											passOnce(dd, ff);
										}
									} else {
										if (im.count === 0) {
											ff.instanceManager.addInstance(1);
											if (!ff.mapped) {
												dd.mapped = ff;
												ff.mapped = dd;
												passOnce(dd, ff);
											}
										} else {
											var list = im.getInstances();
											var found = false;
											for (var i = 0, ii = list.length; i < ii; i++) {
												var li = list.item(i);
												if (!li.mapped) {
													dd.mapped = li;
													li.mapped = dd;
													passOnce(dd, li);
													found = true;
													break;
												}
											}
											if (!found && im.count < im.max) {
												var obj = im.addInstance();
												dd.mapped = obj;
												obj.mapped = dd;
												passOnce(dd, obj);
											}
										}
									}
								} else {
									if (!ff.mapped) {
										dd.mapped = ff;
										ff.mapped = dd;
										passOnce(dd, ff);
									}
								}
							}
						}
					} else {
						if (isFormGroup(ff)) {
							for (var i = 0, max = ff.nodes.length; i < max; i++) {
								passOnce(dd, ff.nodes.item(i));
							}
						} else if (dd._nameHash === ff._nameHash && isFormValue(ff) && !ff.mapped) {
							dd.mapped = ff;
							ff.mapped = dd;
							ff.rawValue = dd._textStream;
						}
					}
				}
			}

			function passGlobal(dd, ff) {
				if (ff.isContainer || ff.isWidget) {
					var ffMatch = getBindMatch(ff);
					if (isFormValue(ff) && ff._nameHash !== 0 && ffMatch === "global") {
						var list = new LCList();
						LCU.searchDownName(dd, ff._nameHash, list, true);
						if (list.length > 0) {
							ff.rawValue = list.item(0)._textStream;
						}
					}
					if (ff.isContainer) {
						for (var i = 0, ii = ff.nodes.length; i < ii; i++) {
							passGlobal(dd, ff.nodes.item(i));
						}
					}
				}
			}

			function passDataRef(dd, ff) {
				if (ff.isContainer || ff.isWidget) {
					var ffMatch = getBindMatch(ff);
					if (ffMatch === "dataRef" && ff._nameHash !== 0) {
						var ref = getBindRef(ff);
						var chunks = ref.split(".");
						var cur = dd, cc;
						if (isFormGroup(ff)) {
							for (var i = 0, ii = chunks.length; i < ii; i++) {
								cc = chunks[i];
								if (cc === "$") {
									continue;
								}
								var brac = cc.indexOf("[")
								if (brac > -1) {
									cc = cc.substring(0, brac);
								}
								var list = new LCList();
								LCU.searchDownName(cur, LCMath.hash(cc), list, false);
								if (list.length > 0) {
									for (var j = 0, jj = list.length; j < jj; j++) {
										var dx = list.item(j);
										var im = ff.instanceManager;
										if (im) {
											if (im.count === im.max) {
												if (!dx.mapped) {
													dx.mapped = ff;
													ff.mapped = dx;
													for (var z = 0, zz = ff.nodes.length; z < zz; z++) {
														passDataRef(dx, ff.nodes.item(z));
													}

												}
											} else {
												if (im.count === 0) {
													ff.instanceManager.addInstance(1);
													if (!dx.mapped) {
														dx.mapped = ff;
														ff.mapped = dx;
														for (var z = 0, zz = ff.nodes.length; z < zz; z++) {
															passDataRef(dx, ff.nodes.item(z));
														}
													}
												} else {
													var lists = ff.instanceManager.getInstances();
													var found = false;

													for (var q = 0, qq = lists.length; q < qq; q++) {
														var pp = lists.item(q);
														if (!pp.mapped) {
															dx.mapped = pp;
															pp.mapped = dx;
															passDataRef(dx, pp);
															found = true;
															break;
														}
													}
													if (!found) {
														if (im.count < im.max) {
															var obj = im.addInstance();
															dx.mapped = obj;
															obj.mapped = dx;
															for (var z = 0, zz = obj.nodes.length; z < zz; z++) {
																passDataRef(dx, obj.nodes.item(z));
															}
														}
													}
												}
											}
										}
									}
								}
								break;
							}
						} else if (isFormValue(ff)) {
							cur = dd;
							for (var i = 0, ii = chunks.length; i < ii; i++) {
								cc = chunks[i];
								if (cc === "$") {
									continue;
								}
								if (cc.indexOf("[") > -1) {
									cc = cc.substring(0, cc.indexOf("["));
								}
								var list = new LCList();
								LCU.searchDownName(cur, LCMath.hash(cc), list, true);
								if (list.length > 0) {
									cur = list.item(0);
								} else {
									var atr = cur.getAttribute(cc);
									if (atr.length > 0 && cc === ff.name) {
										ff.rawValue = atr;
										return;
									}
									break;
								}
							}

							if (cur._classHash === LCO.DATAVALUE) {
								ff.rawValue = cur._textStream;
							}
						}
					}
					if (ff.isContainer) {
						for (var i = 0, ii = ff.nodes.length; i < ii; i++) {
							passDataRef(dd, ff.nodes.item(i));
						}
					}
				}
			}

			function getBindMatch(f) {
				var bind = LCU.findChild(f, LCO.BIND);
				if (bind) {
					return bind.match;
				}
				return "once";
			}
			function getBindRef(f) {
				var bind = LCU.findChild(f, LCO.BIND);
				if (bind && bind.match === "dataRef") {
					return bind.ref;
				}
				return "";
			}

			function isDataGroup(d) {
				return d._classHash === LCO.DATAGROUP;
			}

			function isFormValue(f) {
				return f.isWidget || f._classHash === LCO.EXCLGROUP;
			}

			function isDataValue(d) {
				return d._classHash === LCO.DATAVALUE;
			}

			function isFormGroup(f) {
				return f._classHash === LCO.SUBFORM || f._classHash === LCO.SUBFORMSET;
			}

		}

	}

	function Doc() {
		//custom addition
		this.pages = [];
		this.alternatePresentations = {};
		this.author = "", this.baseURL = "";
		this.bookmarkRoot = {};
		this.calculate = false;
		this.creationDate = new Date();
		this.creator = "";
		this.dataObjects = [];
		this.delay = false;
		this.dirty = false;
		this.disclosed = false;
		this.docID = [];
		this.documentFileName = "";
		this.dynamicXFAForm = true;
		this.external = true;
		this.fileSize = 0; //should be in bytes
		this.hidden = false;
		this.hostContainer = {};
		this.icons = null;
		this.info = {};
		this.innerAppWindowRect = [];
		this.innerDocWindowRect = [];
		this.isModal = false;
		this.keywords = {};
		this.layout = "";
		this.media = {};
		this.metadata = "";
		this.modDate = new Date();
		this.mouseX = 0;
		this.mouseY = 0;
		this.noautoComplete = false;
		this.nocache = false;
		this.numFields = 0;
		this.numTemplates = 0;
		this.path = "";
		this.outerAppWindowRect = [];
		this.outerDocWindowRect = [];
		this._pageNum = 0;
		this.pageWindowRect = [];
		this.permStatusReady = false;
		this.producer = "PDFWriter";
		this.requiresFullSave = false;
		this.securityHandler = "";
		this.selectedAnnots = [];
		this.sounds = [];
		this.spellDictionaryOrder = [];
		this.spellLanguageOrder = [];
		this.subject = "";
		this.templates = [];
		this.title = "";
		this.URL = "";
		this.viewState = {};
		this.xfa = null;
		this.XFAForeground = true;
		this.zoom = 100;
		this.addAnnot = function () {
			console.log("not defined");
		};
		this.addField = function () {
			console.log("not defined");
		};
		this.addIcon = function () {
			console.log("not defined");
		};
		this.addLink = function () {
			console.log("not defined");
		};
		this.addRecipientListCryptFilter = function () {};
		this.addRequirement = function () {};
		this.addScript = function () {};
		this.addThumbnails = function () {};
		this.addWatermarkFromFile = function () {};
		this.addWatermarkFromText = function () {};
		this.addWebLinks = function () {};
		this.bringToFront = function () {};
		this.calculateNow = function () {};
		this.closeDoc = function () {};
		this.colorConvertPage = function () {};
		this.createDataObject = function () {};
		this.createTemplate = function () {};
		this.deletePages = function () {};
		this.embedDocAsDataObject = function () {};
		this.embedOutputIntent = function () {};
		this.encryptForRecipients = function () {};
		this.encryptUsingPolicy = function () {};
		this.exportAsFDF = function () {};
		this.exportAsText = function () {};
		this.exportAsXFDF = function () {};
		this.exportAsXFDFStr = function () {};
		this.exportDataObject = function () {};
		this.exportXFAData = function () {};
		this.extractPages = function () {};
		this.flattenPages = function () {};
		this.getAnnot = function () {};
		this.getAnnot3D = function () {};
		this.getAnnots = function () {};
		this.getAnnots3D = function () {};
		this.getColorConvertAction = function () {};
		this.getDataObject = function () {};
		this.getDataObjectContents = function () {};
		this.getField = function () {};
		this.getIcon = function () {};
		this.getLegalWarnings = function () {};
		this.getLinks = function () {};
		this.getNthFieldName = function () {};
		this.getNthTemplate = function () {};
		this.getOCGs = function () {};
		this.getOCGOrder = function () {};
		this.getPageBox = function () {};
		this.getPageLabel = function () {};
		this.getPageNthWord = function () {};
		this.getPageNthWordQuads = function () {};
		this.getPageNumWords = function () {};
		this.getPageRotation = function () {};
		this.getPageTransiction = function () {};
		this.getPrintParams = function () {};
		this.getSound = function () {};
		this.getTemplate = function () {};
		this.getURL = function (v) {
			window.open(v);
		};
		this.gotoNameDest = function () {};
		this.importAnFDF = function () {};
		this.importDataObject = function () {};
		this.importIcon = function () {};
		this.importSound = function () {};
		this.importTextData = function () {};
		this.importXFAData = function () {};
		this.insertPages = function () {};
		this.mailDoc = function () {};
		this.mailForm = function () {};
		this.movePage = function () {};
		this.newPage = function () {};
		this.openDataObject = function () {};
		this.print = function () {
			window.print();
		};
		this.removeDataObject = function () {};
		this.removeIcon = function () {};
		this.removeLinks = function () {};
		this.removeRequirement = function () {};
		this.removeScript = function () {};
		this.removeTemplate = function () {};
		this.removeThumbnails = function () {};
		this.removeWeblinks = function () {};
		this.replacePages = function () {};
		this.resetForm = function () {
			if (this.xfa) {
				LCU.recursiveReset(this.xfa.template);
				this.xfa.layout.thrashing = true;
			}
		};
		this.saveAs = function (cPath, cConvID, cFS, bCopy, bPrompToOverwrite) {
			//cConvID Valid extensions
			//com.adobe.Acrobat.eps eps
			//com.adobe.Acrobat.html-3-20 html, htm
			//com.adobe.Acrobat.html-4-01-css-1-00 html, htm
			//com.adobe.Acrobat.jpeg jpeg ,jpg, jpe
			//com.adobe.Acrobat.jp2k jpf,jpx,jp2,j2k,j2c,jpc
			//com.adobe.Acrobat.doc doc
			//com.callas.preflight.pdfa pdf
			//com.callas.preflight.pdfx pdf
			//com.adobe.Acrobat.png png
			//com.adobe.Acrobat.ps ps
			//com.adobe.Acrobat.rtf rft
			//com.adobe.Acrobat.accesstext txt
			//com.adobe.Acrobat.plain-text txt
			//com.adobe.Acrobat.tiff tiff, tif
			//com.adobe.Acrobat.xml-1-00 xml        
			console.log("saveAs not defined");
		};
		this.scroll = function (nx, ny) {
			window.scrollTo(nx, ny);
		};
		this.selectPageNthWord;
		this.setAction;
		this.setDataObjectContents;
		this.setOCGOrder;
		this.setPageAction;
		this.setPageBoxes;
		this.setPageLabels;
		this.setPageTabOrder;
		this.setPageTransitions;
		this.spawnPageFromTemplate;
		this.submitForm = function (url) {
			if (app.isFDF) {
				var dataArr = EcmaParser._insertFieldsToPDF("");
				var str64 = EcmaFilter.encodeBase64(dataArr);
				var form = document.getElementById("FDFXFA_Form");
				if (url) {
					form.setAttribute("action", url);
				} else {
					url = window.prompt("Please Enter URL to Submit Form; \n[ Please use 'pdfdata' as named parameter for accessing filled pdf as base64 ] \n[ Please refer to JPDFFORMS documentation for defining submit URL ]");
					form.setAttribute("action", url);
				}
				var textArea = document.getElementById("FDFXFA_Textarea");
				textArea.value = str64;
				form.submit();
			} else {
				var pdfDoc = new PdfDocument();
				var page = new PdfPage();
				pdfDoc.addPage(page);
				var text = new PdfText(70, 70, "Helvetica", 20, "Please wait...");
				page.addText(text);
				text = new PdfText(70, 110, "Helvetica", 11, "If this message is not eventually replaced by proper contents of the document, your PDF");
				page.addText(text);
				text = new PdfText(70, 124, "Helvetica", 11, "viewer may not be able to display this type of document.");
				page.addText(text);
				text = new PdfText(70, 150, "Helvetica", 11, "You can upgrade to the latest version of Adobe Reader for Windows, Mac, or Linux by");
				page.addText(text);
				text = new PdfText(70, 164, "Helvetica", 11, "visiting http://www.adobe.com/go/reader_download.");
				page.addText(text);
				text = new PdfText(70, 190, "Helvetica", 11, "For more assistance with Adobe Reader visit http://www.adobe.com/go/acrreader.");
				page.addText(text);
				text = new PdfText(70, 220, "Helvetica", 7.5, "Windows is either a registered trademark or a trademark of Microsoft Corporation in the United States and/or other countries. Mac is a trademark ");
				page.addText(text);
				text = new PdfText(70, 229, "Helvetica", 7.5, "of Apple Inc., registered in the United States and other countries. Linux is the registered trademark of Linus Torvalds in the U.S. and other ");
				page.addText(text);
				text = new PdfText(70, 238, "Helvetica", 7.5, "countries.");
				page.addText(text);

//    console.log(EcmaPDF.decode64(templateStr));
				var xdpStr = generateXDP();
				var str = pdfDoc.createPdfString(xdpStr);
				var str64 = EcmaPDF.encode64(str);
				var form = document.getElementById("FDFXFA_Form");
				if (url) {
					form.setAttribute("action", url);
				} else {
					url = window.prompt("Please Enter URL to Submit Form; \n[ Please use 'pdfdata' as named parameter for accessing filled pdf as base64 ] \n[ Please refer to JPDFFORMS documentation for defining submit URL ]");
					form.setAttribute("action", url);
				}
				var textArea = document.getElementById("FDFXFA_Textarea");
				textArea.value = str64;
				form.submit();
			}
		}
		this.syncAnnotScan = function () {};
	}

	Object.defineProperty(Doc.prototype, "pageNum", {
		get: function () {
			return this._pageNum;
		}, set: function (v) {
			if (v > -1 && v < this.numPages) {
				var areas = document.getElementsByClassName("pageArea");
				window.scrollTo(0, areas[v].offsetTop);
				this._pageNum = v;
			}
		}
	});

	Object.defineProperty(Doc.prototype, "numPages", {
		get: function () {
			return document.getElementsByClassName("pageArea").length;
		}
	});

	this.isFDF = false;
	this.activeDocs = [new Doc()];
	this.calculate = false;
	this.contstants = null;
	this.focusRect = false;
	this.formsVersion = 6.0;
	this.fromPDFConverters = [];
	this.fs = {};
	this.fullScreen = false;
	this.language = "ENU";
	this.media = {};
	this.monitors = {};
	this.numPlugins = 0;
	this.openInPlace = false;
	this.platform = "WIN";
	this.plugins = [];
	this.printColorProfiles = [];
	this.printNames = [];
	this.runtimeHighlight = false;
	this.runtimeHightlightColor = [];
	this.thermometer = null;
	this.toolBar = false;
	this.toolBarHorizontal = false;
	this.toolBarVertical = false;
	this.viewerType = "Exchange-Pro";
	this.viewerVariation = "Full";
	this.viewerVersion = 6.0;

	this.addMenuItem = function () {
		console.log("addMenuItem not defined");
	};
	this.addSubMenu = function () {
		console.log("addSubMenu not defined");
	};
	this.addToolButton = function () {
		console.log("addToolButton not defined");
	};
	this.alert = function () {
		var obj = {nIcon: 0, nType: 0, cTitle: "Adobe Acrobat", oDoc: null, oCheckBox: null};
		console.log("alert not defined");
	};
	this.beep = function () {
		var snd = new Audio("data:audio/wav;base64,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");
		snd.play();
	};
	this.beginPriv = function () {
		console.log("beginPriv not defined");
	};
	this.browseForDoc = function () {
		console.log("browseForDoc not defined");
	};
	this.clearInterval = function () {
		console.log("not defined");
	};
	this.clearTimeOut = function () {
		console.log("not defined");
	};
	this.endPriv = function () {
		console.log("endPriv not defined");
	};
	this.execDialog = function () {
		console.log("execDialog not defined");
		//read page 106 for dialog box handling as it is major subject to be implemented
	};
	this.execMenuItem = function (str) {
		var totalPages = document.getElementsByClassName("pageArea").length;
		var sParam = str.toUpperCase();
		if (sParam === "SAVEAS") {
			if (this.isFDF) {
				var pdfName = document.getElementById("FDFXFA_PDFName").textContent;
				EcmaParser.saveFormToPDF(pdfName);
			} else {
				createXFAPDF();
			}
		} else if (sParam === "PRINT") {
			this.activeDocs[0].print();
		} else if (sParam === "FIRSTPAGE") {
			this.activeDocs[0].pageNum = 0;
		} else if (sParam === "PREVPAGE") {
			this.activeDocs[0].pageNum--;
		} else if (sParam === "NEXTPAGE") {
			this.activeDocs[0].pageNum++;
		} else if (sParam === "LASTPAGE") {
			this.activeDocs[0].pageNum = totalPages - 1;
		}
	};

	this.getNthPluginName = function () {
		console.log("not defined");
	};
	this.getPath = function () {
		console.log("not defined");
	};
	this.goBack = function () {
		this.activeDocs[0].pageNum--;
	};
	this.goForward = function () {
		this.activeDocs[0].pageNum++;
	};
	this.hideMenuItem = function () {
		console.log("not defined");
	};
	this.hideToolbarButton = function () {
		console.log("not defined");
	};
	this.launchURL = function (v) {
		app.activeDocs[0].getURL(v);
	};
	this.listMenuItems = function () {
		console.log("not defined");
	};
	this.listToolbarButtons = function () {
		console.log("not defined");
	};
	this.mailGetAddrs = function () {
		console.log("not defined");
	};
	this.mailMsg = function () {
		console.log("not defined");
	};
	this.mailGetAddrs = function () {
		console.log("not defined");
	};
	this.newDoc = function () {
		console.log("not defined");
	};
	this.newFDF = function () {
		console.log("not defined");
	};
	this.openDoc = function () {
		console.log("not defined");
	};
	this.openFDF = function () {
		console.log("not defined");
	};
	this.popUpMenu = function () {
		console.log("not defined");
	};
	this.popUpMenuEx = function () {
		console.log("not defined");
	};
	this.removeToolButton = function () {
		console.log("not defined");
	};
	this.response = function (p1, p2, p3, p4) {
		var res;
		if (p2) {
			res = window.prompt(p1, p2);
		} else {
			res = window.prompt(p1);
		}
		return res;
	};
	this.setInterval = function () {
		console.log("not defined");
	};
	this.setTimeOut = function () {
		console.log("not defined");
	};
	this.trustedFunction = function () {
		console.log("not defined");
	};
	this.trustPropagatorFunction = function () {
		console.log("not defined");
	};

	this.changeImageEdit = function (input, imageId) {
		var img = document.getElementById("IMFU" + imageId);
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function (e) {
				var rr = "" + e.target.result;
				var som = LCU.findSomId(xfa.form, parseInt(imageId));
				if (som && rr.length > 0) {
					var raw = rr.substring(rr.indexOf(",") + 1);
					som._rawValue = raw;
				}
				img.setAttribute("src", rr);
			};
			reader.readAsDataURL(input.files[0]);
		}
	};

	this.fitImageEdit = function (e, maxW, maxH) {
		var iw = e.width;
		var ih = e.height;
		var ratio = Math.min((maxW / iw), (maxH / ih));
		e.style.width = "" + (iw * ratio) + LCPX;
		e.style.height = "" + (ih * ratio) + LCPX;
	};

	this.fireEvent = function (event, id, hh) {
		var ea = parseInt(hh);
		var sid = parseInt(id);
		var s = LCU.findSomId(xfa.template, sid);
		var vv;
		if (event.target.type.toUpperCase() === "CHECKBOX") {
			vv = event.target.checked ? "1" : "0";
		} else {
			vv = event.target.value;
		}

		xfa.event.target = s;
		switch (ea) {
			case LCV.MOUSEUP:
				xfa.event.name = "mouseUp";
				break;
			case LCV.MOUSEDOWN:
				xfa.event.name = "mouseDown";
				xfa.event.target = s;
				break;
			case LCV.MOUSEENTER:
				xfa.event.name = "mouseEnter";
				break;
			case LCV.MOUSEEXIT:
				xfa.event.name = "mouseExit";
				break;
			case LCV.ENTER:
				xfa.event.name = "enter";
				break;
			case LCV.EXIT:
				xfa.event.name = "exit";
				break;
			case LCV.CHANGE:
				xfa.event.name = "change";
				xfa.event.newText = vv;
				break;
			case LCV.CLICK:
				xfa.event.name = "click";
				break;
		}

		if (s) {
			if (ea === LCV.CHANGE || ea === LCV.CLICK) {
				s.rawValue = vv;
			} else if (ea === LCV.MOUSEUP && event.target.type.toUpperCase() === "RADIO") {
				s.rawValue = vv;
			}
			s.execEventHash(ea);
		}
		xfa.form.recalculate();
		xfa.layout.thrashing = true;
		if (xfa.layout.thrashing) {
			xfa.layout.relayout();
		}
	};

	this.fireValue = function (event) {
		var id = parseInt(event.target.getAttribute("id"));
		var s = LCU.findSomId(xfa.template, id);
		if (s) {
			if (event.target.type.toUpperCase() === "CHECKBOX") {
				s.rawValue = event.target.checked ? "1" : "0";
			} else {
				s.rawValue = event.target.value;
			}
		}
		xfa.form.recalculate();
		xfa.layout.thrashing = true;
		if (xfa.layout.thrashing) {
			xfa.layout.relayout();
		}
	};

	window.onscroll = function (e) {
		var sy = parseInt(document.documentElement.scrollTop || document.body.scrollTop);
		var areas = document.getElementsByClassName("pageArea");
		var sp = 0;
		for (var i = 0, ii = areas.length; i < ii; i++) {
			var eh = parseInt(areas[i].offsetTop) + parseInt(areas[i].offsetHeight);
			if (sy > eh) {
				sp++;
			}
		}
		var dd = document.getElementById("FDFXFA_PageLabel");
		if (dd) {
			dd.textContent = sp + 1;
		}
		app.activeDocs[0]._pageNum = sp;
	};

	function PdfDocument() {
		var FONTNAMES = [
			"ARIAL", "HELVETICA", "COURIER"
		];
		this._pages = new Array();
		this._xfaStreams = new Array();
		this._fontResources = new Array();
		for (var i = 0, ii = FONTNAMES.length; i < ii; i++) {
			var stream = "<</Type /Font /Subtype /Type1 /BaseFont /" + FONTNAMES[i].toLowerCase() + ">>";
			var xx = new PdfResource(FONTNAMES[i].toLowerCase(), stream);
			this._fontResources.push(xx);
		}
	}

	PdfDocument.prototype.addPage = function (objParam) {
		this._pages.push(objParam);
	};

	PdfDocument.prototype.addXFAStream = function (objParam) {
		this._xfaStreams.push(objParam);
	};

	function PdfPage() {
		this._width = 612;
		this._height = 792;
		this._texts = new Array();
		this._images = new Array();
	}

	PdfPage.prototype.setWidth = function (intParam) {
		this._width = intParam;
	};

	PdfPage.prototype.setHeight = function (intParam) {
		this._height = intParam;
	};

	PdfPage.prototype.addText = function (objParam) {
		objParam._y = this._height - objParam._y - objParam._fontSize;
		this._texts.push(objParam);
	};

	function PdfText(x, y, fontName, fontSize, fontText) {
		var FONTNAMES = {
			"ARIAL": "Arial", "HELVETICA": "Helvetica", "COURIER": "Courier"
		};
		this._x = x;
		this._y = y;
		this._fontName;
		var upperName = fontName.toUpperCase();
		if (upperName in FONTNAMES) {
			this._fontName = FONTNAMES[upperName];
		} else {
			this._fontName = FONTNAMES["ARIAL"];
		}
		this._fontSize = fontSize;
		this._fontText = fontText;
	}

	function PdfResource(name, stream) {
		this._name = name;
		this._stream = stream;
	}

	PdfDocument.prototype.createPdfString = function (xdpStr) {

		function getObjRef(id) {
			return id + " 0 R";
		}

		function getCatalogString(id) {
			return id + " 0 obj <</Type /Catalog /Pages " + getObjRef(id + 1) + ">>\nendobj\n";
		}

		function getXFACatalogString(id, xfaStart) {
			return  id + " 0 obj <</NeedsRendering true/AcroForm " + getObjRef(xfaStart) +
					"/Extensions<</ADBE<</BaseVersion/1.7/ExtensionLevel 5>>>>" +
					"/MarkInfo<</Marked true>>/Type /Catalog /Pages " + getObjRef(id + 1) + ">>\nendobj\n";
		}

		function getPageTreeString(id, pageCount) {
			var str = id + " 0 obj <</Type /Pages /Kids [ ";
			var start = id + 1;
			for (var i = 0; i < pageCount; i++) {
				str += getObjRef(i + start) + " ";
			}
			str += "] /Count " + pageCount + ">>\nendobj\n";
			return str;
		}

		function getPageString(pageId, pageTreeStart, resourceStart, pageContentId, pdfPage) {
			return pageId + " 0 obj <</Type /Page /Parent " + getObjRef(pageTreeStart)
					+ " /Resources " + getObjRef(resourceStart) + " /Contents " + getObjRef(pageContentId)
					+ " /MediaBox [0 0 " + pdfPage._width + " " + pdfPage._height + "] /Rotate 0"
					+ ">>\nendobj\n";
		}

		function getContentString(pageConentID, curPage) {
			var contentStr = "";
			var totalTexts = curPage._texts.length;
			for (var i = 0; i < totalTexts; i++) {
				var textObj = curPage._texts[i];
				contentStr += "BT /" + textObj._fontName + " " + textObj._fontSize + " Tf " + textObj._x + " " + textObj._y + " Td (" + textObj._fontText + ")Tj ET\n";
			}
			var tempArr = new Array();
			EcmaPDF.writeBytes(contentStr, tempArr);
			return pageConentID + " 0 obj <</Length " + tempArr.length + ">>\nstream\n" + contentStr + "\nendstream\nendobj\n";
		}

		function getResourceString(resourceStart, resourceLen, pdfDoc) {
			var str = resourceStart + " 0 obj <</Font <<";
			for (var i = 0; i < resourceLen; i++) {
				var rFont = pdfDoc._fontResources[i];
				str += "/" + rFont._name + " " + getObjRef(resourceStart + 1 + i) + " ";
			}
			str += ">> >>\nendObj\n";
			return str;
		}

		function getFontDefString(fontID, pdfResource) {
			//note the stream already contains dictionary tags
			return fontID + " 0 obj " + pdfResource._stream + "\nendobj\n";
		}

		function getZeroLead(num) {
			var numStr = "" + num;
			var balance = 10 - numStr.length;
			for (var i = 0; i < balance; i++) {
				numStr = "0" + numStr;
			}
			return numStr;
		}

		function getXrefString(xRef) {
			var len = xRef.length;
			var str = "xref\n0 " + (len + 1) + "\n0000000000 65535 f \n";
			for (var i = 0; i < len; i++) {
				str += getZeroLead(xRef[i]) + " 00000 n \n";
			}
			return str;
		}

		function getXFADefineString(id, xfaTempID) {
			return id + " 0 obj <</XFA " + getObjRef(xfaTempID) + "/Fields[]>>\nendobj\n";
		}

		function getXFATemplateString(id, sLen, tempStr) {
			return id + " 0 obj <</Length " + sLen + ">>stream\n" + tempStr + "\nendstream\nendobj\n";
		}

		var xRef = new Array();
		var pdfData = new Array();
		var pageCount = this._pages.length;
		var docStart = 1;
		var pageTreeStart = 2;
		var pageStart = 3;
		var contentStart = pageStart + pageCount;
		var resourcesStart = contentStart + pageCount;
		var fontResStart = resourcesStart + 1;
		var fontResLen = this._fontResources.length;
		var sTreeIndex = fontResStart + fontResLen;
		var xfaDefStart = sTreeIndex;

		//writeout version
		EcmaPDF.writeBytes("%PDF-1.7\n", pdfData);
		//writeout catalog
		var temp = null;
		if (xdpStr) {
			temp = getXFACatalogString(docStart, xfaDefStart);
		} else {
			temp = getCatalogString(docStart);
		}

		xRef.push(pdfData.length);
		EcmaPDF.writeBytes(temp, pdfData);
		//writeout pagetree
		temp = getPageTreeString(pageTreeStart, pageCount);
		xRef.push(pdfData.length);
		EcmaPDF.writeBytes(temp, pdfData);
		//add pages 
		for (var i = 0; i < pageCount; i++) {
			var curPage = this._pages[i];
			var pageID = pageStart + i;
			var pageConentID = contentStart + i;
			temp = getPageString(pageID, pageTreeStart, resourcesStart, pageConentID, curPage);
			xRef.push(pdfData.length);
			EcmaPDF.writeBytes(temp, pdfData);
		}
		//add page contents
		for (var i = 0; i < pageCount; i++) {
			var curPage = this._pages[i];
			var pageConentID = contentStart + i;
			temp = getContentString(pageConentID, curPage);
			xRef.push(pdfData.length);
			EcmaPDF.writeBytes(temp, pdfData);
		}
		// add Resources
		temp = getResourceString(resourcesStart, fontResLen, this);
		xRef.push(pdfData.length);
		EcmaPDF.writeBytes(temp, pdfData);
		//add each font dictionary
		for (var i = 0; i < fontResLen; i++) {
			temp = getFontDefString(fontResStart + i, this._fontResources[i]);
			xRef.push(pdfData.length);
			EcmaPDF.writeBytes(temp, pdfData);
		}

		if (xdpStr) {
			var xfaTemplateStart = xfaDefStart + 1;
			temp = getXFADefineString(xfaDefStart, xfaTemplateStart);
			xRef.push(pdfData.length);
			EcmaPDF.writeBytes(temp, pdfData);

			var tb = new Array();
			EcmaPDF.writeBytes(xdpStr, tb);

			temp = getXFATemplateString(xfaTemplateStart, tb.length, xdpStr);
			xRef.push(pdfData.length);
			EcmaPDF.writeBytes(temp, pdfData);
		}

		var xRefStart = pdfData.length;
		//add xref table
		temp = getXrefString(xRef);
		EcmaPDF.writeBytes(temp, pdfData);
		//add trailer
		temp = "trailer <</Size " + (xRef.length + 1) + " /Root 1 0 R>>\nstartxref\n" + xRefStart + "\n%%EOF";
		EcmaPDF.writeBytes(temp, pdfData);
		return EcmaPDF.bytesToString(pdfData);
	}

	function createXFAPDF() {
		var pdfDoc = new PdfDocument();
		var page = new PdfPage();
		pdfDoc.addPage(page);
		var text = new PdfText(70, 70, "Helvetica", 20, "Please wait...");
		page.addText(text);
		text = new PdfText(70, 110, "Helvetica", 11, "If this message is not eventually replaced by proper contents of the document, your PDF");
		page.addText(text);
		text = new PdfText(70, 124, "Helvetica", 11, "viewer may not be able to display this type of document.");
		page.addText(text);
		text = new PdfText(70, 150, "Helvetica", 11, "You can upgrade to the latest version of Adobe Reader for Windows, Mac, or Linux by");
		page.addText(text);
		text = new PdfText(70, 164, "Helvetica", 11, "visiting http://www.adobe.com/go/reader_download.");
		page.addText(text);
		text = new PdfText(70, 190, "Helvetica", 11, "For more assistance with Adobe Reader visit http://www.adobe.com/go/acrreader.");
		page.addText(text);
		text = new PdfText(70, 220, "Helvetica", 7.5, "Windows is either a registered trademark or a trademark of Microsoft Corporation in the United States and/or other countries. Mac is a trademark ");
		page.addText(text);
		text = new PdfText(70, 229, "Helvetica", 7.5, "of Apple Inc., registered in the United States and other countries. Linux is the registered trademark of Linus Torvalds in the U.S. and other ");
		page.addText(text);
		text = new PdfText(70, 238, "Helvetica", 7.5, "countries.");
		page.addText(text);

//    console.log(EcmaPDF.decode64(templateStr));
		var xdpStr = generateXDP();
		var str = pdfDoc.createPdfString(xdpStr);
		var hrefStr = "data:application/octet-stream;charset=utf-8;base64," + EcmaPDF.encode64(str);
		var title = document.title;
		title = title.length > 0 ? title : "File_Edited";
		var userAgent = "" + navigator.userAgent;
		if (userAgent.indexOf("Edge") > -1 || userAgent.indexOf("MSIE ") > -1) {
			var blobObject = new Blob([str]);
			window.navigator.msSaveBlob(blobObject, title + ".pdf");
			return;
		}
		var link = document.createElement("a");
		link.setAttribute("download", title + ".pdf");
		link.setAttribute("href", hrefStr);
		document.getElementById("preRenderer").appendChild(link);
		if ("click" in link) {
			link.click();
		} else { //hack for safari
			var clk = document.createEvent("MouseEvent");
			clk.initEvent("click", true, true);
			link.dispatchEvent(clk);
		}
		link.setAttribute("href", "");
	}


	function generateXDP() {

		var createTool = "AdobeLiveCycleDesignerES_V10.0";
		var pdfTool = "JPDF2HTML5";
		var createUUID = FormCalc.uuid();
		var d = new Date();
		var createDATE = d.toISOString();

		var prefix = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
		prefix += "<?xfa generator=\"" + createTool + "\" APIVersion=\"3.5.12002.0\"?>";
		prefix += "<xdp:xdp xmlns:xdp=\"http://ns.adobe.com/xdp/\" timeStamp=\"" + createDATE + "\" uuid=\"" + createUUID + "\">";

		var xmpMeta = "<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 5.2-c001 63.139439, 2011/06/07-10:39:26\">";
		xmpMeta += "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">";
		xmpMeta += "<rdf:Description xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\" rdf:about=\"\">";
		xmpMeta += "<xmp:MetadataDate>" + createDATE + "</xmp:MetadataDate>";
		xmpMeta += "<xmp:CreatorTool>" + createTool + "</xmp:CreatorTool>";
		xmpMeta += "</rdf:Description>";
		xmpMeta += "<rdf:Description xmlns:pdf=\"http://ns.adobe.com/pdf/1.3/\" rdf:about=\"\">";
		xmpMeta += "<pdf:Producer>" + pdfTool + "</pdf:Producer>";
		xmpMeta += "</rdf:Description>";
		xmpMeta += "<rdf:Description xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\" rdf:about=\"\">";
		xmpMeta += "<xmpMM:DocumentID>" + createUUID + "</xmpMM:DocumentID>";
		xmpMeta += "</rdf:Description>";
		xmpMeta += "<rdf:Description xmlns:desc=\"http://ns.adobe.com/xfa/promoted-desc/\" rdf:about=\"\">";
		xmpMeta += "<desc:version rdf:parseType=\"Resource\">";
		xmpMeta += "<rdf:value>10.0.2.20120224.1.869952.867557</rdf:value>";
		xmpMeta += "<desc:ref>/template/subform[1]</desc:ref>";
		xmpMeta += "</desc:version>";
		xmpMeta += "</rdf:Description>";
		xmpMeta += "</rdf:RDF>";
		xmpMeta += "</x:xmpmeta>";

		if (xfa.templateStr.indexOf("<?xml") === 0) {
			xfa.templateStr = xfa.templateStr.substring(xfa.templateStr.indexOf(">") + 1);
		}

		var configDump = document.getElementById("configDump");
		var configStr = "";
		if (configDump) {
			configStr = configDump.textContent;
			configStr = EcmaPDF.decode64(configStr);
		}

		var localeSetStr = document.getElementById("localeSetDump").textContent;
		localeSetStr = EcmaPDF.decode64(localeSetStr);

		var dataStr = "";

		var dataPrefix = "<xfa:datasets xmlns=\"\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"><xfa:data>";
		var dataSuffix = "</xfa:data></xfa:datasets>";
		var gData = {};
		var dd = generateXDPDataFromSom(xfa.form, gData);
		var gd = "";
		for (var gName in gData) {
			if (gName !== "_xquery") {
				gd += "<" + gName + ">" + gData[gName] + "</" + gName + ">";
			}
		}
		if (dd.length > 0) {
			if (gd.length > 0) {
				var end = dd.indexOf(">") + 1;
				var ee = dd.substring(0, end);
				dd = ee + gd + dd.substring(end);
			}
			dataStr = dataPrefix + dd + dataSuffix;
		}

		return prefix + "\n" + xfa.templateStr + "\n" + configStr + "\n" + dataStr + "\n" + localeSetStr + "\n" + xmpMeta + "\n" + "</xdp:xdp>\n\n";

		function generateXDPDataFromSom(som, gData) {

			var result = "";
			var bindMatch = LCU.getBindMatch(som);
			var sn = som.getAttribute("name");

			switch (som._classHash) {
				case LCO.SUBFORM:
				case LCO.SUBFORMSET:
					if (bindMatch === "none" || sn.length === 0) {
						for (var i = 0, ii = som.nodes.length; i < ii; i++) {
							result += generateXDPDataFromSom(som.nodes.item(i), gData);
						}
					} else {
						result += "<" + sn + ">"
						for (var i = 0, ii = som.nodes.length; i < ii; i++) {
							result += generateXDPDataFromSom(som.nodes.item(i), gData);

						}
						result += "</" + sn + ">";
					}
					break;
				case LCO.EXCLGROUP:
				case LCO.FIELD:
					if (sn.length > 0) {
						var raw = som.rawValue;
						if (bindMatch === "global") {
							if (LCU.hasValue(raw) && raw.length > 0) {
								gData[sn] = raw;
							}
						} else if (bindMatch !== "none") {
							if (LCU.hasValue(raw)) {
								result += "<" + sn + ">" + raw + "</" + sn + ">";
							}
						}
					}
					break;
			}
			return result;
		}
	}

	var EcmaPDF = {
		hashKey: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
		getDictionaryString: function (dataBytes, offsetStart) {
			var pos = offsetStart;
			var max = dataBytes.length;
			while (pos < max && dataBytes[pos] !== 60) {
				pos++;
			}
			var dictStack = [1];
			var result = "<<";
			pos += 2;
			while (dictStack.length !== 0 && pos < max) {
				var cc = dataBytes[pos];
				var next = dataBytes[pos + 1];
				if (cc === 60 && next && next === 60) {
					dictStack.push(1);
					pos += 2;
					result += "<<";
					continue;
				} else if (cc === 62 && next && next === 62) {
					dictStack.pop();
					pos += 2;
					result += ">>";
					continue;
				} else {
					result += String.fromCharCode(cc);
					pos++;
				}
			}
			return result;
		},
		byteToString: function (charCode) {
			return String.fromCharCode(charCode);
		},
		bytesToString: function (array) {
			var result = "";
			for (var i = 0; i < array.length; i++) {
				result += String.fromCharCode(parseInt(array[i]));
			}
			return result;
		},
		writeBytes: function (str, data) {
			for (var i = 0; i < str.length; i++) {
				var cc = str.charCodeAt(i);
				if (cc < 0x80) {
					data.push(cc);
				} else if (cc < 0x800) {
					data.push(0xc0 | (cc >> 6), 0x80 | (cc & 0x3f));
				} else if (cc < 0xd800 || cc >= 0xe000) {
					data.push(0xe0 | (cc >> 12), 0x80 | ((cc >> 6) & 0x3f),
							0x80 | (cc & 0x3f));
				} else {
					i++;
					cc = 0x10000 + (((cc & 0x3ff) << 10) | (str.charCodeAt(i) & 0x3ff));
					data.push(0xf0 | (cc >> 18), 0x80 | ((cc >> 12) & 0x3f),
							0x80 | ((cc >> 6) & 0x3f), 0x80 | (cc & 0x3f));
				}
			}
		},
		encode64: function (input) {
			var output = "";
			var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
			var i = 0;

			input = this.encodeUTF8(input);
			while (i < input.length) {
				chr1 = input.charCodeAt(i++);
				chr2 = input.charCodeAt(i++);
				chr3 = input.charCodeAt(i++);
				enc1 = chr1 >> 2;
				enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
				enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
				enc4 = chr3 & 63;
				if (isNaN(chr2)) {
					enc3 = enc4 = 64;
				} else if (isNaN(chr3)) {
					enc4 = 64;
				}
				output += this.hashKey.charAt(enc1) + this.hashKey.charAt(enc2) +
						this.hashKey.charAt(enc3) + this.hashKey.charAt(enc4);
			}
			return output;
		},
		decode64: function (input) {
			var output = "";
			var chr1, chr2, chr3;
			var enc1, enc2, enc3, enc4;
			var i = 0;

			input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
			var ii = input.length;

			while (i < ii) {
				enc1 = this.hashKey.indexOf(input.charAt(i++));
				enc2 = this.hashKey.indexOf(input.charAt(i++));
				enc3 = this.hashKey.indexOf(input.charAt(i++));
				enc4 = this.hashKey.indexOf(input.charAt(i++));

				chr1 = (enc1 << 2) | (enc2 >> 4);
				chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
				chr3 = ((enc3 & 3) << 6) | enc4;

				output += String.fromCharCode(chr1);

				if (enc3 !== 64) {
					output += String.fromCharCode(chr2);
				}
				if (enc4 !== 64) {
					output += String.fromCharCode(chr3);
				}
			}
			output = this.decodeUTF8(output);
			return output;

		},
		encodeUTF8: function (string) {
			string = string.replace(/\r\n/g, "\n");
			var utftext = "";

			for (var n = 0, nn = string.length; n < nn; n++) {
				var c = string.charCodeAt(n);
				if (c < 128) {
					utftext += String.fromCharCode(c);
				} else if ((c > 127) && (c < 2048)) {
					utftext += String.fromCharCode((c >> 6) | 192);
					utftext += String.fromCharCode((c & 63) | 128);
				} else {
					utftext += String.fromCharCode((c >> 12) | 224);
					utftext += String.fromCharCode(((c >> 6) & 63) | 128);
					utftext += String.fromCharCode((c & 63) | 128);
				}
			}
			return utftext;
		},
		decodeUTF8: function (utftext) {
			var str = "";
			var i = 0;
			var c, c2, c3;
			var ii = utftext.length;

			while (i < ii) {
				c = utftext.charCodeAt(i);
				if (c < 128) {
					str += String.fromCharCode(c);
					i++;
				} else if ((c > 191) && (c < 224)) {
					c2 = utftext.charCodeAt(i + 1);
					str += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
					i += 2;
				} else {
					c2 = utftext.charCodeAt(i + 1);
					c3 = utftext.charCodeAt(i + 2);
					str += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
					i += 3;
				}
			}
			return str;
		}
	};
}

var app = new APP();

function doScriptTest() {
//    var xmlStr = document.getElementById("inputField").value;
//    var ss = grabVariableFunctionObject(xmlStr);
//    console.log(ss);
//    document.getElementById("layoutDiv").innerHTML = ss;
}
