/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.extractor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import org.apache.poi.xslf.usermodel.XSLFComments;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentAuthor;

public class XSLFPowerPointExtractor
extends POIXMLTextExtractor {
    public static final XSLFRelation[] SUPPORTED_TYPES = new XSLFRelation[]{XSLFRelation.MAIN, XSLFRelation.MACRO, XSLFRelation.MACRO_TEMPLATE, XSLFRelation.PRESENTATIONML, XSLFRelation.PRESENTATIONML_TEMPLATE, XSLFRelation.PRESENTATION_MACRO};
    private XMLSlideShow slideshow;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;
    private boolean masterByDefault = false;

    public XSLFPowerPointExtractor(XMLSlideShow slideshow) {
        super(slideshow);
        this.slideshow = slideshow;
    }

    public XSLFPowerPointExtractor(XSLFSlideShow slideshow) throws XmlException, IOException {
        this(new XMLSlideShow(slideshow.getPackage()));
    }

    public XSLFPowerPointExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        this(new XSLFSlideShow(container));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSLFPowerPointExtractor <filename.pptx>");
            System.exit(1);
        }
        XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(new XSLFSlideShow(args[0]));
        System.out.println(((POITextExtractor)extractor).getText());
        extractor.close();
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
    }

    public void setMasterByDefault(boolean masterByDefault) {
        this.masterByDefault = masterByDefault;
    }

    @Override
    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault);
    }

    public String getText(boolean slideText, boolean notesText) {
        return this.getText(slideText, notesText, this.masterByDefault);
    }

    public String getText(boolean slideText, boolean notesText, boolean masterText) {
        StringBuilder text = new StringBuilder();
        for (XSLFSlide slide : this.slideshow.getSlides()) {
            text.append(XSLFPowerPointExtractor.getText(slide, slideText, notesText, masterText));
        }
        return text.toString();
    }

    public static String getText(XSLFSlide slide, boolean slideText, boolean notesText, boolean masterText) {
        StringBuilder text = new StringBuilder();
        XSLFCommentAuthors commentAuthors = slide.getSlideShow().getCommentAuthors();
        XSLFNotes notes = slide.getNotes();
        XSLFComments comments = slide.getComments();
        XSLFSlideLayout layout = slide.getSlideLayout();
        XSLFSlideMaster master = layout.getSlideMaster();
        if (slideText) {
            XSLFPowerPointExtractor.extractText(slide, false, text);
            if (masterText) {
                assert (layout != null);
                XSLFPowerPointExtractor.extractText(layout, true, text);
                assert (master != null);
                XSLFPowerPointExtractor.extractText(master, true, text);
            }
            if (comments != null) {
                for (CTComment comment : comments.getCTCommentsList().getCmArray()) {
                    CTCommentAuthor author;
                    if (commentAuthors != null && (author = commentAuthors.getAuthorById(comment.getAuthorId())) != null) {
                        text.append(author.getName() + ": ");
                    }
                    text.append(comment.getText());
                    text.append("\n");
                }
            }
        }
        if (notesText && notes != null) {
            XSLFPowerPointExtractor.extractText(notes, false, text);
        }
        return text.toString();
    }

    private static void extractText(XSLFShapeContainer data, boolean skipPlaceholders, StringBuilder text) {
        for (XSLFShape s : data) {
            XSLFShape ts;
            if (s instanceof XSLFShapeContainer) {
                XSLFPowerPointExtractor.extractText((XSLFShapeContainer)((Object)s), skipPlaceholders, text);
                continue;
            }
            if (s instanceof XSLFTextShape) {
                ts = (XSLFTextShape)s;
                if (skipPlaceholders && ((XSLFSimpleShape)ts).isPlaceholder()) continue;
                text.append(((XSLFTextShape)ts).getText());
                text.append("\n");
                continue;
            }
            if (!(s instanceof XSLFTable)) continue;
            ts = (XSLFTable)s;
            Iterator<XSLFTableRow> iterator = ((XSLFTable)ts).iterator();
            while (iterator.hasNext()) {
                XSLFTableRow r = iterator.next();
                for (XSLFTableCell c : r) {
                    text.append(c.getText());
                    text.append("\t");
                }
                text.append("\n");
            }
        }
    }
}

