/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import coldfusion.document.link.G2DLink;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.poi.hslf.usermodel.HSLFFill;
import org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.sl.usermodel.VerticalAlignment;
import org.apache.poi.util.NotImplemented;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.SuppressForbidden;

public final class PPGraphics2D
extends Graphics2D
implements Cloneable,
G2DLink {
    private static final POILogger LOG = POILogFactory.getLogger(PPGraphics2D.class);
    private HSLFGroupShape _group;
    private AffineTransform _transform;
    private Stroke _stroke;
    private Paint _paint;
    private Font _font;
    private Color _foreground;
    private Color _background;
    private RenderingHints _hints;
    private HSLFSlide _slide;
    private Area _clip;
    private HSLFSlideShow _ppt;
    protected boolean _underline;

    public PPGraphics2D(HSLFGroupShape group) {
        this._group = group;
        this._transform = new AffineTransform();
        this._stroke = new BasicStroke();
        this._paint = Color.black;
        this._font = new Font("Arial", 0, 12);
        this._background = Color.black;
        this._foreground = Color.white;
        this._hints = new RenderingHints(null);
    }

    public PPGraphics2D(HSLFGroupShape group, HSLFSlide slide, HSLFSlideShow ppt) {
        this._group = group;
        this._ppt = ppt;
        this._slide = slide;
        this._transform = new AffineTransform();
        this._stroke = new BasicStroke();
        this._paint = Color.black;
        this._font = new Font("Arial", 0, 12);
        this._background = Color.black;
        this._foreground = Color.white;
        this._hints = new RenderingHints(null);
    }

    public HSLFGroupShape getShapeGroup() {
        return this._group;
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font font) {
        this._font = font;
    }

    @Override
    public Color getColor() {
        return this._foreground;
    }

    @Override
    public void setColor(Color c) {
        this.setPaint(c);
    }

    @Override
    public Stroke getStroke() {
        return this._stroke;
    }

    @Override
    public void setStroke(Stroke s) {
        this._stroke = s;
    }

    @Override
    public Paint getPaint() {
        return this._paint;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this._paint = paint;
        if (paint instanceof Color) {
            this._foreground = (Color)paint;
        }
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this._transform = new AffineTransform(Tx);
    }

    @Override
    public void draw(Shape shape) {
        Path2D.Double path = new Path2D.Double(this._transform.createTransformedShape(shape));
        HSLFFreeformShape p = new HSLFFreeformShape(this._group);
        p.setPath(path);
        p.getFill().setForegroundColor(null);
        this.applyStroke(p);
        if (this._paint instanceof Color) {
            p.setLineColor((Color)this._paint);
        }
        this._group.addShape(p);
    }

    @Override
    public void drawString(String s, float x, float y) {
        HSLFTextBox txt = new HSLFTextBox(this._group);
        txt.setSheet(this._group.getSheet());
        txt.setText(s);
        AffineTransform at = this.getTransform();
        AffineTransform at2 = this.getTransform();
        at2.translate(x, y);
        at2.concatenate(this._font.getTransform());
        this.setTransform(at2);
        x = (float)at2.getTranslateX();
        y = (float)at2.getTranslateY();
        HSLFTextRun rt = txt.getTextParagraphs().get(0).getTextRuns().get(0);
        rt.setFontSize(Double.valueOf(this._font.getSize()));
        rt.setFontFamily(this._font.getFamily());
        if (this.getColor() != null) {
            rt.setFontColor(DrawPaint.createSolidPaint(this.getColor()));
        }
        if (this._font.isBold()) {
            rt.setBold(true);
        }
        if (this._font.isItalic()) {
            rt.setItalic(true);
        }
        txt.setBottomInset(0.0);
        txt.setTopInset(0.0);
        txt.setLeftInset(0.0);
        txt.setRightInset(0.0);
        txt.setWordWrap(false);
        txt.setHorizontalCentered(false);
        txt.setVerticalAlignment(VerticalAlignment.MIDDLE);
        TextLayout layout = new TextLayout(s, this._font, this.getFontRenderContext());
        float ascent = layout.getAscent();
        double width = 0.0;
        if (this._font.getSize2D() > 0.0f) {
            float scale = 1000.0f / this._font.getSize2D();
            Font derivedFont = this._font.deriveFont(AffineTransform.getScaleInstance(scale, scale));
            width = derivedFont.getStringBounds(s, this.getFontRenderContext()).getWidth();
            if (derivedFont.isTransformed()) {
                width /= (double)scale;
            }
        }
        float height = ascent * 2.0f;
        txt.setAnchor(new Rectangle((int)x, (int)(y -= height / 2.0f + ascent / 2.0f), (int)width, (int)height));
        this._group.addShape(txt);
        this.setTransform(at);
    }

    @Override
    public void fill(Shape shape) {
        Path2D.Double path = new Path2D.Double(this._transform.createTransformedShape(shape));
        HSLFFreeformShape p = new HSLFFreeformShape(this._group);
        p.setPath(path);
        this.applyPaint(p);
        p.setLineColor(null);
        this._group.addShape(p);
    }

    @Override
    public void translate(int x, int y) {
        this._transform.translate(x, y);
    }

    @Override
    @NotImplemented
    public void clip(Shape s) {
        if (s == null) {
            this.setClip(null);
            return;
        }
        s = this._transform.createTransformedShape(s);
        if (this._clip == null) {
            this._clip = new Area(s);
        } else {
            this._clip.intersect(new Area(s));
        }
        Path2D.Double path = new Path2D.Double(this._transform.createTransformedShape(this._clip));
        HSLFFreeformShape p = new HSLFFreeformShape(this._group);
        p.setPath(path);
        p.getFill().setForegroundColor(null);
        p.setLineColor(null);
        this.applyStroke(p);
        this._group.addShape(p);
    }

    @Override
    @NotImplemented
    public Shape getClip() {
        try {
            return this._transform.createInverse().createTransformedShape(this._clip);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    @Override
    public void scale(double sx, double sy) {
        this._transform.scale(sx, sy);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.draw(rect);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.fill(oval);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.fill(rect);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(arc);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xPoints[0], yPoints[0]);
            for (int i = 1; i < nPoints; ++i) {
                path.lineTo(xPoints[i], yPoints[i]);
            }
            this.draw(path);
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.draw(oval);
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        double scalex = (double)width / (double)img.getWidth(observer);
        double scaley = (double)height / (double)img.getHeight(observer);
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        tx.scale(scalex, scaley);
        return this.drawImage(img, null, tx, bgcolor, observer);
    }

    public void addLink(String resource, int linkType, AffineTransform trans, Shape s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawImage(Image img, Image mask, AffineTransform xform, Color bgColor, ImageObserver obs) {
        float jpegQuality = 0.95f;
        if (img != null) {
            boolean imageForBackground = this.isImageForBackground(img);
            xform = xform == null ? new AffineTransform() : new AffineTransform(xform);
            double scalex = xform.getScaleX();
            double scaley = xform.getScaleY();
            xform.translate(0.0, img.getHeight(obs));
            xform.scale(img.getWidth(obs), img.getHeight(obs));
            AffineTransform inverse = this.normalizeMatrix();
            AffineTransform flipper = AffineTransform.getScaleInstance(1.0, -1.0);
            AffineTransform at2 = this.getTransform();
            inverse.concatenate(xform);
            inverse.concatenate(flipper);
            double x = this._transform.getTranslateX();
            double y = this._transform.getTranslateY();
            x -= scalex;
            y -= scaley;
            double[] mx = new double[6];
            inverse.getMatrix(mx);
            boolean hasAlpha = this.imageHasAlpha(img);
            int colorspace = 1;
            if (hasAlpha) {
                colorspace = 2;
            }
            BufferedImage scaled = new BufferedImage(img.getWidth(null), img.getHeight(null), colorspace);
            Graphics2D g3 = scaled.createGraphics();
            g3.drawImage(img, 0, 0, img.getWidth(null), img.getHeight(null), null);
            g3.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PictureData.PictureType imagetype = PictureData.PictureType.JPEG;
            if (hasAlpha) {
                try {
                    ImageIO.write((RenderedImage)scaled, "png", baos);
                    imagetype = PictureData.PictureType.PNG;
                }
                catch (IOException iOException) {}
            } else {
                JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality(jpegQuality);
                ImageWriter iw = ImageIO.getImageWritersByFormatName("jpg").next();
                ImageOutputStream ios = null;
                try {
                    ios = ImageIO.createImageOutputStream(baos);
                    iw.setOutput(ios);
                    iw.write(null, new IIOImage(scaled, null, null), iwparam);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        iw.dispose();
                        if (ios != null) {
                            ios.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            scaled.flush();
            scaled = null;
            try {
                byte[] b = baos.toByteArray();
                HSLFPictureData pictureData = this._ppt.addPicture(b, imagetype);
                HSLFPictureShape pict = new HSLFPictureShape(pictureData);
                pict.setAnchor(new Rectangle2D.Double(x, y, mx[0], mx[3]));
                if (imageForBackground) {
                    HSLFFill fill = this._slide.getBackground().getFill();
                    fill.setFillType(3);
                    fill.setPictureData(pictureData);
                } else {
                    this._slide.addShape(pict);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean imageHasAlpha(Image image) {
        boolean hasAlpha = false;
        PixelGrabber pg = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), false);
        try {
            pg.grabPixels();
            ColorModel cm = pg.getColorModel();
            hasAlpha = cm.hasAlpha();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return hasAlpha;
    }

    private strictfp boolean isImageForBackground(Image image) {
        boolean isbackground = false;
        float accelerationPriority = image.getAccelerationPriority();
        if (accelerationPriority == 0.99f) {
            image.setAccelerationPriority(0.5f);
            isbackground = true;
        }
        return isbackground;
    }

    private AffineTransform normalizeMatrix() {
        double[] mx = new double[6];
        AffineTransform result = AffineTransform.getTranslateInstance(0.0, 0.0);
        result.getMatrix(mx);
        mx[3] = -1.0;
        mx[5] = this.getShapeGroup().getAnchor().getHeight();
        result = new AffineTransform(mx);
        result.concatenate(this._transform);
        return result;
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        double dwidth = (double)dx2 - (double)dx1;
        double dheight = (double)dy2 - (double)dy1;
        double swidth = (double)sx2 - (double)sx1;
        double sheight = (double)sy2 - (double)sy1;
        if (dwidth == 0.0 || dheight == 0.0 || swidth == 0.0 || sheight == 0.0) {
            return true;
        }
        double scalex = dwidth / swidth;
        double scaley = dheight / sheight;
        double transx = (double)sx1 * scalex;
        double transy = (double)sy1 * scaley;
        AffineTransform tx = AffineTransform.getTranslateInstance((double)dx1 - transx, (double)dy1 - transy);
        tx.scale(scalex, scaley);
        BufferedImage mask = new BufferedImage(img.getWidth(observer), img.getHeight(observer), 12);
        Graphics g = mask.getGraphics();
        g.fillRect(sx1, sy1, (int)swidth, (int)sheight);
        this.drawImage(img, mask, tx, null, observer);
        g.dispose();
        return true;
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
        this.draw(line);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.fill(polygon);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.fill(rect);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.draw(rect);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.draw(polygon);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    @NotImplemented
    public void setClip(Shape s) {
        if (s != null) {
            s = this._transform.createTransformedShape(s);
        }
        if (s == null) {
            this._clip = null;
        } else {
            this._clip = new Area(s);
            Path2D.Double path = new Path2D.Double(this._transform.createTransformedShape(this._clip));
            HSLFFreeformShape p = new HSLFFreeformShape(this._group);
            p.setPath(path);
            p.getFill().setForegroundColor(null);
            p.setLineColor(null);
            this.applyStroke(p);
        }
    }

    @Override
    public Rectangle getClipBounds() {
        Shape c = this.getClip();
        if (c == null) {
            return null;
        }
        return c.getBounds();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    protected void doAttributes(AttributedCharacterIterator iter) {
        this._underline = false;
        Set<AttributedCharacterIterator.Attribute> set = iter.getAttributes().keySet();
        for (AttributedCharacterIterator.Attribute attribute : set) {
            Font font;
            if (!(attribute instanceof TextAttribute)) continue;
            TextAttribute textattribute = (TextAttribute)attribute;
            if (textattribute.equals(TextAttribute.FONT)) {
                font = (Font)iter.getAttributes().get(textattribute);
                this.setFont(font);
                continue;
            }
            if (textattribute.equals(TextAttribute.UNDERLINE)) {
                if (iter.getAttributes().get(textattribute) != TextAttribute.UNDERLINE_ON) continue;
                this._underline = true;
                continue;
            }
            if (textattribute.equals(TextAttribute.SIZE)) {
                Object obj = iter.getAttributes().get(textattribute);
                if (obj instanceof Integer) {
                    int i = (Integer)obj;
                    this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), i));
                    continue;
                }
                if (!(obj instanceof Float)) continue;
                float f = ((Float)obj).floatValue();
                this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), f));
                continue;
            }
            if (textattribute.equals(TextAttribute.FOREGROUND)) {
                this.setColor((Color)iter.getAttributes().get(textattribute));
                continue;
            }
            if (textattribute.equals(TextAttribute.FAMILY)) {
                font = this.getFont();
                Map<TextAttribute, ?> fontAttributes = font.getAttributes();
                fontAttributes.put(TextAttribute.FAMILY, iter.getAttributes().get(textattribute));
                this.setFont(font.deriveFont(fontAttributes));
                continue;
            }
            if (textattribute.equals(TextAttribute.POSTURE)) {
                font = this.getFont();
                Map<TextAttribute, ?> fontAttributes = font.getAttributes();
                fontAttributes.put(TextAttribute.POSTURE, iter.getAttributes().get(textattribute));
                this.setFont(font.deriveFont(fontAttributes));
                continue;
            }
            if (!textattribute.equals(TextAttribute.WEIGHT)) continue;
            font = this.getFont();
            Map<TextAttribute, ?> fontAttributes = font.getAttributes();
            fontAttributes.put(TextAttribute.WEIGHT, iter.getAttributes().get(textattribute));
            this.setFont(font.deriveFont(fontAttributes));
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint paint = this.getPaint();
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(paint);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void rotate(double theta) {
        this._transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this._transform.rotate(theta, x, y);
    }

    @Override
    public void shear(double shx, double shy) {
        this._transform.shear(shx, shy);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean isAntiAliased = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean usesFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), isAntiAliased, usesFractionalMetrics);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this._transform.concatenate(Tx);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage result = img;
        if (op != null) {
            result = op.createCompatibleDestImage(img, img.getColorModel());
            result = op.filter(img, result);
        }
        this.drawImage((Image)result, x, y, null);
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this._background = color;
    }

    @Override
    public Color getBackground() {
        return this._background;
    }

    @Override
    @NotImplemented
    public void setComposite(Composite comp) {
        if (LOG.check(5)) {
            LOG.log(5, "Not implemented");
        }
    }

    @Override
    @NotImplemented
    public Composite getComposite() {
        if (LOG.check(5)) {
            LOG.log(5, "Not implemented");
        }
        return null;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this._hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this._hints.put(hintKey, hintValue);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape glyphOutline = g.getOutline(x, y);
        this.fill(glyphOutline);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this._hints.putAll(hints);
    }

    @Override
    public void translate(double tx, double ty) {
        this._transform.translate(tx, ty);
    }

    @Override
    @NotImplemented
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        StringBuffer stringbuffer = new StringBuffer(iterator.getEndIndex());
        char c = iterator.first();
        while (c != '\uffff') {
            if (iterator.getIndex() == iterator.getRunStart()) {
                if (stringbuffer.length() > 0) {
                    this.drawString(stringbuffer.toString(), x, y);
                    FontMetrics fontmetrics = this.getFontMetrics();
                    x = (float)((double)x + fontmetrics.getStringBounds(stringbuffer.toString(), this).getWidth());
                    stringbuffer.delete(0, stringbuffer.length());
                }
                this.doAttributes(iterator);
            }
            stringbuffer.append(c);
            c = iterator.next();
        }
        this.drawString(stringbuffer.toString(), x, y);
        this._underline = false;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.getStroke().createStrokedShape(s);
        }
        s = this.getTransform().createTransformedShape(s);
        return s.intersects(rect);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this._hints;
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this._hints = new RenderingHints(null);
        this._hints.putAll(hints);
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.drawImage(img, null, xform, null, obs);
    }

    @Override
    @NotImplemented
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public Graphics create() {
        PPGraphics2D g2 = new PPGraphics2D(this._group, this._slide, this._ppt);
        g2._transform = this._transform;
        g2._paint = this._paint;
        g2._font = this._font;
        g2._background = this._background;
        g2._foreground = this._foreground;
        g2._stroke = this._stroke;
        if (this._clip != null) {
            g2.setClip(this._clip);
        }
        g2._hints = this._hints;
        return g2;
    }

    @Override
    @SuppressForbidden
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    @NotImplemented
    public void setXORMode(Color c1) {
        if (LOG.check(5)) {
            LOG.log(5, "Not implemented");
        }
    }

    @Override
    @NotImplemented
    public void setPaintMode() {
        if (LOG.check(5)) {
            LOG.log(5, "Not implemented");
        }
    }

    @Override
    @NotImplemented
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (LOG.check(5)) {
            LOG.log(5, "Not implemented");
        }
    }

    @Override
    @NotImplemented
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (LOG.check(5)) {
            LOG.log(5, "Not implemented");
        }
    }

    protected void applyStroke(HSLFSimpleShape shape) {
        if (this._stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this._stroke;
            shape.setLineWidth(bs.getLineWidth());
            float[] dash = bs.getDashArray();
            if (dash != null) {
                shape.setLineDash(StrokeStyle.LineDash.DASH);
            }
        }
    }

    protected void applyPaint(HSLFSimpleShape shape) {
        if (this._paint instanceof Color) {
            shape.getFill().setForegroundColor((Color)this._paint);
        }
    }

    public void addAltText(Image image, String altText) {
    }

    public void addAltText(Shape s, String altText) {
    }

    private void showAltText(Shape s, String altText, String type) {
    }
}

