/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph.osgi.cache;

import coldfusion.graph.ChartImageTagTemplate;
import coldfusion.graph.osgi.cache.InteractiveChartCacheManager;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class ChartCacheEventListener
implements CacheEventListener {
    private static final Logger logger = CFLogs.SERVER_LOG;

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (element.getObjectValue() instanceof ChartImageTagTemplate) {
            ChartImageTagTemplate imageTemplate = (ChartImageTagTemplate)element.getObjectValue();
            String cachedFileName = imageTemplate.getImageServletPath().substring(imageTemplate.getImageServletPath().lastIndexOf("/") + 1);
            File tempImageFile = VFSFileFactory.getFileObject((String)(InteractiveChartCacheManager.getInstance().getCachePath() + File.separator + cachedFileName));
            cache.evictExpiredElements();
            if (tempImageFile.exists() && tempImageFile.delete()) {
                logger.debug((Object)("file deleted on cache eviction from ehcache. filename : " + cachedFileName));
            }
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

