/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public class StringList
extends ComplexProperty
implements Iterable<String> {
    private List<String> items = new ArrayList<String>();
    private String itemXmlElementName = "String";

    public StringList() {
    }

    public StringList(Iterable<String> strings) {
        this.addRange(strings);
    }

    public StringList(String itemXmlElementName) {
        this.itemXmlElementName = itemXmlElementName;
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        boolean returnValue = false;
        if (reader.getLocalName().equals(this.itemXmlElementName)) {
            if (!reader.isEmptyElement()) {
                this.add(reader.readValue());
                returnValue = true;
            } else {
                reader.read();
                returnValue = true;
            }
        }
        return returnValue;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        for (String item : this.items) {
            writer.writeStartElement(XmlNamespace.Types, this.itemXmlElementName);
            writer.writeValue(item, this.itemXmlElementName);
            writer.writeEndElement();
        }
    }

    public void add(String s) {
        this.items.add(s);
        this.changed();
    }

    public void addRange(Iterable<String> strings) {
        boolean changed = false;
        for (String s : strings) {
            if (this.contains(s)) continue;
            this.items.add(s);
            changed = true;
        }
        if (changed) {
            this.changed();
        }
    }

    public boolean contains(String s) {
        return this.items.contains(s);
    }

    public boolean remove(String s) {
        boolean result = this.items.remove(s);
        if (result) {
            this.changed();
        }
        return result;
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("index is out of range.");
        }
        this.items.remove(index);
        this.changed();
    }

    public void clearList() {
        this.items.clear();
        this.changed();
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        for (String str : this.items) {
            temp.append(str.concat(","));
        }
        String tempString = temp.toString();
        return tempString;
    }

    public int getSize() {
        return this.items.size();
    }

    public String getString(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("index is out of range.");
        }
        return this.items.get(index);
    }

    public void setString(int index, Object object) {
        if (index < 0 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException("index is out of range.");
        }
        if (this.items.get(index) != object) {
            this.items.set(index, (String)object);
            this.changed();
        }
    }

    public Iterator<String> getIterator() {
        return this.items.iterator();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringList) {
            StringList other = (StringList)obj;
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Iterator<String> iterator() {
        return this.items.iterator();
    }
}

