/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.notification;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class SubscriptionBase {
    private ExchangeService service;
    private String id;
    private String watermark;

    protected SubscriptionBase(ExchangeService service) throws Exception {
        EwsUtilities.validateParam(service, "service");
        this.service = service;
    }

    protected SubscriptionBase(ExchangeService service, String id) throws Exception {
        this(service);
        EwsUtilities.validateParam(id, "id");
        this.id = id;
    }

    protected SubscriptionBase(ExchangeService service, String id, String watermark) throws Exception {
        this(service, id);
        this.watermark = watermark;
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        this.id = reader.readElementValue(XmlNamespace.Messages, "SubscriptionId");
        if (this.getUsesWatermark()) {
            this.watermark = reader.readElementValue(XmlNamespace.Messages, "Watermark");
        }
    }

    protected ExchangeService getService() {
        return this.service;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setWaterMark(String watermark) {
        this.watermark = watermark;
    }

    public String getWaterMark() {
        return this.watermark;
    }

    protected boolean getUsesWatermark() {
        return true;
    }
}

