/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.notification.FolderEvent;
import microsoft.exchange.webservices.data.notification.GetEventsResults;
import microsoft.exchange.webservices.data.notification.ItemEvent;
import microsoft.exchange.webservices.data.notification.NotificationEvent;

public final class GetStreamingEventsResults {
    private Collection<NotificationGroup> events = new ArrayList<NotificationGroup>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "Notification");
        do {
            NotificationGroup notifications = new NotificationGroup();
            notifications.subscriptionId = reader.readElementValue(XmlNamespace.Types, "SubscriptionId");
            notifications.events = new ArrayList<NotificationEvent>();
            GetStreamingEventsResults getStreamingEventsResults = this;
            synchronized (getStreamingEventsResults) {
                this.events.add(notifications);
            }
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                String eventElementName = reader.getLocalName();
                if (GetEventsResults.getXmlElementNameToEventTypeMap().containsKey(eventElementName)) {
                    EventType eventType = GetEventsResults.getXmlElementNameToEventTypeMap().get(eventElementName);
                    if (eventType == EventType.Status) {
                        reader.readEndElementIfNecessary(XmlNamespace.Types, eventElementName);
                        continue;
                    }
                    this.loadNotificationEventFromXml(reader, eventElementName, eventType, notifications);
                    continue;
                }
                reader.skipCurrentElement();
            } while (!reader.isEndElement(XmlNamespace.Messages, "Notification"));
            reader.read();
        } while (!reader.isEndElement(XmlNamespace.Messages, "Notifications"));
    }

    private void loadNotificationEventFromXml(EwsServiceXmlReader reader, String eventElementName, EventType eventType, NotificationGroup notifications) throws Exception {
        Date timestamp = reader.readElementValue(Date.class, XmlNamespace.Types, "TimeStamp");
        reader.read();
        NotificationEvent notificationEvent = reader.getLocalName().equals("FolderId") ? new FolderEvent(eventType, timestamp) : new ItemEvent(eventType, timestamp);
        notificationEvent.loadFromXml(reader, eventElementName);
        notifications.events.add(notificationEvent);
    }

    protected Collection<NotificationGroup> getNotifications() {
        return this.events;
    }

    protected static class NotificationGroup {
        protected String subscriptionId;
        protected Collection<NotificationEvent> events;

        protected NotificationGroup() {
        }
    }
}

