/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.NameResolutionCollection;

public final class ResolveNamesResponse
extends ServiceResponse {
    private NameResolutionCollection resolutions;

    public ResolveNamesResponse(ExchangeService service) {
        EwsUtilities.ewsAssert(service != null, "ResolveNamesResponse.ctor", "service is null");
        this.resolutions = new NameResolutionCollection(service);
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readElementsFromXml(reader);
        this.resolutions.loadFromXml(reader);
    }

    @Override
    protected void internalThrowIfNecessary() throws ServiceResponseException {
        if (this.getErrorCode() != ServiceError.ErrorNameResolutionNoResults) {
            super.internalThrowIfNecessary();
        }
    }

    public NameResolutionCollection getResolutions() {
        return this.resolutions;
    }
}

