/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.search.FindFoldersResults;

public final class FindFolderResponse
extends ServiceResponse {
    private FindFoldersResults results = new FindFoldersResults();
    private PropertySet propertySet;

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "RootFolder");
        this.results.setTotalCount(reader.readAttributeValue(Integer.class, "TotalItemsInView"));
        this.results.setMoreAvailable(reader.readAttributeValue(Boolean.class, "IncludesLastItemInRange") == false);
        this.results.setNextPageOffset(this.results.isMoreAvailable() ? reader.readNullableAttributeValue(Integer.class, "IndexedPagingOffset") : null);
        reader.readStartElement(XmlNamespace.Types, "Folders");
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().nodeType != 1) continue;
                Folder folder = (Folder)EwsUtilities.createEwsObjectFromXmlElementName(Folder.class, reader.getService(), reader.getLocalName());
                if (folder == null) {
                    reader.skipCurrentElement();
                    continue;
                }
                folder.loadFromXml(reader, true, this.propertySet, true);
                this.results.getFolders().add(folder);
            } while (!reader.isEndElement(XmlNamespace.Types, "Folders"));
        } else {
            reader.read();
        }
        reader.readEndElement(XmlNamespace.Messages, "RootFolder");
    }

    public FindFolderResponse(PropertySet propertySet) {
        this.propertySet = propertySet;
        EwsUtilities.ewsAssert(this.propertySet != null, "FindFolderResponse.ctor", "PropertySet should not be null");
    }

    public FindFoldersResults getResults() {
        return this.results;
    }
}

