/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut.trace;

import com.adobe.xfa.ut.trace.Trace;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class GlobalTraceStore {
    private static final GlobalTraceStore mInstance = new GlobalTraceStore();
    private final ConcurrentMap<String, Trace> mTraceAreas = new ConcurrentHashMap<String, Trace>();
    private volatile boolean mbEnabled;

    void addTrace(Trace trace) {
        Trace existingTrace = this.mTraceAreas.putIfAbsent(trace.getName(), trace);
        if (existingTrace != null && existingTrace.isPlaceHolder() && !trace.isPlaceHolder()) {
            existingTrace.setHelpId(trace.getHelpId());
            existingTrace.setPlaceHolder(false);
            return;
        }
    }

    void removeTrace(Trace trace) {
        this.mTraceAreas.remove(trace.getName());
    }

    static GlobalTraceStore getStore() {
        return mInstance;
    }

    Collection<Trace> getTraceSections() {
        return this.mTraceAreas.values();
    }

    void ensureTraceExists(String sName) {
        if (!this.mTraceAreas.containsKey(sName)) {
            this.addTrace(new Trace(sName));
        }
    }

    void enable() {
        this.mbEnabled = true;
    }

    boolean isEnabled() {
        return this.mbEnabled;
    }

    protected GlobalTraceStore() {
    }
}

