/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class LcNum {
    public static final int MAX_PRECISION = 15;
    public static final String NUMERIC_PICTURE_SYMBOLS = "(%$,.)89BCDERSVZbcdrsvzt";
    final StringBuilder msText;
    final LcLocale mLocale;
    boolean mbValid;
    double mdValue;
    int mnExpon;
    int mnSignf;
    int mnInSignf;
    boolean mbNegative;
    boolean mbSignSeen;
    boolean mbLeftParenSeen;
    boolean mbRightParenSeen;
    boolean mbDigitSeen;
    boolean mbRadixSeen;
    boolean mbExponSeen;
    boolean mbVeeSeen;
    boolean mbCommaSeen;
    boolean mbOnlyZedSeen;
    boolean mbFracZedSeen;
    boolean mbOnly8Seen;
    boolean mbFracDigitSeen;
    boolean mbPercentSeen;
    boolean mbFracStartSeen;
    Symbols mSymbols;
    static final DecimalFormat gNumberFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    static final String gsNonIgnorable = "(%$.)BCDERSZ89";
    static final String gsCondIgnorable = "(%$.)BCDERS";
    static final String gsDB = "DB";
    static final String gsCR = "CR";
    static final String gsLP = "(";
    static final String gsRP = ")";
    static final String gsE = "E";
    static final String gsDSP = "  ";
    static final String gsSSP = " ";

    public LcNum(String text, String locale) {
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        LcLocale lcLocale = new LcLocale(sLocale);
        this.mLocale = lcLocale.isValid() ? lcLocale : new LcLocale("en_US");
        LcData oData = new LcData(locale);
        this.mSymbols = new Symbols(oData.getRadixSymbol(), oData.getNegativeSymbol(), oData.getPositiveSymbol(), oData.getGroupingSymbol(), oData.getPercentSymbol(), oData.getCurrencySymbol(), oData.getCurrencyName(), oData.getZeroSymbol().charAt(0));
        this.msText = new StringBuilder();
        if (text != null) {
            this.msText.append(text);
        }
        this.mdValue = 0.0;
        this.mbValid = true;
    }

    public LcNum(String text, String pic, String locale) {
        this(text, locale);
        this.mbValid = this.parse(this.msText.toString(), pic);
    }

    public String getText() {
        return this.msText.toString();
    }

    public double getValue() {
        return this.mdValue;
    }

    public boolean isValid() {
        return this.mbValid;
    }

    public String format(String pat, IntegerHolder radixPos) {
        int nRadixPos = -1;
        StringBuilder sRes = new StringBuilder();
        try {
            double dbl;
            String pic = this.xlate(pat);
            this.mbNegative = false;
            int prec = this.mnInSignf;
            if (this.mbExponSeen) {
                prec += this.mnSignf;
            }
            if (this.mbPercentSeen) {
                prec += 2;
            }
            if ((dbl = LcNum.strToDbl(this.msText.toString(), prec)) == -0.0) {
                dbl = 0.0;
            }
            int nPrec = this.mnInSignf;
            int nDot = this.msText.indexOf(".");
            if (nDot >= 0) {
                nPrec = this.msText.length() - nDot - 1;
            } else if (this.mbOnly8Seen) {
                nPrec = -1;
            }
            this.mdValue = dbl;
            if (dbl < 0.0) {
                dbl = -dbl;
                this.mbNegative = true;
            }
            if (dbl != 0.0) {
                this.mbOnlyZedSeen = false;
            }
            if (this.mbExponSeen) {
                this.mnExpon = 0;
                while (dbl >= 1.0) {
                    dbl /= 10.0;
                    ++this.mnExpon;
                }
                while (0.0 < dbl && dbl < 1.0) {
                    dbl *= 10.0;
                    --this.mnExpon;
                }
                int i = 1;
                while (i < this.mnSignf) {
                    dbl *= 10.0;
                    ++i;
                    --this.mnExpon;
                }
            } else if (this.mbPercentSeen) {
                dbl *= 100.0;
            }
            int fmt = 1;
            int width = this.mnSignf;
            if (this.mbExponSeen || nPrec > this.mnInSignf || !this.mbOnly8Seen) {
                width += this.mnInSignf;
                if (this.mbRadixSeen) {
                    ++width;
                } else {
                    fmt = 0;
                }
                nPrec = this.mnInSignf;
            } else if (nPrec >= 0) {
                width += nPrec + 1;
            } else {
                fmt = 0;
            }
            if (!LcNum.dblToStr(this.msText, dbl, width, nPrec, fmt)) {
                throw new ExFull();
            }
            if (this.mbFracDigitSeen && dbl < 1.0) {
                this.msText.deleteCharAt(0);
            }
            this.mbDigitSeen = false;
            this.mbRadixSeen = false;
            char prevChr = '\u0000';
            int chrCnt = 0;
            boolean inQuoted = false;
            boolean inQuoteQuoted = false;
            boolean bRadixSeen = false;
            int picLen = pic.length();
            int txtLen = this.msText.length();
            int txtIdx = 0;
            int i = 0;
            while (i < picLen) {
                int nPos;
                char chr = pic.charAt(i++);
                if (inQuoteQuoted) {
                    if (chr == '\'') {
                        sRes.append(chr);
                        chrCnt = 0;
                    } else {
                        inQuoted = false;
                        chrCnt = 1;
                        prevChr = chr;
                    }
                    inQuoteQuoted = false;
                    continue;
                }
                if (inQuoted) {
                    if (chr == '\'') {
                        inQuoteQuoted = true;
                    } else {
                        sRes.append(chr);
                    }
                    ++chrCnt;
                    continue;
                }
                if (chr == '\'') {
                    if (chrCnt > 0) {
                        bRadixSeen = this.mbRadixSeen;
                        nPos = sRes.length();
                        txtIdx = this.subFormat(prevChr, chrCnt, txtIdx, sRes);
                        if (!bRadixSeen && this.mbRadixSeen) {
                            nRadixPos = nPos;
                        }
                        chrCnt = 0;
                        prevChr = '\u0000';
                    }
                    inQuoted = true;
                    continue;
                }
                if (DateTimeUtil.matchChr(NUMERIC_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                    if (chr != prevChr) {
                        if (chrCnt > 0) {
                            bRadixSeen = this.mbRadixSeen;
                            nPos = sRes.length();
                            txtIdx = this.subFormat(prevChr, chrCnt, txtIdx, sRes);
                            if (!bRadixSeen && this.mbRadixSeen) {
                                nRadixPos = nPos;
                            }
                            chrCnt = 0;
                        }
                        prevChr = chr;
                    }
                    ++chrCnt;
                    continue;
                }
                if (chrCnt > 0) {
                    bRadixSeen = this.mbRadixSeen;
                    nPos = sRes.length();
                    txtIdx = this.subFormat(prevChr, chrCnt, txtIdx, sRes);
                    if (!bRadixSeen && this.mbRadixSeen) {
                        nRadixPos = nPos;
                    }
                    chrCnt = 0;
                }
                prevChr = '\u0000';
                if (chr == '?' || chr == '*' || chr == '+') {
                    sRes.append(' ');
                    continue;
                }
                sRes.append(chr);
            }
            if (inQuoteQuoted) {
                inQuoted = false;
            }
            if (inQuoted) {
                throw new ExFull();
            }
            if (prevChr > '\u0000' && chrCnt > 0) {
                bRadixSeen = this.mbRadixSeen;
                int nPos = sRes.length();
                txtIdx = this.subFormat(prevChr, chrCnt, txtIdx, sRes);
                if (!bRadixSeen && this.mbRadixSeen) {
                    nRadixPos = nPos;
                }
            }
            if (txtIdx > 0 && txtIdx < txtLen) {
                sRes.setLength(0);
            }
            if (!this.mbRadixSeen) {
                nRadixPos = -1;
            }
        }
        catch (ExFull e) {
            sRes.setLength(0);
        }
        if (radixPos != null) {
            radixPos.value = nRadixPos;
        }
        return sRes.toString();
    }

    public boolean parse(String sStr, String pat) {
        boolean bRes = true;
        try {
            int i;
            String pic = this.xlate(pat);
            pic = LcNum.reverse(pic);
            StringBuilder sBuf = new StringBuilder(sStr).reverse();
            String sRadix = this.mSymbols.radixSymbol;
            int nRadix = sBuf.indexOf(sRadix);
            if (this.mbRadixSeen && !this.mbVeeSeen && nRadix < 0) {
                char cZero = this.mSymbols.zeroDigit;
                int i2 = 0;
                int n = sBuf.length();
                while (i2 < n) {
                    char chr;
                    int j = i2;
                    if (cZero > (chr = sBuf.charAt(i2++)) || chr > cZero + 9) continue;
                    sBuf.insert(j, sRadix);
                    break;
                }
            }
            String str = sBuf.toString();
            this.mbDigitSeen = false;
            this.mbRadixSeen = false;
            this.mbExponSeen = false;
            this.mbLeftParenSeen = false;
            this.mbRightParenSeen = false;
            this.mbVeeSeen = false;
            this.mbCommaSeen = false;
            this.mbSignSeen = false;
            this.mbPercentSeen = false;
            this.mbNegative = false;
            char prevChr = '\u0000';
            int chrCnt = 0;
            boolean inQuoted = false;
            boolean inQuoteQuoted = false;
            StringBuilder sRes = new StringBuilder();
            int strPos = 0;
            int picLen = pic.length();
            int strLen = str.length();
            int i3 = 0;
            while (i3 < picLen) {
                char chr;
                boolean fw;
                boolean bl = fw = '\uff01' <= (chr = pic.charAt(i3++)) && chr <= '\uff5e';
                if (inQuoteQuoted) {
                    if (chr == '\'') {
                        if (!DateTimeUtil.matchChr(str, strPos, chr, fw)) {
                            throw new ExFull();
                        }
                        ++strPos;
                        chrCnt = 0;
                    } else {
                        inQuoted = false;
                        chrCnt = 1;
                        prevChr = chr;
                    }
                    inQuoteQuoted = false;
                    continue;
                }
                if (inQuoted) {
                    if (chr == '\'') {
                        inQuoteQuoted = true;
                    } else {
                        if (!DateTimeUtil.matchChr(str, strPos, chr, fw)) {
                            throw new ExFull();
                        }
                        ++strPos;
                    }
                    ++chrCnt;
                    continue;
                }
                if (chr == '\'') {
                    if (chrCnt > 0) {
                        if (strPos >= strLen && this.isNonIgnorable(prevChr)) {
                            throw new ExFull();
                        }
                        if (chrCnt >= strLen - strPos) {
                            chrCnt = strLen - strPos;
                        }
                        if (chrCnt > 0) {
                            strPos = this.subParse(str, strPos, prevChr, chrCnt, sRes);
                        }
                        chrCnt = 0;
                        prevChr = '\u0000';
                    }
                    inQuoted = true;
                    continue;
                }
                if (DateTimeUtil.matchChr(NUMERIC_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                    if (chr != prevChr) {
                        if (chrCnt > 0) {
                            if (strPos >= strLen && this.isNonIgnorable(prevChr)) {
                                throw new ExFull();
                            }
                            if (chrCnt >= strLen - strPos) {
                                chrCnt = strLen - strPos;
                            }
                            if (chrCnt > 0) {
                                strPos = this.subParse(str, strPos, prevChr, chrCnt, sRes);
                            }
                            chrCnt = 0;
                        }
                        prevChr = chr;
                    }
                    ++chrCnt;
                    continue;
                }
                if (chrCnt > 0) {
                    if (strPos >= strLen && this.isNonIgnorable(prevChr)) {
                        throw new ExFull();
                    }
                    if (chrCnt >= strLen - strPos) {
                        chrCnt = strLen - strPos;
                    }
                    if (chrCnt > 0) {
                        strPos = this.subParse(str, strPos, prevChr, chrCnt, sRes);
                    }
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                if (chr == '?') {
                    if (strPos >= strLen || !Character.isDefined(str.charAt(strPos))) continue;
                    ++strPos;
                    continue;
                }
                if (chr == '+') {
                    if (strPos >= strLen || !Character.isWhitespace(str.charAt(strPos))) {
                        throw new ExFull();
                    }
                    ++strPos;
                    while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                        ++strPos;
                    }
                    continue;
                }
                if (chr == '*') {
                    while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                        ++strPos;
                    }
                    continue;
                }
                if (strPos < strLen && str.charAt(strPos) == chr) {
                    ++strPos;
                    continue;
                }
                throw new ExFull();
            }
            if (inQuoteQuoted) {
                inQuoted = false;
            }
            if (inQuoted) {
                throw new ExFull();
            }
            if (prevChr > '\u0000' && chrCnt > 0) {
                if (strPos >= strLen && this.isNonIgnorable(prevChr)) {
                    throw new ExFull();
                }
                if (chrCnt >= strLen - strPos) {
                    chrCnt = strLen - strPos;
                }
                if (chrCnt > 0) {
                    strPos = this.subParse(str, strPos, prevChr, chrCnt, sRes);
                }
                prevChr = '\u0000';
            }
            if (!this.mbSignSeen) {
                if (strPos >= strLen && this.isNonIgnorable(prevChr)) {
                    throw new ExFull();
                }
                strPos = this.subParse(str, strPos, 's', 1, sRes);
            }
            if (strPos != strLen) {
                throw new ExFull();
            }
            sRes.reverse();
            int resLen = sRes.length();
            for (i = 0; i < resLen && sRes.charAt(i) == '0'; ++i) {
            }
            if (i < resLen) {
                sRes.delete(0, i);
            } else if (i > 0) {
                sRes.delete(0, i - 1);
            }
            if (!this.mbExponSeen && this.mbRadixSeen && !this.mbOnly8Seen) {
                for (i = sRes.length(); i > 0 && sRes.charAt(i - 1) == '0'; --i) {
                }
                sRes.setLength(i);
            }
            if (sRes.toString().equals(".")) {
                sRes.append('0');
            }
            this.msText.setLength(0);
            if (sRes.length() != 0) {
                if (this.mbNegative) {
                    this.msText.append('-');
                }
                this.msText.append((CharSequence)sRes);
            }
            this.mdValue = LcNum.strToDbl(this.msText.toString(), 11);
            if (this.mbPercentSeen) {
                int nWidth = this.msText.length();
                int nPrec = 2;
                int nDot = this.msText.indexOf(".");
                if (nDot >= 0) {
                    nPrec += nWidth - nDot - 1;
                }
                LcNum.dblToStr(this.msText, this.mdValue / 100.0, nWidth, nPrec, 0);
            }
        }
        catch (ExFull e) {
            bRes = false;
        }
        return bRes;
    }

    public static void getSymbolCount(String pic, IntegerHolder lead, IntegerHolder frac) {
        String sLoc = "en_US";
        String sZero = "0.0";
        LcNum oNum = new LcNum(sZero, sLoc);
        oNum.xlate(pic);
        lead.value = oNum.mnSignf;
        frac.value = oNum.mnInSignf;
    }

    private String xlate(String pic) {
        this.mbFracStartSeen = false;
        this.mbFracDigitSeen = false;
        this.mbOnly8Seen = false;
        this.mbFracZedSeen = false;
        this.mbOnlyZedSeen = true;
        this.mbDigitSeen = false;
        this.mbRadixSeen = false;
        this.mbExponSeen = false;
        this.mbLeftParenSeen = false;
        this.mbRightParenSeen = false;
        this.mbVeeSeen = false;
        this.mbCommaSeen = false;
        this.mbSignSeen = false;
        this.mbPercentSeen = false;
        this.mnInSignf = 0;
        this.mnSignf = 0;
        StringBuilder sRes = new StringBuilder();
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int picLen = pic.length();
        int i = 0;
        while (i < picLen) {
            char chr = pic.charAt(i++);
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    sRes.append(chr);
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                }
                sRes.append(chr);
                chrCnt = 0;
                prevChr = chr;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    sRes.append(this.subXlate(prevChr, chrCnt));
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                sRes.append(chr);
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(NUMERIC_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (prevChr != chr) {
                    if (chrCnt == 1 && prevChr == 'D' && chr == 'B') {
                        sRes.append('D');
                        prevChr = '\u0000';
                        chrCnt = 0;
                        this.mbSignSeen = true;
                        continue;
                    }
                    if (chrCnt == 1 && prevChr == 'd' && chr == 'b') {
                        sRes.append('d');
                        prevChr = '\u0000';
                        chrCnt = 0;
                        this.mbSignSeen = true;
                        continue;
                    }
                    if (chrCnt == 1 && prevChr == 'C' && chr == 'R') {
                        sRes.append('C');
                        prevChr = '\u0000';
                        chrCnt = 0;
                        this.mbSignSeen = true;
                        continue;
                    }
                    if (chrCnt == 1 && prevChr == 'c' && chr == 'r') {
                        sRes.append('c');
                        prevChr = '\u0000';
                        chrCnt = 0;
                        this.mbSignSeen = true;
                        continue;
                    }
                    if (chrCnt > 0) {
                        sRes.append(this.subXlate(prevChr, chrCnt));
                        prevChr = chr;
                        chrCnt = 1;
                        continue;
                    }
                    prevChr = chr;
                    ++chrCnt;
                    continue;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                sRes.append(this.subXlate(prevChr, chrCnt));
                chrCnt = 0;
            }
            prevChr = '\u0000';
            sRes.append(chr);
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            throw new ExFull();
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            sRes.append(this.subXlate(prevChr, chrCnt));
        }
        if (this.mbLeftParenSeen && this.mbDigitSeen && this.mbRightParenSeen) {
            this.mbSignSeen = true;
        }
        return sRes.toString();
    }

    private String subXlate(char chr, int chrCnt) {
        StringBuilder sRes = new StringBuilder();
        for (int i = 0; i < chrCnt; ++i) {
            sRes.append(chr);
        }
        if ('\uff01' <= chr && chr <= '\uff5e') {
            chr = (char)(chr - 65504);
            chr = (char)(chr & 0xFF);
        }
        if (chr == 'E') {
            if (chrCnt > 1 || this.mbExponSeen || !this.mbDigitSeen) {
                throw new ExFull();
            }
            this.mbExponSeen = true;
        } else if (chr == '(') {
            if (chrCnt > 1 || this.mbLeftParenSeen || this.mbDigitSeen || this.mbRightParenSeen) {
                throw new ExFull();
            }
            this.mbLeftParenSeen = true;
        } else if (chr == 'S' || chr == 's') {
            this.mbSignSeen = true;
        } else if (chr == '%') {
            this.mbPercentSeen = true;
        } else if (chr == '.' || chr == 'V' || chr == 'v') {
            if (chr == 'v' || chr == 'V') {
                if (chrCnt > 1 || this.mbVeeSeen) {
                    throw new ExFull();
                }
                this.mbVeeSeen = true;
            }
            if (chrCnt > 1 || this.mbRadixSeen) {
                throw new ExFull();
            }
            this.mbRadixSeen = true;
            this.mbFracStartSeen = true;
            if (!this.mbDigitSeen) {
                this.mbFracDigitSeen = true;
            }
        } else if (chr == '8' || chr == '9' || chr == 'Z' || chr == 'z') {
            if (this.mbFracStartSeen) {
                this.mbFracStartSeen = false;
                this.mbFracZedSeen = true;
                this.mbOnly8Seen = true;
            }
            if (this.mbRightParenSeen) {
                throw new ExFull();
            }
            if (chr != 'z') {
                this.mbOnlyZedSeen = false;
                if (this.mbRadixSeen) {
                    this.mbFracZedSeen = false;
                }
            }
            if (chr != '8') {
                this.mbOnly8Seen = false;
            }
            this.mbDigitSeen = true;
            if (this.mbRadixSeen) {
                this.mnInSignf += chrCnt;
            } else {
                this.mnSignf += chrCnt;
            }
        } else if (chr == ')') {
            if (chrCnt > 1 || !this.mbLeftParenSeen || !this.mbDigitSeen || this.mbRightParenSeen) {
                throw new ExFull();
            }
            this.mbRightParenSeen = true;
        }
        return sRes.toString();
    }

    private int subFormat(char chr, int chrCnt, int txtIdx, StringBuilder sRes) {
        boolean fw = '\uff01' <= chr && chr <= '\uff5e';
        switch (chr) {
            case '9': 
            case '\uff19': {
                if (this.mbNegative && !this.mbDigitSeen && !this.mbSignSeen) {
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.negativeSymbol, fw));
                    this.mbSignSeen = true;
                }
                while (chrCnt-- > 0 && txtIdx < this.msText.length()) {
                    char cValue;
                    if ('0' > (cValue = this.msText.charAt(txtIdx++)) || cValue > '9') {
                        throw new ExFull();
                    }
                    int value = cValue - 48;
                    sRes.append(DateTimeUtil.fmtNum(1, value, fw, this.mSymbols.zeroDigit));
                    this.mbDigitSeen = true;
                }
                break;
            }
            case '8': 
            case '\uff18': {
                if (this.mbNegative && !this.mbDigitSeen && !this.mbSignSeen) {
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.negativeSymbol, fw));
                    this.mbSignSeen = true;
                }
                while (chrCnt-- > 0 && txtIdx < this.msText.length()) {
                    char cValue;
                    if ('0' > (cValue = this.msText.charAt(txtIdx++)) || cValue > '9') {
                        throw new ExFull();
                    }
                    int value = cValue - 48;
                    sRes.append(DateTimeUtil.fmtNum(1, value, fw, this.mSymbols.zeroDigit));
                    this.mbDigitSeen = true;
                }
                break;
            }
            case 'Z': 
            case '\uff3a': {
                if (this.mbNegative && !this.mbDigitSeen && !this.mbSignSeen) {
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.negativeSymbol, fw));
                    this.mbSignSeen = true;
                }
                while (chrCnt-- > 0 && txtIdx < this.msText.length()) {
                    char cValue;
                    if ('0' > (cValue = this.msText.charAt(txtIdx++)) || cValue > '9') {
                        throw new ExFull();
                    }
                    int value = cValue - 48;
                    if (this.mbDigitSeen || this.mbRadixSeen || value > 0) {
                        sRes.append(DateTimeUtil.fmtNum(1, value, fw, this.mSymbols.zeroDigit));
                        this.mbDigitSeen = true;
                        continue;
                    }
                    sRes.append(DateTimeUtil.matchChr(' ', fw));
                }
                break;
            }
            case 'z': 
            case '\uff5a': {
                if (this.mbNegative && !this.mbDigitSeen && !this.mbSignSeen) {
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.negativeSymbol, fw));
                    this.mbSignSeen = true;
                }
                while (chrCnt-- > 0 && txtIdx < this.msText.length()) {
                    char cValue;
                    if ('0' > (cValue = this.msText.charAt(txtIdx++)) || cValue > '9') {
                        throw new ExFull();
                    }
                    int value = cValue - 48;
                    boolean bFormatIt = false;
                    if (this.mbRadixSeen) {
                        int nSigf = StringUtils.skipUntil(this.msText.toString(), "123456789", txtIdx);
                        if (nSigf + txtIdx < this.msText.length()) {
                            bFormatIt = true;
                        } else if (!this.mbDigitSeen && !this.mbFracZedSeen) {
                            bFormatIt = true;
                        } else if (!this.mbFracZedSeen && value > 0) {
                            bFormatIt = true;
                        } else if (value > 0) {
                            bFormatIt = true;
                        }
                    } else if (!(!this.mbDigitSeen && value <= 0 || this.mbFracZedSeen && this.mbRadixSeen)) {
                        bFormatIt = true;
                    }
                    if (!bFormatIt) continue;
                    sRes.append(DateTimeUtil.fmtNum(1, value, fw, this.mSymbols.zeroDigit));
                    this.mbDigitSeen = true;
                }
                break;
            }
            case 'E': 
            case '\uff25': {
                if (this.mbOnlyZedSeen) break;
                sRes.append(DateTimeUtil.fmtStr(gsE, fw));
                int value = this.mnExpon;
                if (value < 0) {
                    sRes.append(DateTimeUtil.matchChr('-', fw));
                    value = -value;
                } else if (value > 0) {
                    sRes.append(DateTimeUtil.matchChr('+', fw));
                }
                sRes.append(DateTimeUtil.fmtPlainNum(3, value, fw, this.mSymbols.zeroDigit));
                break;
            }
            case 'C': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    sRes.append(this.mbNegative ? gsCR : gsDSP);
                }
                break;
            }
            case 'c': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen || !this.mbNegative) continue;
                    sRes.append(gsCR);
                }
                break;
            }
            case 'D': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    sRes.append(this.mbNegative ? gsDB : gsDSP);
                }
                break;
            }
            case 'd': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen || !this.mbNegative) continue;
                    sRes.append(gsDB);
                }
                break;
            }
            case 'S': 
            case '\uff33': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    if (this.mbNegative) {
                        sRes.append(DateTimeUtil.fmtStr(this.mSymbols.negativeSymbol, fw));
                        continue;
                    }
                    sRes.append(DateTimeUtil.matchChr(' ', fw));
                }
                break;
            }
            case 's': 
            case '\uff53': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen || !this.mbNegative) continue;
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.negativeSymbol, fw));
                }
                break;
            }
            case 'V': 
            case '\uff36': {
                while (chrCnt-- > 0) {
                    if (this.msText.charAt(txtIdx++) != '.') {
                        throw new ExFull();
                    }
                    if (!this.mbOnlyZedSeen) {
                        sRes.append(DateTimeUtil.fmtStr(this.mSymbols.radixSymbol, fw));
                    }
                    this.mbRadixSeen = true;
                }
                break;
            }
            case 'v': 
            case '\uff56': {
                while (chrCnt-- > 0) {
                    if (this.msText.charAt(txtIdx++) != '.') {
                        throw new ExFull();
                    }
                    if (!this.mbOnlyZedSeen && this.mbExponSeen) {
                        sRes.append(DateTimeUtil.fmtStr(this.mSymbols.radixSymbol, fw));
                    }
                    this.mbRadixSeen = true;
                }
                break;
            }
            case '.': 
            case '\uff0e': {
                while (chrCnt-- > 0) {
                    if (this.mbOnly8Seen) {
                        char cValue;
                        char c = cValue = txtIdx < this.msText.length() ? this.msText.charAt(txtIdx++) : (char)'\u0000';
                        if (cValue == '.') {
                            sRes.append(DateTimeUtil.fmtStr(this.mSymbols.radixSymbol, fw));
                        } else if ('0' <= cValue && cValue <= '9') {
                            throw new ExFull();
                        }
                    } else {
                        if (this.msText.charAt(txtIdx++) != '.') {
                            throw new ExFull();
                        }
                        int nSigf = StringUtils.skipUntil(this.msText.toString(), "123456789", txtIdx);
                        if (!this.mbFracZedSeen || nSigf + txtIdx < this.msText.length()) {
                            sRes.append(DateTimeUtil.fmtStr(this.mSymbols.radixSymbol, fw));
                        }
                    }
                    this.mbRadixSeen = true;
                }
                break;
            }
            case ',': 
            case '\uff0c': {
                while (chrCnt-- > 0) {
                    if (!this.mbOnlyZedSeen && this.mbDigitSeen) {
                        sRes.append(DateTimeUtil.fmtStr(this.mSymbols.groupingSymbol, fw));
                    }
                    this.mbCommaSeen = true;
                }
                break;
            }
            case '$': 
            case '\uff04': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    if (chrCnt > 0) {
                        --chrCnt;
                        sRes.append(DateTimeUtil.fmtStr(this.mSymbols.currencyName, fw));
                        continue;
                    }
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.currencySymbol, fw));
                }
                break;
            }
            case '%': 
            case '\uff05': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    sRes.append(DateTimeUtil.fmtStr(this.mSymbols.percentSymbol, fw));
                }
                break;
            }
            case '(': 
            case ')': 
            case '\uff08': 
            case '\uff09': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    sRes.append(DateTimeUtil.matchChr(this.mbNegative ? chr : (char)' ', fw));
                }
                break;
            }
            case 't': {
                while (chrCnt-- > 0) {
                    if (this.mbOnlyZedSeen) continue;
                    sRes.append('\t');
                }
                break;
            }
            default: {
                if (this.mbOnlyZedSeen) break;
                sRes.append(DateTimeUtil.matchChr(chr, fw));
            }
        }
        return txtIdx;
    }

    private int subParse(String src, int srcPos, char chr, int chrCnt, StringBuilder sRes) {
        assert (sRes != null);
        int curPos = srcPos;
        boolean fw = '\uff01' <= chr && chr <= '\uff5e';
        switch (chr) {
            case '9': 
            case '\uff19': {
                while (chrCnt-- > 0) {
                    int n = DateTimeUtil.matchNum(src, srcPos, srcPos + 1, fw, this.mSymbols.zeroDigit);
                    if (n <= 0) {
                        throw new ExFull();
                    }
                    if (this.mbCommaSeen) {
                        throw new ExFull();
                    }
                    curPos = DateTimeUtil.incPos(src, srcPos, n);
                    n = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                    sRes.append((char)(48 + n));
                    srcPos = curPos;
                    this.mbDigitSeen = true;
                }
                break;
            }
            case 'Z': 
            case '\uff3a': {
                String sSym = gsSSP;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                while (chrCnt-- > 0) {
                    int n = DateTimeUtil.matchNum(src, srcPos, srcPos + 1, fw, this.mSymbols.zeroDigit);
                    if (n == 1) {
                        if (this.mbCommaSeen) {
                            throw new ExFull();
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, n);
                        n = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        sRes.append((char)(48 + n));
                        srcPos = curPos;
                    } else {
                        n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                        if (n > 0) {
                            if (!this.mbRadixSeen) {
                                sRes.append('0');
                            }
                            srcPos = n;
                        }
                    }
                    this.mbDigitSeen = true;
                }
                break;
            }
            case '8': 
            case 'z': 
            case '\uff18': 
            case '\uff5a': {
                while (chrCnt-- > 0) {
                    int n = DateTimeUtil.matchNum(src, srcPos, srcPos + 1, fw, this.mSymbols.zeroDigit);
                    if (n != 1) continue;
                    if (this.mbCommaSeen) {
                        throw new ExFull();
                    }
                    curPos = DateTimeUtil.incPos(src, srcPos, n);
                    n = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                    sRes.append((char)(48 + n));
                    srcPos = curPos;
                    this.mbDigitSeen = true;
                }
                break;
            }
            case 'E': 
            case '\uff25': {
                while (chrCnt-- > 0) {
                    if (this.mbExponSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchNum(src, srcPos, srcPos + 3, fw, this.mSymbols.zeroDigit);
                    if (n < 1 || 3 < n) {
                        throw new ExFull();
                    }
                    for (int i = 0; i < n; ++i) {
                        curPos = DateTimeUtil.incPos(src, srcPos, 1);
                        int num = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        sRes.append((char)(48 + num));
                        srcPos = curPos;
                    }
                    if (DateTimeUtil.matchChr(src, srcPos, '+', fw)) {
                        sRes.append('+');
                        ++srcPos;
                    } else if (DateTimeUtil.matchChr(src, srcPos, '-', fw)) {
                        sRes.append('-');
                        ++srcPos;
                    }
                    if (DateTimeUtil.matchChr(src, srcPos, 'E', fw)) {
                        sRes.append('E');
                        ++srcPos;
                    } else if (DateTimeUtil.matchChr(src, srcPos, 'e', fw)) {
                        sRes.append('E');
                        ++srcPos;
                    } else {
                        throw new ExFull();
                    }
                    this.mbExponSeen = true;
                }
                break;
            }
            case 'C': {
                String sPos;
                String sNeg = gsCR;
                if (sNeg.length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                if ((sPos = gsDSP).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (this.mbSignSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbNegative = true;
                    } else {
                        n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                        if (n > 0) {
                            srcPos = n;
                        }
                    }
                    this.mbSignSeen = true;
                }
                break;
            }
            case 'c': {
                String sPos = gsCR;
                if (sPos.length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (this.mbSignSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbNegative = true;
                    }
                    this.mbSignSeen = true;
                }
                break;
            }
            case 'D': {
                String sPos;
                String sNeg = gsDB;
                if (sNeg.length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                if ((sPos = gsDSP).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (this.mbSignSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbNegative = true;
                    } else {
                        n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                        if (n > 0) {
                            srcPos = n;
                        }
                    }
                    this.mbSignSeen = true;
                }
                break;
            }
            case 'd': {
                String sNeg = gsDB;
                if (sNeg.length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                while (chrCnt-- > 0) {
                    if (this.mbSignSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbNegative = true;
                    }
                    this.mbSignSeen = true;
                }
                break;
            }
            case 'S': 
            case '\uff33': {
                String sPos;
                String sNeg;
                String sSym = gsSSP;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                if ((sNeg = this.mSymbols.negativeSymbol).length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                if ((sPos = this.mSymbols.positiveSymbol).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (this.mbSignSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbNegative = true;
                    } else {
                        n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                        if (n > 0) {
                            srcPos = n;
                        } else {
                            n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                            if (n > 0) {
                                srcPos = n;
                            }
                        }
                    }
                    this.mbSignSeen = true;
                }
                break;
            }
            case 's': 
            case '\uff53': {
                String sPos;
                String sNeg = this.mSymbols.negativeSymbol;
                if (sNeg.length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                if ((sPos = this.mSymbols.positiveSymbol).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (this.mbSignSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbNegative = true;
                    } else {
                        n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                        if (n > 0) {
                            srcPos = n;
                        }
                    }
                    this.mbSignSeen = true;
                }
                break;
            }
            case 'V': 
            case '\uff36': {
                String sSym = this.mSymbols.radixSymbol;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                while (chrCnt-- > 0) {
                    if (this.mbVeeSeen || this.mbRadixSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                    if (n > 0) {
                        srcPos = n;
                    }
                    sRes.append('.');
                    this.mbVeeSeen = true;
                    this.mbRadixSeen = true;
                }
                break;
            }
            case 'v': 
            case '\uff56': {
                String sSym = this.mSymbols.radixSymbol;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                while (chrCnt-- > 0) {
                    if (this.mbVeeSeen || this.mbRadixSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                    if (n > 0) {
                        srcPos = n;
                    }
                    sRes.append('.');
                    this.mbVeeSeen = true;
                    this.mbRadixSeen = true;
                }
                break;
            }
            case '.': 
            case '\uff0e': {
                String sSym = this.mSymbols.radixSymbol;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                while (chrCnt-- > 0) {
                    if (this.mbRadixSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                    if (n <= 0) {
                        throw new ExFull();
                    }
                    srcPos = n;
                    sRes.append('.');
                    this.mbRadixSeen = true;
                }
                break;
            }
            case ',': 
            case '\uff0c': {
                String sPos;
                String sSym = this.mSymbols.groupingSymbol;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                if ((sPos = gsSSP).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    int n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                    if (n > 0) {
                        srcPos = n;
                        continue;
                    }
                    if (this.mSymbols.groupingSymbol.equals("\u00a0")) {
                        n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                        if (n <= 0 || n != src.length() && DateTimeUtil.matchNum(src, n, n + 1, fw, this.mSymbols.zeroDigit) <= 0) continue;
                        srcPos = n;
                        continue;
                    }
                    this.mbCommaSeen = true;
                }
                break;
            }
            case '$': 
            case '\uff04': {
                while (chrCnt-- > 0) {
                    int n;
                    String sSym;
                    if (chrCnt > 0) {
                        --chrCnt;
                        sSym = this.mSymbols.currencyName;
                    } else {
                        sSym = this.mSymbols.currencySymbol;
                    }
                    if (sSym.length() > 1) {
                        sSym = LcNum.reverse(sSym);
                    }
                    if ((n = DateTimeUtil.matchStr(src, srcPos, sSym, fw)) <= 0) {
                        throw new ExFull();
                    }
                    srcPos = n;
                }
                break;
            }
            case '%': 
            case '\uff05': {
                String sSym = this.mSymbols.percentSymbol;
                if (sSym.length() > 1) {
                    sSym = LcNum.reverse(sSym);
                }
                while (chrCnt-- > 0) {
                    int n = DateTimeUtil.matchStr(src, srcPos, sSym, fw);
                    if (n <= 0) {
                        throw new ExFull();
                    }
                    srcPos = n;
                    this.mbPercentSeen = true;
                }
                break;
            }
            case '(': 
            case '\uff08': {
                String sPos;
                String sNeg = gsLP;
                if (sNeg.length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                if ((sPos = gsSSP).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (!this.mbRightParenSeen || !this.mbDigitSeen || this.mbLeftParenSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbLeftParenSeen = true;
                        this.mbNegative = true;
                        continue;
                    }
                    n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                    if (n <= 0) {
                        throw new ExFull();
                    }
                    srcPos = n;
                    this.mbLeftParenSeen = true;
                }
                break;
            }
            case ')': 
            case '\uff09': {
                String sPos;
                String sNeg = gsRP;
                if (sNeg.length() > 1) {
                    sNeg = LcNum.reverse(sNeg);
                }
                if ((sPos = gsSSP).length() > 1) {
                    sPos = LcNum.reverse(sPos);
                }
                while (chrCnt-- > 0) {
                    if (this.mbLeftParenSeen || this.mbDigitSeen || this.mbRightParenSeen) {
                        throw new ExFull();
                    }
                    int n = DateTimeUtil.matchStr(src, srcPos, sNeg, fw);
                    if (n > 0) {
                        srcPos = n;
                        this.mbRightParenSeen = true;
                        this.mbNegative = true;
                        continue;
                    }
                    n = DateTimeUtil.matchStr(src, srcPos, sPos, fw);
                    if (n <= 0) {
                        throw new ExFull();
                    }
                    srcPos = n;
                    this.mbRightParenSeen = true;
                }
                break;
            }
            case 't': {
                while (chrCnt-- != 0) {
                    if (src.charAt(srcPos) != '\t') {
                        throw new ExFull();
                    }
                    ++srcPos;
                }
                break;
            }
            default: {
                if (!DateTimeUtil.matchChr(src, srcPos, chr, fw)) {
                    throw new ExFull();
                }
                ++srcPos;
            }
        }
        return srcPos;
    }

    private boolean isNonIgnorable(char chr) {
        if (this.mbCommaSeen) {
            return DateTimeUtil.matchChr(gsNonIgnorable, chr);
        }
        return DateTimeUtil.matchChr(gsCondIgnorable, chr);
    }

    private static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    private static boolean dblToStr(StringBuilder text, double dbl, int width, int prec, int fmt) {
        int i;
        assert (text != null);
        StringBuilder s = new StringBuilder();
        if (prec > 15) {
            prec = 15;
        }
        if (prec > 0) {
            for (i = 2; i < width - prec; ++i) {
                s.append('0');
            }
            s.append('0');
            s.append('.');
            for (i = 0; i < prec; ++i) {
                s.append('0');
            }
        } else {
            for (i = 1; i < width; ++i) {
                s.append('0');
            }
            s.append(fmt == 1 ? (char)'.' : '0');
        }
        DecimalFormat oNumberFormat = (DecimalFormat)gNumberFormat.clone();
        oNumberFormat.applyPattern(s.toString());
        oNumberFormat.setDecimalSeparatorAlwaysShown(fmt == 1);
        text.setLength(0);
        text.append(oNumberFormat.format(dbl));
        return true;
    }

    private static double strToDbl(String text, int prec) {
        double dbl;
        block3: {
            dbl = 0.0;
            if (prec > 15) {
                prec = 15;
            }
            try {
                dbl = new BigDecimal(text).setScale(prec, 4).doubleValue();
            }
            catch (NumberFormatException e) {
                if (text.length() == 0) break block3;
                throw new ExFull();
            }
        }
        return dbl;
    }

    static class Symbols {
        final String radixSymbol;
        final String negativeSymbol;
        final String positiveSymbol;
        final String groupingSymbol;
        final String percentSymbol;
        final String currencySymbol;
        final String currencyName;
        final char zeroDigit;

        public Symbols(String radixSymbol, String negativeSymbol, String positiveSymbol, String groupingSymbol, String percentSymbol, String currencySymbol, String currencyName, char zeroDigit) {
            this.radixSymbol = radixSymbol;
            this.negativeSymbol = negativeSymbol;
            this.positiveSymbol = positiveSymbol;
            this.groupingSymbol = groupingSymbol;
            this.percentSymbol = percentSymbol;
            this.currencySymbol = currencySymbol;
            this.currencyName = currencyName;
            this.zeroDigit = zeroDigit;
        }
    }
}

