/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.ISODate;
import com.adobe.xfa.ut.ISOTime;

public class ISODateTime {
    public static final String XFA_DATETIME_FMT1 = "YYYYMMDDTHHMMSS.FFFz";
    public static final String XFA_DATETIME_FMT2 = "YYYY-MM-DDTHH:MM:SS.FFFzz";
    protected ISODate mDate;
    protected ISOTime mTime;

    public ISODateTime() {
        this.mDate = new ISODate();
        this.mTime = new ISOTime();
        this.mDate.setLocalDate();
        this.mTime.setLocalTime();
    }

    public ISODateTime(String datetime, String datelocale, String timelocale) {
        String date = datetime;
        int tee = datetime.indexOf(84);
        if (tee >= 0) {
            date = datetime.substring(0, tee);
        }
        String time = datetime;
        if ((tee = datetime.indexOf(84, tee)) >= 0) {
            time = datetime.substring(tee + 1);
        }
        this.mDate = new ISODate(date, datelocale);
        this.mTime = new ISOTime(time, timelocale);
        this.mDate.setLocalDate();
        this.mTime.setLocalTime();
    }

    public void setLocalTime() {
        this.mDate.setLocalDate();
        this.mTime.setLocalTime();
    }

    public void setGMTime() {
        this.mDate.setGMDate();
        this.mTime.setGMTime();
    }

    public String format(String isoformat) {
        if (!this.isValid()) {
            return "";
        }
        int tee = isoformat.indexOf(84);
        if (tee < 0) {
            return "";
        }
        String dateformat = isoformat.substring(0, tee);
        String timeformat = isoformat.substring(tee + 1);
        return this.mDate.format(dateformat) + 'T' + this.mTime.format(timeformat);
    }

    public boolean isValid() {
        return this.mDate.isValid() && this.mTime.isValid();
    }

    public ISODate getDate() {
        return this.mDate;
    }

    public ISOTime getTime() {
        return this.mTime;
    }
}

