/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.ut.UnitSpan;

public class TextTab {
    public static final int TYPE_LEFT = 0;
    public static final int TYPE_CENTRE = 1;
    public static final int TYPE_RIGHT = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_ALIGN_AFTER = 4;
    public static final int TYPE_ALIGN_BEFORE = 5;
    public static final TextTab DEFAULT_TAB = new TextTab(0.5, 4);
    public static final TextTab ZERO_TAB = new TextTab();
    private int meType = 0;
    private UnitSpan moStop = null;

    public TextTab() {
    }

    public TextTab(TextTab oSource) {
        this.meType = oSource.meType;
        this.moStop = oSource.moStop;
    }

    public TextTab(UnitSpan oNewStop, int eNewType) {
        this.meType = eNewType;
        this.moStop = oNewStop;
    }

    public TextTab(double fNewStop, int eNewType) {
        this.meType = eNewType;
        this.moStop = new UnitSpan(fNewStop, 3);
    }

    public int tabType() {
        return this.meType;
    }

    public void tabType(int eNewType) {
        this.meType = eNewType;
    }

    public UnitSpan tabStop() {
        return this.moStop == null ? UnitSpan.ZERO : this.moStop;
    }

    public void tabStop(UnitSpan oNewStop) {
        this.moStop = oNewStop;
    }

    public int value() {
        return this.moStop == null ? 0 : this.moStop.value();
    }

    public static int resolveType(int eSource, boolean bRTL, boolean bLayout) {
        if (bLayout) {
            switch (eSource) {
                case 0: {
                    return bRTL ? 5 : 4;
                }
                case 2: {
                    return bRTL ? 4 : 5;
                }
            }
        } else {
            switch (eSource) {
                case 5: {
                    return bRTL ? 0 : 2;
                }
                case 4: {
                    return bRTL ? 2 : 0;
                }
            }
        }
        return eSource;
    }

    public TextTab copyFrom(TextTab oSource) {
        this.meType = oSource.meType;
        this.moStop = oSource.moStop;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextTab test = (TextTab)object;
        if (this.moStop != null && test.moStop != null ? !this.moStop.equals(test.moStop) : this.moStop != test.moStop) {
            return false;
        }
        return this.meType == test.meType;
    }

    public int hashCode() {
        int hash = 67;
        if (this.moStop != null) {
            hash = hash * 31 ^ this.moStop.hashCode();
        }
        hash = hash * 31 ^ this.meType;
        return hash;
    }

    public boolean notEqual(TextTab oCompare) {
        return !this.equals(oCompare);
    }

    public boolean lessThan(TextTab oCompare) {
        return this.lt(oCompare.tabStop());
    }

    public boolean lessThanOrEqual(TextTab oCompare) {
        return this.lte(oCompare.tabStop());
    }

    public boolean greaterThan(TextTab oCompare) {
        return this.gt(oCompare.tabStop());
    }

    public boolean greaterThanOrEqual(TextTab oCompare) {
        return this.gte(oCompare.tabStop());
    }

    public boolean equals(UnitSpan oCompare) {
        return this.tabStop().equals(oCompare);
    }

    public boolean notEqual(UnitSpan oCompare) {
        return !this.equals(oCompare);
    }

    public boolean lt(UnitSpan oCompare) {
        return this.tabStop().lt(oCompare);
    }

    public boolean lte(UnitSpan oCompare) {
        return this.tabStop().lte(oCompare);
    }

    public boolean gt(UnitSpan oCompare) {
        return this.tabStop().gt(oCompare);
    }

    public boolean gte(UnitSpan oCompare) {
        return this.tabStop().gte(oCompare);
    }

    public void debug() {
        this.debug(0);
    }

    void debug(int indent) {
        System.out.print(Pkg.doIndent(indent + 1) + "Tab: ");
        String type = "(unknown)";
        switch (this.meType) {
            case 0: {
                type = "left";
                break;
            }
            case 1: {
                type = "centre";
                break;
            }
            case 2: {
                type = "right";
                break;
            }
            case 3: {
                type = "decimal";
            }
        }
        System.out.println(type + ' ' + this.tabStop().toString());
    }
}

