/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.PosnMarker;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextStream;

public abstract class TextMarker {
    public static final int SPLIT_NONE = 0;
    public static final int SPLIT_PARA = 1;
    public static final int SPLIT_INSERT = 2;
    public static final int SPLIT_INSERT_WRAP = 3;
    public static final int SPLIT_REASON_UNKNOWN = -1;
    public static final int SPLIT_REASON_FORCED = 0;
    public static final int SPLIT_REASON_INSERT_EMBED = 1;
    public static final int SPLIT_REASON_INSERT_FIELD = 2;
    public static final int SPLIT_REASON_INSERT_PARA_BREAK = 3;
    public static final int SPLIT_REASON_INSERT_TEXT_PLAIN = 4;
    public static final int SPLIT_REASON_INSERT_TEXT_RICH = 5;
    public static final int SPLIT_REASON_PARA_MARKER = 6;
    public static final int SPLIT_REASON_WORD_WRAP = 7;
    private PosnMarker mpoLocation;
    private int meSplitState;
    private boolean mbAutoCoalesce;
    private boolean mbAutoRemove;
    private boolean mbParaMarker;

    public boolean isPositionMarker() {
        return this.mpoLocation != null && this.mpoLocation.getMate() == null;
    }

    public boolean isRangeMarker() {
        return this.mpoLocation != null && this.mpoLocation.getMate() != null;
    }

    public boolean getAutoCoalesce() {
        return this.mbAutoCoalesce;
    }

    public boolean getAutoRemove() {
        return this.mbAutoRemove;
    }

    public boolean isParaMarker() {
        return this.mbParaMarker;
    }

    public int getSplitState() {
        return this.meSplitState;
    }

    public TextPosn getPosition() {
        return this.isPositionMarker() ? this.mpoLocation : null;
    }

    public TextRange getRange() {
        return new TextRange(this.mpoLocation.stream(), this.mpoLocation.index(), this.mpoLocation.getMate().index());
    }

    public void remove() {
        TextStream poStream = this.getStream();
        if (poStream == null) {
            return;
        }
        poStream.removeMarker(this, false);
    }

    public TextMarker forceSplit(int nSplitStart, int nSplitEnd, int eReason) {
        if (!this.isRangeMarker()) {
            return null;
        }
        TextStream poStream = this.getStream();
        if (poStream == null) {
            return null;
        }
        return poStream.splitMarker(this, nSplitStart, nSplitEnd, eReason);
    }

    public boolean forceCoalesce(TextMarker poOther) {
        if (!this.canCoalesce(poOther)) {
            return false;
        }
        return this.getStream().coalesceMarker(this, poOther);
    }

    public abstract TextMarker cloneMarker();

    public void onAttributeChange(int nStart, int nEnd, TextAttr poAttr) {
    }

    public boolean onClick(TextPosnBase oPosition) {
        return false;
    }

    public boolean onCoalesce(TextMarker oOther) {
        return true;
    }

    public void onDeleteContent(int nStart, int nEnd) {
    }

    public void onRemove(boolean bEditOnly) {
    }

    public TextMarker onSplit(int nSplitStart, int nSplitEnd, int eReason) {
        return this.cloneMarker();
    }

    public boolean onTruncate(int nSplitStart, int nSplitEnd, boolean bEnd, int eReason) {
        return true;
    }

    PosnMarker getLocation() {
        return this.mpoLocation;
    }

    void setLocation(PosnMarker poLocation) {
        this.mpoLocation = poLocation;
    }

    boolean canCoalesce(TextMarker poOther) {
        TextStream poStream = this.getStream();
        return poOther != null && poStream != null && poStream == poOther.getStream() && this.meSplitState == poOther.meSplitState && this.mbAutoCoalesce == poOther.mbAutoCoalesce && this.mbAutoRemove == poOther.mbAutoRemove && this.mbParaMarker == poOther.mbParaMarker;
    }

    protected TextMarker() {
        this.mpoLocation = null;
        this.meSplitState = 0;
        this.mbAutoCoalesce = true;
        this.mbAutoRemove = true;
        this.mbParaMarker = false;
    }

    protected TextMarker(boolean bAutoCoalesce, boolean bAutoRemove, boolean bParaMarker, int eSplitState) {
        this.mpoLocation = null;
        this.meSplitState = eSplitState;
        this.mbAutoCoalesce = bAutoCoalesce;
        this.mbAutoRemove = bAutoRemove;
        this.mbParaMarker = bParaMarker;
    }

    protected TextMarker(TextMarker oSource) {
        this.copyFrom(oSource);
    }

    protected void setAutoCoalesce(boolean bAutoCoalesce) {
        this.mbAutoCoalesce = bAutoCoalesce;
    }

    protected void setAutoRemove(boolean bAutoRemove) {
        this.mbAutoRemove = bAutoRemove;
    }

    protected void setParaMarker(boolean bParaMarker) {
        this.mbParaMarker = bParaMarker;
    }

    protected void setSplitState(int eSplitState) {
        this.meSplitState = eSplitState;
    }

    protected void copyFrom(TextMarker oSource) {
        this.meSplitState = oSource.meSplitState;
        this.mbAutoCoalesce = oSource.mbAutoCoalesce;
        this.mbAutoRemove = oSource.mbAutoRemove;
        this.mbParaMarker = oSource.mbParaMarker;
    }

    protected TextStream getStream() {
        return this.mpoLocation == null ? null : this.mpoLocation.stream();
    }
}

