/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.StrItem;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.markup.MarkupOut;
import java.util.List;

class StrEmbed
extends StrItem {
    private final TextEmbed mpoEmbed;

    StrEmbed(TextEmbed poNewEmbed, int eLevel) {
        super(4);
        this.mpoEmbed = poNewEmbed.cloneEmbed();
        this.mpoEmbed.setLegacyLevel(eLevel);
    }

    StrEmbed(TextEmbed poNewEmbed, TextGfxSource oGfxSource) {
        super(4);
        this.mpoEmbed = poNewEmbed.cloneEmbed();
        this.mpoEmbed.gfxSource(oGfxSource);
    }

    @Override
    void addEmbed(List<TextEmbed> oEmbeds) {
        oEmbeds.add(this.mpoEmbed);
    }

    @Override
    TextAttr markup(MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
        oMarkup.embed(this.mpoEmbed);
        return poPrevAttr;
    }

    @Override
    TextEmbed embedAt(int nIndex) {
        return this.mpoEmbed;
    }

    @Override
    boolean isEqual(StrItem poCompare) {
        if (!(poCompare instanceof StrEmbed)) {
            return false;
        }
        StrEmbed poEmbedItem = (StrEmbed)poCompare;
        TextEmbed poCompareEmbed = poEmbedItem.mpoEmbed;
        if (this.mpoEmbed == null || poCompareEmbed == null) {
            return this.mpoEmbed == poCompareEmbed;
        }
        return this.mpoEmbed.isEqual(poCompareEmbed);
    }

    @Override
    StrItem cloneItem(TextGfxSource oGfxSource) {
        return new StrEmbed(this.mpoEmbed, oGfxSource);
    }

    @Override
    void gfxSource(TextGfxSource oGfxSource) {
        if (this.mpoEmbed != null) {
            this.mpoEmbed.gfxSource(oGfxSource);
        }
    }

    @Override
    void cascadeLegacyLevel(int eLevel) {
        if (this.mpoEmbed != null) {
            this.mpoEmbed.setLegacyLevel(eLevel);
        }
    }

    @Override
    void debug(int indent) {
        System.out.println(Pkg.doIndent(indent + 1) + "Embed");
    }
}

