/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontItem;
import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXFillAttr;
import com.adobe.xfa.gfx.GFXGlyphOrientation;
import com.adobe.xfa.gfx.GFXLineAttr;
import com.adobe.xfa.gfx.GFXTextAttr;
import com.adobe.xfa.text.ABXY;
import com.adobe.xfa.text.Decoration;
import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispRect;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.DrawSelection;
import com.adobe.xfa.text.Glyph;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.text.RenderInfo;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextSelection;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

class DrawAttr {
    private final DispLineWrapped mpoLine;
    private final DrawParm moParm;
    private final DrawSelection moSelection = new DrawSelection();
    private final boolean mbInteractive;
    private final boolean mbBreakOnGlyphs;
    private UnitSpan moBaseline;
    private TextAttr mpoAttr;
    private final GFXTextAttr moGfxAttr = new GFXTextAttr();
    private FontInstance moFontOverride;
    private UnitSpan moCharSpacing = UnitSpan.ZERO;
    private UnitSpan moWordSpacing = UnitSpan.ZERO;
    private boolean mbCharSpacingChanged;
    private boolean mbWordSpacingChanged;
    private boolean mbRTL;
    private final Decoration moUnderline;
    private final Decoration moLineThrough;
    private final Decoration moOverline;
    private static final boolean mbIncludeSpaces = false;
    private final SortedMap<Decoration.DecorationKey, Decoration.DecorationValue> moDecorations = new TreeMap<Decoration.DecorationKey, Decoration.DecorationValue>();
    private GlyphLoc moGlyphLoc;
    private int mnGlyphLocIndex;
    private int mnClipIndex;
    private int mnBackup;
    private boolean mbBackupSet;
    private int mnPrevCharIndex;
    private Rect moClipRect;
    private boolean mbClipRectSet;
    private int meGlyphOrientation;

    DrawAttr(DispLineWrapped poLine, DrawParm oParm) {
        this.mpoLine = poLine;
        this.moParm = oParm;
        this.moUnderline = Decoration.createUnderline(poLine, oParm);
        this.moLineThrough = Decoration.createLineThrough(poLine, oParm);
        this.moOverline = Decoration.createOverline(poLine, oParm);
        this.mnPrevCharIndex = poLine.getCharCount();
        this.mbClipRectSet = false;
        this.meGlyphOrientation = 0;
        this.mbInteractive = this.moParm.env().interactive();
        this.mbBreakOnGlyphs = this.moParm.driver().getMappingLevel() == 2;
    }

    TextAttr getAttr() {
        return this.mpoAttr;
    }

    FontInstance getWorkingFont() {
        return this.moFontOverride == null ? this.mpoAttr.fontInstance() : this.moFontOverride;
    }

    FontInstance getFontOverride() {
        return this.moFontOverride;
    }

    GFXTextAttr getGfxAttr() {
        return this.moGfxAttr;
    }

    void drawBackground() {
        int i;
        TextSelection poPrimary = this.moParm.primary();
        TextSelection poSecondary = this.moParm.secondary();
        if (poPrimary != null && poPrimary.isEmpty()) {
            poPrimary = null;
        }
        if (poSecondary != null && poSecondary.isEmpty()) {
            poSecondary = null;
        }
        if (this.mpoLine.hasSingleColour() && poPrimary == null && poSecondary == null) {
            boolean bTransparent;
            GFXColour oBG;
            GFXColour oFG;
            TextAttr poAttr = this.mpoLine.getStartAttr();
            if (poAttr == null) {
                oFG = GFXColour.black();
                oBG = GFXColour.white();
                bTransparent = false;
            } else {
                oFG = poAttr.colour();
                oBG = poAttr.colourBg();
                bTransparent = poAttr.transparent();
            }
            this.moSelection.addClip(Units.toFloat(this.mpoLine.getAMin()), Units.toFloat(this.mpoLine.getAMin().add(this.mpoLine.getAExtent())), oFG, oBG, bTransparent);
        } else {
            this.mpoLine.preAllocOffsets();
        }
        for (i = 0; i < this.mpoLine.getGlyphCount(); ++i) {
            this.processBackgroundGlyph(i, poPrimary, poSecondary);
        }
        if (this.moParm.driver() != null) {
            for (i = 0; i < this.moSelection.getClipCount(); ++i) {
                float oEnd;
                DrawSelection.Clip oClip = this.moSelection.getClip(i);
                if (oClip.mbTransparent) continue;
                float oStart = oClip.moLeft;
                if (oStart < this.moParm.invalidAMin()) {
                    oStart = this.moParm.invalidAMin();
                }
                if ((oEnd = oClip.moRight) > this.moParm.invalidAMax()) {
                    oEnd = this.moParm.invalidAMax();
                }
                if (!(oStart < oEnd)) continue;
                GFXFillAttr oFillAttr = new GFXFillAttr();
                oFillAttr.colour(oClip.moBG);
                oFillAttr.colourBg(oClip.moBG);
                this.moParm.driver().fillAttr(oFillAttr);
                Rect oFillRect = new Rect(Units.toUnitSpan(oStart), this.mpoLine.getBMinExtended(true), Units.toUnitSpan(oEnd), this.mpoLine.getBMaxExtended(true));
                oFillRect = ABXY.toXY(this.mpoLine.getXYOrigin(), oFillRect, this.mpoLine.frame().getLayoutOrientation());
                this.moParm.driver().relFillRect(oFillRect);
            }
        }
    }

    boolean prepareGlyph(RenderInfo oRenderInfo) {
        oRenderInfo.mpoGlyphLoc = null;
        boolean bRetry = true;
        while (bRetry) {
            boolean bRTL;
            oRenderInfo.mnGlyphID = 0;
            oRenderInfo.mcGlyph = 0;
            oRenderInfo.mbFlushBefore = false;
            oRenderInfo.mbFlushAfter = false;
            oRenderInfo.mbShifted = false;
            oRenderInfo.mpoGlyphLoc = this.getGlyphLoc(this.mnGlyphLocIndex);
            if (oRenderInfo.mpoGlyphLoc == null) {
                if (this.mbInteractive) {
                    oRenderInfo.mpoGlyphLoc = this.nextSelection();
                }
                if (oRenderInfo.mpoGlyphLoc == null) {
                    return false;
                }
                oRenderInfo.mbFlushBefore = true;
                oRenderInfo.mbShifted = true;
            }
            DrawSelection.Clip oClip = new DrawSelection.Clip();
            DrawSelection.Clip poOverride = null;
            if (this.mbInteractive) {
                if (this.moSelection.getClipCount() == 0) {
                    oClip.moFG = GFXColour.black();
                    oClip.moBG = GFXColour.white();
                } else if (this.moSelection.getClipCount() == 1) {
                    oClip = this.moSelection.getClip(0);
                } else if (this.moSelection.getClipCount() > 1) {
                    GlyphLoc poOldGlyphLoc = oRenderInfo.mpoGlyphLoc;
                    float[] extents = this.getGlyphExtents(oRenderInfo.mpoGlyphLoc);
                    if (this.mnClipIndex < this.moSelection.getClipCount() && extents[0] >= this.moSelection.getClip((int)this.mnClipIndex).moRight) {
                        oRenderInfo.mpoGlyphLoc = this.nextSelection();
                        if (oRenderInfo.mpoGlyphLoc == null) {
                            return false;
                        }
                        oRenderInfo.mbFlushBefore = true;
                        oRenderInfo.mbShifted = true;
                    }
                    oClip = this.moSelection.getClip(this.mnClipIndex);
                    if (!this.mbBackupSet) {
                        if (oRenderInfo.mpoGlyphLoc != poOldGlyphLoc) {
                            extents = this.getGlyphExtents(oRenderInfo.mpoGlyphLoc);
                        }
                        if (extents[1] > oClip.moRight) {
                            this.mnBackup = this.mnGlyphLocIndex;
                            this.mbBackupSet = true;
                        }
                    }
                }
                poOverride = oClip;
            }
            ++this.mnGlyphLocIndex;
            DrawData data = this.initDrawAttr(oRenderInfo.mpoGlyphLoc);
            int nCharIndex = oRenderInfo.mpoGlyphLoc.getMapIndex();
            oRenderInfo.mcGlyph = this.mpoLine.getChar(nCharIndex);
            if (oRenderInfo.mcGlyph >= 8234 && oRenderInfo.mcGlyph <= 8238) continue;
            if (nCharIndex == this.mnPrevCharIndex) {
                oRenderInfo.mbFlushBefore = true;
                oRenderInfo.mbFlushAfter = true;
            }
            this.mnPrevCharIndex = nCharIndex;
            if (poOverride != null) {
                data.colour(poOverride.moFG);
                data.colourBg(poOverride.moBG);
            }
            Glyph oGlyph = this.mpoLine.getGlyph(oRenderInfo.mpoGlyphLoc.getGlyphIndex());
            FontInstance oFontInstance = null;
            UnitSpan oNewBaseline = this.moParm.offsetText();
            UnitSpan oNewCharSpacing = UnitSpan.ZERO;
            UnitSpan oNewWordSpacing = UnitSpan.ZERO;
            this.mbCharSpacingChanged = false;
            this.mbWordSpacingChanged = false;
            if (data.mTextAttr != null) {
                oFontInstance = data.mTextAttr.fontInstance();
                if (!this.mpoLine.isLayoutLine() && data.mTextAttr.baselineShiftEnable() && !data.mTextAttr.baselineShift().isNeutral()) {
                    oNewBaseline = data.mTextAttr.baselineShift().applyShift(oNewBaseline, this.moParm.shiftSize());
                }
                if (data.mTextAttr.charSpacingEnable()) {
                    oNewCharSpacing = data.mTextAttr.charSpacing().getLength();
                }
                if (data.mTextAttr.wordSpacingEnable()) {
                    oNewWordSpacing = data.mTextAttr.wordSpacing().getLength();
                }
            }
            if (!UnitSpan.match(oNewBaseline, this.moBaseline)) {
                this.moBaseline = oNewBaseline;
                oRenderInfo.mbFlushBefore = true;
                oRenderInfo.mbShifted = true;
            }
            if (!UnitSpan.match(oNewCharSpacing, this.moCharSpacing)) {
                this.moCharSpacing = oNewCharSpacing;
                this.mbCharSpacingChanged = true;
                if (this.moParm.driver().charSpacingSupported()) {
                    oRenderInfo.mbAttrChange = true;
                    oRenderInfo.mbFlushBefore = true;
                    oRenderInfo.mbShifted = true;
                }
            }
            if (!UnitSpan.match(oNewWordSpacing, this.moWordSpacing)) {
                this.moWordSpacing = oNewWordSpacing;
                this.mbWordSpacingChanged = true;
                if (this.moParm.driver().wordSpacingSupported()) {
                    oRenderInfo.mbAttrChange = true;
                    oRenderInfo.mbFlushBefore = true;
                    oRenderInfo.mbShifted = true;
                }
            }
            if ((bRTL = oGlyph.isRTL()) != this.mbRTL) {
                oRenderInfo.mbFlushBefore = true;
                this.mbRTL = bRTL;
            }
            int eGlyphOrientation = oGlyph.getOrientation();
            if (this.mpoAttr == null || oFontInstance != this.mpoAttr.fontInstance() && oFontInstance != null || data.mTextAttr != null && data.mTextAttr.transparent() != this.mpoAttr.transparent() || !this.moGfxAttr.equals(data) || this.meGlyphOrientation != eGlyphOrientation) {
                this.mpoAttr = data.mTextAttr;
                this.moGfxAttr.copyFrom(data);
                this.meGlyphOrientation = eGlyphOrientation;
                oRenderInfo.mbAttrChange = true;
                oRenderInfo.mbFlushBefore = true;
            }
            FontItem poFontItem = oFontInstance.getFontItem();
            this.mpoLine.getRenderChar(data.mTextAttr, oFontInstance, oRenderInfo.mpoGlyphLoc, oGlyph, oRenderInfo, poFontItem);
            if (this.mbBreakOnGlyphs && (bRTL || oRenderInfo.mcGlyph == 0)) {
                oRenderInfo.mbFlushBefore = true;
                oRenderInfo.mbFlushAfter = true;
            }
            if (poFontItem == oFontInstance.getFontItem() || this.mpoAttr == null) {
                if (this.moFontOverride != null) {
                    this.moFontOverride = null;
                    oRenderInfo.mbAttrChange = true;
                    oRenderInfo.mbFlushBefore = true;
                }
            } else {
                FontInstance oOverride = poFontItem.reconcile(this.mpoAttr.size());
                if (oOverride != this.moFontOverride) {
                    this.moFontOverride = oOverride;
                    oRenderInfo.mbAttrChange = true;
                    oRenderInfo.mbFlushBefore = true;
                }
            }
            bRetry = false;
        }
        return oRenderInfo.mpoGlyphLoc != null;
    }

    UnitSpan getBaseline() {
        return this.moBaseline;
    }

    boolean assertAttrs(ClipRect oClipRect) {
        GFXDriver poDriver = this.moParm.driver();
        poDriver.textAttr(this.moGfxAttr);
        poDriver.glyphOrientation(this.meGlyphOrientation);
        if (this.mpoAttr != null) {
            poDriver.fontInstance(this.getWorkingFont());
            poDriver.mode(this.mpoAttr.transparent() ? 1 : 0);
            if (this.mbCharSpacingChanged) {
                poDriver.charSpacing(this.moCharSpacing);
            }
            if (this.mbWordSpacingChanged) {
                poDriver.wordSpacing(this.moWordSpacing);
            }
        }
        if (this.mbClipRectSet) {
            if (this.moClipRect.isDegenerate()) {
                return false;
            }
            oClipRect.set(this.moClipRect);
        }
        return true;
    }

    void flush() {
        if (this.mpoLine.hasDecoration()) {
            this.moUnderline.complete(this.moParm, this.moDecorations, false);
            this.moLineThrough.complete(this.moParm, this.moDecorations, false);
            this.moOverline.complete(this.moParm, this.moDecorations, false);
            Decoration.DecorationKey[] keys = new Decoration.DecorationKey[this.moDecorations.size()];
            int i = 0;
            for (Decoration.DecorationKey key : this.moDecorations.keySet()) {
                keys[i++] = key;
            }
            int nDecorationStart = 0;
            block1: for (int nClip = 0; nClip < this.moSelection.getClipCount(); ++nClip) {
                DrawSelection.Clip oClip = this.moSelection.getClip(nClip);
                while (nDecorationStart < this.moDecorations.size() && !(keys[nDecorationStart].moXEnd > oClip.moLeft)) {
                    ++nDecorationStart;
                }
                if (nDecorationStart >= this.moDecorations.size()) break;
                for (int j = nDecorationStart; j < this.moDecorations.size(); ++j) {
                    float oRight;
                    Decoration.DecorationKey oKey = keys[j];
                    if (oKey.moXStart >= oClip.moRight) continue block1;
                    Decoration.DecorationValue oValue = (Decoration.DecorationValue)this.moDecorations.get(oKey);
                    float oLeft = oClip.moLeft;
                    if (oKey.moXStart > oLeft) {
                        oLeft = oKey.moXStart;
                    }
                    if (oKey.moXEnd < (oRight = oClip.moRight)) {
                        oRight = oKey.moXEnd;
                    }
                    GFXLineAttr oLineAttr = new GFXLineAttr();
                    oLineAttr.colour(oClip.moFG);
                    oLineAttr.colourBg(oClip.moBG);
                    oLineAttr.width(oValue.moWidth);
                    CoordPair oP1 = new CoordPair(Units.toUnitSpan(oLeft), oValue.moYOffset);
                    CoordPair oP2 = new CoordPair(Units.toUnitSpan(oRight), oValue.moYOffset);
                    this.moParm.driver().lineAttr(oLineAttr);
                    oP1 = ABXY.toXY(this.mpoLine.getXYOrigin(), oP1, this.mpoLine.frame().getLayoutOrientation());
                    oP2 = ABXY.toXY(this.mpoLine.getXYOrigin(), oP2, this.mpoLine.frame().getLayoutOrientation());
                    this.moParm.driver().relLine(oP1, oP2);
                }
            }
        }
    }

    void reset(DrawAttr oSource) {
        this.mpoAttr = oSource.mpoAttr;
        this.moGfxAttr.copyFrom(oSource.moGfxAttr);
        this.moFontOverride = oSource.moFontOverride;
        this.moCharSpacing = oSource.moCharSpacing;
        this.mbCharSpacingChanged = oSource.mbCharSpacingChanged;
        this.moWordSpacing = oSource.moWordSpacing;
        this.mbWordSpacingChanged = oSource.mbWordSpacingChanged;
        this.moClipRect = oSource.moClipRect;
        this.mbClipRectSet = oSource.mbClipRectSet;
        this.meGlyphOrientation = oSource.meGlyphOrientation;
    }

    static boolean getSelectionRectangles(DispLineWrapped poLine, TextSelection poSelection, UnitSpan oYOffset, List<Rect> oRectangles) {
        int i;
        TextStream poStream = poSelection.stream();
        int nPositions = poLine.getPositionCount();
        boolean bFound = false;
        int nSelectionStart = poSelection.start().index();
        int nSelectionEnd = poSelection.end().index();
        for (i = 0; i < nPositions; ++i) {
            DispPosn oPosition = poLine.getPosition(i);
            if (oPosition.pp().stream() != poStream || nSelectionStart >= oPosition.pp().index() + oPosition.getMapLength() || nSelectionEnd <= oPosition.pp().index()) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            return false;
        }
        DrawSelection oSelectionInfo = new DrawSelection();
        for (i = 0; i < poLine.getGlyphCount(); ++i) {
            DrawAttr.processBackgroundGlyph(poLine, poLine.getGlyph(i), poLine.getOrderedGlyphLoc(i), poSelection, null, GFXColour.black(), GFXColour.white(), false, oSelectionInfo);
        }
        bFound = false;
        for (i = 0; i < oSelectionInfo.getClipCount(); ++i) {
            DrawSelection.Clip oClip = oSelectionInfo.getClip(i);
            if (oClip.moFG == GFXColour.black() || oClip.moBG == GFXColour.white()) continue;
            Rect oArea = new Rect(Units.toUnitSpan(oClip.moLeft), oYOffset, Units.toUnitSpan(oClip.moRight), poLine.getBExtent().add(oYOffset));
            oArea = ABXY.toXY(poLine.getXYOrigin(), oArea, poLine.frame().getLayoutOrientation());
            oRectangles.add(oArea);
            bFound = true;
        }
        return bFound;
    }

    private void processBackgroundGlyph(int nGlyphIndex, TextSelection poPrimary, TextSelection poSecondary) {
        boolean bAnySelection;
        Glyph oGlyph = this.mpoLine.getGlyph(nGlyphIndex);
        GlyphLoc oGlyphLoc = this.mpoLine.getOrderedGlyphLoc(nGlyphIndex);
        DrawData data = this.initDrawAttr(oGlyphLoc);
        boolean bl = bAnySelection = poPrimary != null || poSecondary != null;
        if (!this.mpoLine.hasSingleColour() || bAnySelection) {
            DrawAttr.processBackgroundGlyph(this.mpoLine, oGlyph, oGlyphLoc, poPrimary, poSecondary, data.mTextAttr.colour(), data.mTextAttr.colourBg(), data.mTextAttr.transparent(), this.moSelection);
        }
        if (this.mpoLine.hasDecoration() && (oGlyphLoc.getMapLength() > 1 || this.mpoLine.isVisualChar(oGlyphLoc.getMapIndex()))) {
            FontInstance poFontInstance = null;
            FontInstance poOldFontInstance = null;
            if (this.mpoAttr != null) {
                poOldFontInstance = this.mpoAttr.fontInstance();
            }
            if (data.mTextAttr != null) {
                poFontInstance = data.mTextAttr.fontInstance();
            }
            if (poFontInstance != poOldFontInstance && (poOldFontInstance == null || poFontInstance == null || poFontInstance != poOldFontInstance)) {
                this.moUnderline.fontChange(this.moParm, this.moDecorations);
                this.moLineThrough.fontChange(this.moParm, this.moDecorations);
                this.moOverline.fontChange(this.moParm, this.moDecorations);
                this.mpoAttr = data.mTextAttr;
            }
            int nFlags = 0;
            if (GFXGlyphOrientation.usesVerticalGlyphs(data.mRun.glyphOrientation())) {
                nFlags |= 4;
            }
            if (oGlyphLoc.getMapLength() == 1 && this.mpoLine.getBreakClass(oGlyphLoc.getMapIndex()) == 31) {
                nFlags |= 1;
            }
            float oLeft = oGlyph.getDrawX(this.mpoLine) + this.mpoLine.getAMinFloat();
            float oRight = oGlyph.getDrawNextX(this.mpoLine) + this.mpoLine.getAMinFloat();
            if (this.moParm.truncate() != null) {
                if (oLeft < this.moParm.truncateAMin()) {
                    nFlags |= 2;
                } else {
                    float oOverflow = oRight - this.moParm.truncateAMax();
                    if (oOverflow > 0.0f && (oGlyph.isRTL() || oGlyphLoc.getMapIndex() + 1 != this.mpoLine.getVisualCharCount() || oOverflow > 0.5f)) {
                        nFlags |= 2;
                    }
                }
            } else if (oLeft > this.moParm.invalidAMax() || oRight < this.moParm.invalidAMin()) {
                nFlags |= 2;
            }
            this.moUnderline.update(this.moParm, data.mTextAttr, oLeft, oRight, nFlags, this.moDecorations);
            this.moLineThrough.update(this.moParm, data.mTextAttr, oLeft, oRight, nFlags, this.moDecorations);
            this.moOverline.update(this.moParm, data.mTextAttr, oLeft, oRight, nFlags, this.moDecorations);
        }
    }

    private static void processBackgroundGlyph(DispLineWrapped poLine, Glyph oGlyph, GlyphLoc oGlyphLoc, TextSelection poPrimary, TextSelection poSecondary, GFXColour oFG, GFXColour oBG, boolean bTransparent, DrawSelection oSelection) {
        int nBaseIndex = oGlyphLoc.getMapIndex();
        boolean bAnySelection = poPrimary != null || poSecondary != null;
        DispLine.PosnInfo posnInfo = new DispLine.PosnInfo();
        for (int i = 0; i < oGlyphLoc.getMapLength(); ++i) {
            int nCharIndex = oGlyph.isRTL() ? nBaseIndex + oGlyphLoc.getMapLength() - 1 - i : nBaseIndex + i;
            int nPositionIndex = poLine.getPositionMap().findItem(nCharIndex);
            assert (poLine.getPositionMap().isValidMapIndex(nPositionIndex));
            DispPosn oPosition = poLine.getPosition(nPositionIndex);
            TextStream poSelStream = oPosition.pp().stream();
            DispLine.charToStreamInfo(oPosition, nCharIndex, posnInfo);
            for (int nSel = 0; nSel < posnInfo.auxInfo; ++nSel) {
                TextSelection poSelection = null;
                TextStream poStream = poSelStream;
                int nStreamIndex = posnInfo.index + nSel;
                if (bAnySelection) {
                    while (poStream != null) {
                        if (poPrimary != null && poPrimary.stream() == poStream && nStreamIndex >= poPrimary.start().index() && nStreamIndex < poPrimary.end().index()) {
                            poSelection = poPrimary;
                            break;
                        }
                        if (poSecondary != null && poSecondary.stream() == poStream && nStreamIndex >= poSecondary.start().index() && nStreamIndex < poSecondary.end().index()) {
                            poSelection = poSecondary;
                            break;
                        }
                        TextPosn poParentPosition = poStream.position();
                        if (poParentPosition == null) {
                            poStream = null;
                            continue;
                        }
                        poStream = poParentPosition.stream();
                        nStreamIndex = poParentPosition.index();
                    }
                }
                DispLineWrapped.CharRange oRange = poLine.getCharExtent(nPositionIndex, nCharIndex, nSel);
                if (poSelection != null) {
                    oSelection.addClip(oRange.moMinX, oRange.moMaxX, poSelection.colour(), poSelection.colourBg(), false);
                    continue;
                }
                oSelection.addClip(oRange.moMinX, oRange.moMaxX, oFG, oBG, bTransparent);
            }
        }
    }

    private DrawData initDrawAttr(GlyphLoc oGlyphLoc) {
        int nCharIndex = oGlyphLoc.getMapIndex();
        DispRun run = this.mpoLine.getMappedRun(nCharIndex);
        TextAttr textAttr = run.getAttr();
        DrawData data = textAttr == null ? new DrawData() : new DrawData(textAttr.gfxTextAttr());
        data.mRun = run;
        data.mTextAttr = textAttr;
        return data;
    }

    private GlyphLoc nextSelection() {
        ++this.mnClipIndex;
        if (this.mnClipIndex >= this.moSelection.getClipCount()) {
            return null;
        }
        if (this.mbBackupSet) {
            this.mnGlyphLocIndex = this.mnBackup;
            this.mbBackupSet = false;
        }
        this.setClipRect();
        return this.getGlyphLoc(this.mnGlyphLocIndex);
    }

    private GlyphLoc getGlyphLoc(int nGlyphLocIndex) {
        if (nGlyphLocIndex < this.mpoLine.getGlyphCount()) {
            this.moGlyphLoc = this.mpoLine.getOrderedGlyphLoc(nGlyphLocIndex);
            return this.moGlyphLoc;
        }
        return null;
    }

    private void setClipRect() {
        DrawSelection.Clip oClip = this.moSelection.getClip(this.mnClipIndex);
        this.moClipRect = new Rect(Units.toUnitSpan(oClip.moLeft), this.mpoLine.getBMinExtended(true), Units.toUnitSpan(oClip.moRight), this.mpoLine.getBMaxExtended(true));
        this.moClipRect = ABXY.toXY(this.mpoLine.getXYOrigin(), this.moClipRect, this.mpoLine.frame().getLayoutOrientation());
        this.mbClipRectSet = true;
    }

    private float[] getGlyphExtents(GlyphLoc poGlyphLoc) {
        float oRight;
        int nGlyphIndex = poGlyphLoc.getGlyphIndex();
        Glyph oGlyph = this.mpoLine.getGlyph(nGlyphIndex);
        DispRect oExtent = this.mpoLine.getABGlyphBBox(nGlyphIndex, true);
        float oXOffset = oGlyph.getDrawX(this.mpoLine) + this.mpoLine.getAMinFloat();
        oExtent.xMin += oXOffset;
        oExtent.xMax += oXOffset;
        float oLeft = oGlyph.getDrawX(this.mpoLine) + this.mpoLine.getAMinFloat();
        if (oLeft > oExtent.xMin) {
            oLeft = oExtent.xMin;
        }
        if ((oRight = oGlyph.getDrawNextX(this.mpoLine) + this.mpoLine.getAMinFloat()) < oExtent.xMax) {
            oRight = oExtent.xMax;
        }
        float[] result = new float[]{oLeft, oRight};
        return result;
    }

    private static class DrawData
    extends GFXTextAttr {
        DispRun mRun;
        TextAttr mTextAttr;

        DrawData() {
        }

        DrawData(GFXTextAttr source) {
            super(source);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    static class ClipRect {
        private final DrawParm moParm;
        private boolean mbClipRectSet;

        ClipRect(DrawParm oParm) {
            this.moParm = oParm;
            this.mbClipRectSet = false;
        }

        void detach() {
            if (this.mbClipRectSet) {
                this.moParm.driver().popClipRect();
                this.mbClipRectSet = false;
            }
        }

        void set(Rect oClipRect) {
            if (this.mbClipRectSet) {
                this.moParm.driver().popClipRect();
            }
            this.moParm.driver().pushClipRect(true, oClipRect);
            this.mbClipRectSet = true;
        }
    }
}

