/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.sequencing;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.TemplateModel;

public final class Traverse
extends ProtoableNode {
    public Traverse(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "traverse", "traverse", null, XFA.TRAVERSETAG, "traverse");
    }

    @Override
    public String getPrivateName() {
        Attribute oOperation = null;
        if (this.getProto() != null) {
            oOperation = this.getProto().getAttribute(XFA.OPERATIONTAG);
        }
        if (oOperation == null) {
            oOperation = this.getAttribute(XFA.OPERATIONTAG);
        }
        if (oOperation == null) {
            return this.defaultAttribute(XFA.OPERATIONTAG).toString();
        }
        return oOperation.getAttrValue();
    }

    @Override
    public String getName() {
        if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
            return super.getName();
        }
        return this.getPrivateName();
    }

    @Override
    public void setPrivateName(String sNewName) {
        this.setAttribute(new StringAttr("operation", sNewName), XFA.OPERATIONTAG);
    }

    @Override
    public void setName(String sNewName) {
        boolean bLegacyScripting = true;
        AppModel oAppModel = this.getAppModel();
        TemplateModel oModel = TemplateModel.getTemplateModel(oAppModel, false);
        if (oModel != null) {
            bLegacyScripting = oModel.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING);
        }
        if (bLegacyScripting) {
            super.setName(sNewName);
        } else {
            this.setPrivateName(sNewName);
        }
    }
}

