/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.binding;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.ut.StringUtils;
import org.xml.sax.Attributes;

public class BindingNode
extends ProtoableNode {
    private String msAbsoluteDataRef;

    public BindingNode(Element parent, Node prevSibling, String uri, String name, String qname, Attributes attrs, int classTag, String className) {
        super(parent, prevSibling, null, name, qname, attrs, classTag, className);
    }

    @Override
    public Element clone(Element pParent, boolean bDeep) {
        BindingNode oClone = (BindingNode)super.clone(pParent, bDeep);
        oClone.msAbsoluteDataRef = this.msAbsoluteDataRef;
        return oClone;
    }

    String getAbsoluteDataRef() {
        return this.msAbsoluteDataRef;
    }

    String getBindingContext() {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getContextRef(Element oNode, String sConnectionName, int eUsage) {
        String sExistingRef = "";
        if (oNode == null) {
            return "";
        }
        Element oParent = oNode.getXFAParent();
        while (oParent != null) {
            block15: {
                block13: {
                    block14: {
                        if (oParent == this.getModel()) return "";
                        if (!oParent.isSameClass(XFA.SUBFORMTAG) && !oParent.isSameClass(XFA.FIELDTAG) && !oParent.isSameClass(XFA.EXCLGROUPTAG)) break block13;
                        if (!StringUtils.isEmpty(sConnectionName)) break block14;
                        Element oBind = oParent.getElement(XFA.BINDTAG, false, 0, false, false);
                        int eMatch = oBind.getEnum(XFA.MATCHTAG);
                        if (eMatch == 2031619) {
                            String sRef = oBind.getAttribute(XFA.REFTAG).toString();
                            sRef = this.cleanRelativeRef(sRef);
                            String sConnector = "";
                            if (sRef.length() > 0 && sExistingRef.length() > 0) {
                                sConnector = ".";
                            }
                            sExistingRef = sRef + sConnector + sExistingRef;
                        } else if (eMatch != 0x1F0000 && (eMatch != 0x1F0001 || oParent.getName() != "")) {
                            if (!oParent.isSameClass(XFA.SUBFORMTAG)) return "";
                            if (oParent.getXFAParent() != oParent.getModel()) return "";
                            sExistingRef = sExistingRef.length() > 0 ? "$record." + sExistingRef : "$record";
                        }
                        break block13;
                    }
                    Element oConnect = null;
                    if (oParent.isSameClass(XFA.SUBFORMTAG) || oParent.isSameClass(XFA.FIELDTAG) || oParent.isSameClass(XFA.EXCLGROUPTAG)) {
                        oConnect = ((Container)oParent).getConnectNode(sConnectionName, eUsage, false);
                    }
                    if (oConnect == null) break block15;
                    String sRef = oConnect.getAttribute(XFA.REFTAG).toString();
                    sRef = this.cleanRelativeRef(sRef);
                    String sConnector = "";
                    if (sRef.length() > 0 && sExistingRef.length() > 0) {
                        sConnector = ".";
                    }
                    sExistingRef = sRef + sConnector + sExistingRef;
                }
                if (this.isAbsoluteDataRef(sExistingRef)) {
                    return sExistingRef;
                }
            }
            oParent = oParent.getXFAParent();
        }
        return "";
    }

    private boolean isAbsoluteDataRef(String sDataRef) {
        if (StringUtils.isEmpty(sDataRef)) {
            return false;
        }
        if (sDataRef.charAt(0) == '$') {
            if (sDataRef.length() > 1 && sDataRef.charAt(1) == '.') {
                return false;
            }
        } else if (sDataRef.charAt(0) == '!') {
            return true;
        }
        return sDataRef.startsWith("xfa.datasets.");
    }

    private String cleanRelativeRef(String sDataRef) {
        String sCleanRef = sDataRef;
        if (sCleanRef.length() > 1 && sCleanRef.charAt(0) == '$' && sCleanRef.charAt(1) == '.') {
            sCleanRef = sCleanRef.substring(2);
        }
        return sCleanRef;
    }

    void setRef(String sRef) {
        this.msAbsoluteDataRef = "";
        this.setAttribute(new StringAttr("ref", sRef), XFA.REFTAG);
    }

    void updateAbsoluteDataRef() {
    }

    void updateAbsoluteDataRef(String sRef, String sConnection, int eUsage, boolean bIsPropertyBinding) {
        this.msAbsoluteDataRef = sRef;
        if (sRef.length() != 0 && !this.isAbsoluteDataRef(sRef)) {
            String sContextRef = null;
            sContextRef = bIsPropertyBinding ? this.getContextRef(this, sConnection, eUsage) : this.getContextRef(this.getXFAParent(), sConnection, eUsage);
            if (sContextRef.length() != 0) {
                this.msAbsoluteDataRef = sContextRef + "." + this.cleanRelativeRef(sRef);
            }
        }
    }
}

