/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.automation;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.automation.ScriptScript;
import com.adobe.xfa.ut.ResourceLoader;

public final class Script
extends ProtoableNode {
    private static final boolean ACROBAT_PLUGIN = ResourceLoader.loadProperty("ACROBAT_PLUGIN").equalsIgnoreCase("true");
    private boolean mbIsParsing;

    public Script(Element pParent, Node prevSibling) {
        super(pParent, prevSibling, null, "script", "script", null, XFA.SCRIPTTAG, "script");
        if (ACROBAT_PLUGIN && this.getModel().getLocalName().equals("template")) {
            this.setPermsLock(true);
        }
    }

    @Override
    public ScriptTable getScriptTable() {
        return ScriptScript.getScriptTable();
    }

    public String getValue() {
        TextNode t = this.getText(true, false, false);
        if (t == null) {
            return "";
        }
        return t.getValue();
    }

    public boolean isParsing() {
        return this.mbIsParsing;
    }

    public void isParsing(boolean bIsParsing) {
        this.mbIsParsing = bIsParsing;
    }

    public void setValue(String sValue) {
        TextNode pNode = this.getText(true, false, false);
        if (pNode != null) {
            pNode.setValue(sValue, true, false);
        }
    }
}

