/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.protocol;

import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.Resolver;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpForm {
    public static final int ChunkSize = 4096;
    public static final int MixedSize = 32;
    private PostEncodingType meEncoding = PostEncodingType.UNKNOWN_ENCODING;
    private String msContentType;
    private String msCharSet;
    private Map<String, String> msHeaderMap;
    private ByteArrayOutputStream mPairs;
    private ByteArrayOutputStream mChunk;
    private List<Protocol.MultiPartDesc> moMulti;
    private byte[] mRespData;
    private int mnRespCode;
    private String msRespType;

    public void setEncodingType(PostEncodingType ePostEncodingType) {
        this.meEncoding = ePostEncodingType;
        this.moMulti = null;
        this.msCharSet = null;
        this.mChunk = null;
        this.msContentType = null;
        if (this.msHeaderMap != null) {
            this.msHeaderMap.clear();
        }
        if (this.mPairs != null) {
            this.mPairs.reset();
        }
        this.msRespType = null;
        this.mnRespCode = 0;
    }

    public void addNameValuePair(String name, String value) {
        assert (this.meEncoding != PostEncodingType.MULTIPART_ENCODING);
        if (StringUtils.isEmpty(this.msContentType)) {
            this.msContentType = "text/plain";
        }
        byte[] encodedName = null;
        byte[] encodedValue = null;
        try {
            encodedName = ProtocolUtils.urlEncode(name).getBytes("US-ASCII");
            encodedValue = ProtocolUtils.urlEncode(value).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            if (this.mPairs == null) {
                this.mPairs = new ByteArrayOutputStream();
            } else {
                this.mPairs.write(38);
            }
            this.mPairs.write(encodedName);
            this.mPairs.write(61);
            this.mPairs.write(encodedValue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addEncodedData(byte[] encodedData, String sContentType, String sCharSet) {
        assert (this.meEncoding != PostEncodingType.MULTIPART_ENCODING);
        if (StringUtils.isEmpty(this.msContentType) && !StringUtils.isEmpty(sContentType)) {
            this.msContentType = sContentType;
        }
        if (StringUtils.isEmpty(this.msCharSet) && !StringUtils.isEmpty(sCharSet)) {
            this.msCharSet = sCharSet;
        }
        if (encodedData != null) {
            if (this.mChunk == null) {
                this.mChunk = new ByteArrayOutputStream();
            }
            try {
                this.mChunk.write(encodedData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addHeaderData(String sKey, String sValue) {
        if (this.msHeaderMap == null) {
            this.msHeaderMap = new HashMap<String, String>();
        }
        this.msHeaderMap.put(sKey, sValue);
    }

    public void addMultipartData(Protocol.SectionDataOption eOption, byte[] value) {
        Protocol.MultiPartDesc oDesc = new Protocol.MultiPartDesc(eOption, value);
        if (this.moMulti == null) {
            this.moMulti = new ArrayList<Protocol.MultiPartDesc>();
        }
        this.moMulti.add(oDesc);
    }

    public void post(String sUrl) {
        assert (this.meEncoding != PostEncodingType.UNKNOWN_ENCODING);
        StringHolder sScheme = new StringHolder();
        StringHolder sUser = new StringHolder();
        StringHolder sPwd = new StringHolder();
        StringHolder sHost = new StringHolder();
        StringHolder sPort = new StringHolder();
        StringHolder sPath = new StringHolder();
        Resolver.crackUrl(sUrl, sScheme, sUser, sPwd, sHost, sPort, sPath);
        Protocol oProtocol = Resolver.getProtocol(sScheme.value);
        if (oProtocol == null) {
            throw new ExFull(new MsgFormat(ResId.STREAM_PROTOCOL_NOT_AVAIL));
        }
        Protocol.PostRsvp oRsvp = null;
        if (this.meEncoding == PostEncodingType.URL_ENCODING) {
            Protocol.SimplePostData oData = new Protocol.SimplePostData(this.mPairs.toByteArray());
            this.mPairs = null;
            oRsvp = oProtocol.post(oData, sUrl);
        } else if (this.meEncoding == PostEncodingType.USER_ENCODING && this.mChunk != null && this.mChunk.size() > 0) {
            Protocol.SimplePostData oData = new Protocol.SimplePostData(this.mChunk.toByteArray());
            StringBuilder sHead = new StringBuilder();
            if (StringUtils.isEmpty(this.msContentType)) {
                sHead.append("application/octet-stream");
            } else {
                sHead.append(this.msContentType);
                if (!StringUtils.isEmpty(this.msCharSet)) {
                    sHead.append("; charset=").append(this.msCharSet);
                }
            }
            oData.headerMap.put("Content-Type", sHead.toString());
            if (this.msHeaderMap != null && this.msHeaderMap.size() > 0) {
                oData.headerMap.putAll(this.msHeaderMap);
            }
            oRsvp = oProtocol.post(oData, sUrl);
            this.mChunk = null;
        } else if (this.meEncoding == PostEncodingType.MULTIPART_ENCODING && this.moMulti != null) {
            oRsvp = oProtocol.post(this.moMulti, sUrl);
        }
        if (oRsvp != null) {
            this.mnRespCode = oRsvp.nCode;
            this.msRespType = oRsvp.sType;
            this.mRespData = oRsvp.data;
            if (oRsvp.exception != null) {
                throw oRsvp.exception;
            }
        }
    }

    public byte[] getResponse() {
        return this.mRespData;
    }

    public int getResponseCode() {
        return this.mnRespCode;
    }

    public String getResponseType() {
        return this.msRespType;
    }

    public static enum PostEncodingType {
        UNKNOWN_ENCODING,
        URL_ENCODING,
        USER_ENCODING,
        MULTIPART_ENCODING,
        LAST_ENCODING;

    }
}

