/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.adobepdf417pmp;

import com.adobe.xfa.pmp.adobepdf417pmp.PDF417ByteCompactor;
import com.adobe.xfa.pmp.adobepdf417pmp.PDF417TextCompactor;
import java.util.ArrayList;
import java.util.List;

class PDF417CompactorManager {
    PDF417CompactorManager() {
    }

    static void compact(char[] message, List<Integer> compactedMessage) {
        compactedMessage.add(0);
        int mode = 0;
        ArrayList<Character> packetVector = new ArrayList<Character>();
        ArrayList<Character> messageVector = new ArrayList<Character>();
        boolean canHandleText = true;
        for (int idx = 0; idx < message.length; ++idx) {
            char v = message[idx];
            if (canHandleText) {
                canHandleText = canHandleText && PDF417TextCompactor.canHandle(v);
            }
            packetVector.add(Character.valueOf(v));
            if (idx % 12 != 11) continue;
            switch (mode) {
                case 0: {
                    ArrayList<Integer> data;
                    if (!canHandleText) {
                        if (messageVector.size() > 0) {
                            data = new ArrayList<Integer>();
                            PDF417TextCompactor.compact(messageVector, data);
                            compactedMessage.addAll(data);
                            messageVector.clear();
                        }
                        mode = 1;
                    }
                    messageVector.addAll(packetVector);
                    packetVector.clear();
                    break;
                }
                case 1: {
                    ArrayList<Integer> data;
                    if (canHandleText) {
                        if (messageVector.size() > 0) {
                            data = new ArrayList();
                            PDF417ByteCompactor.compact(messageVector, data);
                            compactedMessage.addAll(data);
                            messageVector.clear();
                        }
                        mode = 0;
                    }
                    messageVector.addAll(packetVector);
                    packetVector.clear();
                }
            }
            canHandleText = true;
        }
        if (packetVector.size() > 0) {
            switch (mode) {
                case 0: {
                    if (!canHandleText) {
                        if (messageVector.size() > 0) {
                            ArrayList<Integer> data = new ArrayList<Integer>();
                            PDF417TextCompactor.compact(messageVector, data);
                            compactedMessage.addAll(data);
                            messageVector.clear();
                        }
                        mode = 1;
                    }
                    messageVector.addAll(packetVector);
                    packetVector.clear();
                    break;
                }
                case 1: {
                    if (canHandleText) {
                        if (messageVector.size() > 0) {
                            ArrayList<Integer> data = new ArrayList<Integer>();
                            PDF417ByteCompactor.compact(messageVector, data);
                            compactedMessage.addAll(data);
                            messageVector.clear();
                        }
                        mode = 0;
                    }
                    messageVector.addAll(packetVector);
                    packetVector.clear();
                }
            }
            canHandleText = true;
        }
        if (messageVector.size() > 0) {
            ArrayList<Integer> data = new ArrayList<Integer>();
            switch (mode) {
                case 0: {
                    PDF417TextCompactor.compact(messageVector, data);
                    break;
                }
                case 1: {
                    PDF417ByteCompactor.compact(messageVector, data);
                }
            }
            compactedMessage.addAll(data);
        }
        compactedMessage.set(0, compactedMessage.size());
    }
}

